/*
Copyright 2007-2025. Algoryx Simulation AB.

All AGX source code, intellectual property, documentation, sample code,
tutorials, scene files and technical white papers, are copyrighted, proprietary
and confidential material of Algoryx Simulation AB. You may not download, read,
store, distribute, publish, copy or otherwise disseminate, use or expose this
material unless having a written signed agreement with Algoryx Simulation AB, or having been
advised so by Algoryx Simulation AB for a time limited evaluation, or having purchased a
valid commercial license from Algoryx Simulation AB.

Algoryx Simulation AB disclaims all responsibilities for loss or damage caused
from using this software, unless otherwise stated in written agreements with
Algoryx Simulation AB.
*/
#pragma once
#include <agxSensor/SensorOutputHandler.h>
#include <agxSensor/SystemNode.h>

namespace agxSensor
{
  AGX_DECLARE_POINTER_TYPES( Sensor );
  AGX_DECLARE_VECTOR_TYPES( Sensor );

  /**
  Common base type for all sensors sharing the same general agxSensor layout.
  */
  class AGXSENSOR_EXPORT Sensor : public SystemNode
  {
    public:
      /**
      Default constructor.
      */
      Sensor() = default;

      /**
      \return the output handler managing the outputs from the sensor
      */
      ISensorOutputHandler* getOutputHandler() const;

      /**
      \return the output handler managing the outputs from the sensor
      */
      virtual ISensorOutputHandler* getOutputHandlerBase() const = 0;

      DOXYGEN_START_INTERNAL_BLOCK()

    public:
      AGXSTREAM_DECLARE_ABSTRACT_SERIALIZABLE( agxSensor::Sensor );

      virtual void store( agxStream::OutputArchive& out ) const override;
      virtual void restore( agxStream::InputArchive& in ) override;

      DOXYGEN_END_INTERNAL_BLOCK()
  };
}
