/*
Copyright 2007-2025. Algoryx Simulation AB.

All AGX source code, intellectual property, documentation, sample code,
tutorials, scene files and technical white papers, are copyrighted, proprietary
and confidential material of Algoryx Simulation AB. You may not download, read,
store, distribute, publish, copy or otherwise disseminate, use or expose this
material unless having a written signed agreement with Algoryx Simulation AB, or having been
advised so by Algoryx Simulation AB for a time limited evaluation, or having purchased a
valid commercial license from Algoryx Simulation AB.

Algoryx Simulation AB disclaims all responsibilities for loss or damage caused
from using this software, unless otherwise stated in written agreements with
Algoryx Simulation AB.
*/

#pragma once

#include <agx/Constraint.h>
#include <agx/ElementaryConstraint.h>
#include <agxPowerLine/PowerLine.h>
#include <agxSDK/Assembly.h>
#include <openplx/Physics/Physics_all.h>
#include <agxOpenPLX/SignalQueue.h>
#include <agxOpenPLX/export.h>

namespace agxopenplx
{
  /**
   * @brief Maps OpenPLX names to secondary constraints
   *
   */

  using InputPtr = std::shared_ptr<openplx::Physics::Signals::Input>;
  using OutputPtr = std::shared_ptr<openplx::Physics::Signals::Output>;

  AGXOPENPLX_EXPORT void populateSecondaryConstraintsMap(
    const agxSDK::Assembly& assembly,
    std::unordered_map<std::string, agx::ElementaryConstraintRef>& secondary_constraints_map);
  AGXOPENPLX_EXPORT std::unordered_map<std::string, agx::ElementaryConstraintRef> createSecondaryConstraintsMap(
    const agxSDK::Assembly& assembly);
  template <class T>
  static std::shared_ptr<T> getSignalBySourceName(const std::vector<OutputSignalPtr>& signals, const std::string& name)
  {
    for (auto& signal : signals) {
      if (signal->source()->getName() == name) {
        return std::dynamic_pointer_cast<T>(signal);
      }
    }
    return nullptr;
  }

  template <typename T>
  agx::ref_ptr<T> getSpecificAgxDriveTrainConnector(
    const agxPowerLine::ConnectorRefSet& agx_connectors,
    std::shared_ptr<openplx::Physics::Interactions::Interaction> interaction)
  {
    auto name = interaction->getName();
    for (auto connector : agx_connectors) {
      if (connector->getName() == name) {
        auto specific_connector = agx::dynamic_pointer_cast<T>(connector);
        return specific_connector;
      }
    }

    return nullptr;
  }

  AGXOPENPLX_EXPORT agxPowerLine::ConnectorRef getAgxDriveTrainConnector(
    const agxPowerLine::ConnectorRefSet& agx_connectors, std::shared_ptr<openplx::Core::Object> possible_interaction);

  AGXOPENPLX_EXPORT std::vector<OutputPtr> findAllOutputs(const openplx::Core::ObjectPtr& openplx_scene);
}
