
/*
Copyright 2007-2025. Algoryx Simulation AB.
All AGX source code, intellectual property, documentation, sample code,
tutorials, scene files and technical white papers, are copyrighted, proprietary
and confidential material of Algoryx Simulation AB. You may not download, read,
store, distribute, publish, copy or otherwise disseminate, use or expose this
material unless having a written signed agreement with Algoryx Simulation AB, or having been
advised so by Algoryx Simulation AB for a time limited evaluation, or having purchased a
valid commercial license from Algoryx Simulation AB.
Algoryx Simulation AB disclaims all responsibilities for loss or damage caused
from using this software, unless otherwise stated in written agreements with
Algoryx Simulation AB.
*/

#pragma once

#include <memory>
#include <string>
#include <unordered_map>
#include <unordered_set>
#include <agx/Vector.h>
#include <agx/Constraint.h>
#include <agxDriveTrain/Brake.h>
#include <agxDriveTrain/CombustionEngine.h>
#include <agxDriveTrain/Differential.h>
#include <agxDriveTrain/DryClutch.h>
#include <agxDriveTrain/Engine.h>
#include <agxDriveTrain/Gear.h>
#include <agxDriveTrain/GearBox.h>
#include <agxDriveTrain/Shaft.h>
#include <agxDriveTrain/TorqueConverter.h>
#include <agxPowerLine/Actuator1DOF.h>
#include <agxPowerLine/Connector.h>
#include <agxPowerLine/PowerLine.h>
#include <agxPowerLine/RotationalUnit.h>
#include <agxPowerLine/Unit.h>
#include <agxSDK/Assembly.h>
#include <openplx/Error.h>
#include <agxOpenPLX/export.h>
#include <agxOpenPLX/AgxObjectMap.h>
#include <agxVehicle/Steering.h>
#include <agxVehicle/Track.h>
#include <agxVehicle/WheelJoint.h>
#include <openplx/Vehicles/VehiclesForward.h>
#include <openplx/Vehicles/Suspensions/SingleMateSuspension.h>

namespace openplx
{
  class ErrorReporter;
}

namespace openplx::Core
{
  class Object;
}

namespace openplx::Physics
{
  class System;
}

namespace openplx::Physics1D::Interactions
{
  class Mate;
  class RotationalVelocityMotor;
}

namespace openplx::Physics1D::Bodies
{
  class RotationalBody;
}

namespace agxopenplx
{
  /**
   * Maps the vehicle components of an OpenPLX scene (Physics3D.System) into AGX vehicle
   * components.
   */
  class AGXOPENPLX_EXPORT OpenPlxVehicleMapper
  {
  public:
    OpenPlxVehicleMapper(
      std::shared_ptr<openplx::ErrorReporter> error_reporter,
      std::shared_ptr<AgxObjectMap> object_map);

    void mapVehicle(
      const std::shared_ptr<openplx::Physics3D::System>& system, const agxSDK::AssemblyRef& assembly);

    const std::unordered_map<std::shared_ptr<openplx::Core::Object>, agx::ConstraintRef>& getMappedConstraints();

  private:
    void mapSystemPass(
      const std::shared_ptr<openplx::Physics3D::System>& system, const agxSDK::AssemblyRef& assembly);

    /* Wheel Joint */
    agxVehicle::WheelJointRef mapSingleMateSuspension(const std::shared_ptr<openplx::Vehicles::Suspensions::SingleMateSuspension>& single_mate_suspension);

    /* Steering */
    agxVehicle::SteeringRef mapAckermann(const std::shared_ptr<openplx::Vehicles::Steering::Interactions::Ackermann>& ackermann);
    agxVehicle::SteeringRef mapBellCrank(const std::shared_ptr<openplx::Vehicles::Steering::Interactions::BellCrank>& bell_crank);
    agxVehicle::SteeringRef mapRackAndPinion(const std::shared_ptr<openplx::Vehicles::Steering::Interactions::RackAndPinion>& rack_and_pinion);

    std::shared_ptr<openplx::ErrorReporter> m_error_reporter;
    std::shared_ptr<AgxObjectMap> m_object_map;
    std::unordered_map<std::shared_ptr<openplx::Core::Object>, agx::ConstraintRef> m_constraint_map;

    friend class OpenPlxToAgxMapper;
  };
}
