// Copyright Epic Games, Inc. All Rights Reserved.
/*===========================================================================
	Generated code exported from UnrealHeaderTool.
	DO NOT modify this manually! Edit the corresponding .h files instead!
===========================================================================*/

#include "UObject/GeneratedCppIncludes.h"
#include "Constraints/AGX_ConstraintController.h"
#include "AGX_Real.h"
#include "AGX_RealInterval.h"

PRAGMA_DISABLE_DEPRECATION_WARNINGS

void EmptyLinkFunctionForGeneratedCodeAGX_ConstraintController() {}

// ********** Begin Cross Module References ********************************************************
AGXUNREAL_API UClass* Z_Construct_UClass_UAGX_ConstraintController_FL();
AGXUNREAL_API UClass* Z_Construct_UClass_UAGX_ConstraintController_FL_NoRegister();
AGXUNREAL_API UScriptStruct* Z_Construct_UScriptStruct_FAGX_ConstraintController();
AGXUNREALBARRIER_API UScriptStruct* Z_Construct_UScriptStruct_FAGX_Real();
AGXUNREALBARRIER_API UScriptStruct* Z_Construct_UScriptStruct_FAGX_RealInterval();
ENGINE_API UClass* Z_Construct_UClass_UBlueprintFunctionLibrary();
UPackage* Z_Construct_UPackage__Script_AGXUnreal();
// ********** End Cross Module References **********************************************************

// ********** Begin ScriptStruct FAGX_ConstraintController *****************************************
static FStructRegistrationInfo Z_Registration_Info_UScriptStruct_FAGX_ConstraintController;
class UScriptStruct* FAGX_ConstraintController::StaticStruct()
{
	if (!Z_Registration_Info_UScriptStruct_FAGX_ConstraintController.OuterSingleton)
	{
		Z_Registration_Info_UScriptStruct_FAGX_ConstraintController.OuterSingleton = GetStaticStruct(Z_Construct_UScriptStruct_FAGX_ConstraintController, (UObject*)Z_Construct_UPackage__Script_AGXUnreal(), TEXT("AGX_ConstraintController"));
	}
	return Z_Registration_Info_UScriptStruct_FAGX_ConstraintController.OuterSingleton;
}
struct Z_Construct_UScriptStruct_FAGX_ConstraintController_Statics
{
#if WITH_METADATA
	static constexpr UECodeGen_Private::FMetaDataPairParam Struct_MetaDataParams[] = {
		{ "BlueprintType", "true" },
		{ "Comment", "/**\n * Base struct for Constraint Controllers, also called Secondary Constraints. These are\n * sub-constraints that act on a degree of freedom that is unconstrained by the constraint. For\n * example, for a Hinge Constraint there is a free rotational axis around which the constrained\n * bodies can rotate. A Constraint Controller add functionality to this degree of freedom. There\n * are controllers that enforce a relative speed (Target Speed Controller), limiting it to a\n * particular range (Range Controller), outright locking (Lock Controller), and more.\n */" },
		{ "ModuleRelativePath", "Public/Constraints/AGX_ConstraintController.h" },
		{ "ToolTip", "Base struct for Constraint Controllers, also called Secondary Constraints. These are\nsub-constraints that act on a degree of freedom that is unconstrained by the constraint. For\nexample, for a Hinge Constraint there is a free rotational axis around which the constrained\nbodies can rotate. A Constraint Controller add functionality to this degree of freedom. There\nare controllers that enforce a relative speed (Target Speed Controller), limiting it to a\nparticular range (Range Controller), outright locking (Lock Controller), and more." },
	};
	static constexpr UECodeGen_Private::FMetaDataPairParam NewProp_bEnable_MetaData[] = {
		{ "Category", "AGX Constraint Controller" },
		{ "Comment", "/**\n\x09 * Whether this Constraint Controller is active or not. A disabled Constraint Controller has\n\x09 * no effect on the simulation.\n\x09 */" },
		{ "ModuleRelativePath", "Public/Constraints/AGX_ConstraintController.h" },
		{ "ToolTip", "Whether this Constraint Controller is active or not. A disabled Constraint Controller has\nno effect on the simulation." },
	};
	static constexpr UECodeGen_Private::FMetaDataPairParam NewProp_Compliance_MetaData[] = {
		{ "Category", "AGX Constraint Controller" },
		{ "Comment", "/**\n\x09 * The compliance in a certain DOF. Measured in [m/N] for translational DOFs and [rad/Nm] for\n\x09 * rotational DOFs.\n\x09 *\n\x09 * The compliance measure the inverse of stiffness of the Constraint Controller. A smaller\n\x09 * compliance will cause a stronger force or torque to be created to restore from the violation.\n\x09 * A too small compliance will lead to instabilities in the simulation.\n\x09 */" },
		{ "EditCondition", "bEnable" },
		{ "ModuleRelativePath", "Public/Constraints/AGX_ConstraintController.h" },
		{ "SliderExponent", "100000" },
		{ "SliderMax", "1" },
		{ "SliderMin", "1e-10" },
		{ "ToolTip", "The compliance in a certain DOF. Measured in [m/N] for translational DOFs and [rad/Nm] for\nrotational DOFs.\n\nThe compliance measure the inverse of stiffness of the Constraint Controller. A smaller\ncompliance will cause a stronger force or torque to be created to restore from the violation.\nA too small compliance will lead to instabilities in the simulation." },
	};
	static constexpr UECodeGen_Private::FMetaDataPairParam NewProp_SpookDamping_MetaData[] = {
		{ "Category", "AGX Constraint Controller" },
		{ "EditCondition", "bEnable" },
		{ "ModuleRelativePath", "Public/Constraints/AGX_ConstraintController.h" },
	};
	static constexpr UECodeGen_Private::FMetaDataPairParam NewProp_ForceRange_MetaData[] = {
		{ "Category", "AGX Constraint Controller" },
		{ "Comment", "/**\n\x09 * The minimum and maximum force or torque that the constraint controller can produce [N] or\n\x09 * [Nm].\n\x09 */" },
		{ "EditCondition", "bEnable" },
		{ "ModuleRelativePath", "Public/Constraints/AGX_ConstraintController.h" },
		{ "ToolTip", "The minimum and maximum force or torque that the constraint controller can produce [N] or\n[Nm]." },
	};
	static constexpr UECodeGen_Private::FMetaDataPairParam NewProp_Name_MetaData[] = {
		{ "Category", "AGX Constraint Controller" },
		{ "ModuleRelativePath", "Public/Constraints/AGX_ConstraintController.h" },
	};
	static constexpr UECodeGen_Private::FMetaDataPairParam NewProp_Elasticity_MetaData[] = {
		{ "Comment", "/**\n\x09 * The elasticity in a certain DOF. Measured in [N/m] for translational DOFs and [Nm/rad] for\n\x09 * rotational DOFs.\n\x09 * The elasticity measure the responsiveness/reactiveness of the Constraint Controller to\n\x09 * violations in its constraint. A higher elasticity will cause a stronger force or torque to\n\x09 * be created to restore from the violation. A too high elasticity will lead to instabilities in\n\x09 * the simulation. It is the inverse of Compliance. It is measured in unit force or torque per\n\x09 * unit violation, much like a spring constant, where the violation can be either a translation\n\x09 * or a rotation.\n\x09 *\n\x09 * The unit is currently in Newton per meter or Newtonmeter per radian, the native AGX Dynamics\n\x09 * units, but this may change to Newton per centimieter or Newtoncentimeter per degree, the\n\x09 * Unreal Engine units, in the future.\n\x09 */" },
		{ "ModuleRelativePath", "Public/Constraints/AGX_ConstraintController.h" },
		{ "ToolTip", "The elasticity in a certain DOF. Measured in [N/m] for translational DOFs and [Nm/rad] for\nrotational DOFs.\nThe elasticity measure the responsiveness/reactiveness of the Constraint Controller to\nviolations in its constraint. A higher elasticity will cause a stronger force or torque to\nbe created to restore from the violation. A too high elasticity will lead to instabilities in\nthe simulation. It is the inverse of Compliance. It is measured in unit force or torque per\nunit violation, much like a spring constant, where the violation can be either a translation\nor a rotation.\n\nThe unit is currently in Newton per meter or Newtonmeter per radian, the native AGX Dynamics\nunits, but this may change to Newton per centimieter or Newtoncentimeter per degree, the\nUnreal Engine units, in the future." },
	};
#endif // WITH_METADATA
	static void NewProp_bEnable_SetBit(void* Obj);
	static const UECodeGen_Private::FBoolPropertyParams NewProp_bEnable;
	static const UECodeGen_Private::FStructPropertyParams NewProp_Compliance;
	static const UECodeGen_Private::FDoublePropertyParams NewProp_SpookDamping;
	static const UECodeGen_Private::FStructPropertyParams NewProp_ForceRange;
	static const UECodeGen_Private::FStrPropertyParams NewProp_Name;
	static const UECodeGen_Private::FDoublePropertyParams NewProp_Elasticity;
	static const UECodeGen_Private::FPropertyParamsBase* const PropPointers[];
	static void* NewStructOps()
	{
		return (UScriptStruct::ICppStructOps*)new UScriptStruct::TCppStructOps<FAGX_ConstraintController>();
	}
	static const UECodeGen_Private::FStructParams StructParams;
};
void Z_Construct_UScriptStruct_FAGX_ConstraintController_Statics::NewProp_bEnable_SetBit(void* Obj)
{
	((FAGX_ConstraintController*)Obj)->bEnable = 1;
}
const UECodeGen_Private::FBoolPropertyParams Z_Construct_UScriptStruct_FAGX_ConstraintController_Statics::NewProp_bEnable = { "bEnable", nullptr, (EPropertyFlags)0x0010000000000001, UECodeGen_Private::EPropertyGenFlags::Bool | UECodeGen_Private::EPropertyGenFlags::NativeBool, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, sizeof(bool), sizeof(FAGX_ConstraintController), &Z_Construct_UScriptStruct_FAGX_ConstraintController_Statics::NewProp_bEnable_SetBit, METADATA_PARAMS(UE_ARRAY_COUNT(NewProp_bEnable_MetaData), NewProp_bEnable_MetaData) };
const UECodeGen_Private::FStructPropertyParams Z_Construct_UScriptStruct_FAGX_ConstraintController_Statics::NewProp_Compliance = { "Compliance", nullptr, (EPropertyFlags)0x0010000000000001, UECodeGen_Private::EPropertyGenFlags::Struct, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, STRUCT_OFFSET(FAGX_ConstraintController, Compliance), Z_Construct_UScriptStruct_FAGX_Real, METADATA_PARAMS(UE_ARRAY_COUNT(NewProp_Compliance_MetaData), NewProp_Compliance_MetaData) }; // 3617455029
const UECodeGen_Private::FDoublePropertyParams Z_Construct_UScriptStruct_FAGX_ConstraintController_Statics::NewProp_SpookDamping = { "SpookDamping", nullptr, (EPropertyFlags)0x0010000000000001, UECodeGen_Private::EPropertyGenFlags::Double, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, STRUCT_OFFSET(FAGX_ConstraintController, SpookDamping), METADATA_PARAMS(UE_ARRAY_COUNT(NewProp_SpookDamping_MetaData), NewProp_SpookDamping_MetaData) };
const UECodeGen_Private::FStructPropertyParams Z_Construct_UScriptStruct_FAGX_ConstraintController_Statics::NewProp_ForceRange = { "ForceRange", nullptr, (EPropertyFlags)0x0010000000000001, UECodeGen_Private::EPropertyGenFlags::Struct, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, STRUCT_OFFSET(FAGX_ConstraintController, ForceRange), Z_Construct_UScriptStruct_FAGX_RealInterval, METADATA_PARAMS(UE_ARRAY_COUNT(NewProp_ForceRange_MetaData), NewProp_ForceRange_MetaData) }; // 3325759884
const UECodeGen_Private::FStrPropertyParams Z_Construct_UScriptStruct_FAGX_ConstraintController_Statics::NewProp_Name = { "Name", nullptr, (EPropertyFlags)0x0010000000000001, UECodeGen_Private::EPropertyGenFlags::Str, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, STRUCT_OFFSET(FAGX_ConstraintController, Name), METADATA_PARAMS(UE_ARRAY_COUNT(NewProp_Name_MetaData), NewProp_Name_MetaData) };
const UECodeGen_Private::FDoublePropertyParams Z_Construct_UScriptStruct_FAGX_ConstraintController_Statics::NewProp_Elasticity = { "Elasticity", nullptr, (EPropertyFlags)0x0040000020000000, UECodeGen_Private::EPropertyGenFlags::Double, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, STRUCT_OFFSET(FAGX_ConstraintController, Elasticity_DEPRECATED), METADATA_PARAMS(UE_ARRAY_COUNT(NewProp_Elasticity_MetaData), NewProp_Elasticity_MetaData) };
const UECodeGen_Private::FPropertyParamsBase* const Z_Construct_UScriptStruct_FAGX_ConstraintController_Statics::PropPointers[] = {
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UScriptStruct_FAGX_ConstraintController_Statics::NewProp_bEnable,
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UScriptStruct_FAGX_ConstraintController_Statics::NewProp_Compliance,
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UScriptStruct_FAGX_ConstraintController_Statics::NewProp_SpookDamping,
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UScriptStruct_FAGX_ConstraintController_Statics::NewProp_ForceRange,
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UScriptStruct_FAGX_ConstraintController_Statics::NewProp_Name,
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UScriptStruct_FAGX_ConstraintController_Statics::NewProp_Elasticity,
};
static_assert(UE_ARRAY_COUNT(Z_Construct_UScriptStruct_FAGX_ConstraintController_Statics::PropPointers) < 2048);
const UECodeGen_Private::FStructParams Z_Construct_UScriptStruct_FAGX_ConstraintController_Statics::StructParams = {
	(UObject* (*)())Z_Construct_UPackage__Script_AGXUnreal,
	nullptr,
	&NewStructOps,
	"AGX_ConstraintController",
	Z_Construct_UScriptStruct_FAGX_ConstraintController_Statics::PropPointers,
	UE_ARRAY_COUNT(Z_Construct_UScriptStruct_FAGX_ConstraintController_Statics::PropPointers),
	sizeof(FAGX_ConstraintController),
	alignof(FAGX_ConstraintController),
	RF_Public|RF_Transient|RF_MarkAsNative,
	EStructFlags(0x00000201),
	METADATA_PARAMS(UE_ARRAY_COUNT(Z_Construct_UScriptStruct_FAGX_ConstraintController_Statics::Struct_MetaDataParams), Z_Construct_UScriptStruct_FAGX_ConstraintController_Statics::Struct_MetaDataParams)
};
UScriptStruct* Z_Construct_UScriptStruct_FAGX_ConstraintController()
{
	if (!Z_Registration_Info_UScriptStruct_FAGX_ConstraintController.InnerSingleton)
	{
		UECodeGen_Private::ConstructUScriptStruct(Z_Registration_Info_UScriptStruct_FAGX_ConstraintController.InnerSingleton, Z_Construct_UScriptStruct_FAGX_ConstraintController_Statics::StructParams);
	}
	return Z_Registration_Info_UScriptStruct_FAGX_ConstraintController.InnerSingleton;
}
// ********** End ScriptStruct FAGX_ConstraintController *******************************************

// ********** Begin Class UAGX_ConstraintController_FL Function GetCompliance **********************
struct Z_Construct_UFunction_UAGX_ConstraintController_FL_GetCompliance_Statics
{
	struct AGX_ConstraintController_FL_eventGetCompliance_Parms
	{
		FAGX_ConstraintController Controller;
		float ReturnValue;
	};
#if WITH_METADATA
	static constexpr UECodeGen_Private::FMetaDataPairParam Function_MetaDataParams[] = {
		{ "Category", "AGX Constraint Controller" },
		{ "ModuleRelativePath", "Public/Constraints/AGX_ConstraintController.h" },
	};
	static constexpr UECodeGen_Private::FMetaDataPairParam NewProp_Controller_MetaData[] = {
		{ "NativeConst", "" },
	};
#endif // WITH_METADATA
	static const UECodeGen_Private::FStructPropertyParams NewProp_Controller;
	static const UECodeGen_Private::FFloatPropertyParams NewProp_ReturnValue;
	static const UECodeGen_Private::FPropertyParamsBase* const PropPointers[];
	static const UECodeGen_Private::FFunctionParams FuncParams;
};
const UECodeGen_Private::FStructPropertyParams Z_Construct_UFunction_UAGX_ConstraintController_FL_GetCompliance_Statics::NewProp_Controller = { "Controller", nullptr, (EPropertyFlags)0x0010000008000182, UECodeGen_Private::EPropertyGenFlags::Struct, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, STRUCT_OFFSET(AGX_ConstraintController_FL_eventGetCompliance_Parms, Controller), Z_Construct_UScriptStruct_FAGX_ConstraintController, METADATA_PARAMS(UE_ARRAY_COUNT(NewProp_Controller_MetaData), NewProp_Controller_MetaData) }; // 3011295661
const UECodeGen_Private::FFloatPropertyParams Z_Construct_UFunction_UAGX_ConstraintController_FL_GetCompliance_Statics::NewProp_ReturnValue = { "ReturnValue", nullptr, (EPropertyFlags)0x0010000000000580, UECodeGen_Private::EPropertyGenFlags::Float, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, STRUCT_OFFSET(AGX_ConstraintController_FL_eventGetCompliance_Parms, ReturnValue), METADATA_PARAMS(0, nullptr) };
const UECodeGen_Private::FPropertyParamsBase* const Z_Construct_UFunction_UAGX_ConstraintController_FL_GetCompliance_Statics::PropPointers[] = {
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UFunction_UAGX_ConstraintController_FL_GetCompliance_Statics::NewProp_Controller,
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UFunction_UAGX_ConstraintController_FL_GetCompliance_Statics::NewProp_ReturnValue,
};
static_assert(UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_ConstraintController_FL_GetCompliance_Statics::PropPointers) < 2048);
const UECodeGen_Private::FFunctionParams Z_Construct_UFunction_UAGX_ConstraintController_FL_GetCompliance_Statics::FuncParams = { { (UObject*(*)())Z_Construct_UClass_UAGX_ConstraintController_FL, nullptr, "GetCompliance", Z_Construct_UFunction_UAGX_ConstraintController_FL_GetCompliance_Statics::PropPointers, UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_ConstraintController_FL_GetCompliance_Statics::PropPointers), sizeof(Z_Construct_UFunction_UAGX_ConstraintController_FL_GetCompliance_Statics::AGX_ConstraintController_FL_eventGetCompliance_Parms), RF_Public|RF_Transient|RF_MarkAsNative, (EFunctionFlags)0x04442401, 0, 0, METADATA_PARAMS(UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_ConstraintController_FL_GetCompliance_Statics::Function_MetaDataParams), Z_Construct_UFunction_UAGX_ConstraintController_FL_GetCompliance_Statics::Function_MetaDataParams)},  };
static_assert(sizeof(Z_Construct_UFunction_UAGX_ConstraintController_FL_GetCompliance_Statics::AGX_ConstraintController_FL_eventGetCompliance_Parms) < MAX_uint16);
UFunction* Z_Construct_UFunction_UAGX_ConstraintController_FL_GetCompliance()
{
	static UFunction* ReturnFunction = nullptr;
	if (!ReturnFunction)
	{
		UECodeGen_Private::ConstructUFunction(&ReturnFunction, Z_Construct_UFunction_UAGX_ConstraintController_FL_GetCompliance_Statics::FuncParams);
	}
	return ReturnFunction;
}
DEFINE_FUNCTION(UAGX_ConstraintController_FL::execGetCompliance)
{
	P_GET_STRUCT_REF(FAGX_ConstraintController,Z_Param_Out_Controller);
	P_FINISH;
	P_NATIVE_BEGIN;
	*(float*)Z_Param__Result=UAGX_ConstraintController_FL::GetCompliance(Z_Param_Out_Controller);
	P_NATIVE_END;
}
// ********** End Class UAGX_ConstraintController_FL Function GetCompliance ************************

// ********** Begin Class UAGX_ConstraintController_FL Function GetElasticity **********************
struct Z_Construct_UFunction_UAGX_ConstraintController_FL_GetElasticity_Statics
{
	struct AGX_ConstraintController_FL_eventGetElasticity_Parms
	{
		FAGX_ConstraintController Controller;
		float ReturnValue;
	};
#if WITH_METADATA
	static constexpr UECodeGen_Private::FMetaDataPairParam Function_MetaDataParams[] = {
		{ "Category", "AGX Constraint Controller" },
		{ "ModuleRelativePath", "Public/Constraints/AGX_ConstraintController.h" },
	};
	static constexpr UECodeGen_Private::FMetaDataPairParam NewProp_Controller_MetaData[] = {
		{ "NativeConst", "" },
	};
#endif // WITH_METADATA
	static const UECodeGen_Private::FStructPropertyParams NewProp_Controller;
	static const UECodeGen_Private::FFloatPropertyParams NewProp_ReturnValue;
	static const UECodeGen_Private::FPropertyParamsBase* const PropPointers[];
	static const UECodeGen_Private::FFunctionParams FuncParams;
};
const UECodeGen_Private::FStructPropertyParams Z_Construct_UFunction_UAGX_ConstraintController_FL_GetElasticity_Statics::NewProp_Controller = { "Controller", nullptr, (EPropertyFlags)0x0010000008000182, UECodeGen_Private::EPropertyGenFlags::Struct, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, STRUCT_OFFSET(AGX_ConstraintController_FL_eventGetElasticity_Parms, Controller), Z_Construct_UScriptStruct_FAGX_ConstraintController, METADATA_PARAMS(UE_ARRAY_COUNT(NewProp_Controller_MetaData), NewProp_Controller_MetaData) }; // 3011295661
const UECodeGen_Private::FFloatPropertyParams Z_Construct_UFunction_UAGX_ConstraintController_FL_GetElasticity_Statics::NewProp_ReturnValue = { "ReturnValue", nullptr, (EPropertyFlags)0x0010000000000580, UECodeGen_Private::EPropertyGenFlags::Float, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, STRUCT_OFFSET(AGX_ConstraintController_FL_eventGetElasticity_Parms, ReturnValue), METADATA_PARAMS(0, nullptr) };
const UECodeGen_Private::FPropertyParamsBase* const Z_Construct_UFunction_UAGX_ConstraintController_FL_GetElasticity_Statics::PropPointers[] = {
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UFunction_UAGX_ConstraintController_FL_GetElasticity_Statics::NewProp_Controller,
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UFunction_UAGX_ConstraintController_FL_GetElasticity_Statics::NewProp_ReturnValue,
};
static_assert(UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_ConstraintController_FL_GetElasticity_Statics::PropPointers) < 2048);
const UECodeGen_Private::FFunctionParams Z_Construct_UFunction_UAGX_ConstraintController_FL_GetElasticity_Statics::FuncParams = { { (UObject*(*)())Z_Construct_UClass_UAGX_ConstraintController_FL, nullptr, "GetElasticity", Z_Construct_UFunction_UAGX_ConstraintController_FL_GetElasticity_Statics::PropPointers, UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_ConstraintController_FL_GetElasticity_Statics::PropPointers), sizeof(Z_Construct_UFunction_UAGX_ConstraintController_FL_GetElasticity_Statics::AGX_ConstraintController_FL_eventGetElasticity_Parms), RF_Public|RF_Transient|RF_MarkAsNative, (EFunctionFlags)0x04442401, 0, 0, METADATA_PARAMS(UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_ConstraintController_FL_GetElasticity_Statics::Function_MetaDataParams), Z_Construct_UFunction_UAGX_ConstraintController_FL_GetElasticity_Statics::Function_MetaDataParams)},  };
static_assert(sizeof(Z_Construct_UFunction_UAGX_ConstraintController_FL_GetElasticity_Statics::AGX_ConstraintController_FL_eventGetElasticity_Parms) < MAX_uint16);
UFunction* Z_Construct_UFunction_UAGX_ConstraintController_FL_GetElasticity()
{
	static UFunction* ReturnFunction = nullptr;
	if (!ReturnFunction)
	{
		UECodeGen_Private::ConstructUFunction(&ReturnFunction, Z_Construct_UFunction_UAGX_ConstraintController_FL_GetElasticity_Statics::FuncParams);
	}
	return ReturnFunction;
}
DEFINE_FUNCTION(UAGX_ConstraintController_FL::execGetElasticity)
{
	P_GET_STRUCT_REF(FAGX_ConstraintController,Z_Param_Out_Controller);
	P_FINISH;
	P_NATIVE_BEGIN;
	*(float*)Z_Param__Result=UAGX_ConstraintController_FL::GetElasticity(Z_Param_Out_Controller);
	P_NATIVE_END;
}
// ********** End Class UAGX_ConstraintController_FL Function GetElasticity ************************

// ********** Begin Class UAGX_ConstraintController_FL Function GetEnable **************************
struct Z_Construct_UFunction_UAGX_ConstraintController_FL_GetEnable_Statics
{
	struct AGX_ConstraintController_FL_eventGetEnable_Parms
	{
		FAGX_ConstraintController ControllerRef;
		bool ReturnValue;
	};
#if WITH_METADATA
	static constexpr UECodeGen_Private::FMetaDataPairParam Function_MetaDataParams[] = {
		{ "Category", "AGX Constraint Controller" },
		{ "ModuleRelativePath", "Public/Constraints/AGX_ConstraintController.h" },
	};
#endif // WITH_METADATA
	static const UECodeGen_Private::FStructPropertyParams NewProp_ControllerRef;
	static void NewProp_ReturnValue_SetBit(void* Obj);
	static const UECodeGen_Private::FBoolPropertyParams NewProp_ReturnValue;
	static const UECodeGen_Private::FPropertyParamsBase* const PropPointers[];
	static const UECodeGen_Private::FFunctionParams FuncParams;
};
const UECodeGen_Private::FStructPropertyParams Z_Construct_UFunction_UAGX_ConstraintController_FL_GetEnable_Statics::NewProp_ControllerRef = { "ControllerRef", nullptr, (EPropertyFlags)0x0010000008000180, UECodeGen_Private::EPropertyGenFlags::Struct, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, STRUCT_OFFSET(AGX_ConstraintController_FL_eventGetEnable_Parms, ControllerRef), Z_Construct_UScriptStruct_FAGX_ConstraintController, METADATA_PARAMS(0, nullptr) }; // 3011295661
void Z_Construct_UFunction_UAGX_ConstraintController_FL_GetEnable_Statics::NewProp_ReturnValue_SetBit(void* Obj)
{
	((AGX_ConstraintController_FL_eventGetEnable_Parms*)Obj)->ReturnValue = 1;
}
const UECodeGen_Private::FBoolPropertyParams Z_Construct_UFunction_UAGX_ConstraintController_FL_GetEnable_Statics::NewProp_ReturnValue = { "ReturnValue", nullptr, (EPropertyFlags)0x0010000000000580, UECodeGen_Private::EPropertyGenFlags::Bool | UECodeGen_Private::EPropertyGenFlags::NativeBool, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, sizeof(bool), sizeof(AGX_ConstraintController_FL_eventGetEnable_Parms), &Z_Construct_UFunction_UAGX_ConstraintController_FL_GetEnable_Statics::NewProp_ReturnValue_SetBit, METADATA_PARAMS(0, nullptr) };
const UECodeGen_Private::FPropertyParamsBase* const Z_Construct_UFunction_UAGX_ConstraintController_FL_GetEnable_Statics::PropPointers[] = {
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UFunction_UAGX_ConstraintController_FL_GetEnable_Statics::NewProp_ControllerRef,
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UFunction_UAGX_ConstraintController_FL_GetEnable_Statics::NewProp_ReturnValue,
};
static_assert(UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_ConstraintController_FL_GetEnable_Statics::PropPointers) < 2048);
const UECodeGen_Private::FFunctionParams Z_Construct_UFunction_UAGX_ConstraintController_FL_GetEnable_Statics::FuncParams = { { (UObject*(*)())Z_Construct_UClass_UAGX_ConstraintController_FL, nullptr, "GetEnable", Z_Construct_UFunction_UAGX_ConstraintController_FL_GetEnable_Statics::PropPointers, UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_ConstraintController_FL_GetEnable_Statics::PropPointers), sizeof(Z_Construct_UFunction_UAGX_ConstraintController_FL_GetEnable_Statics::AGX_ConstraintController_FL_eventGetEnable_Parms), RF_Public|RF_Transient|RF_MarkAsNative, (EFunctionFlags)0x04442401, 0, 0, METADATA_PARAMS(UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_ConstraintController_FL_GetEnable_Statics::Function_MetaDataParams), Z_Construct_UFunction_UAGX_ConstraintController_FL_GetEnable_Statics::Function_MetaDataParams)},  };
static_assert(sizeof(Z_Construct_UFunction_UAGX_ConstraintController_FL_GetEnable_Statics::AGX_ConstraintController_FL_eventGetEnable_Parms) < MAX_uint16);
UFunction* Z_Construct_UFunction_UAGX_ConstraintController_FL_GetEnable()
{
	static UFunction* ReturnFunction = nullptr;
	if (!ReturnFunction)
	{
		UECodeGen_Private::ConstructUFunction(&ReturnFunction, Z_Construct_UFunction_UAGX_ConstraintController_FL_GetEnable_Statics::FuncParams);
	}
	return ReturnFunction;
}
DEFINE_FUNCTION(UAGX_ConstraintController_FL::execGetEnable)
{
	P_GET_STRUCT_REF(FAGX_ConstraintController,Z_Param_Out_ControllerRef);
	P_FINISH;
	P_NATIVE_BEGIN;
	*(bool*)Z_Param__Result=UAGX_ConstraintController_FL::GetEnable(Z_Param_Out_ControllerRef);
	P_NATIVE_END;
}
// ********** End Class UAGX_ConstraintController_FL Function GetEnable ****************************

// ********** Begin Class UAGX_ConstraintController_FL Function GetForce ***************************
struct Z_Construct_UFunction_UAGX_ConstraintController_FL_GetForce_Statics
{
	struct AGX_ConstraintController_FL_eventGetForce_Parms
	{
		FAGX_ConstraintController ControllerRef;
		float ReturnValue;
	};
#if WITH_METADATA
	static constexpr UECodeGen_Private::FMetaDataPairParam Function_MetaDataParams[] = {
		{ "Category", "AGX Constraint Controller" },
		{ "ModuleRelativePath", "Public/Constraints/AGX_ConstraintController.h" },
	};
#endif // WITH_METADATA
	static const UECodeGen_Private::FStructPropertyParams NewProp_ControllerRef;
	static const UECodeGen_Private::FFloatPropertyParams NewProp_ReturnValue;
	static const UECodeGen_Private::FPropertyParamsBase* const PropPointers[];
	static const UECodeGen_Private::FFunctionParams FuncParams;
};
const UECodeGen_Private::FStructPropertyParams Z_Construct_UFunction_UAGX_ConstraintController_FL_GetForce_Statics::NewProp_ControllerRef = { "ControllerRef", nullptr, (EPropertyFlags)0x0010000008000180, UECodeGen_Private::EPropertyGenFlags::Struct, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, STRUCT_OFFSET(AGX_ConstraintController_FL_eventGetForce_Parms, ControllerRef), Z_Construct_UScriptStruct_FAGX_ConstraintController, METADATA_PARAMS(0, nullptr) }; // 3011295661
const UECodeGen_Private::FFloatPropertyParams Z_Construct_UFunction_UAGX_ConstraintController_FL_GetForce_Statics::NewProp_ReturnValue = { "ReturnValue", nullptr, (EPropertyFlags)0x0010000000000580, UECodeGen_Private::EPropertyGenFlags::Float, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, STRUCT_OFFSET(AGX_ConstraintController_FL_eventGetForce_Parms, ReturnValue), METADATA_PARAMS(0, nullptr) };
const UECodeGen_Private::FPropertyParamsBase* const Z_Construct_UFunction_UAGX_ConstraintController_FL_GetForce_Statics::PropPointers[] = {
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UFunction_UAGX_ConstraintController_FL_GetForce_Statics::NewProp_ControllerRef,
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UFunction_UAGX_ConstraintController_FL_GetForce_Statics::NewProp_ReturnValue,
};
static_assert(UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_ConstraintController_FL_GetForce_Statics::PropPointers) < 2048);
const UECodeGen_Private::FFunctionParams Z_Construct_UFunction_UAGX_ConstraintController_FL_GetForce_Statics::FuncParams = { { (UObject*(*)())Z_Construct_UClass_UAGX_ConstraintController_FL, nullptr, "GetForce", Z_Construct_UFunction_UAGX_ConstraintController_FL_GetForce_Statics::PropPointers, UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_ConstraintController_FL_GetForce_Statics::PropPointers), sizeof(Z_Construct_UFunction_UAGX_ConstraintController_FL_GetForce_Statics::AGX_ConstraintController_FL_eventGetForce_Parms), RF_Public|RF_Transient|RF_MarkAsNative, (EFunctionFlags)0x04442401, 0, 0, METADATA_PARAMS(UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_ConstraintController_FL_GetForce_Statics::Function_MetaDataParams), Z_Construct_UFunction_UAGX_ConstraintController_FL_GetForce_Statics::Function_MetaDataParams)},  };
static_assert(sizeof(Z_Construct_UFunction_UAGX_ConstraintController_FL_GetForce_Statics::AGX_ConstraintController_FL_eventGetForce_Parms) < MAX_uint16);
UFunction* Z_Construct_UFunction_UAGX_ConstraintController_FL_GetForce()
{
	static UFunction* ReturnFunction = nullptr;
	if (!ReturnFunction)
	{
		UECodeGen_Private::ConstructUFunction(&ReturnFunction, Z_Construct_UFunction_UAGX_ConstraintController_FL_GetForce_Statics::FuncParams);
	}
	return ReturnFunction;
}
DEFINE_FUNCTION(UAGX_ConstraintController_FL::execGetForce)
{
	P_GET_STRUCT_REF(FAGX_ConstraintController,Z_Param_Out_ControllerRef);
	P_FINISH;
	P_NATIVE_BEGIN;
	*(float*)Z_Param__Result=UAGX_ConstraintController_FL::GetForce(Z_Param_Out_ControllerRef);
	P_NATIVE_END;
}
// ********** End Class UAGX_ConstraintController_FL Function GetForce *****************************

// ********** Begin Class UAGX_ConstraintController_FL Function GetForceRangeMax *******************
struct Z_Construct_UFunction_UAGX_ConstraintController_FL_GetForceRangeMax_Statics
{
	struct AGX_ConstraintController_FL_eventGetForceRangeMax_Parms
	{
		FAGX_ConstraintController Controller;
		float ReturnValue;
	};
#if WITH_METADATA
	static constexpr UECodeGen_Private::FMetaDataPairParam Function_MetaDataParams[] = {
		{ "Category", "AGX Constraint Controller" },
		{ "ModuleRelativePath", "Public/Constraints/AGX_ConstraintController.h" },
	};
	static constexpr UECodeGen_Private::FMetaDataPairParam NewProp_Controller_MetaData[] = {
		{ "NativeConst", "" },
	};
#endif // WITH_METADATA
	static const UECodeGen_Private::FStructPropertyParams NewProp_Controller;
	static const UECodeGen_Private::FFloatPropertyParams NewProp_ReturnValue;
	static const UECodeGen_Private::FPropertyParamsBase* const PropPointers[];
	static const UECodeGen_Private::FFunctionParams FuncParams;
};
const UECodeGen_Private::FStructPropertyParams Z_Construct_UFunction_UAGX_ConstraintController_FL_GetForceRangeMax_Statics::NewProp_Controller = { "Controller", nullptr, (EPropertyFlags)0x0010000008000182, UECodeGen_Private::EPropertyGenFlags::Struct, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, STRUCT_OFFSET(AGX_ConstraintController_FL_eventGetForceRangeMax_Parms, Controller), Z_Construct_UScriptStruct_FAGX_ConstraintController, METADATA_PARAMS(UE_ARRAY_COUNT(NewProp_Controller_MetaData), NewProp_Controller_MetaData) }; // 3011295661
const UECodeGen_Private::FFloatPropertyParams Z_Construct_UFunction_UAGX_ConstraintController_FL_GetForceRangeMax_Statics::NewProp_ReturnValue = { "ReturnValue", nullptr, (EPropertyFlags)0x0010000000000580, UECodeGen_Private::EPropertyGenFlags::Float, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, STRUCT_OFFSET(AGX_ConstraintController_FL_eventGetForceRangeMax_Parms, ReturnValue), METADATA_PARAMS(0, nullptr) };
const UECodeGen_Private::FPropertyParamsBase* const Z_Construct_UFunction_UAGX_ConstraintController_FL_GetForceRangeMax_Statics::PropPointers[] = {
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UFunction_UAGX_ConstraintController_FL_GetForceRangeMax_Statics::NewProp_Controller,
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UFunction_UAGX_ConstraintController_FL_GetForceRangeMax_Statics::NewProp_ReturnValue,
};
static_assert(UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_ConstraintController_FL_GetForceRangeMax_Statics::PropPointers) < 2048);
const UECodeGen_Private::FFunctionParams Z_Construct_UFunction_UAGX_ConstraintController_FL_GetForceRangeMax_Statics::FuncParams = { { (UObject*(*)())Z_Construct_UClass_UAGX_ConstraintController_FL, nullptr, "GetForceRangeMax", Z_Construct_UFunction_UAGX_ConstraintController_FL_GetForceRangeMax_Statics::PropPointers, UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_ConstraintController_FL_GetForceRangeMax_Statics::PropPointers), sizeof(Z_Construct_UFunction_UAGX_ConstraintController_FL_GetForceRangeMax_Statics::AGX_ConstraintController_FL_eventGetForceRangeMax_Parms), RF_Public|RF_Transient|RF_MarkAsNative, (EFunctionFlags)0x04442401, 0, 0, METADATA_PARAMS(UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_ConstraintController_FL_GetForceRangeMax_Statics::Function_MetaDataParams), Z_Construct_UFunction_UAGX_ConstraintController_FL_GetForceRangeMax_Statics::Function_MetaDataParams)},  };
static_assert(sizeof(Z_Construct_UFunction_UAGX_ConstraintController_FL_GetForceRangeMax_Statics::AGX_ConstraintController_FL_eventGetForceRangeMax_Parms) < MAX_uint16);
UFunction* Z_Construct_UFunction_UAGX_ConstraintController_FL_GetForceRangeMax()
{
	static UFunction* ReturnFunction = nullptr;
	if (!ReturnFunction)
	{
		UECodeGen_Private::ConstructUFunction(&ReturnFunction, Z_Construct_UFunction_UAGX_ConstraintController_FL_GetForceRangeMax_Statics::FuncParams);
	}
	return ReturnFunction;
}
DEFINE_FUNCTION(UAGX_ConstraintController_FL::execGetForceRangeMax)
{
	P_GET_STRUCT_REF(FAGX_ConstraintController,Z_Param_Out_Controller);
	P_FINISH;
	P_NATIVE_BEGIN;
	*(float*)Z_Param__Result=UAGX_ConstraintController_FL::GetForceRangeMax(Z_Param_Out_Controller);
	P_NATIVE_END;
}
// ********** End Class UAGX_ConstraintController_FL Function GetForceRangeMax *********************

// ********** Begin Class UAGX_ConstraintController_FL Function GetForceRangeMin *******************
struct Z_Construct_UFunction_UAGX_ConstraintController_FL_GetForceRangeMin_Statics
{
	struct AGX_ConstraintController_FL_eventGetForceRangeMin_Parms
	{
		FAGX_ConstraintController Controller;
		float ReturnValue;
	};
#if WITH_METADATA
	static constexpr UECodeGen_Private::FMetaDataPairParam Function_MetaDataParams[] = {
		{ "Category", "AGX Constraint Controller" },
		{ "ModuleRelativePath", "Public/Constraints/AGX_ConstraintController.h" },
	};
	static constexpr UECodeGen_Private::FMetaDataPairParam NewProp_Controller_MetaData[] = {
		{ "NativeConst", "" },
	};
#endif // WITH_METADATA
	static const UECodeGen_Private::FStructPropertyParams NewProp_Controller;
	static const UECodeGen_Private::FFloatPropertyParams NewProp_ReturnValue;
	static const UECodeGen_Private::FPropertyParamsBase* const PropPointers[];
	static const UECodeGen_Private::FFunctionParams FuncParams;
};
const UECodeGen_Private::FStructPropertyParams Z_Construct_UFunction_UAGX_ConstraintController_FL_GetForceRangeMin_Statics::NewProp_Controller = { "Controller", nullptr, (EPropertyFlags)0x0010000008000182, UECodeGen_Private::EPropertyGenFlags::Struct, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, STRUCT_OFFSET(AGX_ConstraintController_FL_eventGetForceRangeMin_Parms, Controller), Z_Construct_UScriptStruct_FAGX_ConstraintController, METADATA_PARAMS(UE_ARRAY_COUNT(NewProp_Controller_MetaData), NewProp_Controller_MetaData) }; // 3011295661
const UECodeGen_Private::FFloatPropertyParams Z_Construct_UFunction_UAGX_ConstraintController_FL_GetForceRangeMin_Statics::NewProp_ReturnValue = { "ReturnValue", nullptr, (EPropertyFlags)0x0010000000000580, UECodeGen_Private::EPropertyGenFlags::Float, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, STRUCT_OFFSET(AGX_ConstraintController_FL_eventGetForceRangeMin_Parms, ReturnValue), METADATA_PARAMS(0, nullptr) };
const UECodeGen_Private::FPropertyParamsBase* const Z_Construct_UFunction_UAGX_ConstraintController_FL_GetForceRangeMin_Statics::PropPointers[] = {
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UFunction_UAGX_ConstraintController_FL_GetForceRangeMin_Statics::NewProp_Controller,
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UFunction_UAGX_ConstraintController_FL_GetForceRangeMin_Statics::NewProp_ReturnValue,
};
static_assert(UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_ConstraintController_FL_GetForceRangeMin_Statics::PropPointers) < 2048);
const UECodeGen_Private::FFunctionParams Z_Construct_UFunction_UAGX_ConstraintController_FL_GetForceRangeMin_Statics::FuncParams = { { (UObject*(*)())Z_Construct_UClass_UAGX_ConstraintController_FL, nullptr, "GetForceRangeMin", Z_Construct_UFunction_UAGX_ConstraintController_FL_GetForceRangeMin_Statics::PropPointers, UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_ConstraintController_FL_GetForceRangeMin_Statics::PropPointers), sizeof(Z_Construct_UFunction_UAGX_ConstraintController_FL_GetForceRangeMin_Statics::AGX_ConstraintController_FL_eventGetForceRangeMin_Parms), RF_Public|RF_Transient|RF_MarkAsNative, (EFunctionFlags)0x04442401, 0, 0, METADATA_PARAMS(UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_ConstraintController_FL_GetForceRangeMin_Statics::Function_MetaDataParams), Z_Construct_UFunction_UAGX_ConstraintController_FL_GetForceRangeMin_Statics::Function_MetaDataParams)},  };
static_assert(sizeof(Z_Construct_UFunction_UAGX_ConstraintController_FL_GetForceRangeMin_Statics::AGX_ConstraintController_FL_eventGetForceRangeMin_Parms) < MAX_uint16);
UFunction* Z_Construct_UFunction_UAGX_ConstraintController_FL_GetForceRangeMin()
{
	static UFunction* ReturnFunction = nullptr;
	if (!ReturnFunction)
	{
		UECodeGen_Private::ConstructUFunction(&ReturnFunction, Z_Construct_UFunction_UAGX_ConstraintController_FL_GetForceRangeMin_Statics::FuncParams);
	}
	return ReturnFunction;
}
DEFINE_FUNCTION(UAGX_ConstraintController_FL::execGetForceRangeMin)
{
	P_GET_STRUCT_REF(FAGX_ConstraintController,Z_Param_Out_Controller);
	P_FINISH;
	P_NATIVE_BEGIN;
	*(float*)Z_Param__Result=UAGX_ConstraintController_FL::GetForceRangeMin(Z_Param_Out_Controller);
	P_NATIVE_END;
}
// ********** End Class UAGX_ConstraintController_FL Function GetForceRangeMin *********************

// ********** Begin Class UAGX_ConstraintController_FL Function GetSpookDamping ********************
struct Z_Construct_UFunction_UAGX_ConstraintController_FL_GetSpookDamping_Statics
{
	struct AGX_ConstraintController_FL_eventGetSpookDamping_Parms
	{
		FAGX_ConstraintController Controller;
		float ReturnValue;
	};
#if WITH_METADATA
	static constexpr UECodeGen_Private::FMetaDataPairParam Function_MetaDataParams[] = {
		{ "Category", "AGX Constraint Controller" },
		{ "ModuleRelativePath", "Public/Constraints/AGX_ConstraintController.h" },
	};
	static constexpr UECodeGen_Private::FMetaDataPairParam NewProp_Controller_MetaData[] = {
		{ "NativeConst", "" },
	};
#endif // WITH_METADATA
	static const UECodeGen_Private::FStructPropertyParams NewProp_Controller;
	static const UECodeGen_Private::FFloatPropertyParams NewProp_ReturnValue;
	static const UECodeGen_Private::FPropertyParamsBase* const PropPointers[];
	static const UECodeGen_Private::FFunctionParams FuncParams;
};
const UECodeGen_Private::FStructPropertyParams Z_Construct_UFunction_UAGX_ConstraintController_FL_GetSpookDamping_Statics::NewProp_Controller = { "Controller", nullptr, (EPropertyFlags)0x0010000008000182, UECodeGen_Private::EPropertyGenFlags::Struct, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, STRUCT_OFFSET(AGX_ConstraintController_FL_eventGetSpookDamping_Parms, Controller), Z_Construct_UScriptStruct_FAGX_ConstraintController, METADATA_PARAMS(UE_ARRAY_COUNT(NewProp_Controller_MetaData), NewProp_Controller_MetaData) }; // 3011295661
const UECodeGen_Private::FFloatPropertyParams Z_Construct_UFunction_UAGX_ConstraintController_FL_GetSpookDamping_Statics::NewProp_ReturnValue = { "ReturnValue", nullptr, (EPropertyFlags)0x0010000000000580, UECodeGen_Private::EPropertyGenFlags::Float, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, STRUCT_OFFSET(AGX_ConstraintController_FL_eventGetSpookDamping_Parms, ReturnValue), METADATA_PARAMS(0, nullptr) };
const UECodeGen_Private::FPropertyParamsBase* const Z_Construct_UFunction_UAGX_ConstraintController_FL_GetSpookDamping_Statics::PropPointers[] = {
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UFunction_UAGX_ConstraintController_FL_GetSpookDamping_Statics::NewProp_Controller,
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UFunction_UAGX_ConstraintController_FL_GetSpookDamping_Statics::NewProp_ReturnValue,
};
static_assert(UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_ConstraintController_FL_GetSpookDamping_Statics::PropPointers) < 2048);
const UECodeGen_Private::FFunctionParams Z_Construct_UFunction_UAGX_ConstraintController_FL_GetSpookDamping_Statics::FuncParams = { { (UObject*(*)())Z_Construct_UClass_UAGX_ConstraintController_FL, nullptr, "GetSpookDamping", Z_Construct_UFunction_UAGX_ConstraintController_FL_GetSpookDamping_Statics::PropPointers, UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_ConstraintController_FL_GetSpookDamping_Statics::PropPointers), sizeof(Z_Construct_UFunction_UAGX_ConstraintController_FL_GetSpookDamping_Statics::AGX_ConstraintController_FL_eventGetSpookDamping_Parms), RF_Public|RF_Transient|RF_MarkAsNative, (EFunctionFlags)0x04442401, 0, 0, METADATA_PARAMS(UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_ConstraintController_FL_GetSpookDamping_Statics::Function_MetaDataParams), Z_Construct_UFunction_UAGX_ConstraintController_FL_GetSpookDamping_Statics::Function_MetaDataParams)},  };
static_assert(sizeof(Z_Construct_UFunction_UAGX_ConstraintController_FL_GetSpookDamping_Statics::AGX_ConstraintController_FL_eventGetSpookDamping_Parms) < MAX_uint16);
UFunction* Z_Construct_UFunction_UAGX_ConstraintController_FL_GetSpookDamping()
{
	static UFunction* ReturnFunction = nullptr;
	if (!ReturnFunction)
	{
		UECodeGen_Private::ConstructUFunction(&ReturnFunction, Z_Construct_UFunction_UAGX_ConstraintController_FL_GetSpookDamping_Statics::FuncParams);
	}
	return ReturnFunction;
}
DEFINE_FUNCTION(UAGX_ConstraintController_FL::execGetSpookDamping)
{
	P_GET_STRUCT_REF(FAGX_ConstraintController,Z_Param_Out_Controller);
	P_FINISH;
	P_NATIVE_BEGIN;
	*(float*)Z_Param__Result=UAGX_ConstraintController_FL::GetSpookDamping(Z_Param_Out_Controller);
	P_NATIVE_END;
}
// ********** End Class UAGX_ConstraintController_FL Function GetSpookDamping **********************

// ********** Begin Class UAGX_ConstraintController_FL Function IsValid ****************************
struct Z_Construct_UFunction_UAGX_ConstraintController_FL_IsValid_Statics
{
	struct AGX_ConstraintController_FL_eventIsValid_Parms
	{
		FAGX_ConstraintController ControllerRef;
		bool ReturnValue;
	};
#if WITH_METADATA
	static constexpr UECodeGen_Private::FMetaDataPairParam Function_MetaDataParams[] = {
		{ "Category", "AGX Constraint Controller" },
		{ "ModuleRelativePath", "Public/Constraints/AGX_ConstraintController.h" },
	};
#endif // WITH_METADATA
	static const UECodeGen_Private::FStructPropertyParams NewProp_ControllerRef;
	static void NewProp_ReturnValue_SetBit(void* Obj);
	static const UECodeGen_Private::FBoolPropertyParams NewProp_ReturnValue;
	static const UECodeGen_Private::FPropertyParamsBase* const PropPointers[];
	static const UECodeGen_Private::FFunctionParams FuncParams;
};
const UECodeGen_Private::FStructPropertyParams Z_Construct_UFunction_UAGX_ConstraintController_FL_IsValid_Statics::NewProp_ControllerRef = { "ControllerRef", nullptr, (EPropertyFlags)0x0010000008000180, UECodeGen_Private::EPropertyGenFlags::Struct, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, STRUCT_OFFSET(AGX_ConstraintController_FL_eventIsValid_Parms, ControllerRef), Z_Construct_UScriptStruct_FAGX_ConstraintController, METADATA_PARAMS(0, nullptr) }; // 3011295661
void Z_Construct_UFunction_UAGX_ConstraintController_FL_IsValid_Statics::NewProp_ReturnValue_SetBit(void* Obj)
{
	((AGX_ConstraintController_FL_eventIsValid_Parms*)Obj)->ReturnValue = 1;
}
const UECodeGen_Private::FBoolPropertyParams Z_Construct_UFunction_UAGX_ConstraintController_FL_IsValid_Statics::NewProp_ReturnValue = { "ReturnValue", nullptr, (EPropertyFlags)0x0010000000000580, UECodeGen_Private::EPropertyGenFlags::Bool | UECodeGen_Private::EPropertyGenFlags::NativeBool, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, sizeof(bool), sizeof(AGX_ConstraintController_FL_eventIsValid_Parms), &Z_Construct_UFunction_UAGX_ConstraintController_FL_IsValid_Statics::NewProp_ReturnValue_SetBit, METADATA_PARAMS(0, nullptr) };
const UECodeGen_Private::FPropertyParamsBase* const Z_Construct_UFunction_UAGX_ConstraintController_FL_IsValid_Statics::PropPointers[] = {
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UFunction_UAGX_ConstraintController_FL_IsValid_Statics::NewProp_ControllerRef,
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UFunction_UAGX_ConstraintController_FL_IsValid_Statics::NewProp_ReturnValue,
};
static_assert(UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_ConstraintController_FL_IsValid_Statics::PropPointers) < 2048);
const UECodeGen_Private::FFunctionParams Z_Construct_UFunction_UAGX_ConstraintController_FL_IsValid_Statics::FuncParams = { { (UObject*(*)())Z_Construct_UClass_UAGX_ConstraintController_FL, nullptr, "IsValid", Z_Construct_UFunction_UAGX_ConstraintController_FL_IsValid_Statics::PropPointers, UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_ConstraintController_FL_IsValid_Statics::PropPointers), sizeof(Z_Construct_UFunction_UAGX_ConstraintController_FL_IsValid_Statics::AGX_ConstraintController_FL_eventIsValid_Parms), RF_Public|RF_Transient|RF_MarkAsNative, (EFunctionFlags)0x04442401, 0, 0, METADATA_PARAMS(UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_ConstraintController_FL_IsValid_Statics::Function_MetaDataParams), Z_Construct_UFunction_UAGX_ConstraintController_FL_IsValid_Statics::Function_MetaDataParams)},  };
static_assert(sizeof(Z_Construct_UFunction_UAGX_ConstraintController_FL_IsValid_Statics::AGX_ConstraintController_FL_eventIsValid_Parms) < MAX_uint16);
UFunction* Z_Construct_UFunction_UAGX_ConstraintController_FL_IsValid()
{
	static UFunction* ReturnFunction = nullptr;
	if (!ReturnFunction)
	{
		UECodeGen_Private::ConstructUFunction(&ReturnFunction, Z_Construct_UFunction_UAGX_ConstraintController_FL_IsValid_Statics::FuncParams);
	}
	return ReturnFunction;
}
DEFINE_FUNCTION(UAGX_ConstraintController_FL::execIsValid)
{
	P_GET_STRUCT_REF(FAGX_ConstraintController,Z_Param_Out_ControllerRef);
	P_FINISH;
	P_NATIVE_BEGIN;
	*(bool*)Z_Param__Result=UAGX_ConstraintController_FL::IsValid(Z_Param_Out_ControllerRef);
	P_NATIVE_END;
}
// ********** End Class UAGX_ConstraintController_FL Function IsValid ******************************

// ********** Begin Class UAGX_ConstraintController_FL Function SetCompliance **********************
struct Z_Construct_UFunction_UAGX_ConstraintController_FL_SetCompliance_Statics
{
	struct AGX_ConstraintController_FL_eventSetCompliance_Parms
	{
		FAGX_ConstraintController Controller;
		float Compliance;
	};
#if WITH_METADATA
	static constexpr UECodeGen_Private::FMetaDataPairParam Function_MetaDataParams[] = {
		{ "Category", "AGX Constraint Controller" },
		{ "ModuleRelativePath", "Public/Constraints/AGX_ConstraintController.h" },
	};
#endif // WITH_METADATA
	static const UECodeGen_Private::FStructPropertyParams NewProp_Controller;
	static const UECodeGen_Private::FFloatPropertyParams NewProp_Compliance;
	static const UECodeGen_Private::FPropertyParamsBase* const PropPointers[];
	static const UECodeGen_Private::FFunctionParams FuncParams;
};
const UECodeGen_Private::FStructPropertyParams Z_Construct_UFunction_UAGX_ConstraintController_FL_SetCompliance_Statics::NewProp_Controller = { "Controller", nullptr, (EPropertyFlags)0x0010000008000180, UECodeGen_Private::EPropertyGenFlags::Struct, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, STRUCT_OFFSET(AGX_ConstraintController_FL_eventSetCompliance_Parms, Controller), Z_Construct_UScriptStruct_FAGX_ConstraintController, METADATA_PARAMS(0, nullptr) }; // 3011295661
const UECodeGen_Private::FFloatPropertyParams Z_Construct_UFunction_UAGX_ConstraintController_FL_SetCompliance_Statics::NewProp_Compliance = { "Compliance", nullptr, (EPropertyFlags)0x0010000000000080, UECodeGen_Private::EPropertyGenFlags::Float, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, STRUCT_OFFSET(AGX_ConstraintController_FL_eventSetCompliance_Parms, Compliance), METADATA_PARAMS(0, nullptr) };
const UECodeGen_Private::FPropertyParamsBase* const Z_Construct_UFunction_UAGX_ConstraintController_FL_SetCompliance_Statics::PropPointers[] = {
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UFunction_UAGX_ConstraintController_FL_SetCompliance_Statics::NewProp_Controller,
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UFunction_UAGX_ConstraintController_FL_SetCompliance_Statics::NewProp_Compliance,
};
static_assert(UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_ConstraintController_FL_SetCompliance_Statics::PropPointers) < 2048);
const UECodeGen_Private::FFunctionParams Z_Construct_UFunction_UAGX_ConstraintController_FL_SetCompliance_Statics::FuncParams = { { (UObject*(*)())Z_Construct_UClass_UAGX_ConstraintController_FL, nullptr, "SetCompliance", Z_Construct_UFunction_UAGX_ConstraintController_FL_SetCompliance_Statics::PropPointers, UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_ConstraintController_FL_SetCompliance_Statics::PropPointers), sizeof(Z_Construct_UFunction_UAGX_ConstraintController_FL_SetCompliance_Statics::AGX_ConstraintController_FL_eventSetCompliance_Parms), RF_Public|RF_Transient|RF_MarkAsNative, (EFunctionFlags)0x04442401, 0, 0, METADATA_PARAMS(UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_ConstraintController_FL_SetCompliance_Statics::Function_MetaDataParams), Z_Construct_UFunction_UAGX_ConstraintController_FL_SetCompliance_Statics::Function_MetaDataParams)},  };
static_assert(sizeof(Z_Construct_UFunction_UAGX_ConstraintController_FL_SetCompliance_Statics::AGX_ConstraintController_FL_eventSetCompliance_Parms) < MAX_uint16);
UFunction* Z_Construct_UFunction_UAGX_ConstraintController_FL_SetCompliance()
{
	static UFunction* ReturnFunction = nullptr;
	if (!ReturnFunction)
	{
		UECodeGen_Private::ConstructUFunction(&ReturnFunction, Z_Construct_UFunction_UAGX_ConstraintController_FL_SetCompliance_Statics::FuncParams);
	}
	return ReturnFunction;
}
DEFINE_FUNCTION(UAGX_ConstraintController_FL::execSetCompliance)
{
	P_GET_STRUCT_REF(FAGX_ConstraintController,Z_Param_Out_Controller);
	P_GET_PROPERTY(FFloatProperty,Z_Param_Compliance);
	P_FINISH;
	P_NATIVE_BEGIN;
	UAGX_ConstraintController_FL::SetCompliance(Z_Param_Out_Controller,Z_Param_Compliance);
	P_NATIVE_END;
}
// ********** End Class UAGX_ConstraintController_FL Function SetCompliance ************************

// ********** Begin Class UAGX_ConstraintController_FL Function SetElasticity **********************
struct Z_Construct_UFunction_UAGX_ConstraintController_FL_SetElasticity_Statics
{
	struct AGX_ConstraintController_FL_eventSetElasticity_Parms
	{
		FAGX_ConstraintController Controller;
		float Elasticity;
	};
#if WITH_METADATA
	static constexpr UECodeGen_Private::FMetaDataPairParam Function_MetaDataParams[] = {
		{ "Category", "AGX Constraint Controller" },
		{ "ModuleRelativePath", "Public/Constraints/AGX_ConstraintController.h" },
	};
#endif // WITH_METADATA
	static const UECodeGen_Private::FStructPropertyParams NewProp_Controller;
	static const UECodeGen_Private::FFloatPropertyParams NewProp_Elasticity;
	static const UECodeGen_Private::FPropertyParamsBase* const PropPointers[];
	static const UECodeGen_Private::FFunctionParams FuncParams;
};
const UECodeGen_Private::FStructPropertyParams Z_Construct_UFunction_UAGX_ConstraintController_FL_SetElasticity_Statics::NewProp_Controller = { "Controller", nullptr, (EPropertyFlags)0x0010000008000180, UECodeGen_Private::EPropertyGenFlags::Struct, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, STRUCT_OFFSET(AGX_ConstraintController_FL_eventSetElasticity_Parms, Controller), Z_Construct_UScriptStruct_FAGX_ConstraintController, METADATA_PARAMS(0, nullptr) }; // 3011295661
const UECodeGen_Private::FFloatPropertyParams Z_Construct_UFunction_UAGX_ConstraintController_FL_SetElasticity_Statics::NewProp_Elasticity = { "Elasticity", nullptr, (EPropertyFlags)0x0010000000000080, UECodeGen_Private::EPropertyGenFlags::Float, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, STRUCT_OFFSET(AGX_ConstraintController_FL_eventSetElasticity_Parms, Elasticity), METADATA_PARAMS(0, nullptr) };
const UECodeGen_Private::FPropertyParamsBase* const Z_Construct_UFunction_UAGX_ConstraintController_FL_SetElasticity_Statics::PropPointers[] = {
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UFunction_UAGX_ConstraintController_FL_SetElasticity_Statics::NewProp_Controller,
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UFunction_UAGX_ConstraintController_FL_SetElasticity_Statics::NewProp_Elasticity,
};
static_assert(UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_ConstraintController_FL_SetElasticity_Statics::PropPointers) < 2048);
const UECodeGen_Private::FFunctionParams Z_Construct_UFunction_UAGX_ConstraintController_FL_SetElasticity_Statics::FuncParams = { { (UObject*(*)())Z_Construct_UClass_UAGX_ConstraintController_FL, nullptr, "SetElasticity", Z_Construct_UFunction_UAGX_ConstraintController_FL_SetElasticity_Statics::PropPointers, UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_ConstraintController_FL_SetElasticity_Statics::PropPointers), sizeof(Z_Construct_UFunction_UAGX_ConstraintController_FL_SetElasticity_Statics::AGX_ConstraintController_FL_eventSetElasticity_Parms), RF_Public|RF_Transient|RF_MarkAsNative, (EFunctionFlags)0x04442401, 0, 0, METADATA_PARAMS(UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_ConstraintController_FL_SetElasticity_Statics::Function_MetaDataParams), Z_Construct_UFunction_UAGX_ConstraintController_FL_SetElasticity_Statics::Function_MetaDataParams)},  };
static_assert(sizeof(Z_Construct_UFunction_UAGX_ConstraintController_FL_SetElasticity_Statics::AGX_ConstraintController_FL_eventSetElasticity_Parms) < MAX_uint16);
UFunction* Z_Construct_UFunction_UAGX_ConstraintController_FL_SetElasticity()
{
	static UFunction* ReturnFunction = nullptr;
	if (!ReturnFunction)
	{
		UECodeGen_Private::ConstructUFunction(&ReturnFunction, Z_Construct_UFunction_UAGX_ConstraintController_FL_SetElasticity_Statics::FuncParams);
	}
	return ReturnFunction;
}
DEFINE_FUNCTION(UAGX_ConstraintController_FL::execSetElasticity)
{
	P_GET_STRUCT_REF(FAGX_ConstraintController,Z_Param_Out_Controller);
	P_GET_PROPERTY(FFloatProperty,Z_Param_Elasticity);
	P_FINISH;
	P_NATIVE_BEGIN;
	UAGX_ConstraintController_FL::SetElasticity(Z_Param_Out_Controller,Z_Param_Elasticity);
	P_NATIVE_END;
}
// ********** End Class UAGX_ConstraintController_FL Function SetElasticity ************************

// ********** Begin Class UAGX_ConstraintController_FL Function SetEnable **************************
struct Z_Construct_UFunction_UAGX_ConstraintController_FL_SetEnable_Statics
{
	struct AGX_ConstraintController_FL_eventSetEnable_Parms
	{
		FAGX_ConstraintController ControllerRef;
		bool Enable;
	};
#if WITH_METADATA
	static constexpr UECodeGen_Private::FMetaDataPairParam Function_MetaDataParams[] = {
		{ "Category", "AGX Constraint Controller" },
		{ "ModuleRelativePath", "Public/Constraints/AGX_ConstraintController.h" },
	};
#endif // WITH_METADATA
	static const UECodeGen_Private::FStructPropertyParams NewProp_ControllerRef;
	static void NewProp_Enable_SetBit(void* Obj);
	static const UECodeGen_Private::FBoolPropertyParams NewProp_Enable;
	static const UECodeGen_Private::FPropertyParamsBase* const PropPointers[];
	static const UECodeGen_Private::FFunctionParams FuncParams;
};
const UECodeGen_Private::FStructPropertyParams Z_Construct_UFunction_UAGX_ConstraintController_FL_SetEnable_Statics::NewProp_ControllerRef = { "ControllerRef", nullptr, (EPropertyFlags)0x0010000008000180, UECodeGen_Private::EPropertyGenFlags::Struct, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, STRUCT_OFFSET(AGX_ConstraintController_FL_eventSetEnable_Parms, ControllerRef), Z_Construct_UScriptStruct_FAGX_ConstraintController, METADATA_PARAMS(0, nullptr) }; // 3011295661
void Z_Construct_UFunction_UAGX_ConstraintController_FL_SetEnable_Statics::NewProp_Enable_SetBit(void* Obj)
{
	((AGX_ConstraintController_FL_eventSetEnable_Parms*)Obj)->Enable = 1;
}
const UECodeGen_Private::FBoolPropertyParams Z_Construct_UFunction_UAGX_ConstraintController_FL_SetEnable_Statics::NewProp_Enable = { "Enable", nullptr, (EPropertyFlags)0x0010000000000080, UECodeGen_Private::EPropertyGenFlags::Bool | UECodeGen_Private::EPropertyGenFlags::NativeBool, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, sizeof(bool), sizeof(AGX_ConstraintController_FL_eventSetEnable_Parms), &Z_Construct_UFunction_UAGX_ConstraintController_FL_SetEnable_Statics::NewProp_Enable_SetBit, METADATA_PARAMS(0, nullptr) };
const UECodeGen_Private::FPropertyParamsBase* const Z_Construct_UFunction_UAGX_ConstraintController_FL_SetEnable_Statics::PropPointers[] = {
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UFunction_UAGX_ConstraintController_FL_SetEnable_Statics::NewProp_ControllerRef,
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UFunction_UAGX_ConstraintController_FL_SetEnable_Statics::NewProp_Enable,
};
static_assert(UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_ConstraintController_FL_SetEnable_Statics::PropPointers) < 2048);
const UECodeGen_Private::FFunctionParams Z_Construct_UFunction_UAGX_ConstraintController_FL_SetEnable_Statics::FuncParams = { { (UObject*(*)())Z_Construct_UClass_UAGX_ConstraintController_FL, nullptr, "SetEnable", Z_Construct_UFunction_UAGX_ConstraintController_FL_SetEnable_Statics::PropPointers, UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_ConstraintController_FL_SetEnable_Statics::PropPointers), sizeof(Z_Construct_UFunction_UAGX_ConstraintController_FL_SetEnable_Statics::AGX_ConstraintController_FL_eventSetEnable_Parms), RF_Public|RF_Transient|RF_MarkAsNative, (EFunctionFlags)0x04442401, 0, 0, METADATA_PARAMS(UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_ConstraintController_FL_SetEnable_Statics::Function_MetaDataParams), Z_Construct_UFunction_UAGX_ConstraintController_FL_SetEnable_Statics::Function_MetaDataParams)},  };
static_assert(sizeof(Z_Construct_UFunction_UAGX_ConstraintController_FL_SetEnable_Statics::AGX_ConstraintController_FL_eventSetEnable_Parms) < MAX_uint16);
UFunction* Z_Construct_UFunction_UAGX_ConstraintController_FL_SetEnable()
{
	static UFunction* ReturnFunction = nullptr;
	if (!ReturnFunction)
	{
		UECodeGen_Private::ConstructUFunction(&ReturnFunction, Z_Construct_UFunction_UAGX_ConstraintController_FL_SetEnable_Statics::FuncParams);
	}
	return ReturnFunction;
}
DEFINE_FUNCTION(UAGX_ConstraintController_FL::execSetEnable)
{
	P_GET_STRUCT_REF(FAGX_ConstraintController,Z_Param_Out_ControllerRef);
	P_GET_UBOOL(Z_Param_Enable);
	P_FINISH;
	P_NATIVE_BEGIN;
	UAGX_ConstraintController_FL::SetEnable(Z_Param_Out_ControllerRef,Z_Param_Enable);
	P_NATIVE_END;
}
// ********** End Class UAGX_ConstraintController_FL Function SetEnable ****************************

// ********** Begin Class UAGX_ConstraintController_FL Function SetForceRange **********************
struct Z_Construct_UFunction_UAGX_ConstraintController_FL_SetForceRange_Statics
{
	struct AGX_ConstraintController_FL_eventSetForceRange_Parms
	{
		FAGX_ConstraintController Controller;
		float MinForce;
		float MaxForce;
	};
#if WITH_METADATA
	static constexpr UECodeGen_Private::FMetaDataPairParam Function_MetaDataParams[] = {
		{ "Category", "AGX Constraint Controller" },
		{ "ModuleRelativePath", "Public/Constraints/AGX_ConstraintController.h" },
	};
#endif // WITH_METADATA
	static const UECodeGen_Private::FStructPropertyParams NewProp_Controller;
	static const UECodeGen_Private::FFloatPropertyParams NewProp_MinForce;
	static const UECodeGen_Private::FFloatPropertyParams NewProp_MaxForce;
	static const UECodeGen_Private::FPropertyParamsBase* const PropPointers[];
	static const UECodeGen_Private::FFunctionParams FuncParams;
};
const UECodeGen_Private::FStructPropertyParams Z_Construct_UFunction_UAGX_ConstraintController_FL_SetForceRange_Statics::NewProp_Controller = { "Controller", nullptr, (EPropertyFlags)0x0010000008000180, UECodeGen_Private::EPropertyGenFlags::Struct, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, STRUCT_OFFSET(AGX_ConstraintController_FL_eventSetForceRange_Parms, Controller), Z_Construct_UScriptStruct_FAGX_ConstraintController, METADATA_PARAMS(0, nullptr) }; // 3011295661
const UECodeGen_Private::FFloatPropertyParams Z_Construct_UFunction_UAGX_ConstraintController_FL_SetForceRange_Statics::NewProp_MinForce = { "MinForce", nullptr, (EPropertyFlags)0x0010000000000080, UECodeGen_Private::EPropertyGenFlags::Float, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, STRUCT_OFFSET(AGX_ConstraintController_FL_eventSetForceRange_Parms, MinForce), METADATA_PARAMS(0, nullptr) };
const UECodeGen_Private::FFloatPropertyParams Z_Construct_UFunction_UAGX_ConstraintController_FL_SetForceRange_Statics::NewProp_MaxForce = { "MaxForce", nullptr, (EPropertyFlags)0x0010000000000080, UECodeGen_Private::EPropertyGenFlags::Float, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, STRUCT_OFFSET(AGX_ConstraintController_FL_eventSetForceRange_Parms, MaxForce), METADATA_PARAMS(0, nullptr) };
const UECodeGen_Private::FPropertyParamsBase* const Z_Construct_UFunction_UAGX_ConstraintController_FL_SetForceRange_Statics::PropPointers[] = {
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UFunction_UAGX_ConstraintController_FL_SetForceRange_Statics::NewProp_Controller,
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UFunction_UAGX_ConstraintController_FL_SetForceRange_Statics::NewProp_MinForce,
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UFunction_UAGX_ConstraintController_FL_SetForceRange_Statics::NewProp_MaxForce,
};
static_assert(UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_ConstraintController_FL_SetForceRange_Statics::PropPointers) < 2048);
const UECodeGen_Private::FFunctionParams Z_Construct_UFunction_UAGX_ConstraintController_FL_SetForceRange_Statics::FuncParams = { { (UObject*(*)())Z_Construct_UClass_UAGX_ConstraintController_FL, nullptr, "SetForceRange", Z_Construct_UFunction_UAGX_ConstraintController_FL_SetForceRange_Statics::PropPointers, UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_ConstraintController_FL_SetForceRange_Statics::PropPointers), sizeof(Z_Construct_UFunction_UAGX_ConstraintController_FL_SetForceRange_Statics::AGX_ConstraintController_FL_eventSetForceRange_Parms), RF_Public|RF_Transient|RF_MarkAsNative, (EFunctionFlags)0x04442401, 0, 0, METADATA_PARAMS(UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_ConstraintController_FL_SetForceRange_Statics::Function_MetaDataParams), Z_Construct_UFunction_UAGX_ConstraintController_FL_SetForceRange_Statics::Function_MetaDataParams)},  };
static_assert(sizeof(Z_Construct_UFunction_UAGX_ConstraintController_FL_SetForceRange_Statics::AGX_ConstraintController_FL_eventSetForceRange_Parms) < MAX_uint16);
UFunction* Z_Construct_UFunction_UAGX_ConstraintController_FL_SetForceRange()
{
	static UFunction* ReturnFunction = nullptr;
	if (!ReturnFunction)
	{
		UECodeGen_Private::ConstructUFunction(&ReturnFunction, Z_Construct_UFunction_UAGX_ConstraintController_FL_SetForceRange_Statics::FuncParams);
	}
	return ReturnFunction;
}
DEFINE_FUNCTION(UAGX_ConstraintController_FL::execSetForceRange)
{
	P_GET_STRUCT_REF(FAGX_ConstraintController,Z_Param_Out_Controller);
	P_GET_PROPERTY(FFloatProperty,Z_Param_MinForce);
	P_GET_PROPERTY(FFloatProperty,Z_Param_MaxForce);
	P_FINISH;
	P_NATIVE_BEGIN;
	UAGX_ConstraintController_FL::SetForceRange(Z_Param_Out_Controller,Z_Param_MinForce,Z_Param_MaxForce);
	P_NATIVE_END;
}
// ********** End Class UAGX_ConstraintController_FL Function SetForceRange ************************

// ********** Begin Class UAGX_ConstraintController_FL Function SetSpookDamping ********************
struct Z_Construct_UFunction_UAGX_ConstraintController_FL_SetSpookDamping_Statics
{
	struct AGX_ConstraintController_FL_eventSetSpookDamping_Parms
	{
		FAGX_ConstraintController Controller;
		float SpookDamping;
	};
#if WITH_METADATA
	static constexpr UECodeGen_Private::FMetaDataPairParam Function_MetaDataParams[] = {
		{ "Category", "AGX Constraint Controller" },
		{ "ModuleRelativePath", "Public/Constraints/AGX_ConstraintController.h" },
	};
#endif // WITH_METADATA
	static const UECodeGen_Private::FStructPropertyParams NewProp_Controller;
	static const UECodeGen_Private::FFloatPropertyParams NewProp_SpookDamping;
	static const UECodeGen_Private::FPropertyParamsBase* const PropPointers[];
	static const UECodeGen_Private::FFunctionParams FuncParams;
};
const UECodeGen_Private::FStructPropertyParams Z_Construct_UFunction_UAGX_ConstraintController_FL_SetSpookDamping_Statics::NewProp_Controller = { "Controller", nullptr, (EPropertyFlags)0x0010000008000180, UECodeGen_Private::EPropertyGenFlags::Struct, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, STRUCT_OFFSET(AGX_ConstraintController_FL_eventSetSpookDamping_Parms, Controller), Z_Construct_UScriptStruct_FAGX_ConstraintController, METADATA_PARAMS(0, nullptr) }; // 3011295661
const UECodeGen_Private::FFloatPropertyParams Z_Construct_UFunction_UAGX_ConstraintController_FL_SetSpookDamping_Statics::NewProp_SpookDamping = { "SpookDamping", nullptr, (EPropertyFlags)0x0010000000000080, UECodeGen_Private::EPropertyGenFlags::Float, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, STRUCT_OFFSET(AGX_ConstraintController_FL_eventSetSpookDamping_Parms, SpookDamping), METADATA_PARAMS(0, nullptr) };
const UECodeGen_Private::FPropertyParamsBase* const Z_Construct_UFunction_UAGX_ConstraintController_FL_SetSpookDamping_Statics::PropPointers[] = {
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UFunction_UAGX_ConstraintController_FL_SetSpookDamping_Statics::NewProp_Controller,
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UFunction_UAGX_ConstraintController_FL_SetSpookDamping_Statics::NewProp_SpookDamping,
};
static_assert(UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_ConstraintController_FL_SetSpookDamping_Statics::PropPointers) < 2048);
const UECodeGen_Private::FFunctionParams Z_Construct_UFunction_UAGX_ConstraintController_FL_SetSpookDamping_Statics::FuncParams = { { (UObject*(*)())Z_Construct_UClass_UAGX_ConstraintController_FL, nullptr, "SetSpookDamping", Z_Construct_UFunction_UAGX_ConstraintController_FL_SetSpookDamping_Statics::PropPointers, UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_ConstraintController_FL_SetSpookDamping_Statics::PropPointers), sizeof(Z_Construct_UFunction_UAGX_ConstraintController_FL_SetSpookDamping_Statics::AGX_ConstraintController_FL_eventSetSpookDamping_Parms), RF_Public|RF_Transient|RF_MarkAsNative, (EFunctionFlags)0x04442401, 0, 0, METADATA_PARAMS(UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_ConstraintController_FL_SetSpookDamping_Statics::Function_MetaDataParams), Z_Construct_UFunction_UAGX_ConstraintController_FL_SetSpookDamping_Statics::Function_MetaDataParams)},  };
static_assert(sizeof(Z_Construct_UFunction_UAGX_ConstraintController_FL_SetSpookDamping_Statics::AGX_ConstraintController_FL_eventSetSpookDamping_Parms) < MAX_uint16);
UFunction* Z_Construct_UFunction_UAGX_ConstraintController_FL_SetSpookDamping()
{
	static UFunction* ReturnFunction = nullptr;
	if (!ReturnFunction)
	{
		UECodeGen_Private::ConstructUFunction(&ReturnFunction, Z_Construct_UFunction_UAGX_ConstraintController_FL_SetSpookDamping_Statics::FuncParams);
	}
	return ReturnFunction;
}
DEFINE_FUNCTION(UAGX_ConstraintController_FL::execSetSpookDamping)
{
	P_GET_STRUCT_REF(FAGX_ConstraintController,Z_Param_Out_Controller);
	P_GET_PROPERTY(FFloatProperty,Z_Param_SpookDamping);
	P_FINISH;
	P_NATIVE_BEGIN;
	UAGX_ConstraintController_FL::SetSpookDamping(Z_Param_Out_Controller,Z_Param_SpookDamping);
	P_NATIVE_END;
}
// ********** End Class UAGX_ConstraintController_FL Function SetSpookDamping **********************

// ********** Begin Class UAGX_ConstraintController_FL *********************************************
void UAGX_ConstraintController_FL::StaticRegisterNativesUAGX_ConstraintController_FL()
{
	UClass* Class = UAGX_ConstraintController_FL::StaticClass();
	static const FNameNativePtrPair Funcs[] = {
		{ "GetCompliance", &UAGX_ConstraintController_FL::execGetCompliance },
		{ "GetElasticity", &UAGX_ConstraintController_FL::execGetElasticity },
		{ "GetEnable", &UAGX_ConstraintController_FL::execGetEnable },
		{ "GetForce", &UAGX_ConstraintController_FL::execGetForce },
		{ "GetForceRangeMax", &UAGX_ConstraintController_FL::execGetForceRangeMax },
		{ "GetForceRangeMin", &UAGX_ConstraintController_FL::execGetForceRangeMin },
		{ "GetSpookDamping", &UAGX_ConstraintController_FL::execGetSpookDamping },
		{ "IsValid", &UAGX_ConstraintController_FL::execIsValid },
		{ "SetCompliance", &UAGX_ConstraintController_FL::execSetCompliance },
		{ "SetElasticity", &UAGX_ConstraintController_FL::execSetElasticity },
		{ "SetEnable", &UAGX_ConstraintController_FL::execSetEnable },
		{ "SetForceRange", &UAGX_ConstraintController_FL::execSetForceRange },
		{ "SetSpookDamping", &UAGX_ConstraintController_FL::execSetSpookDamping },
	};
	FNativeFunctionRegistrar::RegisterFunctions(Class, Funcs, UE_ARRAY_COUNT(Funcs));
}
FClassRegistrationInfo Z_Registration_Info_UClass_UAGX_ConstraintController_FL;
UClass* UAGX_ConstraintController_FL::GetPrivateStaticClass()
{
	using TClass = UAGX_ConstraintController_FL;
	if (!Z_Registration_Info_UClass_UAGX_ConstraintController_FL.InnerSingleton)
	{
		GetPrivateStaticClassBody(
			StaticPackage(),
			TEXT("AGX_ConstraintController_FL"),
			Z_Registration_Info_UClass_UAGX_ConstraintController_FL.InnerSingleton,
			StaticRegisterNativesUAGX_ConstraintController_FL,
			sizeof(TClass),
			alignof(TClass),
			TClass::StaticClassFlags,
			TClass::StaticClassCastFlags(),
			TClass::StaticConfigName(),
			(UClass::ClassConstructorType)InternalConstructor<TClass>,
			(UClass::ClassVTableHelperCtorCallerType)InternalVTableHelperCtorCaller<TClass>,
			UOBJECT_CPPCLASS_STATICFUNCTIONS_FORCLASS(TClass),
			&TClass::Super::StaticClass,
			&TClass::WithinClass::StaticClass
		);
	}
	return Z_Registration_Info_UClass_UAGX_ConstraintController_FL.InnerSingleton;
}
UClass* Z_Construct_UClass_UAGX_ConstraintController_FL_NoRegister()
{
	return UAGX_ConstraintController_FL::GetPrivateStaticClass();
}
struct Z_Construct_UClass_UAGX_ConstraintController_FL_Statics
{
#if WITH_METADATA
	static constexpr UECodeGen_Private::FMetaDataPairParam Class_MetaDataParams[] = {
		{ "Comment", "/**\n * This class acts as an API that exposes functions of FAGX_ConstraintController in Blueprints.\n */" },
		{ "IncludePath", "Constraints/AGX_ConstraintController.h" },
		{ "ModuleRelativePath", "Public/Constraints/AGX_ConstraintController.h" },
		{ "ToolTip", "This class acts as an API that exposes functions of FAGX_ConstraintController in Blueprints." },
	};
#endif // WITH_METADATA
	static UObject* (*const DependentSingletons[])();
	static constexpr FClassFunctionLinkInfo FuncInfo[] = {
		{ &Z_Construct_UFunction_UAGX_ConstraintController_FL_GetCompliance, "GetCompliance" }, // 1051967573
		{ &Z_Construct_UFunction_UAGX_ConstraintController_FL_GetElasticity, "GetElasticity" }, // 1500956163
		{ &Z_Construct_UFunction_UAGX_ConstraintController_FL_GetEnable, "GetEnable" }, // 2135671030
		{ &Z_Construct_UFunction_UAGX_ConstraintController_FL_GetForce, "GetForce" }, // 3826233293
		{ &Z_Construct_UFunction_UAGX_ConstraintController_FL_GetForceRangeMax, "GetForceRangeMax" }, // 796504033
		{ &Z_Construct_UFunction_UAGX_ConstraintController_FL_GetForceRangeMin, "GetForceRangeMin" }, // 2971659667
		{ &Z_Construct_UFunction_UAGX_ConstraintController_FL_GetSpookDamping, "GetSpookDamping" }, // 1945018481
		{ &Z_Construct_UFunction_UAGX_ConstraintController_FL_IsValid, "IsValid" }, // 1008338374
		{ &Z_Construct_UFunction_UAGX_ConstraintController_FL_SetCompliance, "SetCompliance" }, // 4109927460
		{ &Z_Construct_UFunction_UAGX_ConstraintController_FL_SetElasticity, "SetElasticity" }, // 193466426
		{ &Z_Construct_UFunction_UAGX_ConstraintController_FL_SetEnable, "SetEnable" }, // 2382759773
		{ &Z_Construct_UFunction_UAGX_ConstraintController_FL_SetForceRange, "SetForceRange" }, // 1921074797
		{ &Z_Construct_UFunction_UAGX_ConstraintController_FL_SetSpookDamping, "SetSpookDamping" }, // 3439653962
	};
	static_assert(UE_ARRAY_COUNT(FuncInfo) < 2048);
	static constexpr FCppClassTypeInfoStatic StaticCppClassTypeInfo = {
		TCppClassTypeTraits<UAGX_ConstraintController_FL>::IsAbstract,
	};
	static const UECodeGen_Private::FClassParams ClassParams;
};
UObject* (*const Z_Construct_UClass_UAGX_ConstraintController_FL_Statics::DependentSingletons[])() = {
	(UObject* (*)())Z_Construct_UClass_UBlueprintFunctionLibrary,
	(UObject* (*)())Z_Construct_UPackage__Script_AGXUnreal,
};
static_assert(UE_ARRAY_COUNT(Z_Construct_UClass_UAGX_ConstraintController_FL_Statics::DependentSingletons) < 16);
const UECodeGen_Private::FClassParams Z_Construct_UClass_UAGX_ConstraintController_FL_Statics::ClassParams = {
	&UAGX_ConstraintController_FL::StaticClass,
	nullptr,
	&StaticCppClassTypeInfo,
	DependentSingletons,
	FuncInfo,
	nullptr,
	nullptr,
	UE_ARRAY_COUNT(DependentSingletons),
	UE_ARRAY_COUNT(FuncInfo),
	0,
	0,
	0x001000A0u,
	METADATA_PARAMS(UE_ARRAY_COUNT(Z_Construct_UClass_UAGX_ConstraintController_FL_Statics::Class_MetaDataParams), Z_Construct_UClass_UAGX_ConstraintController_FL_Statics::Class_MetaDataParams)
};
UClass* Z_Construct_UClass_UAGX_ConstraintController_FL()
{
	if (!Z_Registration_Info_UClass_UAGX_ConstraintController_FL.OuterSingleton)
	{
		UECodeGen_Private::ConstructUClass(Z_Registration_Info_UClass_UAGX_ConstraintController_FL.OuterSingleton, Z_Construct_UClass_UAGX_ConstraintController_FL_Statics::ClassParams);
	}
	return Z_Registration_Info_UClass_UAGX_ConstraintController_FL.OuterSingleton;
}
UAGX_ConstraintController_FL::UAGX_ConstraintController_FL(const FObjectInitializer& ObjectInitializer) : Super(ObjectInitializer) {}
DEFINE_VTABLE_PTR_HELPER_CTOR(UAGX_ConstraintController_FL);
UAGX_ConstraintController_FL::~UAGX_ConstraintController_FL() {}
// ********** End Class UAGX_ConstraintController_FL ***********************************************

// ********** Begin Registration *******************************************************************
struct Z_CompiledInDeferFile_FID_GitLab_Runner_builds_9YzzThLq_0_algoryx_unreal_agxunreal_s_selfhosted_build_AGXUnreal_HostProject_Plugins_AGXUnreal_Source_AGXUnreal_Public_Constraints_AGX_ConstraintController_h__Script_AGXUnreal_Statics
{
	static constexpr FStructRegisterCompiledInInfo ScriptStructInfo[] = {
		{ FAGX_ConstraintController::StaticStruct, Z_Construct_UScriptStruct_FAGX_ConstraintController_Statics::NewStructOps, TEXT("AGX_ConstraintController"), &Z_Registration_Info_UScriptStruct_FAGX_ConstraintController, CONSTRUCT_RELOAD_VERSION_INFO(FStructReloadVersionInfo, sizeof(FAGX_ConstraintController), 3011295661U) },
	};
	static constexpr FClassRegisterCompiledInInfo ClassInfo[] = {
		{ Z_Construct_UClass_UAGX_ConstraintController_FL, UAGX_ConstraintController_FL::StaticClass, TEXT("UAGX_ConstraintController_FL"), &Z_Registration_Info_UClass_UAGX_ConstraintController_FL, CONSTRUCT_RELOAD_VERSION_INFO(FClassReloadVersionInfo, sizeof(UAGX_ConstraintController_FL), 1141672437U) },
	};
};
static FRegisterCompiledInInfo Z_CompiledInDeferFile_FID_GitLab_Runner_builds_9YzzThLq_0_algoryx_unreal_agxunreal_s_selfhosted_build_AGXUnreal_HostProject_Plugins_AGXUnreal_Source_AGXUnreal_Public_Constraints_AGX_ConstraintController_h__Script_AGXUnreal_2881951976(TEXT("/Script/AGXUnreal"),
	Z_CompiledInDeferFile_FID_GitLab_Runner_builds_9YzzThLq_0_algoryx_unreal_agxunreal_s_selfhosted_build_AGXUnreal_HostProject_Plugins_AGXUnreal_Source_AGXUnreal_Public_Constraints_AGX_ConstraintController_h__Script_AGXUnreal_Statics::ClassInfo, UE_ARRAY_COUNT(Z_CompiledInDeferFile_FID_GitLab_Runner_builds_9YzzThLq_0_algoryx_unreal_agxunreal_s_selfhosted_build_AGXUnreal_HostProject_Plugins_AGXUnreal_Source_AGXUnreal_Public_Constraints_AGX_ConstraintController_h__Script_AGXUnreal_Statics::ClassInfo),
	Z_CompiledInDeferFile_FID_GitLab_Runner_builds_9YzzThLq_0_algoryx_unreal_agxunreal_s_selfhosted_build_AGXUnreal_HostProject_Plugins_AGXUnreal_Source_AGXUnreal_Public_Constraints_AGX_ConstraintController_h__Script_AGXUnreal_Statics::ScriptStructInfo, UE_ARRAY_COUNT(Z_CompiledInDeferFile_FID_GitLab_Runner_builds_9YzzThLq_0_algoryx_unreal_agxunreal_s_selfhosted_build_AGXUnreal_HostProject_Plugins_AGXUnreal_Source_AGXUnreal_Public_Constraints_AGX_ConstraintController_h__Script_AGXUnreal_Statics::ScriptStructInfo),
	nullptr, 0);
// ********** End Registration *********************************************************************

PRAGMA_ENABLE_DEPRECATION_WARNINGS
