%define OPENPLX_SWIG_NS_IMPORT_PARENT_DEPENDENCIES_Robotics_EndEffectors()
%enddef

%define OPENPLX_SWIG_NS_MODULE_H_DEPENDENCIES_Robotics_EndEffectors()
%{
#include <openplx/DriveTrain/DriveTrain_all.h>
#include <openplx/Math/Math_all.h>
#include <openplx/Physics/Physics_all.h>
#include <openplx/Physics1D/Physics1D_all.h>
#include <openplx/Physics3D/Physics3D_all.h>
#include <openplx/Simulation/Simulation_all.h>
#include <openplx/Robotics/Robotics_all.h>
%}
%enddef

%define OPENPLX_SWIG_NS_RENAMES_Robotics_EndEffectors(prefix)
%rename(prefix ## ConstantVacuumSystem) openplx::Robotics::EndEffectors::ConstantVacuumSystem;
%rename(prefix ## SixDofSuctionCup) openplx::Robotics::EndEffectors::SixDofSuctionCup;
%rename(prefix ## SixDofSuctionCupJoint) openplx::Robotics::EndEffectors::SixDofSuctionCupJoint;
%rename(prefix ## SuctionCup) openplx::Robotics::EndEffectors::SuctionCup;
%rename(prefix ## SuctionCupElastoDynamics) openplx::Robotics::EndEffectors::SuctionCupElastoDynamics;
%rename(prefix ## VacuumGripper) openplx::Robotics::EndEffectors::VacuumGripper;
%rename(prefix ## VacuumSystem) openplx::Robotics::EndEffectors::VacuumSystem;
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTERS_Robotics_EndEffectors()
%shared_ptr(openplx::Robotics::EndEffectors::ConstantVacuumSystem);
%shared_ptr(openplx::Robotics::EndEffectors::SixDofSuctionCup);
%shared_ptr(openplx::Robotics::EndEffectors::SixDofSuctionCupJoint);
%shared_ptr(openplx::Robotics::EndEffectors::SuctionCup);
%shared_ptr(openplx::Robotics::EndEffectors::SuctionCupElastoDynamics);
%shared_ptr(openplx::Robotics::EndEffectors::VacuumGripper);
%shared_ptr(openplx::Robotics::EndEffectors::VacuumSystem);
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Robotics_EndEffectors()
%typemap(out) std::shared_ptr<openplx::Robotics::EndEffectors::ConstantVacuumSystem> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Robotics::EndEffectors::SixDofSuctionCup> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Robotics::EndEffectors::SixDofSuctionCupJoint> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Robotics::EndEffectors::SuctionCup> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Robotics::EndEffectors::SuctionCupElastoDynamics> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Robotics::EndEffectors::VacuumGripper> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Robotics::EndEffectors::VacuumSystem> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%enddef

%define OPENPLX_SWIG_NS_VECTORS_Robotics_EndEffectors()
%template(Robotics_EndEffectors_ConstantVacuumSystem_Vector) std::vector<std::shared_ptr<openplx::Robotics::EndEffectors::ConstantVacuumSystem>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Robotics::EndEffectors::ConstantVacuumSystem>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Robotics::EndEffectors::ConstantVacuumSystem>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Robotics::EndEffectors::ConstantVacuumSystem>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Robotics::EndEffectors::ConstantVacuumSystem>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Robotics::EndEffectors::ConstantVacuumSystem>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Robotics::EndEffectors::ConstantVacuumSystem>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Robotics_EndEffectors_SixDofSuctionCup_Vector) std::vector<std::shared_ptr<openplx::Robotics::EndEffectors::SixDofSuctionCup>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Robotics::EndEffectors::SixDofSuctionCup>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Robotics::EndEffectors::SixDofSuctionCup>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Robotics::EndEffectors::SixDofSuctionCup>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Robotics::EndEffectors::SixDofSuctionCup>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Robotics::EndEffectors::SixDofSuctionCup>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Robotics::EndEffectors::SixDofSuctionCup>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Robotics_EndEffectors_SixDofSuctionCupJoint_Vector) std::vector<std::shared_ptr<openplx::Robotics::EndEffectors::SixDofSuctionCupJoint>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Robotics::EndEffectors::SixDofSuctionCupJoint>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Robotics::EndEffectors::SixDofSuctionCupJoint>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Robotics::EndEffectors::SixDofSuctionCupJoint>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Robotics::EndEffectors::SixDofSuctionCupJoint>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Robotics::EndEffectors::SixDofSuctionCupJoint>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Robotics::EndEffectors::SixDofSuctionCupJoint>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Robotics_EndEffectors_SuctionCup_Vector) std::vector<std::shared_ptr<openplx::Robotics::EndEffectors::SuctionCup>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Robotics::EndEffectors::SuctionCup>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Robotics::EndEffectors::SuctionCup>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Robotics::EndEffectors::SuctionCup>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Robotics::EndEffectors::SuctionCup>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Robotics::EndEffectors::SuctionCup>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Robotics::EndEffectors::SuctionCup>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Robotics_EndEffectors_SuctionCupElastoDynamics_Vector) std::vector<std::shared_ptr<openplx::Robotics::EndEffectors::SuctionCupElastoDynamics>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Robotics::EndEffectors::SuctionCupElastoDynamics>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Robotics::EndEffectors::SuctionCupElastoDynamics>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Robotics::EndEffectors::SuctionCupElastoDynamics>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Robotics::EndEffectors::SuctionCupElastoDynamics>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Robotics::EndEffectors::SuctionCupElastoDynamics>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Robotics::EndEffectors::SuctionCupElastoDynamics>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Robotics_EndEffectors_VacuumGripper_Vector) std::vector<std::shared_ptr<openplx::Robotics::EndEffectors::VacuumGripper>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Robotics::EndEffectors::VacuumGripper>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Robotics::EndEffectors::VacuumGripper>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Robotics::EndEffectors::VacuumGripper>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Robotics::EndEffectors::VacuumGripper>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Robotics::EndEffectors::VacuumGripper>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Robotics::EndEffectors::VacuumGripper>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Robotics_EndEffectors_VacuumSystem_Vector) std::vector<std::shared_ptr<openplx::Robotics::EndEffectors::VacuumSystem>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Robotics::EndEffectors::VacuumSystem>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Robotics::EndEffectors::VacuumSystem>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Robotics::EndEffectors::VacuumSystem>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Robotics::EndEffectors::VacuumSystem>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Robotics::EndEffectors::VacuumSystem>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Robotics::EndEffectors::VacuumSystem>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%enddef

%define OPENPLX_SWIG_NS_INCLUDES_Robotics_EndEffectors()
%include "openplx/Robotics/EndEffectors/VacuumSystem.h"
%include "openplx/Robotics/EndEffectors/ConstantVacuumSystem.h"
%include "openplx/Robotics/EndEffectors/SuctionCup.h"
%include "openplx/Robotics/EndEffectors/SixDofSuctionCup.h"
%include "openplx/Robotics/EndEffectors/SixDofSuctionCupJoint.h"
%include "openplx/Robotics/EndEffectors/SuctionCupElastoDynamics.h"
%include "openplx/Robotics/EndEffectors/VacuumGripper.h"
%enddef

%define OPENPLX_SWIG_NS_PY_IMPORTS_Robotics_EndEffectors()
%pythoncode %{
%}
%enddef

%define OPENPLX_SWIG_NS_IMPORT_PARENT_DEPENDENCIES_Robotics_Joints()
%enddef

%define OPENPLX_SWIG_NS_MODULE_H_DEPENDENCIES_Robotics_Joints()
%{
#include <openplx/DriveTrain/DriveTrain_all.h>
#include <openplx/Math/Math_all.h>
#include <openplx/Physics/Physics_all.h>
#include <openplx/Physics1D/Physics1D_all.h>
#include <openplx/Physics3D/Physics3D_all.h>
#include <openplx/Simulation/Simulation_all.h>
#include <openplx/Robotics/Robotics_all.h>
%}
%enddef

%define OPENPLX_SWIG_NS_RENAMES_Robotics_Joints(prefix)
%rename(prefix ## ActuatedJoint) openplx::Robotics::Joints::ActuatedJoint;
%rename(prefix ## CoupledJointDriveTrain) openplx::Robotics::Joints::CoupledJointDriveTrain;
%rename(prefix ## FixedJoint) openplx::Robotics::Joints::FixedJoint;
%rename(prefix ## FlexibleAngularVelocityJoint) openplx::Robotics::Joints::FlexibleAngularVelocityJoint;
%rename(prefix ## FlexibleJointData) openplx::Robotics::Joints::FlexibleJointData;
%rename(prefix ## FlexibleJointDriveTrain) openplx::Robotics::Joints::FlexibleJointDriveTrain;
%rename(prefix ## FlexibleTorqueJoint) openplx::Robotics::Joints::FlexibleTorqueJoint;
%rename(prefix ## HingeJoint) openplx::Robotics::Joints::HingeJoint;
%rename(prefix ## HingeJointData) openplx::Robotics::Joints::HingeJointData;
%rename(prefix ## Joint) openplx::Robotics::Joints::Joint;
%rename(prefix ## JointData) openplx::Robotics::Joints::JointData;
%rename(prefix ## PositionHingeJoint) openplx::Robotics::Joints::PositionHingeJoint;
%rename(prefix ## PrismaticJoint) openplx::Robotics::Joints::PrismaticJoint;
%rename(prefix ## TorqueHingeJoint) openplx::Robotics::Joints::TorqueHingeJoint;
%rename(prefix ## VelocityHingeJoint) openplx::Robotics::Joints::VelocityHingeJoint;
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTERS_Robotics_Joints()
%shared_ptr(openplx::Robotics::Joints::ActuatedJoint);
%shared_ptr(openplx::Robotics::Joints::CoupledJointDriveTrain);
%shared_ptr(openplx::Robotics::Joints::FixedJoint);
%shared_ptr(openplx::Robotics::Joints::FlexibleAngularVelocityJoint);
%shared_ptr(openplx::Robotics::Joints::FlexibleJointData);
%shared_ptr(openplx::Robotics::Joints::FlexibleJointDriveTrain);
%shared_ptr(openplx::Robotics::Joints::FlexibleTorqueJoint);
%shared_ptr(openplx::Robotics::Joints::HingeJoint);
%shared_ptr(openplx::Robotics::Joints::HingeJointData);
%shared_ptr(openplx::Robotics::Joints::Joint);
%shared_ptr(openplx::Robotics::Joints::JointData);
%shared_ptr(openplx::Robotics::Joints::PositionHingeJoint);
%shared_ptr(openplx::Robotics::Joints::PrismaticJoint);
%shared_ptr(openplx::Robotics::Joints::TorqueHingeJoint);
%shared_ptr(openplx::Robotics::Joints::VelocityHingeJoint);
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Robotics_Joints()
%typemap(out) std::shared_ptr<openplx::Robotics::Joints::ActuatedJoint> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Robotics::Joints::CoupledJointDriveTrain> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Robotics::Joints::FixedJoint> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Robotics::Joints::FlexibleAngularVelocityJoint> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Robotics::Joints::FlexibleJointData> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Robotics::Joints::FlexibleJointDriveTrain> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Robotics::Joints::FlexibleTorqueJoint> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Robotics::Joints::HingeJoint> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Robotics::Joints::HingeJointData> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Robotics::Joints::Joint> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Robotics::Joints::JointData> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Robotics::Joints::PositionHingeJoint> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Robotics::Joints::PrismaticJoint> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Robotics::Joints::TorqueHingeJoint> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Robotics::Joints::VelocityHingeJoint> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%enddef

%define OPENPLX_SWIG_NS_VECTORS_Robotics_Joints()
%template(Robotics_Joints_ActuatedJoint_Vector) std::vector<std::shared_ptr<openplx::Robotics::Joints::ActuatedJoint>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Robotics::Joints::ActuatedJoint>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Robotics::Joints::ActuatedJoint>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Robotics::Joints::ActuatedJoint>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Robotics::Joints::ActuatedJoint>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Robotics::Joints::ActuatedJoint>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Robotics::Joints::ActuatedJoint>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Robotics_Joints_CoupledJointDriveTrain_Vector) std::vector<std::shared_ptr<openplx::Robotics::Joints::CoupledJointDriveTrain>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Robotics::Joints::CoupledJointDriveTrain>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Robotics::Joints::CoupledJointDriveTrain>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Robotics::Joints::CoupledJointDriveTrain>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Robotics::Joints::CoupledJointDriveTrain>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Robotics::Joints::CoupledJointDriveTrain>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Robotics::Joints::CoupledJointDriveTrain>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Robotics_Joints_FixedJoint_Vector) std::vector<std::shared_ptr<openplx::Robotics::Joints::FixedJoint>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Robotics::Joints::FixedJoint>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Robotics::Joints::FixedJoint>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Robotics::Joints::FixedJoint>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Robotics::Joints::FixedJoint>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Robotics::Joints::FixedJoint>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Robotics::Joints::FixedJoint>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Robotics_Joints_FlexibleAngularVelocityJoint_Vector) std::vector<std::shared_ptr<openplx::Robotics::Joints::FlexibleAngularVelocityJoint>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Robotics::Joints::FlexibleAngularVelocityJoint>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Robotics::Joints::FlexibleAngularVelocityJoint>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Robotics::Joints::FlexibleAngularVelocityJoint>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Robotics::Joints::FlexibleAngularVelocityJoint>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Robotics::Joints::FlexibleAngularVelocityJoint>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Robotics::Joints::FlexibleAngularVelocityJoint>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Robotics_Joints_FlexibleJointData_Vector) std::vector<std::shared_ptr<openplx::Robotics::Joints::FlexibleJointData>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Robotics::Joints::FlexibleJointData>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Robotics::Joints::FlexibleJointData>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Robotics::Joints::FlexibleJointData>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Robotics::Joints::FlexibleJointData>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Robotics::Joints::FlexibleJointData>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Robotics::Joints::FlexibleJointData>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Robotics_Joints_FlexibleJointDriveTrain_Vector) std::vector<std::shared_ptr<openplx::Robotics::Joints::FlexibleJointDriveTrain>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Robotics::Joints::FlexibleJointDriveTrain>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Robotics::Joints::FlexibleJointDriveTrain>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Robotics::Joints::FlexibleJointDriveTrain>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Robotics::Joints::FlexibleJointDriveTrain>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Robotics::Joints::FlexibleJointDriveTrain>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Robotics::Joints::FlexibleJointDriveTrain>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Robotics_Joints_FlexibleTorqueJoint_Vector) std::vector<std::shared_ptr<openplx::Robotics::Joints::FlexibleTorqueJoint>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Robotics::Joints::FlexibleTorqueJoint>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Robotics::Joints::FlexibleTorqueJoint>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Robotics::Joints::FlexibleTorqueJoint>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Robotics::Joints::FlexibleTorqueJoint>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Robotics::Joints::FlexibleTorqueJoint>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Robotics::Joints::FlexibleTorqueJoint>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Robotics_Joints_HingeJoint_Vector) std::vector<std::shared_ptr<openplx::Robotics::Joints::HingeJoint>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Robotics::Joints::HingeJoint>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Robotics::Joints::HingeJoint>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Robotics::Joints::HingeJoint>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Robotics::Joints::HingeJoint>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Robotics::Joints::HingeJoint>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Robotics::Joints::HingeJoint>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Robotics_Joints_HingeJointData_Vector) std::vector<std::shared_ptr<openplx::Robotics::Joints::HingeJointData>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Robotics::Joints::HingeJointData>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Robotics::Joints::HingeJointData>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Robotics::Joints::HingeJointData>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Robotics::Joints::HingeJointData>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Robotics::Joints::HingeJointData>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Robotics::Joints::HingeJointData>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Robotics_Joints_Joint_Vector) std::vector<std::shared_ptr<openplx::Robotics::Joints::Joint>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Robotics::Joints::Joint>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Robotics::Joints::Joint>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Robotics::Joints::Joint>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Robotics::Joints::Joint>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Robotics::Joints::Joint>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Robotics::Joints::Joint>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Robotics_Joints_JointData_Vector) std::vector<std::shared_ptr<openplx::Robotics::Joints::JointData>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Robotics::Joints::JointData>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Robotics::Joints::JointData>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Robotics::Joints::JointData>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Robotics::Joints::JointData>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Robotics::Joints::JointData>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Robotics::Joints::JointData>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Robotics_Joints_PositionHingeJoint_Vector) std::vector<std::shared_ptr<openplx::Robotics::Joints::PositionHingeJoint>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Robotics::Joints::PositionHingeJoint>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Robotics::Joints::PositionHingeJoint>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Robotics::Joints::PositionHingeJoint>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Robotics::Joints::PositionHingeJoint>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Robotics::Joints::PositionHingeJoint>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Robotics::Joints::PositionHingeJoint>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Robotics_Joints_PrismaticJoint_Vector) std::vector<std::shared_ptr<openplx::Robotics::Joints::PrismaticJoint>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Robotics::Joints::PrismaticJoint>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Robotics::Joints::PrismaticJoint>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Robotics::Joints::PrismaticJoint>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Robotics::Joints::PrismaticJoint>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Robotics::Joints::PrismaticJoint>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Robotics::Joints::PrismaticJoint>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Robotics_Joints_TorqueHingeJoint_Vector) std::vector<std::shared_ptr<openplx::Robotics::Joints::TorqueHingeJoint>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Robotics::Joints::TorqueHingeJoint>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Robotics::Joints::TorqueHingeJoint>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Robotics::Joints::TorqueHingeJoint>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Robotics::Joints::TorqueHingeJoint>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Robotics::Joints::TorqueHingeJoint>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Robotics::Joints::TorqueHingeJoint>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Robotics_Joints_VelocityHingeJoint_Vector) std::vector<std::shared_ptr<openplx::Robotics::Joints::VelocityHingeJoint>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Robotics::Joints::VelocityHingeJoint>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Robotics::Joints::VelocityHingeJoint>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Robotics::Joints::VelocityHingeJoint>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Robotics::Joints::VelocityHingeJoint>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Robotics::Joints::VelocityHingeJoint>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Robotics::Joints::VelocityHingeJoint>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%enddef

%define OPENPLX_SWIG_NS_INCLUDES_Robotics_Joints()
%include "openplx/Robotics/Joints/Joint.h"
%include "openplx/Robotics/Joints/ActuatedJoint.h"
%include "openplx/Robotics/Joints/CoupledJointDriveTrain.h"
%include "openplx/Robotics/Joints/FixedJoint.h"
%include "openplx/Robotics/Joints/HingeJoint.h"
%include "openplx/Robotics/Joints/FlexibleJointTrait.h"
%include "openplx/Robotics/Joints/FlexibleAngularVelocityJoint.h"
%include "openplx/Robotics/Joints/JointData.h"
%include "openplx/Robotics/Joints/HingeJointData.h"
%include "openplx/Robotics/Joints/FlexibleJointData.h"
%include "openplx/Robotics/Joints/FlexibleJointDriveTrain.h"
%include "openplx/Robotics/Joints/FlexibleTorqueJoint.h"
%include "openplx/Robotics/Joints/PositionHingeJoint.h"
%include "openplx/Robotics/Joints/PrismaticJoint.h"
%include "openplx/Robotics/Joints/TorqueHingeJoint.h"
%include "openplx/Robotics/Joints/VelocityHingeJoint.h"
%enddef

%define OPENPLX_SWIG_NS_PY_IMPORTS_Robotics_Joints()
%pythoncode %{
%}
%enddef

%define OPENPLX_SWIG_NS_IMPORT_PARENT_DEPENDENCIES_Robotics_Links()
%enddef

%define OPENPLX_SWIG_NS_MODULE_H_DEPENDENCIES_Robotics_Links()
%{
#include <openplx/DriveTrain/DriveTrain_all.h>
#include <openplx/Math/Math_all.h>
#include <openplx/Physics/Physics_all.h>
#include <openplx/Physics1D/Physics1D_all.h>
#include <openplx/Physics3D/Physics3D_all.h>
#include <openplx/Simulation/Simulation_all.h>
#include <openplx/Robotics/Robotics_all.h>
%}
%enddef

%define OPENPLX_SWIG_NS_RENAMES_Robotics_Links(prefix)
%rename(prefix ## LinkData) openplx::Robotics::Links::LinkData;
%rename(prefix ## RigidBoxLink) openplx::Robotics::Links::RigidBoxLink;
%rename(prefix ## RigidLink) openplx::Robotics::Links::RigidLink;
%rename(prefix ## RigidTriMeshLink) openplx::Robotics::Links::RigidTriMeshLink;
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTERS_Robotics_Links()
%shared_ptr(openplx::Robotics::Links::LinkData);
%shared_ptr(openplx::Robotics::Links::RigidBoxLink);
%shared_ptr(openplx::Robotics::Links::RigidLink);
%shared_ptr(openplx::Robotics::Links::RigidTriMeshLink);
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Robotics_Links()
%typemap(out) std::shared_ptr<openplx::Robotics::Links::LinkData> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Robotics::Links::RigidBoxLink> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Robotics::Links::RigidLink> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Robotics::Links::RigidTriMeshLink> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%enddef

%define OPENPLX_SWIG_NS_VECTORS_Robotics_Links()
%template(Robotics_Links_LinkData_Vector) std::vector<std::shared_ptr<openplx::Robotics::Links::LinkData>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Robotics::Links::LinkData>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Robotics::Links::LinkData>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Robotics::Links::LinkData>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Robotics::Links::LinkData>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Robotics::Links::LinkData>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Robotics::Links::LinkData>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Robotics_Links_RigidBoxLink_Vector) std::vector<std::shared_ptr<openplx::Robotics::Links::RigidBoxLink>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Robotics::Links::RigidBoxLink>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Robotics::Links::RigidBoxLink>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Robotics::Links::RigidBoxLink>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Robotics::Links::RigidBoxLink>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Robotics::Links::RigidBoxLink>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Robotics::Links::RigidBoxLink>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Robotics_Links_RigidLink_Vector) std::vector<std::shared_ptr<openplx::Robotics::Links::RigidLink>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Robotics::Links::RigidLink>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Robotics::Links::RigidLink>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Robotics::Links::RigidLink>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Robotics::Links::RigidLink>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Robotics::Links::RigidLink>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Robotics::Links::RigidLink>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Robotics_Links_RigidTriMeshLink_Vector) std::vector<std::shared_ptr<openplx::Robotics::Links::RigidTriMeshLink>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Robotics::Links::RigidTriMeshLink>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Robotics::Links::RigidTriMeshLink>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Robotics::Links::RigidTriMeshLink>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Robotics::Links::RigidTriMeshLink>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Robotics::Links::RigidTriMeshLink>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Robotics::Links::RigidTriMeshLink>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%enddef

%define OPENPLX_SWIG_NS_INCLUDES_Robotics_Links()
%include "openplx/Robotics/Links/LinkData.h"
%include "openplx/Robotics/Links/RigidLink.h"
%include "openplx/Robotics/Links/RigidBoxLink.h"
%include "openplx/Robotics/Links/RigidTriMeshLink.h"
%enddef

%define OPENPLX_SWIG_NS_PY_IMPORTS_Robotics_Links()
%pythoncode %{
%}
%enddef

%define OPENPLX_SWIG_NS_IMPORT_PARENT_DEPENDENCIES_Robotics_Robots()
%enddef

%define OPENPLX_SWIG_NS_MODULE_H_DEPENDENCIES_Robotics_Robots()
%{
#include <openplx/DriveTrain/DriveTrain_all.h>
#include <openplx/Math/Math_all.h>
#include <openplx/Physics/Physics_all.h>
#include <openplx/Physics1D/Physics1D_all.h>
#include <openplx/Physics3D/Physics3D_all.h>
#include <openplx/Simulation/Simulation_all.h>
#include <openplx/Robotics/Robotics_all.h>
%}
%enddef

%define OPENPLX_SWIG_NS_RENAMES_Robotics_Robots(prefix)
%rename(prefix ## Robot) openplx::Robotics::Robots::Robot;
%rename(prefix ## SerialManipulatorData) openplx::Robotics::Robots::SerialManipulatorData;
%rename(prefix ## SixAxisSerialManipulator) openplx::Robotics::Robots::SixAxisSerialManipulator;
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTERS_Robotics_Robots()
%shared_ptr(openplx::Robotics::Robots::Robot);
%shared_ptr(openplx::Robotics::Robots::SerialManipulatorData);
%shared_ptr(openplx::Robotics::Robots::SixAxisSerialManipulator);
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Robotics_Robots()
%typemap(out) std::shared_ptr<openplx::Robotics::Robots::Robot> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Robotics::Robots::SerialManipulatorData> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Robotics::Robots::SixAxisSerialManipulator> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%enddef

%define OPENPLX_SWIG_NS_VECTORS_Robotics_Robots()
%template(Robotics_Robots_Robot_Vector) std::vector<std::shared_ptr<openplx::Robotics::Robots::Robot>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Robotics::Robots::Robot>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Robotics::Robots::Robot>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Robotics::Robots::Robot>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Robotics::Robots::Robot>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Robotics::Robots::Robot>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Robotics::Robots::Robot>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Robotics_Robots_SerialManipulatorData_Vector) std::vector<std::shared_ptr<openplx::Robotics::Robots::SerialManipulatorData>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Robotics::Robots::SerialManipulatorData>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Robotics::Robots::SerialManipulatorData>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Robotics::Robots::SerialManipulatorData>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Robotics::Robots::SerialManipulatorData>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Robotics::Robots::SerialManipulatorData>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Robotics::Robots::SerialManipulatorData>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Robotics_Robots_SixAxisSerialManipulator_Vector) std::vector<std::shared_ptr<openplx::Robotics::Robots::SixAxisSerialManipulator>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Robotics::Robots::SixAxisSerialManipulator>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Robotics::Robots::SixAxisSerialManipulator>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Robotics::Robots::SixAxisSerialManipulator>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Robotics::Robots::SixAxisSerialManipulator>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Robotics::Robots::SixAxisSerialManipulator>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Robotics::Robots::SixAxisSerialManipulator>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%enddef

%define OPENPLX_SWIG_NS_INCLUDES_Robotics_Robots()
%include "openplx/Robotics/Robots/Robot.h"
%include "openplx/Robotics/Robots/SerialManipulatorData.h"
%include "openplx/Robotics/Robots/SixAxisSerialManipulator.h"
%enddef

%define OPENPLX_SWIG_NS_PY_IMPORTS_Robotics_Robots()
%pythoncode %{
%}
%enddef

%define OPENPLX_SWIG_NS_IMPORT_PARENT_DEPENDENCIES_Robotics_Signals()
%enddef

%define OPENPLX_SWIG_NS_MODULE_H_DEPENDENCIES_Robotics_Signals()
%{
#include <openplx/DriveTrain/DriveTrain_all.h>
#include <openplx/Math/Math_all.h>
#include <openplx/Physics/Physics_all.h>
#include <openplx/Physics1D/Physics1D_all.h>
#include <openplx/Physics3D/Physics3D_all.h>
#include <openplx/Simulation/Simulation_all.h>
#include <openplx/Robotics/Robotics_all.h>
%}
%enddef

%define OPENPLX_SWIG_NS_RENAMES_Robotics_Signals(prefix)
%rename(prefix ## RobotInput) openplx::Robotics::Signals::RobotInput;
%rename(prefix ## RobotInputSignal) openplx::Robotics::Signals::RobotInputSignal;
%rename(prefix ## RobotOutput) openplx::Robotics::Signals::RobotOutput;
%rename(prefix ## RobotOutputSignal) openplx::Robotics::Signals::RobotOutputSignal;
%rename(prefix ## Sensor) openplx::Robotics::Signals::Sensor;
%rename(prefix ## SensorValues) openplx::Robotics::Signals::SensorValues;
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTERS_Robotics_Signals()
%shared_ptr(openplx::Robotics::Signals::RobotInput);
%shared_ptr(openplx::Robotics::Signals::RobotInputSignal);
%shared_ptr(openplx::Robotics::Signals::RobotOutput);
%shared_ptr(openplx::Robotics::Signals::RobotOutputSignal);
%shared_ptr(openplx::Robotics::Signals::Sensor);
%shared_ptr(openplx::Robotics::Signals::SensorValues);
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Robotics_Signals()
%typemap(out) std::shared_ptr<openplx::Robotics::Signals::RobotInput> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Robotics::Signals::RobotInputSignal> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Robotics::Signals::RobotOutput> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Robotics::Signals::RobotOutputSignal> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Robotics::Signals::Sensor> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Robotics::Signals::SensorValues> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%enddef

%define OPENPLX_SWIG_NS_VECTORS_Robotics_Signals()
%template(Robotics_Signals_RobotInput_Vector) std::vector<std::shared_ptr<openplx::Robotics::Signals::RobotInput>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Robotics::Signals::RobotInput>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Robotics::Signals::RobotInput>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Robotics::Signals::RobotInput>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Robotics::Signals::RobotInput>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Robotics::Signals::RobotInput>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Robotics::Signals::RobotInput>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Robotics_Signals_RobotInputSignal_Vector) std::vector<std::shared_ptr<openplx::Robotics::Signals::RobotInputSignal>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Robotics::Signals::RobotInputSignal>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Robotics::Signals::RobotInputSignal>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Robotics::Signals::RobotInputSignal>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Robotics::Signals::RobotInputSignal>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Robotics::Signals::RobotInputSignal>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Robotics::Signals::RobotInputSignal>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Robotics_Signals_RobotOutput_Vector) std::vector<std::shared_ptr<openplx::Robotics::Signals::RobotOutput>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Robotics::Signals::RobotOutput>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Robotics::Signals::RobotOutput>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Robotics::Signals::RobotOutput>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Robotics::Signals::RobotOutput>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Robotics::Signals::RobotOutput>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Robotics::Signals::RobotOutput>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Robotics_Signals_RobotOutputSignal_Vector) std::vector<std::shared_ptr<openplx::Robotics::Signals::RobotOutputSignal>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Robotics::Signals::RobotOutputSignal>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Robotics::Signals::RobotOutputSignal>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Robotics::Signals::RobotOutputSignal>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Robotics::Signals::RobotOutputSignal>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Robotics::Signals::RobotOutputSignal>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Robotics::Signals::RobotOutputSignal>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Robotics_Signals_Sensor_Vector) std::vector<std::shared_ptr<openplx::Robotics::Signals::Sensor>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Robotics::Signals::Sensor>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Robotics::Signals::Sensor>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Robotics::Signals::Sensor>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Robotics::Signals::Sensor>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Robotics::Signals::Sensor>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Robotics::Signals::Sensor>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Robotics_Signals_SensorValues_Vector) std::vector<std::shared_ptr<openplx::Robotics::Signals::SensorValues>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Robotics::Signals::SensorValues>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Robotics::Signals::SensorValues>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Robotics::Signals::SensorValues>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Robotics::Signals::SensorValues>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Robotics::Signals::SensorValues>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Robotics::Signals::SensorValues>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%enddef

%define OPENPLX_SWIG_NS_INCLUDES_Robotics_Signals()
%include "openplx/Robotics/Signals/RobotInput.h"
%include "openplx/Robotics/Signals/RobotInputSignal.h"
%include "openplx/Robotics/Signals/RobotOutput.h"
%include "openplx/Robotics/Signals/RobotOutputSignal.h"
%include "openplx/Robotics/Signals/Sensor.h"
%include "openplx/Robotics/Signals/SensorValues.h"
%enddef

%define OPENPLX_SWIG_NS_PY_IMPORTS_Robotics_Signals()
%pythoncode %{
%}
%enddef

%define OPENPLX_SWIG_BUNDLE_INCLUDE_H_DEPENDENCIES_Robotics()
%{
#include <openplx/DriveTrain/DriveTrain_all.h>
#include <openplx/Math/Math_all.h>
#include <openplx/Physics/Physics_all.h>
#include <openplx/Physics1D/Physics1D_all.h>
#include <openplx/Physics3D/Physics3D_all.h>
#include <openplx/Simulation/Simulation_all.h>
#include <openplx/Robotics/Robotics_all.h>
%}
%enddef

%define OPENPLX_SWIG_BUNDLE_IMPORT_Robotics()
%import "Robotics_EndEffectors.i"
%import "Robotics_Joints.i"
%import "Robotics_Links.i"
%import "Robotics_Robots.i"
%import "Robotics_Signals.i"
%enddef

%define OPENPLX_SWIG_BUNDLE_IMPORT_DEPENDENCIES_Robotics()
%include <python/DriveTrain/DriveTrain.i>
OPENPLX_SWIG_BUNDLE_IMPORT_DriveTrain();
%include <python/Math/Math.i>
OPENPLX_SWIG_BUNDLE_IMPORT_Math();
%include <python/Physics/Physics.i>
OPENPLX_SWIG_BUNDLE_IMPORT_Physics();
%include <python/Physics1D/Physics1D.i>
OPENPLX_SWIG_BUNDLE_IMPORT_Physics1D();
%include <python/Physics3D/Physics3D.i>
OPENPLX_SWIG_BUNDLE_IMPORT_Physics3D();
%include <python/Simulation/Simulation.i>
OPENPLX_SWIG_BUNDLE_IMPORT_Simulation();
%enddef

%define OPENPLX_SWIG_BUNDLE_IMPORT_FLAT_DEPENDENCIES_Robotics()
%import "DriveTrain.i"
%import "Math.i"
%import "Physics.i"
%import "Physics1D.i"
%import "Physics3D.i"
%import "Simulation.i"
%enddef

%define OPENPLX_SWIG_BUNDLE_RENAMES_Robotics(prefix)
OPENPLX_SWIG_NS_RENAMES_Robotics_EndEffectors(prefix ## EndEffectors_);
OPENPLX_SWIG_NS_RENAMES_Robotics_Joints(prefix ## Joints_);
OPENPLX_SWIG_NS_RENAMES_Robotics_Links(prefix ## Links_);
OPENPLX_SWIG_NS_RENAMES_Robotics_Robots(prefix ## Robots_);
OPENPLX_SWIG_NS_RENAMES_Robotics_Signals(prefix ## Signals_);
%enddef

%define OPENPLX_SWIG_BUNDLE_SHARED_POINTERS_Robotics()
OPENPLX_SWIG_NS_SHARED_POINTERS_Robotics_EndEffectors();
OPENPLX_SWIG_NS_SHARED_POINTERS_Robotics_Joints();
OPENPLX_SWIG_NS_SHARED_POINTERS_Robotics_Links();
OPENPLX_SWIG_NS_SHARED_POINTERS_Robotics_Robots();
OPENPLX_SWIG_NS_SHARED_POINTERS_Robotics_Signals();
%enddef

%define OPENPLX_SWIG_BUNDLE_SHARED_POINTER_DOWNCASTS_Robotics()
OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Robotics_EndEffectors();
OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Robotics_Joints();
OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Robotics_Links();
OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Robotics_Robots();
OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Robotics_Signals();
%enddef

%define OPENPLX_SWIG_BUNDLE_VECTORS_Robotics()
OPENPLX_SWIG_NS_VECTORS_Robotics_EndEffectors();
OPENPLX_SWIG_NS_VECTORS_Robotics_Joints();
OPENPLX_SWIG_NS_VECTORS_Robotics_Links();
OPENPLX_SWIG_NS_VECTORS_Robotics_Robots();
OPENPLX_SWIG_NS_VECTORS_Robotics_Signals();
%enddef

%define OPENPLX_SWIG_BUNDLE_INCLUDES_Robotics()
OPENPLX_SWIG_NS_INCLUDES_Robotics_EndEffectors();
OPENPLX_SWIG_NS_INCLUDES_Robotics_Joints();
OPENPLX_SWIG_NS_INCLUDES_Robotics_Links();
OPENPLX_SWIG_NS_INCLUDES_Robotics_Robots();
OPENPLX_SWIG_NS_INCLUDES_Robotics_Signals();
%enddef

