
#pragma once

namespace openplx
{
    enum class TokenType {
        // Single-character tokens.
        LeftParen, RightParen, LeftBrace, RightBrace, LeftBracket, RightBracket,
        Dot, Minus, Plus, Colon, Slash, Star, Comma,

        // Multiple-character tokens
        RightArrow,

        // Literals.
        Identifier, String, AtString, MultiLineString, Number,

        // Keywords.
        Is, Becomes, Fn, Static, TrueKeyword, FalseKeyword, Operator,
        Const, External, Import, As, Trait, With, Delete, Reference,

        // End of file
        EndOfFile,

        // An error occurred:
        Invalid,

        // Default
        Uninitialized,

        // Intentionally left empty
        NoneType
    };

    class TokenTypeExtensions {
        public:
            static const char * toString(TokenType type)
            {
                switch (type)
                {
                    case TokenType::LeftBrace:
                        return "LeftBrace";
                    case TokenType::RightBrace:
                        return "RightBrace";
                    case TokenType::LeftParen:
                        return "LeftParen";
                    case TokenType::RightParen:
                        return "RightParen";
                    case TokenType::LeftBracket:
                        return "LeftBracket";
                    case TokenType::RightBracket:
                        return "RightBracket";
                    case TokenType::Dot:
                        return "Dot";
                    case TokenType::Minus:
                        return "Minus";
                    case TokenType::Plus:
                        return "Plus";
                    case TokenType::Colon:
                        return "Colon";
                    case TokenType::Comma:
                        return "Comma";
                    case TokenType::Slash:
                        return "Slash";
                    case TokenType::Star:
                        return "Star";
                    case TokenType::RightArrow:
                        return "RightArrow";
                    case TokenType::Identifier:
                        return "Identifier";
                    case TokenType::String:
                        return "String";
                    case TokenType::AtString:
                        return "AtString";
                    case TokenType::MultiLineString:
                        return "MultiLineString";
                    case TokenType::Number:
                        return "Number";
                    case TokenType::Is:
                        return "Is";
                    case TokenType::As:
                        return "As";
                    case TokenType::Trait:
                        return "Trait";
                    case TokenType::With:
                        return "With";
                    case TokenType::Becomes:
                        return "Becomes";
                    case TokenType::Fn:
                        return "Fn";
                    case TokenType::Static:
                        return "Static";
                    case TokenType::Const:
                        return "Const";
                    case TokenType::TrueKeyword:
                        return "True";
                    case TokenType::FalseKeyword:
                        return "False";
                    case TokenType::Operator:
                        return "Operator";
                    case TokenType::External:
                        return "External";
                    case TokenType::Import:
                        return "Import";
                    case TokenType::Delete:
                        return "Delete";
                    case TokenType::Reference:
                        return "Reference";
                    case TokenType::EndOfFile:
                        return "EndOfFile";
                    case TokenType::Uninitialized:
                        return "Uninitialized";
                    case TokenType::Invalid:
                        return "Invalid";
                    case TokenType::NoneType:
                        return "None";
                    default:
                        return "Unknown TokenType";
                }
        }
    };
}
