#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Robotics/RoboticsForward.h>
#include <openplx/DriveTrain/DriveTrainForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics1D/Physics1DForward.h>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/Simulation/SimulationForward.h>
#include <openplx/Robotics/Joints/ActuatedJoint.h>
#include <openplx/Physics3D/Interactions/Prismatic.h>
#include <openplx/Physics3D/Interactions/LinearRange.h>
/* Generated code for model PrismaticJoint */
namespace openplx::Robotics::Joints {
    /**
     * The prismatic joint specializes the mate of the actuated joint to be a prismatic,
     * and declares a range interaction. Position and angular velocity outputs are declared in the mate.
     **/
    class PrismaticJoint : public openplx::Robotics::Joints::ActuatedJoint {
        protected:
            std::shared_ptr<openplx::Physics3D::Interactions::LinearRange> m_range;

        public:
            PrismaticJoint();
            std::shared_ptr<openplx::Physics3D::Interactions::Prismatic> mate() const;
            std::shared_ptr<openplx::Physics3D::Interactions::LinearRange> range() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}
