#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Robotics/RoboticsForward.h>
#include <openplx/DriveTrain/DriveTrainForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics1D/Physics1DForward.h>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/Simulation/SimulationForward.h>
#include <openplx/Robotics/Joints/ActuatedJoint.h>
#include <openplx/Physics3D/Interactions/Hinge.h>
#include <openplx/Physics3D/Interactions/RotationalRange.h>
/* Generated code for model HingeJoint */
namespace openplx::Robotics::Joints {
    /**
     * The hinge joint specializes the mate of the actuated joint to be a hinge,
     * and declares a range interaction and angle and angular velocity outputs.
     **/
    class HingeJoint : public openplx::Robotics::Joints::ActuatedJoint {
        protected:
            std::shared_ptr<openplx::Physics3D::Interactions::RotationalRange> m_range;

        public:
            HingeJoint();
            std::shared_ptr<openplx::Physics3D::Interactions::Hinge> mate() const;
            std::shared_ptr<openplx::Physics3D::Interactions::RotationalRange> range() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}
