#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Robotics/RoboticsForward.h>
#include <openplx/DriveTrain/DriveTrainForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics1D/Physics1DForward.h>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/Simulation/SimulationForward.h>
#include <openplx/Physics3D/System.h>
#include <openplx/DriveTrain/Shaft.h>
#include <openplx/DriveTrain/Gear.h>
#include <openplx/Robotics/Signals/Sensor.h>
#include <openplx/DriveTrain/HingeActuator.h>
/* Generated code for model FlexibleJointDriveTrain */
namespace openplx::Robotics::Joints {
    class FlexibleJointDriveTrain : public openplx::Physics3D::System {
        protected:
            std::shared_ptr<openplx::DriveTrain::Shaft> m_motor_shaft;
            std::shared_ptr<openplx::DriveTrain::Gear> m_gear;
            std::shared_ptr<openplx::DriveTrain::Shaft> m_gear_shaft;
            std::shared_ptr<openplx::Robotics::Signals::Sensor> m_sensor;
            std::shared_ptr<openplx::DriveTrain::HingeActuator> m_hinge_actuator;

        public:
            FlexibleJointDriveTrain();
            std::shared_ptr<openplx::DriveTrain::Shaft> motor_shaft() const;
            std::shared_ptr<openplx::DriveTrain::Gear> gear() const;
            std::shared_ptr<openplx::DriveTrain::Shaft> gear_shaft() const;
            std::shared_ptr<openplx::Robotics::Signals::Sensor> sensor() const;
            std::shared_ptr<openplx::DriveTrain::HingeActuator> hinge_actuator() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}
