#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics/System.h>
#include <openplx/Math/AffineTransform.h>
#include <openplx/Physics3D/Bodies/RigidBody.h>
#include <openplx/Physics3D/Bodies/Body.h>
/* Generated code for model System */
namespace openplx::Physics3D {
    /**
     * A physical system is a collection of bodies, interactions, and subsystems.
     * Each body and subsystem has local transformations relative to the system.
     * These local transformations can either be explicitly specified or computed by SNAP, given the mate interactions.
     *
     * Any Physics3D.Bodies.RigidBody, Physics3D.System or PowerLine within a System will be included in the physics simulation.
     * Geometries, however, will not be part of the simulation unless they belong to a Physics3D.Bodies.RigidBody.
     *
     * Each system has a reference rigid body that maintains the system's frame of reference.
     * This reference is applied to the reference body through a redirected mate connector.
     * The reduce_object_to_root_system_transform() function is utilized by the bundle implementation
     * to compute transformations relative to the root system.
     * Physics3D recognizes a reference system at the origin.
     * on_init() - Used by the bundle implementation, will choose a reference_body, if one is not specified.
     * reduce_body_to_world_system_transform() - Used by the bundle implementation to compute a transform from a rigid body to the world system.
     * reduce_to_world_system_transform() - Used by the bundle implementation to compute a transform from this system to the world system.
     * kinematically_controlled -  deprecated, to specify the motion control of a RigidBody see is_dynamic attribute in RigidBody.openplx.
     * reference_body - a body chosen to be carry the origin of the system.
     *                  Will be the first body to get a forced local transform by SNAP,
     *                  to get past ambiguous states in the SNAP algorithm in a deterministic way.
     **/
    class System : public openplx::Physics::System {
        protected:
            std::shared_ptr<openplx::Math::AffineTransform> m_local_transform;
            std::vector<std::shared_ptr<openplx::Physics3D::Bodies::RigidBody>> m_kinematically_controlled;
            std::shared_ptr<openplx::Physics3D::Bodies::Body> m_reference_body;

        public:
            System();
            std::shared_ptr<openplx::Math::AffineTransform> local_transform() const;
            void on_init(const openplx::RuntimeContext& context) override;
            static void resnap(std::shared_ptr<openplx::Physics3D::System> system);
            std::shared_ptr<openplx::Math::AffineTransform> reduce_body_to_world_system_transform(std::shared_ptr<openplx::Physics3D::Bodies::RigidBody> rigid_body) const;
            std::shared_ptr<openplx::Math::AffineTransform> reduce_to_world_system_transform() const;
            std::vector<std::shared_ptr<openplx::Physics3D::Bodies::RigidBody>> kinematically_controlled() const;
            std::shared_ptr<openplx::Physics3D::Bodies::Body> reference_body() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}
