#pragma once
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics3D/Interactions/SurfaceContact/OrientedFrictionTrait.h>
#include <openplx/Physics3D/Bodies/Body.h>
/* Generated code for model BodyOrientedFrictionTrait */
namespace openplx::Physics3D::Interactions::SurfaceContact {
    /**
     *     The BodyOrientedFrictionTrait implement OrientedFrictionTrait,
     *     for the primary_direction to be relative a reference_body.
     **/
    class BodyOrientedFrictionTrait : public openplx::Physics3D::Interactions::SurfaceContact::OrientedFrictionTrait {
        public:
            BodyOrientedFrictionTrait();
            virtual ~BodyOrientedFrictionTrait();
            virtual std::shared_ptr<openplx::Math::Vec3> primary_direction() const = 0;
            virtual double secondary_coefficient() const = 0;
            virtual std::shared_ptr<openplx::Physics3D::Bodies::Body> reference_body() const = 0;
    };
}
