#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics/Interactions/Interaction1DOF.h>
#include <openplx/Physics/Signals/Force1DInputTrait.h>
#include <openplx/Physics/Signals/Force1DOutputTrait.h>
#include <openplx/Physics/Signals/Force1DInput.h>
#include <openplx/Physics/Signals/Force1DOutput.h>
/* Generated code for model ForceMotor */
namespace openplx::Physics3D::Interactions {
    /**
     *     A force-driven motor provides precise and accurate control of the applied force.
     *     The motor will initially be configured to apply the default force.
     *     */
    class ForceMotor : public openplx::Physics::Interactions::Interaction1DOF, public openplx::Physics::Signals::Force1DInputTrait, public openplx::Physics::Signals::Force1DOutputTrait {
        protected:
            double m_default_force;
            std::shared_ptr<openplx::Physics::Signals::Force1DInput> m_force_input;
            std::shared_ptr<openplx::Physics::Signals::Force1DOutput> m_force_output;

        public:
            ForceMotor();
            double default_force() const;
            std::shared_ptr<openplx::Physics::Signals::Force1DInput> force_input() const;
            std::shared_ptr<openplx::Physics::Signals::Force1DOutput> force_output() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}
