#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics/Bodies/Inertia.h>
#include <openplx/Math/Matrix3x3.h>
#include <openplx/Math/Vec3.h>
/* Generated code for model Inertia */
namespace openplx::Physics3D::Bodies {
    /**
     * The tensor is relative to the local center of mass defined by local_cm_transform
     * in the body kinematics. It is recommended to use Physics3D.Inertia.symmetric_tensor to initalize
     * Physics3D.Inertia.tensor.
     **/
    class Inertia : public openplx::Physics::Bodies::Inertia {
        protected:
            double m_mass;
            std::shared_ptr<openplx::Math::Matrix3x3> m_tensor;

        public:
            Inertia();
            double mass() const;
            std::shared_ptr<openplx::Math::Matrix3x3> tensor() const;
            static std::shared_ptr<openplx::Math::Matrix3x3> symmetric_tensor(std::shared_ptr<openplx::Math::Vec3> diag, double e01_10, double e02_20, double e12_21);
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}
