#pragma once

#include <filesystem>
#include <ostream>
#include <string>
#include <openplx/OpenPlxContextInternal.h>
#include <openplx/BundleConfig.h>
#include <openplx/Type.h>

namespace openplx
{
    /**
     * Mustache is a logic-less template system, basically no if-statements in the templates.
     * The openplx generator will populate the template data objects with everything needed to
     * generate artifacts for a bundle. This allows decoupling of the generated artifacts from
     * the generator by allowing us to create mustache templates for for example .md, .i, .pyi
     * files etc. The end users can also use it to generate custom artifacts from bundles.
     */
    class MustacheGenerator
    {
        public:

            MustacheGenerator();

            void generate(
                std::string tmpl,
                openplx::Core::Api::OpenPlxContextInternal& openplx_context,
                Bundle::BundleConfig& bundle_config,
                const std::filesystem::path& output_path
            );
    };
}
