#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Math/MathForward.h>
#include <openplx/Math/Vec3.h>
#include <openplx/Math/Quat.h>
/* Generated code for model Matrix4x4 */
namespace openplx::Math {
    class Matrix4x4 : public openplx::Core::Object {
        protected:
            double m_e00;
            double m_e01;
            double m_e02;
            double m_e03;
            double m_e10;
            double m_e11;
            double m_e12;
            double m_e13;
            double m_e20;
            double m_e21;
            double m_e22;
            double m_e23;
            double m_e30;
            double m_e31;
            double m_e32;
            double m_e33;

        public:
            Matrix4x4();
            double e00() const;
            double e01() const;
            double e02() const;
            double e03() const;
            double e10() const;
            double e11() const;
            double e12() const;
            double e13() const;
            double e20() const;
            double e21() const;
            double e22() const;
            double e23() const;
            double e30() const;
            double e31() const;
            double e32() const;
            double e33() const;
            static std::shared_ptr<openplx::Math::Matrix4x4> from_row_major(double r0c0, double r0c1, double r0c2, double r0c3, double r1c0, double r1c1, double r1c2, double r1c3, double r2c0, double r2c1, double r2c2, double r2c3, double r3c0, double r3c1, double r3c2, double r3c3);
            static std::shared_ptr<openplx::Math::Matrix4x4> from_rows(std::vector<double> r0, std::vector<double> r1, std::vector<double> r2, std::vector<double> r3);
            static std::shared_ptr<openplx::Math::Matrix4x4> from_columns(std::vector<double> c0, std::vector<double> c1, std::vector<double> c2, std::vector<double> c3);
            static std::shared_ptr<openplx::Math::Matrix4x4> from_vec3_quat(std::shared_ptr<openplx::Math::Vec3> v, std::shared_ptr<openplx::Math::Quat> q);
            std::shared_ptr<openplx::Math::Matrix4x4> transpose() const;
            std::shared_ptr<openplx::Math::Matrix4x4> copy() const;
            std::shared_ptr<openplx::Math::Vec3> get_affine_translation() const;
            std::shared_ptr<openplx::Math::Quat> get_affine_rotation() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}
