#pragma once

#include <memory>
#include <vector>
#include <spdlog/spdlog.h>
#include <spdlog/logger.h>
#include <openplx/SPDLogWorkaround.h>

namespace openplx {
/**
 * Used to setup the default logger for the agx-openplx DLL when using Shared Libraries on Windows. Only required for that case.
 */
class ErrorLogger : private SPDLogWorkaround {
    public:
        static std::shared_ptr<spdlog::logger> setup_default_logger(std::vector<spdlog::sink_ptr> sinks);
        static std::shared_ptr<spdlog::logger> get_default_logger();
        static void set_default_logger(std::shared_ptr<spdlog::logger> logger);
};

}
