#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/DriveTrain/DriveTrainForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics1D/Physics1DForward.h>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/DriveTrain/Gear.h>
#include <openplx/Physics/Interactions/Dissipation/ConstantViscousSurfaceFriction.h>
/* Generated code for model ViscousGear */
namespace openplx::DriveTrain {
    /**
     * The ViscousGear acts as a rotational coupling that connects two RotationalBodies
     * with a focus on viscous surface friction. This model accounts for the damping effects
     * due to surface viscosity, impacting the rotational interaction between two
     * Physics1D.Bodies.RotationalBody instances.
     * It maintains a linear relationship of rotational speed and position through
     * a specified gear ratio but differs from an ideal gear by incorporating the effects
     * of surface viscous friction, adding a layer of complexity and realism to its behavior.
     **/
    class ViscousGear : public openplx::DriveTrain::Gear {
        protected:
            std::shared_ptr<openplx::Physics::Interactions::Dissipation::ConstantViscousSurfaceFriction> m_dissipation;

        public:
            ViscousGear();
            std::shared_ptr<openplx::Physics::Interactions::Dissipation::ConstantViscousSurfaceFriction> dissipation() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}
