#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/DriveTrain/DriveTrainForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics1D/Physics1DForward.h>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/DriveTrain/Differential.h>
/* Generated code for model TorqueLimitedSlipDifferential */
namespace openplx::DriveTrain {
    /**
     *     A TorqueLimitedSlipDifferential is designed to overcome the standard differential's main limitation:
     *     the tendency to send torque to the wheel with the least amount of traction. 
     *     A Torque Limited Slip Differential seeks to maintain both wheels turning at the same speed,
     *     until the difference in torque required to keep both wheels at the same speed exceeds a defined limit.
     *     This limit is often referred to as the "breakaway torque."
     *     Once the breakaway_torque is exceeded, the Limited Slip Differential will allow the wheels to rotate at different speeds. 
     *     This is especially useful when there's significantly different traction on each wheel, such as when turning on a slippery surface.
     *
     *     The differential can then re-engage the lock between the wheels when the torque difference reduces and falls below the threshold again.
     *     This behavior of a Torque LSD allows for better traction and control in situations where a conventional open differential might cause one wheel to spin freely. For instance when driving on ice or when one wheel is in the air.
     *     
     *     
     *     */
    class TorqueLimitedSlipDifferential : public openplx::DriveTrain::Differential {
        protected:
            double m_breakaway_torque;

        public:
            TorqueLimitedSlipDifferential();
            double breakaway_torque() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}
