%{
#include <openplx/Token.h>
using namespace openplx;
#include <openplx/NodeType.h>
#include <openplx/Node.h>
#include <openplx/Any.h>
#include <openplx/Object.h>
#include <openplx/EvaluatorContext.h>
#include <openplx/OpenPlxContext.h>
#include <openplx/OpenPlxContextInternal.h>
#include <openplx/DriveTrain/DriveTrain_all.h>
#include <openplx/Math/Math_all.h>
#include <openplx/Physics/Physics_all.h>
#include <openplx/Physics1D/Physics1D_all.h>
#include <openplx/Physics3D/Physics3D_all.h>
#include <openplx/Simulation/Simulation_all.h>
#include <openplx/Robotics/Robotics_all.h>
%}
%include <exception.i>
%include <std_string.i>
%include <std_vector.i>
%nspace openplx::Robotics::EndEffectors::ConstantVacuumSystem;
%nspace openplx::Robotics::EndEffectors::SixDofSuctionCup;
%nspace openplx::Robotics::EndEffectors::SixDofSuctionCupJoint;
%nspace openplx::Robotics::EndEffectors::SuctionCup;
%nspace openplx::Robotics::EndEffectors::SuctionCupElastoDynamics;
%nspace openplx::Robotics::EndEffectors::VacuumGripper;
%nspace openplx::Robotics::EndEffectors::VacuumSystem;
%nspace openplx::Robotics::Joints::ActuatedJoint;
%nspace openplx::Robotics::Joints::CoupledJointDriveTrain;
%nspace openplx::Robotics::Joints::FixedJoint;
%nspace openplx::Robotics::Joints::FlexibleAngularVelocityJoint;
%nspace openplx::Robotics::Joints::FlexibleJointData;
%nspace openplx::Robotics::Joints::FlexibleJointDriveTrain;
%nspace openplx::Robotics::Joints::FlexibleJointTrait;
%nspace openplx::Robotics::Joints::FlexibleTorqueJoint;
%nspace openplx::Robotics::Joints::HingeJoint;
%nspace openplx::Robotics::Joints::HingeJointData;
%nspace openplx::Robotics::Joints::Joint;
%nspace openplx::Robotics::Joints::JointData;
%nspace openplx::Robotics::Joints::PositionHingeJoint;
%nspace openplx::Robotics::Joints::PrismaticJoint;
%nspace openplx::Robotics::Joints::TorqueHingeJoint;
%nspace openplx::Robotics::Joints::VelocityHingeJoint;
%nspace openplx::Robotics::Links::LinkData;
%nspace openplx::Robotics::Links::RigidBoxLink;
%nspace openplx::Robotics::Links::RigidLink;
%nspace openplx::Robotics::Links::RigidTriMeshLink;
%nspace openplx::Robotics::Robots::Robot;
%nspace openplx::Robotics::Robots::SerialManipulatorData;
%nspace openplx::Robotics::Robots::SixAxisSerialManipulator;
%nspace openplx::Robotics::Signals::RobotInput;
%nspace openplx::Robotics::Signals::RobotInputSignal;
%nspace openplx::Robotics::Signals::RobotOutput;
%nspace openplx::Robotics::Signals::RobotOutputSignal;
%nspace openplx::Robotics::Signals::Sensor;
%nspace openplx::Robotics::Signals::SensorValues;
%shared_ptr(openplx::Robotics::EndEffectors::ConstantVacuumSystem);
%shared_ptr(openplx::Robotics::EndEffectors::SixDofSuctionCup);
%shared_ptr(openplx::Robotics::EndEffectors::SixDofSuctionCupJoint);
%shared_ptr(openplx::Robotics::EndEffectors::SuctionCup);
%shared_ptr(openplx::Robotics::EndEffectors::SuctionCupElastoDynamics);
%shared_ptr(openplx::Robotics::EndEffectors::VacuumGripper);
%shared_ptr(openplx::Robotics::EndEffectors::VacuumSystem);
%shared_ptr(openplx::Robotics::Joints::ActuatedJoint);
%shared_ptr(openplx::Robotics::Joints::CoupledJointDriveTrain);
%shared_ptr(openplx::Robotics::Joints::FixedJoint);
%shared_ptr(openplx::Robotics::Joints::FlexibleAngularVelocityJoint);
%shared_ptr(openplx::Robotics::Joints::FlexibleJointData);
%shared_ptr(openplx::Robotics::Joints::FlexibleJointDriveTrain);
%shared_ptr(openplx::Robotics::Joints::FlexibleJointTrait);
%shared_ptr(openplx::Robotics::Joints::FlexibleTorqueJoint);
%shared_ptr(openplx::Robotics::Joints::HingeJoint);
%shared_ptr(openplx::Robotics::Joints::HingeJointData);
%shared_ptr(openplx::Robotics::Joints::Joint);
%shared_ptr(openplx::Robotics::Joints::JointData);
%shared_ptr(openplx::Robotics::Joints::PositionHingeJoint);
%shared_ptr(openplx::Robotics::Joints::PrismaticJoint);
%shared_ptr(openplx::Robotics::Joints::TorqueHingeJoint);
%shared_ptr(openplx::Robotics::Joints::VelocityHingeJoint);
%shared_ptr(openplx::Robotics::Links::LinkData);
%shared_ptr(openplx::Robotics::Links::RigidBoxLink);
%shared_ptr(openplx::Robotics::Links::RigidLink);
%shared_ptr(openplx::Robotics::Links::RigidTriMeshLink);
%shared_ptr(openplx::Robotics::Robots::Robot);
%shared_ptr(openplx::Robotics::Robots::SerialManipulatorData);
%shared_ptr(openplx::Robotics::Robots::SixAxisSerialManipulator);
%shared_ptr(openplx::Robotics::Signals::RobotInput);
%shared_ptr(openplx::Robotics::Signals::RobotInputSignal);
%shared_ptr(openplx::Robotics::Signals::RobotOutput);
%shared_ptr(openplx::Robotics::Signals::RobotOutputSignal);
%shared_ptr(openplx::Robotics::Signals::Sensor);
%shared_ptr(openplx::Robotics::Signals::SensorValues);
OPENPLX_TRAIT(FlexibleJointTrait_TraitProxy, FlexibleJointTrait, openplx::Robotics::Joints::FlexibleJointTrait);
OPENPLX_FIX_DOWNCASTING(openplx::Robotics::EndEffectors::ConstantVacuumSystem)
OPENPLX_FIX_DOWNCASTING(openplx::Robotics::EndEffectors::SixDofSuctionCup)
OPENPLX_FIX_DOWNCASTING(openplx::Robotics::EndEffectors::SixDofSuctionCupJoint)
OPENPLX_FIX_DOWNCASTING(openplx::Robotics::EndEffectors::SuctionCup)
OPENPLX_FIX_DOWNCASTING(openplx::Robotics::EndEffectors::SuctionCupElastoDynamics)
OPENPLX_FIX_DOWNCASTING(openplx::Robotics::EndEffectors::VacuumGripper)
OPENPLX_FIX_DOWNCASTING(openplx::Robotics::EndEffectors::VacuumSystem)
OPENPLX_FIX_DOWNCASTING(openplx::Robotics::Joints::ActuatedJoint)
OPENPLX_FIX_DOWNCASTING(openplx::Robotics::Joints::CoupledJointDriveTrain)
OPENPLX_FIX_DOWNCASTING(openplx::Robotics::Joints::FixedJoint)
OPENPLX_FIX_DOWNCASTING(openplx::Robotics::Joints::FlexibleAngularVelocityJoint)
OPENPLX_FIX_DOWNCASTING(openplx::Robotics::Joints::FlexibleJointData)
OPENPLX_FIX_DOWNCASTING(openplx::Robotics::Joints::FlexibleJointDriveTrain)
OPENPLX_FIX_DOWNCASTING(openplx::Robotics::Joints::FlexibleTorqueJoint)
OPENPLX_FIX_DOWNCASTING(openplx::Robotics::Joints::HingeJoint)
OPENPLX_FIX_DOWNCASTING(openplx::Robotics::Joints::HingeJointData)
OPENPLX_FIX_DOWNCASTING(openplx::Robotics::Joints::Joint)
OPENPLX_FIX_DOWNCASTING(openplx::Robotics::Joints::JointData)
OPENPLX_FIX_DOWNCASTING(openplx::Robotics::Joints::PositionHingeJoint)
OPENPLX_FIX_DOWNCASTING(openplx::Robotics::Joints::PrismaticJoint)
OPENPLX_FIX_DOWNCASTING(openplx::Robotics::Joints::TorqueHingeJoint)
OPENPLX_FIX_DOWNCASTING(openplx::Robotics::Joints::VelocityHingeJoint)
OPENPLX_FIX_DOWNCASTING(openplx::Robotics::Links::LinkData)
OPENPLX_FIX_DOWNCASTING(openplx::Robotics::Links::RigidBoxLink)
OPENPLX_FIX_DOWNCASTING(openplx::Robotics::Links::RigidLink)
OPENPLX_FIX_DOWNCASTING(openplx::Robotics::Links::RigidTriMeshLink)
OPENPLX_FIX_DOWNCASTING(openplx::Robotics::Robots::Robot)
OPENPLX_FIX_DOWNCASTING(openplx::Robotics::Robots::SerialManipulatorData)
OPENPLX_FIX_DOWNCASTING(openplx::Robotics::Robots::SixAxisSerialManipulator)
OPENPLX_FIX_DOWNCASTING(openplx::Robotics::Signals::RobotInput)
OPENPLX_FIX_DOWNCASTING(openplx::Robotics::Signals::RobotInputSignal)
OPENPLX_FIX_DOWNCASTING(openplx::Robotics::Signals::RobotOutput)
OPENPLX_FIX_DOWNCASTING(openplx::Robotics::Signals::RobotOutputSignal)
OPENPLX_FIX_DOWNCASTING(openplx::Robotics::Signals::Sensor)
OPENPLX_FIX_DOWNCASTING(openplx::Robotics::Signals::SensorValues)
%typemap(csimports) openplx::Robotics::EndEffectors::VacuumGripper "
/* Workaround for missing namespaces on interfaces */
using BoolInputTrait = openplx.Physics.Signals.BoolInputTrait;
using BoolOutputTrait = openplx.Physics.Signals.BoolOutputTrait;
";
%typemap(csimports) openplx::Robotics::Joints::FlexibleAngularVelocityJoint "
/* Workaround for missing namespaces on interfaces */
";
%typemap(csimports) openplx::Robotics::Joints::FlexibleTorqueJoint "
/* Workaround for missing namespaces on interfaces */
";
%include "openplx/Robotics/EndEffectors/VacuumSystem.h"
%include "openplx/Robotics/EndEffectors/ConstantVacuumSystem.h"
%include "openplx/Robotics/EndEffectors/SuctionCup.h"
%include "openplx/Robotics/EndEffectors/SixDofSuctionCup.h"
%include "openplx/Robotics/EndEffectors/SixDofSuctionCupJoint.h"
%include "openplx/Robotics/EndEffectors/SuctionCupElastoDynamics.h"
%include "openplx/Robotics/EndEffectors/VacuumGripper.h"
%include "openplx/Robotics/Joints/Joint.h"
%include "openplx/Robotics/Joints/ActuatedJoint.h"
%include "openplx/Robotics/Joints/CoupledJointDriveTrain.h"
%include "openplx/Robotics/Joints/FixedJoint.h"
%include "openplx/Robotics/Joints/HingeJoint.h"
%include "openplx/Robotics/Joints/FlexibleJointTrait.h"
%include "openplx/Robotics/Joints/FlexibleAngularVelocityJoint.h"
%include "openplx/Robotics/Joints/JointData.h"
%include "openplx/Robotics/Joints/HingeJointData.h"
%include "openplx/Robotics/Joints/FlexibleJointData.h"
%include "openplx/Robotics/Joints/FlexibleJointDriveTrain.h"
%include "openplx/Robotics/Joints/FlexibleTorqueJoint.h"
%include "openplx/Robotics/Joints/PositionHingeJoint.h"
%include "openplx/Robotics/Joints/PrismaticJoint.h"
%include "openplx/Robotics/Joints/TorqueHingeJoint.h"
%include "openplx/Robotics/Joints/VelocityHingeJoint.h"
%include "openplx/Robotics/Links/LinkData.h"
%include "openplx/Robotics/Links/RigidLink.h"
%include "openplx/Robotics/Links/RigidBoxLink.h"
%include "openplx/Robotics/Links/RigidTriMeshLink.h"
%include "openplx/Robotics/Robots/Robot.h"
%include "openplx/Robotics/Robots/SerialManipulatorData.h"
%include "openplx/Robotics/Robots/SixAxisSerialManipulator.h"
%include "openplx/Robotics/Signals/RobotInput.h"
%include "openplx/Robotics/Signals/RobotInputSignal.h"
%include "openplx/Robotics/Signals/RobotOutput.h"
%include "openplx/Robotics/Signals/RobotOutputSignal.h"
%include "openplx/Robotics/Signals/Sensor.h"
%include "openplx/Robotics/Signals/SensorValues.h"
%ignore Robotics_register_factories;
%include <openplx/Robotics/Robotics_all.h>
%inline {
    void Robotics_register_factories_cs(openplx::Core::Api::OpenPlxContext* ctx) {
        auto internal_ctx = openplx::Core::Api::OpenPlxContextInternal::fromContext(*ctx);
        auto eval_ctx = internal_ctx->evaluatorContext().get();
        Robotics_register_factories(eval_ctx);
    }
}
%template(RoboticsEndEffectorsConstantVacuumSystemVector) std::vector<std::shared_ptr<openplx::Robotics::EndEffectors::ConstantVacuumSystem>>;
%template(RoboticsEndEffectorsSixDofSuctionCupVector) std::vector<std::shared_ptr<openplx::Robotics::EndEffectors::SixDofSuctionCup>>;
%template(RoboticsEndEffectorsSixDofSuctionCupJointVector) std::vector<std::shared_ptr<openplx::Robotics::EndEffectors::SixDofSuctionCupJoint>>;
%template(RoboticsEndEffectorsSuctionCupVector) std::vector<std::shared_ptr<openplx::Robotics::EndEffectors::SuctionCup>>;
%template(RoboticsEndEffectorsSuctionCupElastoDynamicsVector) std::vector<std::shared_ptr<openplx::Robotics::EndEffectors::SuctionCupElastoDynamics>>;
%template(RoboticsEndEffectorsVacuumGripperVector) std::vector<std::shared_ptr<openplx::Robotics::EndEffectors::VacuumGripper>>;
%template(RoboticsEndEffectorsVacuumSystemVector) std::vector<std::shared_ptr<openplx::Robotics::EndEffectors::VacuumSystem>>;
%template(RoboticsJointsActuatedJointVector) std::vector<std::shared_ptr<openplx::Robotics::Joints::ActuatedJoint>>;
%template(RoboticsJointsCoupledJointDriveTrainVector) std::vector<std::shared_ptr<openplx::Robotics::Joints::CoupledJointDriveTrain>>;
%template(RoboticsJointsFixedJointVector) std::vector<std::shared_ptr<openplx::Robotics::Joints::FixedJoint>>;
%template(RoboticsJointsFlexibleAngularVelocityJointVector) std::vector<std::shared_ptr<openplx::Robotics::Joints::FlexibleAngularVelocityJoint>>;
%template(RoboticsJointsFlexibleJointDataVector) std::vector<std::shared_ptr<openplx::Robotics::Joints::FlexibleJointData>>;
%template(RoboticsJointsFlexibleJointDriveTrainVector) std::vector<std::shared_ptr<openplx::Robotics::Joints::FlexibleJointDriveTrain>>;
%template(RoboticsJointsFlexibleTorqueJointVector) std::vector<std::shared_ptr<openplx::Robotics::Joints::FlexibleTorqueJoint>>;
%template(RoboticsJointsHingeJointVector) std::vector<std::shared_ptr<openplx::Robotics::Joints::HingeJoint>>;
%template(RoboticsJointsHingeJointDataVector) std::vector<std::shared_ptr<openplx::Robotics::Joints::HingeJointData>>;
%template(RoboticsJointsJointVector) std::vector<std::shared_ptr<openplx::Robotics::Joints::Joint>>;
%template(RoboticsJointsJointDataVector) std::vector<std::shared_ptr<openplx::Robotics::Joints::JointData>>;
%template(RoboticsJointsPositionHingeJointVector) std::vector<std::shared_ptr<openplx::Robotics::Joints::PositionHingeJoint>>;
%template(RoboticsJointsPrismaticJointVector) std::vector<std::shared_ptr<openplx::Robotics::Joints::PrismaticJoint>>;
%template(RoboticsJointsTorqueHingeJointVector) std::vector<std::shared_ptr<openplx::Robotics::Joints::TorqueHingeJoint>>;
%template(RoboticsJointsVelocityHingeJointVector) std::vector<std::shared_ptr<openplx::Robotics::Joints::VelocityHingeJoint>>;
%template(RoboticsLinksLinkDataVector) std::vector<std::shared_ptr<openplx::Robotics::Links::LinkData>>;
%template(RoboticsLinksRigidBoxLinkVector) std::vector<std::shared_ptr<openplx::Robotics::Links::RigidBoxLink>>;
%template(RoboticsLinksRigidLinkVector) std::vector<std::shared_ptr<openplx::Robotics::Links::RigidLink>>;
%template(RoboticsLinksRigidTriMeshLinkVector) std::vector<std::shared_ptr<openplx::Robotics::Links::RigidTriMeshLink>>;
%template(RoboticsRobotsRobotVector) std::vector<std::shared_ptr<openplx::Robotics::Robots::Robot>>;
%template(RoboticsRobotsSerialManipulatorDataVector) std::vector<std::shared_ptr<openplx::Robotics::Robots::SerialManipulatorData>>;
%template(RoboticsRobotsSixAxisSerialManipulatorVector) std::vector<std::shared_ptr<openplx::Robotics::Robots::SixAxisSerialManipulator>>;
%template(RoboticsSignalsRobotInputVector) std::vector<std::shared_ptr<openplx::Robotics::Signals::RobotInput>>;
%template(RoboticsSignalsRobotInputSignalVector) std::vector<std::shared_ptr<openplx::Robotics::Signals::RobotInputSignal>>;
%template(RoboticsSignalsRobotOutputVector) std::vector<std::shared_ptr<openplx::Robotics::Signals::RobotOutput>>;
%template(RoboticsSignalsRobotOutputSignalVector) std::vector<std::shared_ptr<openplx::Robotics::Signals::RobotOutputSignal>>;
%template(RoboticsSignalsSensorVector) std::vector<std::shared_ptr<openplx::Robotics::Signals::Sensor>>;
%template(RoboticsSignalsSensorValuesVector) std::vector<std::shared_ptr<openplx::Robotics::Signals::SensorValues>>;
