%{
#include <openplx/Token.h>
using namespace openplx;
#include <openplx/NodeType.h>
#include <openplx/Node.h>
#include <openplx/Any.h>
#include <openplx/Object.h>
#include <openplx/EvaluatorContext.h>
#include <openplx/OpenPlxContext.h>
#include <openplx/OpenPlxContextInternal.h>
#include <openplx/Math/Math_all.h>
#include <openplx/Physics/Physics_all.h>
%}
%include <exception.i>
%include <std_string.i>
%include <std_vector.i>
%nspace openplx::Physics::Bodies::Body;
%nspace openplx::Physics::Bodies::Inertia;
%nspace openplx::Physics::Bodies::Kinematics;
%nspace openplx::Physics::Charges::Charge;
%nspace openplx::Physics::Charges::ContactGeometry;
%nspace openplx::Physics::Charges::LinearElasticMaterial;
%nspace openplx::Physics::Charges::Material;
%nspace openplx::Physics::Interactions::Adhesion::ConstantForceAdhesion;
%nspace openplx::Physics::Interactions::Adhesion::DefaultAdhesion;
%nspace openplx::Physics::Interactions::Clearance::ConstantAngleClearance;
%nspace openplx::Physics::Interactions::Clearance::ConstantDistanceClearance;
%nspace openplx::Physics::Interactions::Clearance::DefaultClearance;
%nspace openplx::Physics::Interactions::Dissipation::AsymmetricLimitFriction;
%nspace openplx::Physics::Interactions::Dissipation::ConstantLimitFriction;
%nspace openplx::Physics::Interactions::Dissipation::ConstantViscousSurfaceFriction;
%nspace openplx::Physics::Interactions::Dissipation::ConstraintRelaxationTimeDamping;
%nspace openplx::Physics::Interactions::Dissipation::DefaultDissipation;
%nspace openplx::Physics::Interactions::Dissipation::DefaultDryFriction;
%nspace openplx::Physics::Interactions::Dissipation::DefaultFriction;
%nspace openplx::Physics::Interactions::Dissipation::DryBoxFriction;
%nspace openplx::Physics::Interactions::Dissipation::DryConeFriction;
%nspace openplx::Physics::Interactions::Dissipation::DryConstantNormalForceFriction;
%nspace openplx::Physics::Interactions::Dissipation::DryDepthScaledConstantNormalForceFriction;
%nspace openplx::Physics::Interactions::Dissipation::DryScaleBoxFriction;
%nspace openplx::Physics::Interactions::Dissipation::MechanicalDamping;
%nspace openplx::Physics::Interactions::Flexibility::DefaultFlexibility;
%nspace openplx::Physics::Interactions::Flexibility::LinearElastic;
%nspace openplx::Physics::Interactions::Flexibility::Rigid;
%nspace openplx::Physics::Interactions::Interaction;
%nspace openplx::Physics::Interactions::Interaction1DOF;
%nspace openplx::Physics::Interactions::SurfaceContact::Model;
%nspace openplx::Physics::Interactions::SurfaceContact::PatchElasticity;
%nspace openplx::Physics::Interactions::SurfaceContact::PointwiseElasticity;
%nspace openplx::Physics::Interactions::Toughness::DefaultToughness;
%nspace openplx::Physics::Interactions::Toughness::ThresholdFracture;
%nspace openplx::Physics::Interactions::Toughness::ThresholdPlastic;
%nspace openplx::Physics::Interactions::Toughness::ThresholdPlasticFracture;
%nspace openplx::Physics::Interactions::Toughness::Unbreakable;
%nspace openplx::Physics::KinematicLock;
%nspace openplx::Physics::Signals::Acceleration3DValue;
%nspace openplx::Physics::Signals::ActivateInput;
%nspace openplx::Physics::Signals::ActivatedOutput;
%nspace openplx::Physics::Signals::AngleInput;
%nspace openplx::Physics::Signals::AngleInputTrait;
%nspace openplx::Physics::Signals::AngleOutput;
%nspace openplx::Physics::Signals::AngleOutputTrait;
%nspace openplx::Physics::Signals::AngleValue;
%nspace openplx::Physics::Signals::AngularAcceleration3DValue;
%nspace openplx::Physics::Signals::AngularVelocity1DInput;
%nspace openplx::Physics::Signals::AngularVelocity1DInputTrait;
%nspace openplx::Physics::Signals::AngularVelocity1DOutput;
%nspace openplx::Physics::Signals::AngularVelocity1DOutputTrait;
%nspace openplx::Physics::Signals::AngularVelocity1DValue;
%nspace openplx::Physics::Signals::AngularVelocity3DValue;
%nspace openplx::Physics::Signals::BoolInput;
%nspace openplx::Physics::Signals::BoolInputSignal;
%nspace openplx::Physics::Signals::BoolInputTrait;
%nspace openplx::Physics::Signals::BoolOutput;
%nspace openplx::Physics::Signals::BoolOutputTrait;
%nspace openplx::Physics::Signals::BoolValue;
%nspace openplx::Physics::Signals::DistanceValue;
%nspace openplx::Physics::Signals::DurationInput;
%nspace openplx::Physics::Signals::DurationInputTrait;
%nspace openplx::Physics::Signals::DurationOutput;
%nspace openplx::Physics::Signals::DurationOutputTrait;
%nspace openplx::Physics::Signals::DurationValue;
%nspace openplx::Physics::Signals::EnableInteractionInput;
%nspace openplx::Physics::Signals::EngageInput;
%nspace openplx::Physics::Signals::EngagedOutput;
%nspace openplx::Physics::Signals::Force1DInput;
%nspace openplx::Physics::Signals::Force1DInputTrait;
%nspace openplx::Physics::Signals::Force1DOutput;
%nspace openplx::Physics::Signals::Force1DOutputTrait;
%nspace openplx::Physics::Signals::Force1DValue;
%nspace openplx::Physics::Signals::Force3DOutput;
%nspace openplx::Physics::Signals::Force3DOutputTrait;
%nspace openplx::Physics::Signals::Force3DValue;
%nspace openplx::Physics::Signals::ForceRangeInput;
%nspace openplx::Physics::Signals::ForceRangeInputTrait;
%nspace openplx::Physics::Signals::ForceRangeOutput;
%nspace openplx::Physics::Signals::ForceRangeOutputTrait;
%nspace openplx::Physics::Signals::ForceRangeValue;
%nspace openplx::Physics::Signals::FractionInput;
%nspace openplx::Physics::Signals::FractionInputTrait;
%nspace openplx::Physics::Signals::FractionOutput;
%nspace openplx::Physics::Signals::FractionOutputTrait;
%nspace openplx::Physics::Signals::FractionValue;
%nspace openplx::Physics::Signals::Input;
%nspace openplx::Physics::Signals::InputOutputType;
%nspace openplx::Physics::Signals::InputSignal;
%nspace openplx::Physics::Signals::IntInput;
%nspace openplx::Physics::Signals::IntInputSignal;
%nspace openplx::Physics::Signals::IntInputTrait;
%nspace openplx::Physics::Signals::IntOutput;
%nspace openplx::Physics::Signals::IntOutputTrait;
%nspace openplx::Physics::Signals::IntValue;
%nspace openplx::Physics::Signals::InteractionEnabledOutput;
%nspace openplx::Physics::Signals::LinearVelocity1DInput;
%nspace openplx::Physics::Signals::LinearVelocity1DInputTrait;
%nspace openplx::Physics::Signals::LinearVelocity1DOutput;
%nspace openplx::Physics::Signals::LinearVelocity1DOutputTrait;
%nspace openplx::Physics::Signals::Output;
%nspace openplx::Physics::Signals::OutputSignal;
%nspace openplx::Physics::Signals::Position1DInput;
%nspace openplx::Physics::Signals::Position1DInputTrait;
%nspace openplx::Physics::Signals::Position1DOutput;
%nspace openplx::Physics::Signals::Position1DOutputTrait;
%nspace openplx::Physics::Signals::Position3DValue;
%nspace openplx::Physics::Signals::RPYvalue;
%nspace openplx::Physics::Signals::RealInputSignal;
%nspace openplx::Physics::Signals::RealRangeInputSignal;
%nspace openplx::Physics::Signals::RealValue;
%nspace openplx::Physics::Signals::RelativeVelocity1DOutput;
%nspace openplx::Physics::Signals::RelativeVelocity1DOutputTrait;
%nspace openplx::Physics::Signals::SignalInterface;
%nspace openplx::Physics::Signals::Torque1DInput;
%nspace openplx::Physics::Signals::Torque1DInputTrait;
%nspace openplx::Physics::Signals::Torque1DOutput;
%nspace openplx::Physics::Signals::Torque1DOutputTrait;
%nspace openplx::Physics::Signals::Torque1DValue;
%nspace openplx::Physics::Signals::Torque3DOutput;
%nspace openplx::Physics::Signals::Torque3DOutputTrait;
%nspace openplx::Physics::Signals::Torque3DValue;
%nspace openplx::Physics::Signals::TorqueRangeInput;
%nspace openplx::Physics::Signals::TorqueRangeInputTrait;
%nspace openplx::Physics::Signals::TorqueRangeOutput;
%nspace openplx::Physics::Signals::TorqueRangeOutputTrait;
%nspace openplx::Physics::Signals::TorqueRangeValue;
%nspace openplx::Physics::Signals::Value;
%nspace openplx::Physics::Signals::ValueOutputSignal;
%nspace openplx::Physics::Signals::Vec2Value;
%nspace openplx::Physics::Signals::Vec3InputSignal;
%nspace openplx::Physics::Signals::Vec3Value;
%nspace openplx::Physics::Signals::Velocity1DValue;
%nspace openplx::Physics::Signals::Velocity3DValue;
%nspace openplx::Physics::System;
%shared_ptr(openplx::Physics::Bodies::Body);
%shared_ptr(openplx::Physics::Bodies::Inertia);
%shared_ptr(openplx::Physics::Bodies::Kinematics);
%shared_ptr(openplx::Physics::Charges::Charge);
%shared_ptr(openplx::Physics::Charges::ContactGeometry);
%shared_ptr(openplx::Physics::Charges::LinearElasticMaterial);
%shared_ptr(openplx::Physics::Charges::Material);
%shared_ptr(openplx::Physics::Interactions::Adhesion::ConstantForceAdhesion);
%shared_ptr(openplx::Physics::Interactions::Adhesion::DefaultAdhesion);
%shared_ptr(openplx::Physics::Interactions::Clearance::ConstantAngleClearance);
%shared_ptr(openplx::Physics::Interactions::Clearance::ConstantDistanceClearance);
%shared_ptr(openplx::Physics::Interactions::Clearance::DefaultClearance);
%shared_ptr(openplx::Physics::Interactions::Dissipation::AsymmetricLimitFriction);
%shared_ptr(openplx::Physics::Interactions::Dissipation::ConstantLimitFriction);
%shared_ptr(openplx::Physics::Interactions::Dissipation::ConstantViscousSurfaceFriction);
%shared_ptr(openplx::Physics::Interactions::Dissipation::ConstraintRelaxationTimeDamping);
%shared_ptr(openplx::Physics::Interactions::Dissipation::DefaultDissipation);
%shared_ptr(openplx::Physics::Interactions::Dissipation::DefaultDryFriction);
%shared_ptr(openplx::Physics::Interactions::Dissipation::DefaultFriction);
%shared_ptr(openplx::Physics::Interactions::Dissipation::DryBoxFriction);
%shared_ptr(openplx::Physics::Interactions::Dissipation::DryConeFriction);
%shared_ptr(openplx::Physics::Interactions::Dissipation::DryConstantNormalForceFriction);
%shared_ptr(openplx::Physics::Interactions::Dissipation::DryDepthScaledConstantNormalForceFriction);
%shared_ptr(openplx::Physics::Interactions::Dissipation::DryScaleBoxFriction);
%shared_ptr(openplx::Physics::Interactions::Dissipation::MechanicalDamping);
%shared_ptr(openplx::Physics::Interactions::Flexibility::DefaultFlexibility);
%shared_ptr(openplx::Physics::Interactions::Flexibility::LinearElastic);
%shared_ptr(openplx::Physics::Interactions::Flexibility::Rigid);
%shared_ptr(openplx::Physics::Interactions::Interaction);
%shared_ptr(openplx::Physics::Interactions::Interaction1DOF);
%shared_ptr(openplx::Physics::Interactions::SurfaceContact::Model);
%shared_ptr(openplx::Physics::Interactions::SurfaceContact::PatchElasticity);
%shared_ptr(openplx::Physics::Interactions::SurfaceContact::PointwiseElasticity);
%shared_ptr(openplx::Physics::Interactions::Toughness::DefaultToughness);
%shared_ptr(openplx::Physics::Interactions::Toughness::ThresholdFracture);
%shared_ptr(openplx::Physics::Interactions::Toughness::ThresholdPlastic);
%shared_ptr(openplx::Physics::Interactions::Toughness::ThresholdPlasticFracture);
%shared_ptr(openplx::Physics::Interactions::Toughness::Unbreakable);
%shared_ptr(openplx::Physics::KinematicLock);
%shared_ptr(openplx::Physics::Signals::Acceleration3DValue);
%shared_ptr(openplx::Physics::Signals::ActivateInput);
%shared_ptr(openplx::Physics::Signals::ActivatedOutput);
%shared_ptr(openplx::Physics::Signals::AngleInput);
%shared_ptr(openplx::Physics::Signals::AngleInputTrait);
%shared_ptr(openplx::Physics::Signals::AngleOutput);
%shared_ptr(openplx::Physics::Signals::AngleOutputTrait);
%shared_ptr(openplx::Physics::Signals::AngleValue);
%shared_ptr(openplx::Physics::Signals::AngularAcceleration3DValue);
%shared_ptr(openplx::Physics::Signals::AngularVelocity1DInput);
%shared_ptr(openplx::Physics::Signals::AngularVelocity1DInputTrait);
%shared_ptr(openplx::Physics::Signals::AngularVelocity1DOutput);
%shared_ptr(openplx::Physics::Signals::AngularVelocity1DOutputTrait);
%shared_ptr(openplx::Physics::Signals::AngularVelocity1DValue);
%shared_ptr(openplx::Physics::Signals::AngularVelocity3DValue);
%shared_ptr(openplx::Physics::Signals::BoolInput);
%shared_ptr(openplx::Physics::Signals::BoolInputSignal);
%shared_ptr(openplx::Physics::Signals::BoolInputTrait);
%shared_ptr(openplx::Physics::Signals::BoolOutput);
%shared_ptr(openplx::Physics::Signals::BoolOutputTrait);
%shared_ptr(openplx::Physics::Signals::BoolValue);
%shared_ptr(openplx::Physics::Signals::DistanceValue);
%shared_ptr(openplx::Physics::Signals::DurationInput);
%shared_ptr(openplx::Physics::Signals::DurationInputTrait);
%shared_ptr(openplx::Physics::Signals::DurationOutput);
%shared_ptr(openplx::Physics::Signals::DurationOutputTrait);
%shared_ptr(openplx::Physics::Signals::DurationValue);
%shared_ptr(openplx::Physics::Signals::EnableInteractionInput);
%shared_ptr(openplx::Physics::Signals::EngageInput);
%shared_ptr(openplx::Physics::Signals::EngagedOutput);
%shared_ptr(openplx::Physics::Signals::Force1DInput);
%shared_ptr(openplx::Physics::Signals::Force1DInputTrait);
%shared_ptr(openplx::Physics::Signals::Force1DOutput);
%shared_ptr(openplx::Physics::Signals::Force1DOutputTrait);
%shared_ptr(openplx::Physics::Signals::Force1DValue);
%shared_ptr(openplx::Physics::Signals::Force3DOutput);
%shared_ptr(openplx::Physics::Signals::Force3DOutputTrait);
%shared_ptr(openplx::Physics::Signals::Force3DValue);
%shared_ptr(openplx::Physics::Signals::ForceRangeInput);
%shared_ptr(openplx::Physics::Signals::ForceRangeInputTrait);
%shared_ptr(openplx::Physics::Signals::ForceRangeOutput);
%shared_ptr(openplx::Physics::Signals::ForceRangeOutputTrait);
%shared_ptr(openplx::Physics::Signals::ForceRangeValue);
%shared_ptr(openplx::Physics::Signals::FractionInput);
%shared_ptr(openplx::Physics::Signals::FractionInputTrait);
%shared_ptr(openplx::Physics::Signals::FractionOutput);
%shared_ptr(openplx::Physics::Signals::FractionOutputTrait);
%shared_ptr(openplx::Physics::Signals::FractionValue);
%shared_ptr(openplx::Physics::Signals::Input);
%shared_ptr(openplx::Physics::Signals::InputOutputType);
%shared_ptr(openplx::Physics::Signals::InputSignal);
%shared_ptr(openplx::Physics::Signals::IntInput);
%shared_ptr(openplx::Physics::Signals::IntInputSignal);
%shared_ptr(openplx::Physics::Signals::IntInputTrait);
%shared_ptr(openplx::Physics::Signals::IntOutput);
%shared_ptr(openplx::Physics::Signals::IntOutputTrait);
%shared_ptr(openplx::Physics::Signals::IntValue);
%shared_ptr(openplx::Physics::Signals::InteractionEnabledOutput);
%shared_ptr(openplx::Physics::Signals::LinearVelocity1DInput);
%shared_ptr(openplx::Physics::Signals::LinearVelocity1DInputTrait);
%shared_ptr(openplx::Physics::Signals::LinearVelocity1DOutput);
%shared_ptr(openplx::Physics::Signals::LinearVelocity1DOutputTrait);
%shared_ptr(openplx::Physics::Signals::Output);
%shared_ptr(openplx::Physics::Signals::OutputSignal);
%shared_ptr(openplx::Physics::Signals::Position1DInput);
%shared_ptr(openplx::Physics::Signals::Position1DInputTrait);
%shared_ptr(openplx::Physics::Signals::Position1DOutput);
%shared_ptr(openplx::Physics::Signals::Position1DOutputTrait);
%shared_ptr(openplx::Physics::Signals::Position3DValue);
%shared_ptr(openplx::Physics::Signals::RPYvalue);
%shared_ptr(openplx::Physics::Signals::RealInputSignal);
%shared_ptr(openplx::Physics::Signals::RealRangeInputSignal);
%shared_ptr(openplx::Physics::Signals::RealValue);
%shared_ptr(openplx::Physics::Signals::RelativeVelocity1DOutput);
%shared_ptr(openplx::Physics::Signals::RelativeVelocity1DOutputTrait);
%shared_ptr(openplx::Physics::Signals::SignalInterface);
%shared_ptr(openplx::Physics::Signals::Torque1DInput);
%shared_ptr(openplx::Physics::Signals::Torque1DInputTrait);
%shared_ptr(openplx::Physics::Signals::Torque1DOutput);
%shared_ptr(openplx::Physics::Signals::Torque1DOutputTrait);
%shared_ptr(openplx::Physics::Signals::Torque1DValue);
%shared_ptr(openplx::Physics::Signals::Torque3DOutput);
%shared_ptr(openplx::Physics::Signals::Torque3DOutputTrait);
%shared_ptr(openplx::Physics::Signals::Torque3DValue);
%shared_ptr(openplx::Physics::Signals::TorqueRangeInput);
%shared_ptr(openplx::Physics::Signals::TorqueRangeInputTrait);
%shared_ptr(openplx::Physics::Signals::TorqueRangeOutput);
%shared_ptr(openplx::Physics::Signals::TorqueRangeOutputTrait);
%shared_ptr(openplx::Physics::Signals::TorqueRangeValue);
%shared_ptr(openplx::Physics::Signals::Value);
%shared_ptr(openplx::Physics::Signals::ValueOutputSignal);
%shared_ptr(openplx::Physics::Signals::Vec2Value);
%shared_ptr(openplx::Physics::Signals::Vec3InputSignal);
%shared_ptr(openplx::Physics::Signals::Vec3Value);
%shared_ptr(openplx::Physics::Signals::Velocity1DValue);
%shared_ptr(openplx::Physics::Signals::Velocity3DValue);
%shared_ptr(openplx::Physics::System);
OPENPLX_TRAIT(AngleInputTrait_TraitProxy, AngleInputTrait, openplx::Physics::Signals::AngleInputTrait);
OPENPLX_TRAIT(AngleOutputTrait_TraitProxy, AngleOutputTrait, openplx::Physics::Signals::AngleOutputTrait);
OPENPLX_TRAIT(AngularVelocity1DInputTrait_TraitProxy, AngularVelocity1DInputTrait, openplx::Physics::Signals::AngularVelocity1DInputTrait);
OPENPLX_TRAIT(AngularVelocity1DOutputTrait_TraitProxy, AngularVelocity1DOutputTrait, openplx::Physics::Signals::AngularVelocity1DOutputTrait);
OPENPLX_TRAIT(BoolInputTrait_TraitProxy, BoolInputTrait, openplx::Physics::Signals::BoolInputTrait);
OPENPLX_TRAIT(BoolOutputTrait_TraitProxy, BoolOutputTrait, openplx::Physics::Signals::BoolOutputTrait);
OPENPLX_TRAIT(DurationInputTrait_TraitProxy, DurationInputTrait, openplx::Physics::Signals::DurationInputTrait);
OPENPLX_TRAIT(DurationOutputTrait_TraitProxy, DurationOutputTrait, openplx::Physics::Signals::DurationOutputTrait);
OPENPLX_TRAIT(Force1DInputTrait_TraitProxy, Force1DInputTrait, openplx::Physics::Signals::Force1DInputTrait);
OPENPLX_TRAIT(Force1DOutputTrait_TraitProxy, Force1DOutputTrait, openplx::Physics::Signals::Force1DOutputTrait);
OPENPLX_TRAIT(Force3DOutputTrait_TraitProxy, Force3DOutputTrait, openplx::Physics::Signals::Force3DOutputTrait);
OPENPLX_TRAIT(ForceRangeInputTrait_TraitProxy, ForceRangeInputTrait, openplx::Physics::Signals::ForceRangeInputTrait);
OPENPLX_TRAIT(ForceRangeOutputTrait_TraitProxy, ForceRangeOutputTrait, openplx::Physics::Signals::ForceRangeOutputTrait);
OPENPLX_TRAIT(FractionInputTrait_TraitProxy, FractionInputTrait, openplx::Physics::Signals::FractionInputTrait);
OPENPLX_TRAIT(FractionOutputTrait_TraitProxy, FractionOutputTrait, openplx::Physics::Signals::FractionOutputTrait);
OPENPLX_TRAIT(IntInputTrait_TraitProxy, IntInputTrait, openplx::Physics::Signals::IntInputTrait);
OPENPLX_TRAIT(IntOutputTrait_TraitProxy, IntOutputTrait, openplx::Physics::Signals::IntOutputTrait);
OPENPLX_TRAIT(LinearVelocity1DInputTrait_TraitProxy, LinearVelocity1DInputTrait, openplx::Physics::Signals::LinearVelocity1DInputTrait);
OPENPLX_TRAIT(LinearVelocity1DOutputTrait_TraitProxy, LinearVelocity1DOutputTrait, openplx::Physics::Signals::LinearVelocity1DOutputTrait);
OPENPLX_TRAIT(Position1DInputTrait_TraitProxy, Position1DInputTrait, openplx::Physics::Signals::Position1DInputTrait);
OPENPLX_TRAIT(Position1DOutputTrait_TraitProxy, Position1DOutputTrait, openplx::Physics::Signals::Position1DOutputTrait);
OPENPLX_TRAIT(RelativeVelocity1DOutputTrait_TraitProxy, RelativeVelocity1DOutputTrait, openplx::Physics::Signals::RelativeVelocity1DOutputTrait);
OPENPLX_TRAIT(Torque1DInputTrait_TraitProxy, Torque1DInputTrait, openplx::Physics::Signals::Torque1DInputTrait);
OPENPLX_TRAIT(Torque1DOutputTrait_TraitProxy, Torque1DOutputTrait, openplx::Physics::Signals::Torque1DOutputTrait);
OPENPLX_TRAIT(Torque3DOutputTrait_TraitProxy, Torque3DOutputTrait, openplx::Physics::Signals::Torque3DOutputTrait);
OPENPLX_TRAIT(TorqueRangeInputTrait_TraitProxy, TorqueRangeInputTrait, openplx::Physics::Signals::TorqueRangeInputTrait);
OPENPLX_TRAIT(TorqueRangeOutputTrait_TraitProxy, TorqueRangeOutputTrait, openplx::Physics::Signals::TorqueRangeOutputTrait);
OPENPLX_FIX_DOWNCASTING(openplx::Physics::Bodies::Body)
OPENPLX_FIX_DOWNCASTING(openplx::Physics::Bodies::Inertia)
OPENPLX_FIX_DOWNCASTING(openplx::Physics::Bodies::Kinematics)
OPENPLX_FIX_DOWNCASTING(openplx::Physics::Charges::Charge)
OPENPLX_FIX_DOWNCASTING(openplx::Physics::Charges::ContactGeometry)
OPENPLX_FIX_DOWNCASTING(openplx::Physics::Charges::LinearElasticMaterial)
OPENPLX_FIX_DOWNCASTING(openplx::Physics::Charges::Material)
OPENPLX_FIX_DOWNCASTING(openplx::Physics::Interactions::Adhesion::ConstantForceAdhesion)
OPENPLX_FIX_DOWNCASTING(openplx::Physics::Interactions::Adhesion::DefaultAdhesion)
OPENPLX_FIX_DOWNCASTING(openplx::Physics::Interactions::Clearance::ConstantAngleClearance)
OPENPLX_FIX_DOWNCASTING(openplx::Physics::Interactions::Clearance::ConstantDistanceClearance)
OPENPLX_FIX_DOWNCASTING(openplx::Physics::Interactions::Clearance::DefaultClearance)
OPENPLX_FIX_DOWNCASTING(openplx::Physics::Interactions::Dissipation::AsymmetricLimitFriction)
OPENPLX_FIX_DOWNCASTING(openplx::Physics::Interactions::Dissipation::ConstantLimitFriction)
OPENPLX_FIX_DOWNCASTING(openplx::Physics::Interactions::Dissipation::ConstantViscousSurfaceFriction)
OPENPLX_FIX_DOWNCASTING(openplx::Physics::Interactions::Dissipation::ConstraintRelaxationTimeDamping)
OPENPLX_FIX_DOWNCASTING(openplx::Physics::Interactions::Dissipation::DefaultDissipation)
OPENPLX_FIX_DOWNCASTING(openplx::Physics::Interactions::Dissipation::DefaultDryFriction)
OPENPLX_FIX_DOWNCASTING(openplx::Physics::Interactions::Dissipation::DefaultFriction)
OPENPLX_FIX_DOWNCASTING(openplx::Physics::Interactions::Dissipation::DryBoxFriction)
OPENPLX_FIX_DOWNCASTING(openplx::Physics::Interactions::Dissipation::DryConeFriction)
OPENPLX_FIX_DOWNCASTING(openplx::Physics::Interactions::Dissipation::DryConstantNormalForceFriction)
OPENPLX_FIX_DOWNCASTING(openplx::Physics::Interactions::Dissipation::DryDepthScaledConstantNormalForceFriction)
OPENPLX_FIX_DOWNCASTING(openplx::Physics::Interactions::Dissipation::DryScaleBoxFriction)
OPENPLX_FIX_DOWNCASTING(openplx::Physics::Interactions::Dissipation::MechanicalDamping)
OPENPLX_FIX_DOWNCASTING(openplx::Physics::Interactions::Flexibility::DefaultFlexibility)
OPENPLX_FIX_DOWNCASTING(openplx::Physics::Interactions::Flexibility::LinearElastic)
OPENPLX_FIX_DOWNCASTING(openplx::Physics::Interactions::Flexibility::Rigid)
OPENPLX_FIX_DOWNCASTING(openplx::Physics::Interactions::Interaction)
OPENPLX_FIX_DOWNCASTING(openplx::Physics::Interactions::Interaction1DOF)
OPENPLX_FIX_DOWNCASTING(openplx::Physics::Interactions::SurfaceContact::Model)
OPENPLX_FIX_DOWNCASTING(openplx::Physics::Interactions::SurfaceContact::PatchElasticity)
OPENPLX_FIX_DOWNCASTING(openplx::Physics::Interactions::SurfaceContact::PointwiseElasticity)
OPENPLX_FIX_DOWNCASTING(openplx::Physics::Interactions::Toughness::DefaultToughness)
OPENPLX_FIX_DOWNCASTING(openplx::Physics::Interactions::Toughness::ThresholdFracture)
OPENPLX_FIX_DOWNCASTING(openplx::Physics::Interactions::Toughness::ThresholdPlastic)
OPENPLX_FIX_DOWNCASTING(openplx::Physics::Interactions::Toughness::ThresholdPlasticFracture)
OPENPLX_FIX_DOWNCASTING(openplx::Physics::Interactions::Toughness::Unbreakable)
OPENPLX_FIX_DOWNCASTING(openplx::Physics::KinematicLock)
OPENPLX_FIX_DOWNCASTING(openplx::Physics::Signals::Acceleration3DValue)
OPENPLX_FIX_DOWNCASTING(openplx::Physics::Signals::ActivateInput)
OPENPLX_FIX_DOWNCASTING(openplx::Physics::Signals::ActivatedOutput)
OPENPLX_FIX_DOWNCASTING(openplx::Physics::Signals::AngleInput)
OPENPLX_FIX_DOWNCASTING(openplx::Physics::Signals::AngleOutput)
OPENPLX_FIX_DOWNCASTING(openplx::Physics::Signals::AngleValue)
OPENPLX_FIX_DOWNCASTING(openplx::Physics::Signals::AngularAcceleration3DValue)
OPENPLX_FIX_DOWNCASTING(openplx::Physics::Signals::AngularVelocity1DInput)
OPENPLX_FIX_DOWNCASTING(openplx::Physics::Signals::AngularVelocity1DOutput)
OPENPLX_FIX_DOWNCASTING(openplx::Physics::Signals::AngularVelocity1DValue)
OPENPLX_FIX_DOWNCASTING(openplx::Physics::Signals::AngularVelocity3DValue)
OPENPLX_FIX_DOWNCASTING(openplx::Physics::Signals::BoolInput)
OPENPLX_FIX_DOWNCASTING(openplx::Physics::Signals::BoolInputSignal)
OPENPLX_FIX_DOWNCASTING(openplx::Physics::Signals::BoolOutput)
OPENPLX_FIX_DOWNCASTING(openplx::Physics::Signals::BoolValue)
OPENPLX_FIX_DOWNCASTING(openplx::Physics::Signals::DistanceValue)
OPENPLX_FIX_DOWNCASTING(openplx::Physics::Signals::DurationInput)
OPENPLX_FIX_DOWNCASTING(openplx::Physics::Signals::DurationOutput)
OPENPLX_FIX_DOWNCASTING(openplx::Physics::Signals::DurationValue)
OPENPLX_FIX_DOWNCASTING(openplx::Physics::Signals::EnableInteractionInput)
OPENPLX_FIX_DOWNCASTING(openplx::Physics::Signals::EngageInput)
OPENPLX_FIX_DOWNCASTING(openplx::Physics::Signals::EngagedOutput)
OPENPLX_FIX_DOWNCASTING(openplx::Physics::Signals::Force1DInput)
OPENPLX_FIX_DOWNCASTING(openplx::Physics::Signals::Force1DOutput)
OPENPLX_FIX_DOWNCASTING(openplx::Physics::Signals::Force1DValue)
OPENPLX_FIX_DOWNCASTING(openplx::Physics::Signals::Force3DOutput)
OPENPLX_FIX_DOWNCASTING(openplx::Physics::Signals::Force3DValue)
OPENPLX_FIX_DOWNCASTING(openplx::Physics::Signals::ForceRangeInput)
OPENPLX_FIX_DOWNCASTING(openplx::Physics::Signals::ForceRangeOutput)
OPENPLX_FIX_DOWNCASTING(openplx::Physics::Signals::ForceRangeValue)
OPENPLX_FIX_DOWNCASTING(openplx::Physics::Signals::FractionInput)
OPENPLX_FIX_DOWNCASTING(openplx::Physics::Signals::FractionOutput)
OPENPLX_FIX_DOWNCASTING(openplx::Physics::Signals::FractionValue)
OPENPLX_FIX_DOWNCASTING(openplx::Physics::Signals::Input)
OPENPLX_FIX_DOWNCASTING(openplx::Physics::Signals::InputOutputType)
OPENPLX_FIX_DOWNCASTING(openplx::Physics::Signals::InputSignal)
OPENPLX_FIX_DOWNCASTING(openplx::Physics::Signals::IntInput)
OPENPLX_FIX_DOWNCASTING(openplx::Physics::Signals::IntInputSignal)
OPENPLX_FIX_DOWNCASTING(openplx::Physics::Signals::IntOutput)
OPENPLX_FIX_DOWNCASTING(openplx::Physics::Signals::IntValue)
OPENPLX_FIX_DOWNCASTING(openplx::Physics::Signals::InteractionEnabledOutput)
OPENPLX_FIX_DOWNCASTING(openplx::Physics::Signals::LinearVelocity1DInput)
OPENPLX_FIX_DOWNCASTING(openplx::Physics::Signals::LinearVelocity1DOutput)
OPENPLX_FIX_DOWNCASTING(openplx::Physics::Signals::Output)
OPENPLX_FIX_DOWNCASTING(openplx::Physics::Signals::OutputSignal)
OPENPLX_FIX_DOWNCASTING(openplx::Physics::Signals::Position1DInput)
OPENPLX_FIX_DOWNCASTING(openplx::Physics::Signals::Position1DOutput)
OPENPLX_FIX_DOWNCASTING(openplx::Physics::Signals::Position3DValue)
OPENPLX_FIX_DOWNCASTING(openplx::Physics::Signals::RPYvalue)
OPENPLX_FIX_DOWNCASTING(openplx::Physics::Signals::RealInputSignal)
OPENPLX_FIX_DOWNCASTING(openplx::Physics::Signals::RealRangeInputSignal)
OPENPLX_FIX_DOWNCASTING(openplx::Physics::Signals::RealValue)
OPENPLX_FIX_DOWNCASTING(openplx::Physics::Signals::RelativeVelocity1DOutput)
OPENPLX_FIX_DOWNCASTING(openplx::Physics::Signals::SignalInterface)
OPENPLX_FIX_DOWNCASTING(openplx::Physics::Signals::Torque1DInput)
OPENPLX_FIX_DOWNCASTING(openplx::Physics::Signals::Torque1DOutput)
OPENPLX_FIX_DOWNCASTING(openplx::Physics::Signals::Torque1DValue)
OPENPLX_FIX_DOWNCASTING(openplx::Physics::Signals::Torque3DOutput)
OPENPLX_FIX_DOWNCASTING(openplx::Physics::Signals::Torque3DValue)
OPENPLX_FIX_DOWNCASTING(openplx::Physics::Signals::TorqueRangeInput)
OPENPLX_FIX_DOWNCASTING(openplx::Physics::Signals::TorqueRangeOutput)
OPENPLX_FIX_DOWNCASTING(openplx::Physics::Signals::TorqueRangeValue)
OPENPLX_FIX_DOWNCASTING(openplx::Physics::Signals::Value)
OPENPLX_FIX_DOWNCASTING(openplx::Physics::Signals::ValueOutputSignal)
OPENPLX_FIX_DOWNCASTING(openplx::Physics::Signals::Vec2Value)
OPENPLX_FIX_DOWNCASTING(openplx::Physics::Signals::Vec3InputSignal)
OPENPLX_FIX_DOWNCASTING(openplx::Physics::Signals::Vec3Value)
OPENPLX_FIX_DOWNCASTING(openplx::Physics::Signals::Velocity1DValue)
OPENPLX_FIX_DOWNCASTING(openplx::Physics::Signals::Velocity3DValue)
OPENPLX_FIX_DOWNCASTING(openplx::Physics::System)
%typemap(csimports) openplx::Physics::Interactions::Interaction "
/* Workaround for missing namespaces on interfaces */
using BoolInputTrait = openplx.Physics.Signals.BoolInputTrait;
using BoolOutputTrait = openplx.Physics.Signals.BoolOutputTrait;
";
%include "openplx/Physics/Bodies/Body.h"
%include "openplx/Physics/Bodies/Inertia.h"
%include "openplx/Physics/Bodies/Kinematics.h"
%include "openplx/Physics/Charges/Charge.h"
%include "openplx/Physics/Charges/ContactGeometry.h"
%include "openplx/Physics/Charges/Material.h"
%include "openplx/Physics/Charges/LinearElasticMaterial.h"
%include "openplx/Physics/Interactions/Adhesion/DefaultAdhesion.h"
%include "openplx/Physics/Interactions/Adhesion/ConstantForceAdhesion.h"
%include "openplx/Physics/Interactions/Clearance/DefaultClearance.h"
%include "openplx/Physics/Interactions/Clearance/ConstantAngleClearance.h"
%include "openplx/Physics/Interactions/Clearance/ConstantDistanceClearance.h"
%include "openplx/Physics/Interactions/Dissipation/DefaultDissipation.h"
%include "openplx/Physics/Interactions/Dissipation/DefaultFriction.h"
%include "openplx/Physics/Interactions/Dissipation/AsymmetricLimitFriction.h"
%include "openplx/Physics/Interactions/Dissipation/ConstantLimitFriction.h"
%include "openplx/Physics/Interactions/Dissipation/ConstantViscousSurfaceFriction.h"
%include "openplx/Physics/Interactions/Dissipation/ConstraintRelaxationTimeDamping.h"
%include "openplx/Physics/Interactions/Dissipation/DefaultDryFriction.h"
%include "openplx/Physics/Interactions/Dissipation/DryBoxFriction.h"
%include "openplx/Physics/Interactions/Dissipation/DryConeFriction.h"
%include "openplx/Physics/Interactions/Dissipation/DryConstantNormalForceFriction.h"
%include "openplx/Physics/Interactions/Dissipation/DryDepthScaledConstantNormalForceFriction.h"
%include "openplx/Physics/Interactions/Dissipation/DryScaleBoxFriction.h"
%include "openplx/Physics/Interactions/Dissipation/MechanicalDamping.h"
%include "openplx/Physics/Interactions/Flexibility/DefaultFlexibility.h"
%include "openplx/Physics/Interactions/Flexibility/LinearElastic.h"
%include "openplx/Physics/Interactions/Flexibility/Rigid.h"
%include "openplx/Physics/Signals/BoolInputTrait.h"
%include "openplx/Physics/Signals/BoolOutputTrait.h"
%include "openplx/Physics/Interactions/Interaction.h"
%include "openplx/Physics/Interactions/Interaction1DOF.h"
%include "openplx/Physics/Interactions/SurfaceContact/Model.h"
%include "openplx/Physics/Interactions/SurfaceContact/PatchElasticity.h"
%include "openplx/Physics/Interactions/SurfaceContact/PointwiseElasticity.h"
%include "openplx/Physics/Interactions/Toughness/DefaultToughness.h"
%include "openplx/Physics/Interactions/Toughness/ThresholdFracture.h"
%include "openplx/Physics/Interactions/Toughness/ThresholdPlastic.h"
%include "openplx/Physics/Interactions/Toughness/ThresholdPlasticFracture.h"
%include "openplx/Physics/Interactions/Toughness/Unbreakable.h"
%include "openplx/Physics/KinematicLock.h"
%include "openplx/Physics/Signals/Value.h"
%include "openplx/Physics/Signals/Vec3Value.h"
%include "openplx/Physics/Signals/Acceleration3DValue.h"
%include "openplx/Physics/Signals/Input.h"
%include "openplx/Physics/Signals/BoolInput.h"
%include "openplx/Physics/Signals/ActivateInput.h"
%include "openplx/Physics/Signals/Output.h"
%include "openplx/Physics/Signals/BoolOutput.h"
%include "openplx/Physics/Signals/ActivatedOutput.h"
%include "openplx/Physics/Signals/AngleInput.h"
%include "openplx/Physics/Signals/AngleInputTrait.h"
%include "openplx/Physics/Signals/AngleOutput.h"
%include "openplx/Physics/Signals/AngleOutputTrait.h"
%include "openplx/Physics/Signals/RealValue.h"
%include "openplx/Physics/Signals/AngleValue.h"
%include "openplx/Physics/Signals/AngularAcceleration3DValue.h"
%include "openplx/Physics/Signals/AngularVelocity1DInput.h"
%include "openplx/Physics/Signals/AngularVelocity1DInputTrait.h"
%include "openplx/Physics/Signals/AngularVelocity1DOutput.h"
%include "openplx/Physics/Signals/AngularVelocity1DOutputTrait.h"
%include "openplx/Physics/Signals/AngularVelocity1DValue.h"
%include "openplx/Physics/Signals/AngularVelocity3DValue.h"
%include "openplx/Physics/Signals/InputSignal.h"
%include "openplx/Physics/Signals/BoolInputSignal.h"
%include "openplx/Physics/Signals/BoolValue.h"
%include "openplx/Physics/Signals/DistanceValue.h"
%include "openplx/Physics/Signals/DurationInput.h"
%include "openplx/Physics/Signals/DurationInputTrait.h"
%include "openplx/Physics/Signals/DurationOutput.h"
%include "openplx/Physics/Signals/DurationOutputTrait.h"
%include "openplx/Physics/Signals/DurationValue.h"
%include "openplx/Physics/Signals/EnableInteractionInput.h"
%include "openplx/Physics/Signals/EngageInput.h"
%include "openplx/Physics/Signals/EngagedOutput.h"
%include "openplx/Physics/Signals/Force1DInput.h"
%include "openplx/Physics/Signals/Force1DInputTrait.h"
%include "openplx/Physics/Signals/Force1DOutput.h"
%include "openplx/Physics/Signals/Force1DOutputTrait.h"
%include "openplx/Physics/Signals/Force1DValue.h"
%include "openplx/Physics/Signals/Force3DOutput.h"
%include "openplx/Physics/Signals/Force3DOutputTrait.h"
%include "openplx/Physics/Signals/Force3DValue.h"
%include "openplx/Physics/Signals/ForceRangeInput.h"
%include "openplx/Physics/Signals/ForceRangeInputTrait.h"
%include "openplx/Physics/Signals/ForceRangeOutput.h"
%include "openplx/Physics/Signals/ForceRangeOutputTrait.h"
%include "openplx/Physics/Signals/Vec2Value.h"
%include "openplx/Physics/Signals/ForceRangeValue.h"
%include "openplx/Physics/Signals/FractionInput.h"
%include "openplx/Physics/Signals/FractionInputTrait.h"
%include "openplx/Physics/Signals/FractionOutput.h"
%include "openplx/Physics/Signals/FractionOutputTrait.h"
%include "openplx/Physics/Signals/FractionValue.h"
%include "openplx/Physics/Signals/InputOutputType.h"
%include "openplx/Physics/Signals/IntInput.h"
%include "openplx/Physics/Signals/IntInputSignal.h"
%include "openplx/Physics/Signals/IntInputTrait.h"
%include "openplx/Physics/Signals/IntOutput.h"
%include "openplx/Physics/Signals/IntOutputTrait.h"
%include "openplx/Physics/Signals/IntValue.h"
%include "openplx/Physics/Signals/InteractionEnabledOutput.h"
%include "openplx/Physics/Signals/LinearVelocity1DInput.h"
%include "openplx/Physics/Signals/LinearVelocity1DInputTrait.h"
%include "openplx/Physics/Signals/LinearVelocity1DOutput.h"
%include "openplx/Physics/Signals/LinearVelocity1DOutputTrait.h"
%include "openplx/Physics/Signals/OutputSignal.h"
%include "openplx/Physics/Signals/Position1DInput.h"
%include "openplx/Physics/Signals/Position1DInputTrait.h"
%include "openplx/Physics/Signals/Position1DOutput.h"
%include "openplx/Physics/Signals/Position1DOutputTrait.h"
%include "openplx/Physics/Signals/Position3DValue.h"
%include "openplx/Physics/Signals/RPYvalue.h"
%include "openplx/Physics/Signals/RealInputSignal.h"
%include "openplx/Physics/Signals/RealRangeInputSignal.h"
%include "openplx/Physics/Signals/RelativeVelocity1DOutput.h"
%include "openplx/Physics/Signals/RelativeVelocity1DOutputTrait.h"
%include "openplx/Physics/Signals/SignalInterface.h"
%include "openplx/Physics/Signals/Torque1DInput.h"
%include "openplx/Physics/Signals/Torque1DInputTrait.h"
%include "openplx/Physics/Signals/Torque1DOutput.h"
%include "openplx/Physics/Signals/Torque1DOutputTrait.h"
%include "openplx/Physics/Signals/Torque1DValue.h"
%include "openplx/Physics/Signals/Torque3DOutput.h"
%include "openplx/Physics/Signals/Torque3DOutputTrait.h"
%include "openplx/Physics/Signals/Torque3DValue.h"
%include "openplx/Physics/Signals/TorqueRangeInput.h"
%include "openplx/Physics/Signals/TorqueRangeInputTrait.h"
%include "openplx/Physics/Signals/TorqueRangeOutput.h"
%include "openplx/Physics/Signals/TorqueRangeOutputTrait.h"
%include "openplx/Physics/Signals/TorqueRangeValue.h"
%include "openplx/Physics/Signals/ValueOutputSignal.h"
%include "openplx/Physics/Signals/Vec3InputSignal.h"
%include "openplx/Physics/Signals/Velocity1DValue.h"
%include "openplx/Physics/Signals/Velocity3DValue.h"
%include "openplx/Physics/System.h"
%ignore Physics_register_factories;
%include <openplx/Physics/Physics_all.h>
%inline {
    void Physics_register_factories_cs(openplx::Core::Api::OpenPlxContext* ctx) {
        auto internal_ctx = openplx::Core::Api::OpenPlxContextInternal::fromContext(*ctx);
        auto eval_ctx = internal_ctx->evaluatorContext().get();
        Physics_register_factories(eval_ctx);
    }
}
%template(PhysicsBodiesBodyVector) std::vector<std::shared_ptr<openplx::Physics::Bodies::Body>>;
%template(PhysicsBodiesInertiaVector) std::vector<std::shared_ptr<openplx::Physics::Bodies::Inertia>>;
%template(PhysicsBodiesKinematicsVector) std::vector<std::shared_ptr<openplx::Physics::Bodies::Kinematics>>;
%template(PhysicsChargesChargeVector) std::vector<std::shared_ptr<openplx::Physics::Charges::Charge>>;
%template(PhysicsChargesContactGeometryVector) std::vector<std::shared_ptr<openplx::Physics::Charges::ContactGeometry>>;
%template(PhysicsChargesLinearElasticMaterialVector) std::vector<std::shared_ptr<openplx::Physics::Charges::LinearElasticMaterial>>;
%template(PhysicsChargesMaterialVector) std::vector<std::shared_ptr<openplx::Physics::Charges::Material>>;
%template(PhysicsInteractionsAdhesionConstantForceAdhesionVector) std::vector<std::shared_ptr<openplx::Physics::Interactions::Adhesion::ConstantForceAdhesion>>;
%template(PhysicsInteractionsAdhesionDefaultAdhesionVector) std::vector<std::shared_ptr<openplx::Physics::Interactions::Adhesion::DefaultAdhesion>>;
%template(PhysicsInteractionsClearanceConstantAngleClearanceVector) std::vector<std::shared_ptr<openplx::Physics::Interactions::Clearance::ConstantAngleClearance>>;
%template(PhysicsInteractionsClearanceConstantDistanceClearanceVector) std::vector<std::shared_ptr<openplx::Physics::Interactions::Clearance::ConstantDistanceClearance>>;
%template(PhysicsInteractionsClearanceDefaultClearanceVector) std::vector<std::shared_ptr<openplx::Physics::Interactions::Clearance::DefaultClearance>>;
%template(PhysicsInteractionsDissipationAsymmetricLimitFrictionVector) std::vector<std::shared_ptr<openplx::Physics::Interactions::Dissipation::AsymmetricLimitFriction>>;
%template(PhysicsInteractionsDissipationConstantLimitFrictionVector) std::vector<std::shared_ptr<openplx::Physics::Interactions::Dissipation::ConstantLimitFriction>>;
%template(PhysicsInteractionsDissipationConstantViscousSurfaceFrictionVector) std::vector<std::shared_ptr<openplx::Physics::Interactions::Dissipation::ConstantViscousSurfaceFriction>>;
%template(PhysicsInteractionsDissipationConstraintRelaxationTimeDampingVector) std::vector<std::shared_ptr<openplx::Physics::Interactions::Dissipation::ConstraintRelaxationTimeDamping>>;
%template(PhysicsInteractionsDissipationDefaultDissipationVector) std::vector<std::shared_ptr<openplx::Physics::Interactions::Dissipation::DefaultDissipation>>;
%template(PhysicsInteractionsDissipationDefaultDryFrictionVector) std::vector<std::shared_ptr<openplx::Physics::Interactions::Dissipation::DefaultDryFriction>>;
%template(PhysicsInteractionsDissipationDefaultFrictionVector) std::vector<std::shared_ptr<openplx::Physics::Interactions::Dissipation::DefaultFriction>>;
%template(PhysicsInteractionsDissipationDryBoxFrictionVector) std::vector<std::shared_ptr<openplx::Physics::Interactions::Dissipation::DryBoxFriction>>;
%template(PhysicsInteractionsDissipationDryConeFrictionVector) std::vector<std::shared_ptr<openplx::Physics::Interactions::Dissipation::DryConeFriction>>;
%template(PhysicsInteractionsDissipationDryConstantNormalForceFrictionVector) std::vector<std::shared_ptr<openplx::Physics::Interactions::Dissipation::DryConstantNormalForceFriction>>;
%template(PhysicsInteractionsDissipationDryDepthScaledConstantNormalForceFrictionVector) std::vector<std::shared_ptr<openplx::Physics::Interactions::Dissipation::DryDepthScaledConstantNormalForceFriction>>;
%template(PhysicsInteractionsDissipationDryScaleBoxFrictionVector) std::vector<std::shared_ptr<openplx::Physics::Interactions::Dissipation::DryScaleBoxFriction>>;
%template(PhysicsInteractionsDissipationMechanicalDampingVector) std::vector<std::shared_ptr<openplx::Physics::Interactions::Dissipation::MechanicalDamping>>;
%template(PhysicsInteractionsFlexibilityDefaultFlexibilityVector) std::vector<std::shared_ptr<openplx::Physics::Interactions::Flexibility::DefaultFlexibility>>;
%template(PhysicsInteractionsFlexibilityLinearElasticVector) std::vector<std::shared_ptr<openplx::Physics::Interactions::Flexibility::LinearElastic>>;
%template(PhysicsInteractionsFlexibilityRigidVector) std::vector<std::shared_ptr<openplx::Physics::Interactions::Flexibility::Rigid>>;
%template(PhysicsInteractionsInteractionVector) std::vector<std::shared_ptr<openplx::Physics::Interactions::Interaction>>;
%template(PhysicsInteractionsInteraction1DOFVector) std::vector<std::shared_ptr<openplx::Physics::Interactions::Interaction1DOF>>;
%template(PhysicsInteractionsSurfaceContactModelVector) std::vector<std::shared_ptr<openplx::Physics::Interactions::SurfaceContact::Model>>;
%template(PhysicsInteractionsSurfaceContactPatchElasticityVector) std::vector<std::shared_ptr<openplx::Physics::Interactions::SurfaceContact::PatchElasticity>>;
%template(PhysicsInteractionsSurfaceContactPointwiseElasticityVector) std::vector<std::shared_ptr<openplx::Physics::Interactions::SurfaceContact::PointwiseElasticity>>;
%template(PhysicsInteractionsToughnessDefaultToughnessVector) std::vector<std::shared_ptr<openplx::Physics::Interactions::Toughness::DefaultToughness>>;
%template(PhysicsInteractionsToughnessThresholdFractureVector) std::vector<std::shared_ptr<openplx::Physics::Interactions::Toughness::ThresholdFracture>>;
%template(PhysicsInteractionsToughnessThresholdPlasticVector) std::vector<std::shared_ptr<openplx::Physics::Interactions::Toughness::ThresholdPlastic>>;
%template(PhysicsInteractionsToughnessThresholdPlasticFractureVector) std::vector<std::shared_ptr<openplx::Physics::Interactions::Toughness::ThresholdPlasticFracture>>;
%template(PhysicsInteractionsToughnessUnbreakableVector) std::vector<std::shared_ptr<openplx::Physics::Interactions::Toughness::Unbreakable>>;
%template(PhysicsKinematicLockVector) std::vector<std::shared_ptr<openplx::Physics::KinematicLock>>;
%template(PhysicsSignalsAcceleration3DValueVector) std::vector<std::shared_ptr<openplx::Physics::Signals::Acceleration3DValue>>;
%template(PhysicsSignalsActivateInputVector) std::vector<std::shared_ptr<openplx::Physics::Signals::ActivateInput>>;
%template(PhysicsSignalsActivatedOutputVector) std::vector<std::shared_ptr<openplx::Physics::Signals::ActivatedOutput>>;
%template(PhysicsSignalsAngleInputVector) std::vector<std::shared_ptr<openplx::Physics::Signals::AngleInput>>;
%template(PhysicsSignalsAngleOutputVector) std::vector<std::shared_ptr<openplx::Physics::Signals::AngleOutput>>;
%template(PhysicsSignalsAngleValueVector) std::vector<std::shared_ptr<openplx::Physics::Signals::AngleValue>>;
%template(PhysicsSignalsAngularAcceleration3DValueVector) std::vector<std::shared_ptr<openplx::Physics::Signals::AngularAcceleration3DValue>>;
%template(PhysicsSignalsAngularVelocity1DInputVector) std::vector<std::shared_ptr<openplx::Physics::Signals::AngularVelocity1DInput>>;
%template(PhysicsSignalsAngularVelocity1DOutputVector) std::vector<std::shared_ptr<openplx::Physics::Signals::AngularVelocity1DOutput>>;
%template(PhysicsSignalsAngularVelocity1DValueVector) std::vector<std::shared_ptr<openplx::Physics::Signals::AngularVelocity1DValue>>;
%template(PhysicsSignalsAngularVelocity3DValueVector) std::vector<std::shared_ptr<openplx::Physics::Signals::AngularVelocity3DValue>>;
%template(PhysicsSignalsBoolInputVector) std::vector<std::shared_ptr<openplx::Physics::Signals::BoolInput>>;
%template(PhysicsSignalsBoolInputSignalVector) std::vector<std::shared_ptr<openplx::Physics::Signals::BoolInputSignal>>;
%template(PhysicsSignalsBoolOutputVector) std::vector<std::shared_ptr<openplx::Physics::Signals::BoolOutput>>;
%template(PhysicsSignalsBoolValueVector) std::vector<std::shared_ptr<openplx::Physics::Signals::BoolValue>>;
%template(PhysicsSignalsDistanceValueVector) std::vector<std::shared_ptr<openplx::Physics::Signals::DistanceValue>>;
%template(PhysicsSignalsDurationInputVector) std::vector<std::shared_ptr<openplx::Physics::Signals::DurationInput>>;
%template(PhysicsSignalsDurationOutputVector) std::vector<std::shared_ptr<openplx::Physics::Signals::DurationOutput>>;
%template(PhysicsSignalsDurationValueVector) std::vector<std::shared_ptr<openplx::Physics::Signals::DurationValue>>;
%template(PhysicsSignalsEnableInteractionInputVector) std::vector<std::shared_ptr<openplx::Physics::Signals::EnableInteractionInput>>;
%template(PhysicsSignalsEngageInputVector) std::vector<std::shared_ptr<openplx::Physics::Signals::EngageInput>>;
%template(PhysicsSignalsEngagedOutputVector) std::vector<std::shared_ptr<openplx::Physics::Signals::EngagedOutput>>;
%template(PhysicsSignalsForce1DInputVector) std::vector<std::shared_ptr<openplx::Physics::Signals::Force1DInput>>;
%template(PhysicsSignalsForce1DOutputVector) std::vector<std::shared_ptr<openplx::Physics::Signals::Force1DOutput>>;
%template(PhysicsSignalsForce1DValueVector) std::vector<std::shared_ptr<openplx::Physics::Signals::Force1DValue>>;
%template(PhysicsSignalsForce3DOutputVector) std::vector<std::shared_ptr<openplx::Physics::Signals::Force3DOutput>>;
%template(PhysicsSignalsForce3DValueVector) std::vector<std::shared_ptr<openplx::Physics::Signals::Force3DValue>>;
%template(PhysicsSignalsForceRangeInputVector) std::vector<std::shared_ptr<openplx::Physics::Signals::ForceRangeInput>>;
%template(PhysicsSignalsForceRangeOutputVector) std::vector<std::shared_ptr<openplx::Physics::Signals::ForceRangeOutput>>;
%template(PhysicsSignalsForceRangeValueVector) std::vector<std::shared_ptr<openplx::Physics::Signals::ForceRangeValue>>;
%template(PhysicsSignalsFractionInputVector) std::vector<std::shared_ptr<openplx::Physics::Signals::FractionInput>>;
%template(PhysicsSignalsFractionOutputVector) std::vector<std::shared_ptr<openplx::Physics::Signals::FractionOutput>>;
%template(PhysicsSignalsFractionValueVector) std::vector<std::shared_ptr<openplx::Physics::Signals::FractionValue>>;
%template(PhysicsSignalsInputVector) std::vector<std::shared_ptr<openplx::Physics::Signals::Input>>;
%template(PhysicsSignalsInputOutputTypeVector) std::vector<std::shared_ptr<openplx::Physics::Signals::InputOutputType>>;
%template(PhysicsSignalsInputSignalVector) std::vector<std::shared_ptr<openplx::Physics::Signals::InputSignal>>;
%template(PhysicsSignalsIntInputVector) std::vector<std::shared_ptr<openplx::Physics::Signals::IntInput>>;
%template(PhysicsSignalsIntInputSignalVector) std::vector<std::shared_ptr<openplx::Physics::Signals::IntInputSignal>>;
%template(PhysicsSignalsIntOutputVector) std::vector<std::shared_ptr<openplx::Physics::Signals::IntOutput>>;
%template(PhysicsSignalsIntValueVector) std::vector<std::shared_ptr<openplx::Physics::Signals::IntValue>>;
%template(PhysicsSignalsInteractionEnabledOutputVector) std::vector<std::shared_ptr<openplx::Physics::Signals::InteractionEnabledOutput>>;
%template(PhysicsSignalsLinearVelocity1DInputVector) std::vector<std::shared_ptr<openplx::Physics::Signals::LinearVelocity1DInput>>;
%template(PhysicsSignalsLinearVelocity1DOutputVector) std::vector<std::shared_ptr<openplx::Physics::Signals::LinearVelocity1DOutput>>;
%template(PhysicsSignalsOutputVector) std::vector<std::shared_ptr<openplx::Physics::Signals::Output>>;
%template(PhysicsSignalsOutputSignalVector) std::vector<std::shared_ptr<openplx::Physics::Signals::OutputSignal>>;
%template(PhysicsSignalsPosition1DInputVector) std::vector<std::shared_ptr<openplx::Physics::Signals::Position1DInput>>;
%template(PhysicsSignalsPosition1DOutputVector) std::vector<std::shared_ptr<openplx::Physics::Signals::Position1DOutput>>;
%template(PhysicsSignalsPosition3DValueVector) std::vector<std::shared_ptr<openplx::Physics::Signals::Position3DValue>>;
%template(PhysicsSignalsRPYvalueVector) std::vector<std::shared_ptr<openplx::Physics::Signals::RPYvalue>>;
%template(PhysicsSignalsRealInputSignalVector) std::vector<std::shared_ptr<openplx::Physics::Signals::RealInputSignal>>;
%template(PhysicsSignalsRealRangeInputSignalVector) std::vector<std::shared_ptr<openplx::Physics::Signals::RealRangeInputSignal>>;
%template(PhysicsSignalsRealValueVector) std::vector<std::shared_ptr<openplx::Physics::Signals::RealValue>>;
%template(PhysicsSignalsRelativeVelocity1DOutputVector) std::vector<std::shared_ptr<openplx::Physics::Signals::RelativeVelocity1DOutput>>;
%template(PhysicsSignalsSignalInterfaceVector) std::vector<std::shared_ptr<openplx::Physics::Signals::SignalInterface>>;
%template(PhysicsSignalsTorque1DInputVector) std::vector<std::shared_ptr<openplx::Physics::Signals::Torque1DInput>>;
%template(PhysicsSignalsTorque1DOutputVector) std::vector<std::shared_ptr<openplx::Physics::Signals::Torque1DOutput>>;
%template(PhysicsSignalsTorque1DValueVector) std::vector<std::shared_ptr<openplx::Physics::Signals::Torque1DValue>>;
%template(PhysicsSignalsTorque3DOutputVector) std::vector<std::shared_ptr<openplx::Physics::Signals::Torque3DOutput>>;
%template(PhysicsSignalsTorque3DValueVector) std::vector<std::shared_ptr<openplx::Physics::Signals::Torque3DValue>>;
%template(PhysicsSignalsTorqueRangeInputVector) std::vector<std::shared_ptr<openplx::Physics::Signals::TorqueRangeInput>>;
%template(PhysicsSignalsTorqueRangeOutputVector) std::vector<std::shared_ptr<openplx::Physics::Signals::TorqueRangeOutput>>;
%template(PhysicsSignalsTorqueRangeValueVector) std::vector<std::shared_ptr<openplx::Physics::Signals::TorqueRangeValue>>;
%template(PhysicsSignalsValueVector) std::vector<std::shared_ptr<openplx::Physics::Signals::Value>>;
%template(PhysicsSignalsValueOutputSignalVector) std::vector<std::shared_ptr<openplx::Physics::Signals::ValueOutputSignal>>;
%template(PhysicsSignalsVec2ValueVector) std::vector<std::shared_ptr<openplx::Physics::Signals::Vec2Value>>;
%template(PhysicsSignalsVec3InputSignalVector) std::vector<std::shared_ptr<openplx::Physics::Signals::Vec3InputSignal>>;
%template(PhysicsSignalsVec3ValueVector) std::vector<std::shared_ptr<openplx::Physics::Signals::Vec3Value>>;
%template(PhysicsSignalsVelocity1DValueVector) std::vector<std::shared_ptr<openplx::Physics::Signals::Velocity1DValue>>;
%template(PhysicsSignalsVelocity3DValueVector) std::vector<std::shared_ptr<openplx::Physics::Signals::Velocity3DValue>>;
%template(PhysicsSystemVector) std::vector<std::shared_ptr<openplx::Physics::System>>;
