/*
Copyright 2007-2025. Algoryx Simulation AB.

All AGX source code, intellectual property, documentation, sample code,
tutorials, scene files and technical white papers, are copyrighted, proprietary
and confidential material of Algoryx Simulation AB. You may not download, read,
store, distribute, publish, copy or otherwise disseminate, use or expose this
material unless having a written signed agreement with Algoryx Simulation AB, or having been
advised so by Algoryx Simulation AB for a time limited evaluation, or having purchased a
valid commercial license from Algoryx Simulation AB.

Algoryx Simulation AB disclaims all responsibilities for loss or damage caused
from using this software, unless otherwise stated in written agreements with
Algoryx Simulation AB.
*/
#pragma once
#include <agxSensor/Sensor.h>

#include <agx/Frame.h>

namespace agxSensor
{
  AGX_DECLARE_POINTER_TYPES( FrameAttachedSensor );
  AGX_DECLARE_VECTOR_TYPES( FrameAttachedSensor );

  /**
  Common base type for all sensors attached to a frame of reference, such as that of a rigid body.
  */
  class AGXSENSOR_EXPORT FrameAttachedSensor : public Sensor
  {
    public:
      /**
      Default constructor.
      */
      FrameAttachedSensor() = default;

      /**
      Assign a new parent frame to attach this sensor to. The effects will take place the next time
      the environment is stepped.
      \param frame - new frame for this sensor
      */
      virtual void setFrame( agx::Frame* frame ) = 0;

      /**
      \return the frame of this sensor, defining this sensor -> world transform
      */
      virtual agx::Frame* getFrame() const = 0;

      DOXYGEN_START_INTERNAL_BLOCK()

    public:
      AGXSTREAM_DECLARE_ABSTRACT_SERIALIZABLE( agxSensor::FrameAttachedSensor );

      DOXYGEN_END_INTERNAL_BLOCK()
  };
}
