/*
Copyright 2007-2025. Algoryx Simulation AB.

All AGX source code, intellectual property, documentation, sample code,
tutorials, scene files and technical white papers, are copyrighted, proprietary
and confidential material of Algoryx Simulation AB. You may not download, read,
store, distribute, publish, copy or otherwise disseminate, use or expose this
material unless having a written signed agreement with Algoryx Simulation AB, or having been
advised so by Algoryx Simulation AB for a time limited evaluation, or having purchased a
valid commercial license from Algoryx Simulation AB.

Algoryx Simulation AB disclaims all responsibilities for loss or damage caused
from using this software, unless otherwise stated in written agreements with
Algoryx Simulation AB.
*/

#pragma once

#include <agx/Frame.h>
#include <agx/Constraint.h>
#include <agxSDK/StepEventListener.h>
#include <agxModel/SuctionGripper.h>
#include <agxOpenPLX/export.h>

namespace agxopenplx {
    class AGXOPENPLX_EXPORT SuctionCupStateToggler : public agxSDK::StepEventListener {
        public:
            SuctionCupStateToggler(agxModel::SuctionCup* cup,  agx::Frame* frame_1, agx::Frame* frame_2,
                                agx::Constraint* collapsed_constraint, agx::Constraint* relaxed_constraint,
                                agxModel::VacuumSystem* vacuum);

            virtual void pre(const agx::TimeStamp& /*time*/);
        private:
            agxModel::SuctionCup* m_cup;
            agx::FrameObserver m_frame_1;
            agx::FrameObserver m_frame_2;

            agx::ConstraintObserver m_collapsed_constraint;
            agx::ConstraintObserver m_relaxed_constraint;
            agxModel::VacuumSystemObserver m_vacuum_system;
    };
}
