/*
Copyright 2007-2025. Algoryx Simulation AB.

All AGX source code, intellectual property, documentation, sample code,
tutorials, scene files and technical white papers, are copyrighted, proprietary
and confidential material of Algoryx Simulation AB. You may not download, read,
store, distribute, publish, copy or otherwise disseminate, use or expose this
material unless having a written signed agreement with Algoryx Simulation AB, or having been
advised so by Algoryx Simulation AB for a time limited evaluation, or having purchased a
valid commercial license from Algoryx Simulation AB.

Algoryx Simulation AB disclaims all responsibilities for loss or damage caused
from using this software, unless otherwise stated in written agreements with
Algoryx Simulation AB.
*/

#pragma once

#include <vector>
#include <memory>
#include <unordered_set>
#include <unordered_map>
#include <openplx/Object.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/Terrain/TerrainForward.h>
#include <agxOpenPLX/export.h>

namespace agxopenplx {

    class OpenPlxMaterialManager
    {
        public:
            AGXOPENPLX_EXPORT OpenPlxMaterialManager();

            AGXOPENPLX_EXPORT bool registerAndMergeScene(const openplx::Physics3D::System& scene);

        private:

            bool compareMaterials(const std::shared_ptr<openplx::Physics::Charges::Material>& m1,
                                  const std::shared_ptr<openplx::Physics::Charges::Material>& m2);
            bool compareToughness(openplx::Physics::Interactions::Toughness::DefaultToughness& t1, openplx::Physics::Interactions::Toughness::DefaultToughness& t2);

            bool compareSurfaceContactModels(openplx::Physics::Interactions::SurfaceContact::Model& scm1, openplx::Physics::Interactions::SurfaceContact::Model& scm2);
            bool compareFriction(openplx::Physics::Interactions::Dissipation::DefaultFriction& f1, openplx::Physics::Interactions::Dissipation::DefaultFriction& f2);
            bool compareAdhesion(openplx::Physics::Interactions::Adhesion::DefaultAdhesion& a1, openplx::Physics::Interactions::Adhesion::DefaultAdhesion& a2);
            bool compareNormalFlexibility(openplx::Physics::Interactions::Flexibility::DefaultFlexibility& f1, openplx::Physics::Interactions::Flexibility::DefaultFlexibility& f2);
            bool compareDissipation(openplx::Physics::Interactions::Dissipation::DefaultDissipation& d1, openplx::Physics::Interactions::Dissipation::DefaultDissipation& d2);
            bool compareClearance(openplx::Physics::Interactions::Clearance::DefaultClearance& c1, openplx::Physics::Interactions::Clearance::DefaultClearance& c2);

            std::string resolveFrictionSolveType(openplx::Physics::Interactions::Dissipation::DefaultFriction& friction_model);
            bool resolveApproximateConeFriction(openplx::Physics::Interactions::Dissipation::DefaultFriction& friction_model);

            bool mergeMaterials(
                std::unordered_set<std::shared_ptr<openplx::Physics::Charges::Material>>& new_materials,
                std::vector<std::shared_ptr<openplx::Physics::Interactions::SurfaceContact::Model>>& new_surface_contact_models);

            bool checkForMissingSurfaceContactModels(
                std::vector<std::shared_ptr<openplx::Physics::Interactions::SurfaceContact::Model>>& new_surface_contact_models,
                std::unordered_map<std::string, std::shared_ptr<openplx::Physics::Charges::Material>>& new_materials_map);
            bool compareSurfaceContactModelsMaterials(
                openplx::Physics::Interactions::SurfaceContact::Model& scm1,
                openplx::Physics::Interactions::SurfaceContact::Model& scm2
            );

            std::string getFirstAnnotationOrEmpty(const std::shared_ptr<openplx::Core::Object>& object,
                                                  const std::string& name);


            std::unordered_map<std::string, std::shared_ptr<openplx::Physics::Charges::Material>> m_materials;
            std::vector<std::shared_ptr<openplx::Physics::Interactions::SurfaceContact::Model>> m_surface_contact_models;
            std::vector<std::shared_ptr<openplx::Physics3D::Charges::ContactGeometry>> m_geometries;
            std::vector<std::shared_ptr<openplx::Terrain::Terrain>> m_terrains;
    };
}
