/*
Copyright 2007-2025. Algoryx Simulation AB.

All AGX source code, intellectual property, documentation, sample code,
tutorials, scene files and technical white papers, are copyrighted, proprietary
and confidential material of Algoryx Simulation AB. You may not download, read,
store, distribute, publish, copy or otherwise disseminate, use or expose this
material unless having a written signed agreement with Algoryx Simulation AB, or having been
advised so by Algoryx Simulation AB for a time limited evaluation, or having purchased a
valid commercial license from Algoryx Simulation AB.

Algoryx Simulation AB disclaims all responsibilities for loss or damage caused
from using this software, unless otherwise stated in written agreements with
Algoryx Simulation AB.
*/

#pragma once

#ifdef __APPLE__

#include <agx/PushDisableWarnings.h> // Disabling warnings. Include agx/PopDisableWarnings.h below!
#include <osgViewer/api/Cocoa/PixelBufferCocoa>
#include <osg/GraphicsContext>
#include <agx/PopDisableWarnings.h> // End of disabled warnings.
#include <agxGL/OpenGL.h>

/// \cond INTERNAL_DOCUMENTATION
namespace agxOSG
{
  CGLContextObj getCGLContext(osg::GraphicsContext *context);
  double getScreenScalingFactor();
}
/// \endcond

#endif
