// Copyright Epic Games, Inc. All Rights Reserved.
/*===========================================================================
	Generated code exported from UnrealHeaderTool.
	DO NOT modify this manually! Edit the corresponding .h files instead!
===========================================================================*/

#include "UObject/GeneratedCppIncludes.h"
#include "Utilities/AGX_ROS2Utilities.h"
#include "ROS2/AGX_ROS2Messages.h"
#include "Sensors/AGX_LidarOutputTypes.h"
#include "Sensors/AGX_LidarScanPoint.h"

PRAGMA_DISABLE_DEPRECATION_WARNINGS

void EmptyLinkFunctionForGeneratedCodeAGX_ROS2Utilities() {}

// ********** Begin Cross Module References ********************************************************
AGXCOMMON_API UScriptStruct* Z_Construct_UScriptStruct_FAGX_BuiltinInterfacesTime();
AGXCOMMON_API UScriptStruct* Z_Construct_UScriptStruct_FAGX_LidarOutputPositionData();
AGXCOMMON_API UScriptStruct* Z_Construct_UScriptStruct_FAGX_LidarOutputPositionIntensityData();
AGXCOMMON_API UScriptStruct* Z_Construct_UScriptStruct_FAGX_SensorMsgsPointCloud2();
AGXUNREAL_API UClass* Z_Construct_UClass_UAGX_ROS2Utilities();
AGXUNREAL_API UClass* Z_Construct_UClass_UAGX_ROS2Utilities_NoRegister();
AGXUNREAL_API UScriptStruct* Z_Construct_UScriptStruct_FAGX_LidarScanPoint();
COREUOBJECT_API UScriptStruct* Z_Construct_UScriptStruct_FQuat();
COREUOBJECT_API UScriptStruct* Z_Construct_UScriptStruct_FVector();
ENGINE_API UClass* Z_Construct_UClass_UBlueprintFunctionLibrary();
UPackage* Z_Construct_UPackage__Script_AGXUnreal();
// ********** End Cross Module References **********************************************************

// ********** Begin Class UAGX_ROS2Utilities Function ConvertAnglesTOF *****************************
struct Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertAnglesTOF_Statics
{
	struct AGX_ROS2Utilities_eventConvertAnglesTOF_Parms
	{
		TArray<FAGX_LidarScanPoint> Points;
		FString FrameId;
		FAGX_SensorMsgsPointCloud2 ReturnValue;
	};
#if WITH_METADATA
	static constexpr UECodeGen_Private::FMetaDataPairParam Function_MetaDataParams[] = {
		{ "Category", "AGX Lidar" },
		{ "Comment", "/**\n\x09 * Takes an array of Lidar Scan Points and converts it into a ROS2 sensor_msgs::PointCloud2\n\x09 * message.\n\x09 * The Data member consists of AngleX [rad] (double), AngleY [rad] (double), time of flight\n\x09 * (TOF) [ps] (uint32) and Intensity (double) for each point in little endian layout, i.e. 28\n\x09 * bytes per point. The speed of light used for the TOF calculation is the speed of light in\n\x09 * vacuum.\n\x09 *\n\x09 * (Optional) the FrameId parameter corresponds to the frame_id of the std_msgs::Header message.\n\x09 * If not set, it will be an empty string.\n\x09 *\n\x09 * Note that all invalid points, such as points representing scan misses, are ignored.\n\x09 * This means that the sensor_msgs::PointCloud2 message created by this function is always\n\x09 * dense.\n\x09 *\n\x09 * The timestamp written to the Header member of the sensor_msgs::PointCloud2 message is set to\n\x09 * the timestamp of the first valid Point in the given array, even if other points have been\n\x09 * generated at later timestamps.\n\x09 */" },
		{ "CPP_Default_FrameId", "" },
		{ "ModuleRelativePath", "Public/Utilities/AGX_ROS2Utilities.h" },
		{ "ToolTip", "Takes an array of Lidar Scan Points and converts it into a ROS2 sensor_msgs::PointCloud2\nmessage.\nThe Data member consists of AngleX [rad] (double), AngleY [rad] (double), time of flight\n(TOF) [ps] (uint32) and Intensity (double) for each point in little endian layout, i.e. 28\nbytes per point. The speed of light used for the TOF calculation is the speed of light in\nvacuum.\n\n(Optional) the FrameId parameter corresponds to the frame_id of the std_msgs::Header message.\nIf not set, it will be an empty string.\n\nNote that all invalid points, such as points representing scan misses, are ignored.\nThis means that the sensor_msgs::PointCloud2 message created by this function is always\ndense.\n\nThe timestamp written to the Header member of the sensor_msgs::PointCloud2 message is set to\nthe timestamp of the first valid Point in the given array, even if other points have been\ngenerated at later timestamps." },
	};
	static constexpr UECodeGen_Private::FMetaDataPairParam NewProp_Points_MetaData[] = {
		{ "NativeConst", "" },
	};
	static constexpr UECodeGen_Private::FMetaDataPairParam NewProp_FrameId_MetaData[] = {
		{ "NativeConst", "" },
	};
#endif // WITH_METADATA
	static const UECodeGen_Private::FStructPropertyParams NewProp_Points_Inner;
	static const UECodeGen_Private::FArrayPropertyParams NewProp_Points;
	static const UECodeGen_Private::FStrPropertyParams NewProp_FrameId;
	static const UECodeGen_Private::FStructPropertyParams NewProp_ReturnValue;
	static const UECodeGen_Private::FPropertyParamsBase* const PropPointers[];
	static const UECodeGen_Private::FFunctionParams FuncParams;
};
const UECodeGen_Private::FStructPropertyParams Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertAnglesTOF_Statics::NewProp_Points_Inner = { "Points", nullptr, (EPropertyFlags)0x0000000000000000, UECodeGen_Private::EPropertyGenFlags::Struct, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, 0, Z_Construct_UScriptStruct_FAGX_LidarScanPoint, METADATA_PARAMS(0, nullptr) }; // 3032037237
const UECodeGen_Private::FArrayPropertyParams Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertAnglesTOF_Statics::NewProp_Points = { "Points", nullptr, (EPropertyFlags)0x0010000008000182, UECodeGen_Private::EPropertyGenFlags::Array, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, STRUCT_OFFSET(AGX_ROS2Utilities_eventConvertAnglesTOF_Parms, Points), EArrayPropertyFlags::None, METADATA_PARAMS(UE_ARRAY_COUNT(NewProp_Points_MetaData), NewProp_Points_MetaData) }; // 3032037237
const UECodeGen_Private::FStrPropertyParams Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertAnglesTOF_Statics::NewProp_FrameId = { "FrameId", nullptr, (EPropertyFlags)0x0010000000000080, UECodeGen_Private::EPropertyGenFlags::Str, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, STRUCT_OFFSET(AGX_ROS2Utilities_eventConvertAnglesTOF_Parms, FrameId), METADATA_PARAMS(UE_ARRAY_COUNT(NewProp_FrameId_MetaData), NewProp_FrameId_MetaData) };
const UECodeGen_Private::FStructPropertyParams Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertAnglesTOF_Statics::NewProp_ReturnValue = { "ReturnValue", nullptr, (EPropertyFlags)0x0010000000000580, UECodeGen_Private::EPropertyGenFlags::Struct, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, STRUCT_OFFSET(AGX_ROS2Utilities_eventConvertAnglesTOF_Parms, ReturnValue), Z_Construct_UScriptStruct_FAGX_SensorMsgsPointCloud2, METADATA_PARAMS(0, nullptr) }; // 2387818651
const UECodeGen_Private::FPropertyParamsBase* const Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertAnglesTOF_Statics::PropPointers[] = {
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertAnglesTOF_Statics::NewProp_Points_Inner,
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertAnglesTOF_Statics::NewProp_Points,
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertAnglesTOF_Statics::NewProp_FrameId,
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertAnglesTOF_Statics::NewProp_ReturnValue,
};
static_assert(UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertAnglesTOF_Statics::PropPointers) < 2048);
const UECodeGen_Private::FFunctionParams Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertAnglesTOF_Statics::FuncParams = { { (UObject*(*)())Z_Construct_UClass_UAGX_ROS2Utilities, nullptr, "ConvertAnglesTOF", Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertAnglesTOF_Statics::PropPointers, UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertAnglesTOF_Statics::PropPointers), sizeof(Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertAnglesTOF_Statics::AGX_ROS2Utilities_eventConvertAnglesTOF_Parms), RF_Public|RF_Transient|RF_MarkAsNative, (EFunctionFlags)0x14422401, 0, 0, METADATA_PARAMS(UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertAnglesTOF_Statics::Function_MetaDataParams), Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertAnglesTOF_Statics::Function_MetaDataParams)},  };
static_assert(sizeof(Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertAnglesTOF_Statics::AGX_ROS2Utilities_eventConvertAnglesTOF_Parms) < MAX_uint16);
UFunction* Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertAnglesTOF()
{
	static UFunction* ReturnFunction = nullptr;
	if (!ReturnFunction)
	{
		UECodeGen_Private::ConstructUFunction(&ReturnFunction, Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertAnglesTOF_Statics::FuncParams);
	}
	return ReturnFunction;
}
DEFINE_FUNCTION(UAGX_ROS2Utilities::execConvertAnglesTOF)
{
	P_GET_TARRAY_REF(FAGX_LidarScanPoint,Z_Param_Out_Points);
	P_GET_PROPERTY(FStrProperty,Z_Param_FrameId);
	P_FINISH;
	P_NATIVE_BEGIN;
	*(FAGX_SensorMsgsPointCloud2*)Z_Param__Result=UAGX_ROS2Utilities::ConvertAnglesTOF(Z_Param_Out_Points,Z_Param_FrameId);
	P_NATIVE_END;
}
// ********** End Class UAGX_ROS2Utilities Function ConvertAnglesTOF *******************************

// ********** Begin Class UAGX_ROS2Utilities Function ConvertAngularVelocityToROS ******************
struct Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertAngularVelocityToROS_Statics
{
	struct AGX_ROS2Utilities_eventConvertAngularVelocityToROS_Parms
	{
		FVector AngVelUnreal;
		FVector ReturnValue;
	};
#if WITH_METADATA
	static constexpr UECodeGen_Private::FMetaDataPairParam Function_MetaDataParams[] = {
		{ "Category", "AGX ROS2" },
		{ "Comment", "/**\n     * Converts an angular velocity from Unreal's unit system [deg/s] to ROS2's unit system [rad/s].\n\x09\x09 * ROS2 uses right-handed coordinate systems, while Unreal uses left-handed coordinate systems.\n     *\n     * AngVelUnreal - The angular velocity in Unreal's unit system (left-handed) [deg/s].\n     * Returns the converted angular velocity in ROS2's unit system (right-handed) [rad/s].\n     */" },
		{ "ModuleRelativePath", "Public/Utilities/AGX_ROS2Utilities.h" },
		{ "ToolTip", "Converts an angular velocity from Unreal's unit system [deg/s] to ROS2's unit system [rad/s].\nROS2 uses right-handed coordinate systems, while Unreal uses left-handed coordinate systems.\n\nAngVelUnreal - The angular velocity in Unreal's unit system (left-handed) [deg/s].\nReturns the converted angular velocity in ROS2's unit system (right-handed) [rad/s]." },
	};
#endif // WITH_METADATA
	static const UECodeGen_Private::FStructPropertyParams NewProp_AngVelUnreal;
	static const UECodeGen_Private::FStructPropertyParams NewProp_ReturnValue;
	static const UECodeGen_Private::FPropertyParamsBase* const PropPointers[];
	static const UECodeGen_Private::FFunctionParams FuncParams;
};
const UECodeGen_Private::FStructPropertyParams Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertAngularVelocityToROS_Statics::NewProp_AngVelUnreal = { "AngVelUnreal", nullptr, (EPropertyFlags)0x0010000000000080, UECodeGen_Private::EPropertyGenFlags::Struct, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, STRUCT_OFFSET(AGX_ROS2Utilities_eventConvertAngularVelocityToROS_Parms, AngVelUnreal), Z_Construct_UScriptStruct_FVector, METADATA_PARAMS(0, nullptr) };
const UECodeGen_Private::FStructPropertyParams Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertAngularVelocityToROS_Statics::NewProp_ReturnValue = { "ReturnValue", nullptr, (EPropertyFlags)0x0010000000000580, UECodeGen_Private::EPropertyGenFlags::Struct, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, STRUCT_OFFSET(AGX_ROS2Utilities_eventConvertAngularVelocityToROS_Parms, ReturnValue), Z_Construct_UScriptStruct_FVector, METADATA_PARAMS(0, nullptr) };
const UECodeGen_Private::FPropertyParamsBase* const Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertAngularVelocityToROS_Statics::PropPointers[] = {
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertAngularVelocityToROS_Statics::NewProp_AngVelUnreal,
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertAngularVelocityToROS_Statics::NewProp_ReturnValue,
};
static_assert(UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertAngularVelocityToROS_Statics::PropPointers) < 2048);
const UECodeGen_Private::FFunctionParams Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertAngularVelocityToROS_Statics::FuncParams = { { (UObject*(*)())Z_Construct_UClass_UAGX_ROS2Utilities, nullptr, "ConvertAngularVelocityToROS", Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertAngularVelocityToROS_Statics::PropPointers, UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertAngularVelocityToROS_Statics::PropPointers), sizeof(Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertAngularVelocityToROS_Statics::AGX_ROS2Utilities_eventConvertAngularVelocityToROS_Parms), RF_Public|RF_Transient|RF_MarkAsNative, (EFunctionFlags)0x04822401, 0, 0, METADATA_PARAMS(UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertAngularVelocityToROS_Statics::Function_MetaDataParams), Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertAngularVelocityToROS_Statics::Function_MetaDataParams)},  };
static_assert(sizeof(Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertAngularVelocityToROS_Statics::AGX_ROS2Utilities_eventConvertAngularVelocityToROS_Parms) < MAX_uint16);
UFunction* Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertAngularVelocityToROS()
{
	static UFunction* ReturnFunction = nullptr;
	if (!ReturnFunction)
	{
		UECodeGen_Private::ConstructUFunction(&ReturnFunction, Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertAngularVelocityToROS_Statics::FuncParams);
	}
	return ReturnFunction;
}
DEFINE_FUNCTION(UAGX_ROS2Utilities::execConvertAngularVelocityToROS)
{
	P_GET_STRUCT(FVector,Z_Param_AngVelUnreal);
	P_FINISH;
	P_NATIVE_BEGIN;
	*(FVector*)Z_Param__Result=UAGX_ROS2Utilities::ConvertAngularVelocityToROS(Z_Param_AngVelUnreal);
	P_NATIVE_END;
}
// ********** End Class UAGX_ROS2Utilities Function ConvertAngularVelocityToROS ********************

// ********** Begin Class UAGX_ROS2Utilities Function ConvertAngularVelocityToUnreal ***************
struct Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertAngularVelocityToUnreal_Statics
{
	struct AGX_ROS2Utilities_eventConvertAngularVelocityToUnreal_Parms
	{
		FVector AngVelROS;
		FVector ReturnValue;
	};
#if WITH_METADATA
	static constexpr UECodeGen_Private::FMetaDataPairParam Function_MetaDataParams[] = {
		{ "Category", "AGX ROS2" },
		{ "Comment", "/**\n     * Converts an angular velocity from ROS2's unit system [rad/s] to Unreal's unit system [deg/s].\n     * ROS2 uses right-handed coordinate systems, while Unreal uses left-handed coordinate systems.\n     *\n     * AngVelROS - The angular velocity in ROS2's unit system (right-handed) [rad/s].\n     * Returns the converted angular velocity in Unreal's unit system (left-handed) [deg/s].\n     */" },
		{ "ModuleRelativePath", "Public/Utilities/AGX_ROS2Utilities.h" },
		{ "ToolTip", "Converts an angular velocity from ROS2's unit system [rad/s] to Unreal's unit system [deg/s].\nROS2 uses right-handed coordinate systems, while Unreal uses left-handed coordinate systems.\n\nAngVelROS - The angular velocity in ROS2's unit system (right-handed) [rad/s].\nReturns the converted angular velocity in Unreal's unit system (left-handed) [deg/s]." },
	};
#endif // WITH_METADATA
	static const UECodeGen_Private::FStructPropertyParams NewProp_AngVelROS;
	static const UECodeGen_Private::FStructPropertyParams NewProp_ReturnValue;
	static const UECodeGen_Private::FPropertyParamsBase* const PropPointers[];
	static const UECodeGen_Private::FFunctionParams FuncParams;
};
const UECodeGen_Private::FStructPropertyParams Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertAngularVelocityToUnreal_Statics::NewProp_AngVelROS = { "AngVelROS", nullptr, (EPropertyFlags)0x0010000000000080, UECodeGen_Private::EPropertyGenFlags::Struct, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, STRUCT_OFFSET(AGX_ROS2Utilities_eventConvertAngularVelocityToUnreal_Parms, AngVelROS), Z_Construct_UScriptStruct_FVector, METADATA_PARAMS(0, nullptr) };
const UECodeGen_Private::FStructPropertyParams Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertAngularVelocityToUnreal_Statics::NewProp_ReturnValue = { "ReturnValue", nullptr, (EPropertyFlags)0x0010000000000580, UECodeGen_Private::EPropertyGenFlags::Struct, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, STRUCT_OFFSET(AGX_ROS2Utilities_eventConvertAngularVelocityToUnreal_Parms, ReturnValue), Z_Construct_UScriptStruct_FVector, METADATA_PARAMS(0, nullptr) };
const UECodeGen_Private::FPropertyParamsBase* const Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertAngularVelocityToUnreal_Statics::PropPointers[] = {
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertAngularVelocityToUnreal_Statics::NewProp_AngVelROS,
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertAngularVelocityToUnreal_Statics::NewProp_ReturnValue,
};
static_assert(UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertAngularVelocityToUnreal_Statics::PropPointers) < 2048);
const UECodeGen_Private::FFunctionParams Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertAngularVelocityToUnreal_Statics::FuncParams = { { (UObject*(*)())Z_Construct_UClass_UAGX_ROS2Utilities, nullptr, "ConvertAngularVelocityToUnreal", Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertAngularVelocityToUnreal_Statics::PropPointers, UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertAngularVelocityToUnreal_Statics::PropPointers), sizeof(Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertAngularVelocityToUnreal_Statics::AGX_ROS2Utilities_eventConvertAngularVelocityToUnreal_Parms), RF_Public|RF_Transient|RF_MarkAsNative, (EFunctionFlags)0x04822401, 0, 0, METADATA_PARAMS(UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertAngularVelocityToUnreal_Statics::Function_MetaDataParams), Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertAngularVelocityToUnreal_Statics::Function_MetaDataParams)},  };
static_assert(sizeof(Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertAngularVelocityToUnreal_Statics::AGX_ROS2Utilities_eventConvertAngularVelocityToUnreal_Parms) < MAX_uint16);
UFunction* Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertAngularVelocityToUnreal()
{
	static UFunction* ReturnFunction = nullptr;
	if (!ReturnFunction)
	{
		UECodeGen_Private::ConstructUFunction(&ReturnFunction, Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertAngularVelocityToUnreal_Statics::FuncParams);
	}
	return ReturnFunction;
}
DEFINE_FUNCTION(UAGX_ROS2Utilities::execConvertAngularVelocityToUnreal)
{
	P_GET_STRUCT(FVector,Z_Param_AngVelROS);
	P_FINISH;
	P_NATIVE_BEGIN;
	*(FVector*)Z_Param__Result=UAGX_ROS2Utilities::ConvertAngularVelocityToUnreal(Z_Param_AngVelROS);
	P_NATIVE_END;
}
// ********** End Class UAGX_ROS2Utilities Function ConvertAngularVelocityToUnreal *****************

// ********** Begin Class UAGX_ROS2Utilities Function ConvertDistanceToROS *************************
struct Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertDistanceToROS_Statics
{
	struct AGX_ROS2Utilities_eventConvertDistanceToROS_Parms
	{
		double DistanceUnreal;
		double ReturnValue;
	};
#if WITH_METADATA
	static constexpr UECodeGen_Private::FMetaDataPairParam Function_MetaDataParams[] = {
		{ "Category", "AGX ROS2" },
		{ "Comment", "/**\n     * Converts a distance from Unreal's unit system [cm] to ROS2's unit system [m].\n     *\n     * DistanceUnreal - The distance in Unreal's unit system [cm].\n     * Returns the converted distance in ROS2's unit system [m].\n     */" },
		{ "ModuleRelativePath", "Public/Utilities/AGX_ROS2Utilities.h" },
		{ "ToolTip", "Converts a distance from Unreal's unit system [cm] to ROS2's unit system [m].\n\nDistanceUnreal - The distance in Unreal's unit system [cm].\nReturns the converted distance in ROS2's unit system [m]." },
	};
#endif // WITH_METADATA
	static const UECodeGen_Private::FDoublePropertyParams NewProp_DistanceUnreal;
	static const UECodeGen_Private::FDoublePropertyParams NewProp_ReturnValue;
	static const UECodeGen_Private::FPropertyParamsBase* const PropPointers[];
	static const UECodeGen_Private::FFunctionParams FuncParams;
};
const UECodeGen_Private::FDoublePropertyParams Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertDistanceToROS_Statics::NewProp_DistanceUnreal = { "DistanceUnreal", nullptr, (EPropertyFlags)0x0010000000000080, UECodeGen_Private::EPropertyGenFlags::Double, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, STRUCT_OFFSET(AGX_ROS2Utilities_eventConvertDistanceToROS_Parms, DistanceUnreal), METADATA_PARAMS(0, nullptr) };
const UECodeGen_Private::FDoublePropertyParams Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertDistanceToROS_Statics::NewProp_ReturnValue = { "ReturnValue", nullptr, (EPropertyFlags)0x0010000000000580, UECodeGen_Private::EPropertyGenFlags::Double, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, STRUCT_OFFSET(AGX_ROS2Utilities_eventConvertDistanceToROS_Parms, ReturnValue), METADATA_PARAMS(0, nullptr) };
const UECodeGen_Private::FPropertyParamsBase* const Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertDistanceToROS_Statics::PropPointers[] = {
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertDistanceToROS_Statics::NewProp_DistanceUnreal,
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertDistanceToROS_Statics::NewProp_ReturnValue,
};
static_assert(UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertDistanceToROS_Statics::PropPointers) < 2048);
const UECodeGen_Private::FFunctionParams Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertDistanceToROS_Statics::FuncParams = { { (UObject*(*)())Z_Construct_UClass_UAGX_ROS2Utilities, nullptr, "ConvertDistanceToROS", Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertDistanceToROS_Statics::PropPointers, UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertDistanceToROS_Statics::PropPointers), sizeof(Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertDistanceToROS_Statics::AGX_ROS2Utilities_eventConvertDistanceToROS_Parms), RF_Public|RF_Transient|RF_MarkAsNative, (EFunctionFlags)0x04022401, 0, 0, METADATA_PARAMS(UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertDistanceToROS_Statics::Function_MetaDataParams), Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertDistanceToROS_Statics::Function_MetaDataParams)},  };
static_assert(sizeof(Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertDistanceToROS_Statics::AGX_ROS2Utilities_eventConvertDistanceToROS_Parms) < MAX_uint16);
UFunction* Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertDistanceToROS()
{
	static UFunction* ReturnFunction = nullptr;
	if (!ReturnFunction)
	{
		UECodeGen_Private::ConstructUFunction(&ReturnFunction, Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertDistanceToROS_Statics::FuncParams);
	}
	return ReturnFunction;
}
DEFINE_FUNCTION(UAGX_ROS2Utilities::execConvertDistanceToROS)
{
	P_GET_PROPERTY(FDoubleProperty,Z_Param_DistanceUnreal);
	P_FINISH;
	P_NATIVE_BEGIN;
	*(double*)Z_Param__Result=UAGX_ROS2Utilities::ConvertDistanceToROS(Z_Param_DistanceUnreal);
	P_NATIVE_END;
}
// ********** End Class UAGX_ROS2Utilities Function ConvertDistanceToROS ***************************

// ********** Begin Class UAGX_ROS2Utilities Function ConvertDistanceToUnreal **********************
struct Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertDistanceToUnreal_Statics
{
	struct AGX_ROS2Utilities_eventConvertDistanceToUnreal_Parms
	{
		double DistanceROS;
		double ReturnValue;
	};
#if WITH_METADATA
	static constexpr UECodeGen_Private::FMetaDataPairParam Function_MetaDataParams[] = {
		{ "Category", "AGX ROS2" },
		{ "Comment", "/**\n     * Converts a distance from ROS2's unit system [m] to Unreal's unit system [cm].\n     *\n     * DistanceROS - The distance in ROS2's unit system [m].\n     * Returns the converted distance in Unreal's unit system [cm].\n     */" },
		{ "ModuleRelativePath", "Public/Utilities/AGX_ROS2Utilities.h" },
		{ "ToolTip", "Converts a distance from ROS2's unit system [m] to Unreal's unit system [cm].\n\nDistanceROS - The distance in ROS2's unit system [m].\nReturns the converted distance in Unreal's unit system [cm]." },
	};
#endif // WITH_METADATA
	static const UECodeGen_Private::FDoublePropertyParams NewProp_DistanceROS;
	static const UECodeGen_Private::FDoublePropertyParams NewProp_ReturnValue;
	static const UECodeGen_Private::FPropertyParamsBase* const PropPointers[];
	static const UECodeGen_Private::FFunctionParams FuncParams;
};
const UECodeGen_Private::FDoublePropertyParams Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertDistanceToUnreal_Statics::NewProp_DistanceROS = { "DistanceROS", nullptr, (EPropertyFlags)0x0010000000000080, UECodeGen_Private::EPropertyGenFlags::Double, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, STRUCT_OFFSET(AGX_ROS2Utilities_eventConvertDistanceToUnreal_Parms, DistanceROS), METADATA_PARAMS(0, nullptr) };
const UECodeGen_Private::FDoublePropertyParams Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertDistanceToUnreal_Statics::NewProp_ReturnValue = { "ReturnValue", nullptr, (EPropertyFlags)0x0010000000000580, UECodeGen_Private::EPropertyGenFlags::Double, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, STRUCT_OFFSET(AGX_ROS2Utilities_eventConvertDistanceToUnreal_Parms, ReturnValue), METADATA_PARAMS(0, nullptr) };
const UECodeGen_Private::FPropertyParamsBase* const Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertDistanceToUnreal_Statics::PropPointers[] = {
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertDistanceToUnreal_Statics::NewProp_DistanceROS,
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertDistanceToUnreal_Statics::NewProp_ReturnValue,
};
static_assert(UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertDistanceToUnreal_Statics::PropPointers) < 2048);
const UECodeGen_Private::FFunctionParams Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertDistanceToUnreal_Statics::FuncParams = { { (UObject*(*)())Z_Construct_UClass_UAGX_ROS2Utilities, nullptr, "ConvertDistanceToUnreal", Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertDistanceToUnreal_Statics::PropPointers, UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertDistanceToUnreal_Statics::PropPointers), sizeof(Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertDistanceToUnreal_Statics::AGX_ROS2Utilities_eventConvertDistanceToUnreal_Parms), RF_Public|RF_Transient|RF_MarkAsNative, (EFunctionFlags)0x04022401, 0, 0, METADATA_PARAMS(UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertDistanceToUnreal_Statics::Function_MetaDataParams), Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertDistanceToUnreal_Statics::Function_MetaDataParams)},  };
static_assert(sizeof(Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertDistanceToUnreal_Statics::AGX_ROS2Utilities_eventConvertDistanceToUnreal_Parms) < MAX_uint16);
UFunction* Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertDistanceToUnreal()
{
	static UFunction* ReturnFunction = nullptr;
	if (!ReturnFunction)
	{
		UECodeGen_Private::ConstructUFunction(&ReturnFunction, Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertDistanceToUnreal_Statics::FuncParams);
	}
	return ReturnFunction;
}
DEFINE_FUNCTION(UAGX_ROS2Utilities::execConvertDistanceToUnreal)
{
	P_GET_PROPERTY(FDoubleProperty,Z_Param_DistanceROS);
	P_FINISH;
	P_NATIVE_BEGIN;
	*(double*)Z_Param__Result=UAGX_ROS2Utilities::ConvertDistanceToUnreal(Z_Param_DistanceROS);
	P_NATIVE_END;
}
// ********** End Class UAGX_ROS2Utilities Function ConvertDistanceToUnreal ************************

// ********** Begin Class UAGX_ROS2Utilities Function ConvertPositionData **************************
struct Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertPositionData_Statics
{
	struct AGX_ROS2Utilities_eventConvertPositionData_Parms
	{
		TArray<FAGX_LidarOutputPositionData> Data;
		double TimeStamp;
		FString FrameId;
		FAGX_SensorMsgsPointCloud2 ReturnValue;
	};
#if WITH_METADATA
	static constexpr UECodeGen_Private::FMetaDataPairParam Function_MetaDataParams[] = {
		{ "Category", "AGX ROS2" },
		{ "Comment", "/**\n\x09 * Takes an array of Lidar Output Position Data and converts it into a ROS2\n\x09 * sensor_msgs::PointCloud2 message. The Data member of the ROS2 message consists of position x,\n\x09 * y, z [m] for each point written as float's (32 bit) in little endian layout,\n\x09 * i.e. 12 bytes per point.\n\x09 *\n\x09 * It is assumed that the given Output Data is dense, i.e. that no point misses are included.\n\x09 * \n\x09 * The points written will be in ROS2 coordinates, i.e. right-handed and z up.\n\x09 *\n\x09 * The timestamp written to the Header member of the sensor_msgs::PointCloud2 message is set\n\x09 * according to the given timestamp.\n\x09 *\n\x09 * (Optional) the FrameId parameter corresponds to the frame_id of the std_msgs::Header message.\n\x09 * If not set, it will be an empty string.\n\x09 */" },
		{ "CPP_Default_FrameId", "" },
		{ "ModuleRelativePath", "Public/Utilities/AGX_ROS2Utilities.h" },
		{ "ToolTip", "Takes an array of Lidar Output Position Data and converts it into a ROS2\nsensor_msgs::PointCloud2 message. The Data member of the ROS2 message consists of position x,\ny, z [m] for each point written as float's (32 bit) in little endian layout,\ni.e. 12 bytes per point.\n\nIt is assumed that the given Output Data is dense, i.e. that no point misses are included.\n\nThe points written will be in ROS2 coordinates, i.e. right-handed and z up.\n\nThe timestamp written to the Header member of the sensor_msgs::PointCloud2 message is set\naccording to the given timestamp.\n\n(Optional) the FrameId parameter corresponds to the frame_id of the std_msgs::Header message.\nIf not set, it will be an empty string." },
	};
	static constexpr UECodeGen_Private::FMetaDataPairParam NewProp_Data_MetaData[] = {
		{ "NativeConst", "" },
	};
	static constexpr UECodeGen_Private::FMetaDataPairParam NewProp_FrameId_MetaData[] = {
		{ "NativeConst", "" },
	};
#endif // WITH_METADATA
	static const UECodeGen_Private::FStructPropertyParams NewProp_Data_Inner;
	static const UECodeGen_Private::FArrayPropertyParams NewProp_Data;
	static const UECodeGen_Private::FDoublePropertyParams NewProp_TimeStamp;
	static const UECodeGen_Private::FStrPropertyParams NewProp_FrameId;
	static const UECodeGen_Private::FStructPropertyParams NewProp_ReturnValue;
	static const UECodeGen_Private::FPropertyParamsBase* const PropPointers[];
	static const UECodeGen_Private::FFunctionParams FuncParams;
};
const UECodeGen_Private::FStructPropertyParams Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertPositionData_Statics::NewProp_Data_Inner = { "Data", nullptr, (EPropertyFlags)0x0000000000000000, UECodeGen_Private::EPropertyGenFlags::Struct, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, 0, Z_Construct_UScriptStruct_FAGX_LidarOutputPositionData, METADATA_PARAMS(0, nullptr) }; // 805591603
const UECodeGen_Private::FArrayPropertyParams Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertPositionData_Statics::NewProp_Data = { "Data", nullptr, (EPropertyFlags)0x0010000008000182, UECodeGen_Private::EPropertyGenFlags::Array, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, STRUCT_OFFSET(AGX_ROS2Utilities_eventConvertPositionData_Parms, Data), EArrayPropertyFlags::None, METADATA_PARAMS(UE_ARRAY_COUNT(NewProp_Data_MetaData), NewProp_Data_MetaData) }; // 805591603
const UECodeGen_Private::FDoublePropertyParams Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertPositionData_Statics::NewProp_TimeStamp = { "TimeStamp", nullptr, (EPropertyFlags)0x0010000000000080, UECodeGen_Private::EPropertyGenFlags::Double, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, STRUCT_OFFSET(AGX_ROS2Utilities_eventConvertPositionData_Parms, TimeStamp), METADATA_PARAMS(0, nullptr) };
const UECodeGen_Private::FStrPropertyParams Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertPositionData_Statics::NewProp_FrameId = { "FrameId", nullptr, (EPropertyFlags)0x0010000000000080, UECodeGen_Private::EPropertyGenFlags::Str, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, STRUCT_OFFSET(AGX_ROS2Utilities_eventConvertPositionData_Parms, FrameId), METADATA_PARAMS(UE_ARRAY_COUNT(NewProp_FrameId_MetaData), NewProp_FrameId_MetaData) };
const UECodeGen_Private::FStructPropertyParams Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertPositionData_Statics::NewProp_ReturnValue = { "ReturnValue", nullptr, (EPropertyFlags)0x0010000000000580, UECodeGen_Private::EPropertyGenFlags::Struct, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, STRUCT_OFFSET(AGX_ROS2Utilities_eventConvertPositionData_Parms, ReturnValue), Z_Construct_UScriptStruct_FAGX_SensorMsgsPointCloud2, METADATA_PARAMS(0, nullptr) }; // 2387818651
const UECodeGen_Private::FPropertyParamsBase* const Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertPositionData_Statics::PropPointers[] = {
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertPositionData_Statics::NewProp_Data_Inner,
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertPositionData_Statics::NewProp_Data,
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertPositionData_Statics::NewProp_TimeStamp,
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertPositionData_Statics::NewProp_FrameId,
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertPositionData_Statics::NewProp_ReturnValue,
};
static_assert(UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertPositionData_Statics::PropPointers) < 2048);
const UECodeGen_Private::FFunctionParams Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertPositionData_Statics::FuncParams = { { (UObject*(*)())Z_Construct_UClass_UAGX_ROS2Utilities, nullptr, "ConvertPositionData", Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertPositionData_Statics::PropPointers, UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertPositionData_Statics::PropPointers), sizeof(Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertPositionData_Statics::AGX_ROS2Utilities_eventConvertPositionData_Parms), RF_Public|RF_Transient|RF_MarkAsNative, (EFunctionFlags)0x04422401, 0, 0, METADATA_PARAMS(UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertPositionData_Statics::Function_MetaDataParams), Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertPositionData_Statics::Function_MetaDataParams)},  };
static_assert(sizeof(Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertPositionData_Statics::AGX_ROS2Utilities_eventConvertPositionData_Parms) < MAX_uint16);
UFunction* Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertPositionData()
{
	static UFunction* ReturnFunction = nullptr;
	if (!ReturnFunction)
	{
		UECodeGen_Private::ConstructUFunction(&ReturnFunction, Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertPositionData_Statics::FuncParams);
	}
	return ReturnFunction;
}
DEFINE_FUNCTION(UAGX_ROS2Utilities::execConvertPositionData)
{
	P_GET_TARRAY_REF(FAGX_LidarOutputPositionData,Z_Param_Out_Data);
	P_GET_PROPERTY(FDoubleProperty,Z_Param_TimeStamp);
	P_GET_PROPERTY(FStrProperty,Z_Param_FrameId);
	P_FINISH;
	P_NATIVE_BEGIN;
	*(FAGX_SensorMsgsPointCloud2*)Z_Param__Result=UAGX_ROS2Utilities::ConvertPositionData(Z_Param_Out_Data,Z_Param_TimeStamp,Z_Param_FrameId);
	P_NATIVE_END;
}
// ********** End Class UAGX_ROS2Utilities Function ConvertPositionData ****************************

// ********** Begin Class UAGX_ROS2Utilities Function ConvertPositionIntensityData *****************
struct Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertPositionIntensityData_Statics
{
	struct AGX_ROS2Utilities_eventConvertPositionIntensityData_Parms
	{
		TArray<FAGX_LidarOutputPositionIntensityData> Data;
		double TimeStamp;
		FString FrameId;
		FAGX_SensorMsgsPointCloud2 ReturnValue;
	};
#if WITH_METADATA
	static constexpr UECodeGen_Private::FMetaDataPairParam Function_MetaDataParams[] = {
		{ "Category", "AGX ROS2" },
		{ "Comment", "/**\n\x09 * Takes an array of Lidar Output Position Intensity Data and converts it into a ROS2\n\x09 * sensor_msgs::PointCloud2 message. The Data member of the ROS2 message consists of position x,\n\x09 * y, z [m] and Intensity for each point written as float's (32 bit) in little endian layout,\n\x09 * i.e. 16 bytes per point.\n\x09 *\n\x09 * It is assumed that the given Output Data is dense, i.e. that no point misses are included.\n\x09 *\n\x09 * The points written will be in ROS2 coordinates, i.e. right-handed and z up.\n\x09 *\n\x09 * The timestamp written to the Header member of the sensor_msgs::PointCloud2 message is set\n\x09 * according to the given timestamp.\n\x09 *\n\x09 * (Optional) the FrameId parameter corresponds to the frame_id of the std_msgs::Header message.\n\x09 * If not set, it will be an empty string.\n\x09 */" },
		{ "CPP_Default_FrameId", "" },
		{ "ModuleRelativePath", "Public/Utilities/AGX_ROS2Utilities.h" },
		{ "ToolTip", "Takes an array of Lidar Output Position Intensity Data and converts it into a ROS2\nsensor_msgs::PointCloud2 message. The Data member of the ROS2 message consists of position x,\ny, z [m] and Intensity for each point written as float's (32 bit) in little endian layout,\ni.e. 16 bytes per point.\n\nIt is assumed that the given Output Data is dense, i.e. that no point misses are included.\n\nThe points written will be in ROS2 coordinates, i.e. right-handed and z up.\n\nThe timestamp written to the Header member of the sensor_msgs::PointCloud2 message is set\naccording to the given timestamp.\n\n(Optional) the FrameId parameter corresponds to the frame_id of the std_msgs::Header message.\nIf not set, it will be an empty string." },
	};
	static constexpr UECodeGen_Private::FMetaDataPairParam NewProp_Data_MetaData[] = {
		{ "NativeConst", "" },
	};
	static constexpr UECodeGen_Private::FMetaDataPairParam NewProp_FrameId_MetaData[] = {
		{ "NativeConst", "" },
	};
#endif // WITH_METADATA
	static const UECodeGen_Private::FStructPropertyParams NewProp_Data_Inner;
	static const UECodeGen_Private::FArrayPropertyParams NewProp_Data;
	static const UECodeGen_Private::FDoublePropertyParams NewProp_TimeStamp;
	static const UECodeGen_Private::FStrPropertyParams NewProp_FrameId;
	static const UECodeGen_Private::FStructPropertyParams NewProp_ReturnValue;
	static const UECodeGen_Private::FPropertyParamsBase* const PropPointers[];
	static const UECodeGen_Private::FFunctionParams FuncParams;
};
const UECodeGen_Private::FStructPropertyParams Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertPositionIntensityData_Statics::NewProp_Data_Inner = { "Data", nullptr, (EPropertyFlags)0x0000000000000000, UECodeGen_Private::EPropertyGenFlags::Struct, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, 0, Z_Construct_UScriptStruct_FAGX_LidarOutputPositionIntensityData, METADATA_PARAMS(0, nullptr) }; // 2615338657
const UECodeGen_Private::FArrayPropertyParams Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertPositionIntensityData_Statics::NewProp_Data = { "Data", nullptr, (EPropertyFlags)0x0010000008000182, UECodeGen_Private::EPropertyGenFlags::Array, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, STRUCT_OFFSET(AGX_ROS2Utilities_eventConvertPositionIntensityData_Parms, Data), EArrayPropertyFlags::None, METADATA_PARAMS(UE_ARRAY_COUNT(NewProp_Data_MetaData), NewProp_Data_MetaData) }; // 2615338657
const UECodeGen_Private::FDoublePropertyParams Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertPositionIntensityData_Statics::NewProp_TimeStamp = { "TimeStamp", nullptr, (EPropertyFlags)0x0010000000000080, UECodeGen_Private::EPropertyGenFlags::Double, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, STRUCT_OFFSET(AGX_ROS2Utilities_eventConvertPositionIntensityData_Parms, TimeStamp), METADATA_PARAMS(0, nullptr) };
const UECodeGen_Private::FStrPropertyParams Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertPositionIntensityData_Statics::NewProp_FrameId = { "FrameId", nullptr, (EPropertyFlags)0x0010000000000080, UECodeGen_Private::EPropertyGenFlags::Str, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, STRUCT_OFFSET(AGX_ROS2Utilities_eventConvertPositionIntensityData_Parms, FrameId), METADATA_PARAMS(UE_ARRAY_COUNT(NewProp_FrameId_MetaData), NewProp_FrameId_MetaData) };
const UECodeGen_Private::FStructPropertyParams Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertPositionIntensityData_Statics::NewProp_ReturnValue = { "ReturnValue", nullptr, (EPropertyFlags)0x0010000000000580, UECodeGen_Private::EPropertyGenFlags::Struct, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, STRUCT_OFFSET(AGX_ROS2Utilities_eventConvertPositionIntensityData_Parms, ReturnValue), Z_Construct_UScriptStruct_FAGX_SensorMsgsPointCloud2, METADATA_PARAMS(0, nullptr) }; // 2387818651
const UECodeGen_Private::FPropertyParamsBase* const Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertPositionIntensityData_Statics::PropPointers[] = {
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertPositionIntensityData_Statics::NewProp_Data_Inner,
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertPositionIntensityData_Statics::NewProp_Data,
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertPositionIntensityData_Statics::NewProp_TimeStamp,
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertPositionIntensityData_Statics::NewProp_FrameId,
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertPositionIntensityData_Statics::NewProp_ReturnValue,
};
static_assert(UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertPositionIntensityData_Statics::PropPointers) < 2048);
const UECodeGen_Private::FFunctionParams Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertPositionIntensityData_Statics::FuncParams = { { (UObject*(*)())Z_Construct_UClass_UAGX_ROS2Utilities, nullptr, "ConvertPositionIntensityData", Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertPositionIntensityData_Statics::PropPointers, UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertPositionIntensityData_Statics::PropPointers), sizeof(Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertPositionIntensityData_Statics::AGX_ROS2Utilities_eventConvertPositionIntensityData_Parms), RF_Public|RF_Transient|RF_MarkAsNative, (EFunctionFlags)0x04422401, 0, 0, METADATA_PARAMS(UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertPositionIntensityData_Statics::Function_MetaDataParams), Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertPositionIntensityData_Statics::Function_MetaDataParams)},  };
static_assert(sizeof(Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertPositionIntensityData_Statics::AGX_ROS2Utilities_eventConvertPositionIntensityData_Parms) < MAX_uint16);
UFunction* Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertPositionIntensityData()
{
	static UFunction* ReturnFunction = nullptr;
	if (!ReturnFunction)
	{
		UECodeGen_Private::ConstructUFunction(&ReturnFunction, Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertPositionIntensityData_Statics::FuncParams);
	}
	return ReturnFunction;
}
DEFINE_FUNCTION(UAGX_ROS2Utilities::execConvertPositionIntensityData)
{
	P_GET_TARRAY_REF(FAGX_LidarOutputPositionIntensityData,Z_Param_Out_Data);
	P_GET_PROPERTY(FDoubleProperty,Z_Param_TimeStamp);
	P_GET_PROPERTY(FStrProperty,Z_Param_FrameId);
	P_FINISH;
	P_NATIVE_BEGIN;
	*(FAGX_SensorMsgsPointCloud2*)Z_Param__Result=UAGX_ROS2Utilities::ConvertPositionIntensityData(Z_Param_Out_Data,Z_Param_TimeStamp,Z_Param_FrameId);
	P_NATIVE_END;
}
// ********** End Class UAGX_ROS2Utilities Function ConvertPositionIntensityData *******************

// ********** Begin Class UAGX_ROS2Utilities Function ConvertPositionToROS *************************
struct Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertPositionToROS_Statics
{
	struct AGX_ROS2Utilities_eventConvertPositionToROS_Parms
	{
		FVector PosUnreal;
		FVector ReturnValue;
	};
#if WITH_METADATA
	static constexpr UECodeGen_Private::FMetaDataPairParam Function_MetaDataParams[] = {
		{ "Category", "AGX ROS2" },
		{ "Comment", "/**\n     * Converts a position from Unreal's coordinate system [cm] to ROS2's coordinate system [m].\n     * Unreal uses left-handed coordinate systems, while ROS2 uses right-handed coordinate systems.\n     *\n     * PosUnreal - The position in Unreal's coordinate system (left-handed) [cm].\n     * Returns the converted position in ROS2's coordinate system (right-handed) [m].\n     */" },
		{ "ModuleRelativePath", "Public/Utilities/AGX_ROS2Utilities.h" },
		{ "ToolTip", "Converts a position from Unreal's coordinate system [cm] to ROS2's coordinate system [m].\nUnreal uses left-handed coordinate systems, while ROS2 uses right-handed coordinate systems.\n\nPosUnreal - The position in Unreal's coordinate system (left-handed) [cm].\nReturns the converted position in ROS2's coordinate system (right-handed) [m]." },
	};
#endif // WITH_METADATA
	static const UECodeGen_Private::FStructPropertyParams NewProp_PosUnreal;
	static const UECodeGen_Private::FStructPropertyParams NewProp_ReturnValue;
	static const UECodeGen_Private::FPropertyParamsBase* const PropPointers[];
	static const UECodeGen_Private::FFunctionParams FuncParams;
};
const UECodeGen_Private::FStructPropertyParams Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertPositionToROS_Statics::NewProp_PosUnreal = { "PosUnreal", nullptr, (EPropertyFlags)0x0010000000000080, UECodeGen_Private::EPropertyGenFlags::Struct, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, STRUCT_OFFSET(AGX_ROS2Utilities_eventConvertPositionToROS_Parms, PosUnreal), Z_Construct_UScriptStruct_FVector, METADATA_PARAMS(0, nullptr) };
const UECodeGen_Private::FStructPropertyParams Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertPositionToROS_Statics::NewProp_ReturnValue = { "ReturnValue", nullptr, (EPropertyFlags)0x0010000000000580, UECodeGen_Private::EPropertyGenFlags::Struct, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, STRUCT_OFFSET(AGX_ROS2Utilities_eventConvertPositionToROS_Parms, ReturnValue), Z_Construct_UScriptStruct_FVector, METADATA_PARAMS(0, nullptr) };
const UECodeGen_Private::FPropertyParamsBase* const Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertPositionToROS_Statics::PropPointers[] = {
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertPositionToROS_Statics::NewProp_PosUnreal,
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertPositionToROS_Statics::NewProp_ReturnValue,
};
static_assert(UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertPositionToROS_Statics::PropPointers) < 2048);
const UECodeGen_Private::FFunctionParams Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertPositionToROS_Statics::FuncParams = { { (UObject*(*)())Z_Construct_UClass_UAGX_ROS2Utilities, nullptr, "ConvertPositionToROS", Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertPositionToROS_Statics::PropPointers, UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertPositionToROS_Statics::PropPointers), sizeof(Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertPositionToROS_Statics::AGX_ROS2Utilities_eventConvertPositionToROS_Parms), RF_Public|RF_Transient|RF_MarkAsNative, (EFunctionFlags)0x04822401, 0, 0, METADATA_PARAMS(UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertPositionToROS_Statics::Function_MetaDataParams), Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertPositionToROS_Statics::Function_MetaDataParams)},  };
static_assert(sizeof(Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertPositionToROS_Statics::AGX_ROS2Utilities_eventConvertPositionToROS_Parms) < MAX_uint16);
UFunction* Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertPositionToROS()
{
	static UFunction* ReturnFunction = nullptr;
	if (!ReturnFunction)
	{
		UECodeGen_Private::ConstructUFunction(&ReturnFunction, Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertPositionToROS_Statics::FuncParams);
	}
	return ReturnFunction;
}
DEFINE_FUNCTION(UAGX_ROS2Utilities::execConvertPositionToROS)
{
	P_GET_STRUCT(FVector,Z_Param_PosUnreal);
	P_FINISH;
	P_NATIVE_BEGIN;
	*(FVector*)Z_Param__Result=UAGX_ROS2Utilities::ConvertPositionToROS(Z_Param_PosUnreal);
	P_NATIVE_END;
}
// ********** End Class UAGX_ROS2Utilities Function ConvertPositionToROS ***************************

// ********** Begin Class UAGX_ROS2Utilities Function ConvertPositionToUnreal **********************
struct Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertPositionToUnreal_Statics
{
	struct AGX_ROS2Utilities_eventConvertPositionToUnreal_Parms
	{
		FVector PosROS;
		FVector ReturnValue;
	};
#if WITH_METADATA
	static constexpr UECodeGen_Private::FMetaDataPairParam Function_MetaDataParams[] = {
		{ "Category", "AGX ROS2" },
		{ "Comment", "/**\n     * Converts a position from ROS2's coordinate system [m] to Unreal's coordinate system [cm].\n     * ROS2 uses right-handed coordinate systems, while Unreal uses left-handed coordinate systems.\n     *\n     * PosROS - The position in ROS2's coordinate system (right-handed) [m].\n     * Returns the converted position in Unreal's coordinate system (left-handed) [cm].\n     */" },
		{ "ModuleRelativePath", "Public/Utilities/AGX_ROS2Utilities.h" },
		{ "ToolTip", "Converts a position from ROS2's coordinate system [m] to Unreal's coordinate system [cm].\nROS2 uses right-handed coordinate systems, while Unreal uses left-handed coordinate systems.\n\nPosROS - The position in ROS2's coordinate system (right-handed) [m].\nReturns the converted position in Unreal's coordinate system (left-handed) [cm]." },
	};
#endif // WITH_METADATA
	static const UECodeGen_Private::FStructPropertyParams NewProp_PosROS;
	static const UECodeGen_Private::FStructPropertyParams NewProp_ReturnValue;
	static const UECodeGen_Private::FPropertyParamsBase* const PropPointers[];
	static const UECodeGen_Private::FFunctionParams FuncParams;
};
const UECodeGen_Private::FStructPropertyParams Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertPositionToUnreal_Statics::NewProp_PosROS = { "PosROS", nullptr, (EPropertyFlags)0x0010000000000080, UECodeGen_Private::EPropertyGenFlags::Struct, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, STRUCT_OFFSET(AGX_ROS2Utilities_eventConvertPositionToUnreal_Parms, PosROS), Z_Construct_UScriptStruct_FVector, METADATA_PARAMS(0, nullptr) };
const UECodeGen_Private::FStructPropertyParams Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertPositionToUnreal_Statics::NewProp_ReturnValue = { "ReturnValue", nullptr, (EPropertyFlags)0x0010000000000580, UECodeGen_Private::EPropertyGenFlags::Struct, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, STRUCT_OFFSET(AGX_ROS2Utilities_eventConvertPositionToUnreal_Parms, ReturnValue), Z_Construct_UScriptStruct_FVector, METADATA_PARAMS(0, nullptr) };
const UECodeGen_Private::FPropertyParamsBase* const Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertPositionToUnreal_Statics::PropPointers[] = {
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertPositionToUnreal_Statics::NewProp_PosROS,
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertPositionToUnreal_Statics::NewProp_ReturnValue,
};
static_assert(UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertPositionToUnreal_Statics::PropPointers) < 2048);
const UECodeGen_Private::FFunctionParams Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertPositionToUnreal_Statics::FuncParams = { { (UObject*(*)())Z_Construct_UClass_UAGX_ROS2Utilities, nullptr, "ConvertPositionToUnreal", Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertPositionToUnreal_Statics::PropPointers, UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertPositionToUnreal_Statics::PropPointers), sizeof(Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertPositionToUnreal_Statics::AGX_ROS2Utilities_eventConvertPositionToUnreal_Parms), RF_Public|RF_Transient|RF_MarkAsNative, (EFunctionFlags)0x04822401, 0, 0, METADATA_PARAMS(UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertPositionToUnreal_Statics::Function_MetaDataParams), Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertPositionToUnreal_Statics::Function_MetaDataParams)},  };
static_assert(sizeof(Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertPositionToUnreal_Statics::AGX_ROS2Utilities_eventConvertPositionToUnreal_Parms) < MAX_uint16);
UFunction* Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertPositionToUnreal()
{
	static UFunction* ReturnFunction = nullptr;
	if (!ReturnFunction)
	{
		UECodeGen_Private::ConstructUFunction(&ReturnFunction, Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertPositionToUnreal_Statics::FuncParams);
	}
	return ReturnFunction;
}
DEFINE_FUNCTION(UAGX_ROS2Utilities::execConvertPositionToUnreal)
{
	P_GET_STRUCT(FVector,Z_Param_PosROS);
	P_FINISH;
	P_NATIVE_BEGIN;
	*(FVector*)Z_Param__Result=UAGX_ROS2Utilities::ConvertPositionToUnreal(Z_Param_PosROS);
	P_NATIVE_END;
}
// ********** End Class UAGX_ROS2Utilities Function ConvertPositionToUnreal ************************

// ********** Begin Class UAGX_ROS2Utilities Function ConvertRotationToROS *************************
struct Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertRotationToROS_Statics
{
	struct AGX_ROS2Utilities_eventConvertRotationToROS_Parms
	{
		FQuat RotUnreal;
		FQuat ReturnValue;
	};
#if WITH_METADATA
	static constexpr UECodeGen_Private::FMetaDataPairParam Function_MetaDataParams[] = {
		{ "Category", "AGX ROS2" },
		{ "Comment", "/**\n     * Converts a rotation from Unreal's coordinate system [deg] to ROS2's coordinate system [rad].\n     * ROS2 uses right-handed coordinate systems, while Unreal uses left-handed coordinate systems.\n     *\n     * RotUnreal - The rotation in Unreal's coordinate system (left-handed) [deg].\n     * Returns the converted rotation in ROS2's coordinate system (right-handed) [rad].\n     */" },
		{ "ModuleRelativePath", "Public/Utilities/AGX_ROS2Utilities.h" },
		{ "ToolTip", "Converts a rotation from Unreal's coordinate system [deg] to ROS2's coordinate system [rad].\nROS2 uses right-handed coordinate systems, while Unreal uses left-handed coordinate systems.\n\nRotUnreal - The rotation in Unreal's coordinate system (left-handed) [deg].\nReturns the converted rotation in ROS2's coordinate system (right-handed) [rad]." },
	};
#endif // WITH_METADATA
	static const UECodeGen_Private::FStructPropertyParams NewProp_RotUnreal;
	static const UECodeGen_Private::FStructPropertyParams NewProp_ReturnValue;
	static const UECodeGen_Private::FPropertyParamsBase* const PropPointers[];
	static const UECodeGen_Private::FFunctionParams FuncParams;
};
const UECodeGen_Private::FStructPropertyParams Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertRotationToROS_Statics::NewProp_RotUnreal = { "RotUnreal", nullptr, (EPropertyFlags)0x0010000000000080, UECodeGen_Private::EPropertyGenFlags::Struct, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, STRUCT_OFFSET(AGX_ROS2Utilities_eventConvertRotationToROS_Parms, RotUnreal), Z_Construct_UScriptStruct_FQuat, METADATA_PARAMS(0, nullptr) };
const UECodeGen_Private::FStructPropertyParams Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertRotationToROS_Statics::NewProp_ReturnValue = { "ReturnValue", nullptr, (EPropertyFlags)0x0010000000000580, UECodeGen_Private::EPropertyGenFlags::Struct, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, STRUCT_OFFSET(AGX_ROS2Utilities_eventConvertRotationToROS_Parms, ReturnValue), Z_Construct_UScriptStruct_FQuat, METADATA_PARAMS(0, nullptr) };
const UECodeGen_Private::FPropertyParamsBase* const Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertRotationToROS_Statics::PropPointers[] = {
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertRotationToROS_Statics::NewProp_RotUnreal,
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertRotationToROS_Statics::NewProp_ReturnValue,
};
static_assert(UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertRotationToROS_Statics::PropPointers) < 2048);
const UECodeGen_Private::FFunctionParams Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertRotationToROS_Statics::FuncParams = { { (UObject*(*)())Z_Construct_UClass_UAGX_ROS2Utilities, nullptr, "ConvertRotationToROS", Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertRotationToROS_Statics::PropPointers, UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertRotationToROS_Statics::PropPointers), sizeof(Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertRotationToROS_Statics::AGX_ROS2Utilities_eventConvertRotationToROS_Parms), RF_Public|RF_Transient|RF_MarkAsNative, (EFunctionFlags)0x04822401, 0, 0, METADATA_PARAMS(UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertRotationToROS_Statics::Function_MetaDataParams), Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertRotationToROS_Statics::Function_MetaDataParams)},  };
static_assert(sizeof(Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertRotationToROS_Statics::AGX_ROS2Utilities_eventConvertRotationToROS_Parms) < MAX_uint16);
UFunction* Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertRotationToROS()
{
	static UFunction* ReturnFunction = nullptr;
	if (!ReturnFunction)
	{
		UECodeGen_Private::ConstructUFunction(&ReturnFunction, Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertRotationToROS_Statics::FuncParams);
	}
	return ReturnFunction;
}
DEFINE_FUNCTION(UAGX_ROS2Utilities::execConvertRotationToROS)
{
	P_GET_STRUCT(FQuat,Z_Param_RotUnreal);
	P_FINISH;
	P_NATIVE_BEGIN;
	*(FQuat*)Z_Param__Result=UAGX_ROS2Utilities::ConvertRotationToROS(Z_Param_RotUnreal);
	P_NATIVE_END;
}
// ********** End Class UAGX_ROS2Utilities Function ConvertRotationToROS ***************************

// ********** Begin Class UAGX_ROS2Utilities Function ConvertRotationToUnreal **********************
struct Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertRotationToUnreal_Statics
{
	struct AGX_ROS2Utilities_eventConvertRotationToUnreal_Parms
	{
		FQuat RotROS;
		FQuat ReturnValue;
	};
#if WITH_METADATA
	static constexpr UECodeGen_Private::FMetaDataPairParam Function_MetaDataParams[] = {
		{ "Category", "AGX ROS2" },
		{ "Comment", "/**\n     * Converts a rotation from ROS2's coordinate system [rad] to Unreal's coordinate system [deg].\n     * ROS2 uses right-handed coordinate systems, while Unreal uses left-handed coordinate systems.\n     *\n     * RotROS - The rotation in ROS2's coordinate system (right-handed) [rad].\n     * Returns the converted rotation in Unreal's coordinate system (left-handed) [deg].\n     */" },
		{ "ModuleRelativePath", "Public/Utilities/AGX_ROS2Utilities.h" },
		{ "ToolTip", "Converts a rotation from ROS2's coordinate system [rad] to Unreal's coordinate system [deg].\nROS2 uses right-handed coordinate systems, while Unreal uses left-handed coordinate systems.\n\nRotROS - The rotation in ROS2's coordinate system (right-handed) [rad].\nReturns the converted rotation in Unreal's coordinate system (left-handed) [deg]." },
	};
#endif // WITH_METADATA
	static const UECodeGen_Private::FStructPropertyParams NewProp_RotROS;
	static const UECodeGen_Private::FStructPropertyParams NewProp_ReturnValue;
	static const UECodeGen_Private::FPropertyParamsBase* const PropPointers[];
	static const UECodeGen_Private::FFunctionParams FuncParams;
};
const UECodeGen_Private::FStructPropertyParams Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertRotationToUnreal_Statics::NewProp_RotROS = { "RotROS", nullptr, (EPropertyFlags)0x0010000000000080, UECodeGen_Private::EPropertyGenFlags::Struct, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, STRUCT_OFFSET(AGX_ROS2Utilities_eventConvertRotationToUnreal_Parms, RotROS), Z_Construct_UScriptStruct_FQuat, METADATA_PARAMS(0, nullptr) };
const UECodeGen_Private::FStructPropertyParams Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertRotationToUnreal_Statics::NewProp_ReturnValue = { "ReturnValue", nullptr, (EPropertyFlags)0x0010000000000580, UECodeGen_Private::EPropertyGenFlags::Struct, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, STRUCT_OFFSET(AGX_ROS2Utilities_eventConvertRotationToUnreal_Parms, ReturnValue), Z_Construct_UScriptStruct_FQuat, METADATA_PARAMS(0, nullptr) };
const UECodeGen_Private::FPropertyParamsBase* const Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertRotationToUnreal_Statics::PropPointers[] = {
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertRotationToUnreal_Statics::NewProp_RotROS,
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertRotationToUnreal_Statics::NewProp_ReturnValue,
};
static_assert(UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertRotationToUnreal_Statics::PropPointers) < 2048);
const UECodeGen_Private::FFunctionParams Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertRotationToUnreal_Statics::FuncParams = { { (UObject*(*)())Z_Construct_UClass_UAGX_ROS2Utilities, nullptr, "ConvertRotationToUnreal", Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertRotationToUnreal_Statics::PropPointers, UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertRotationToUnreal_Statics::PropPointers), sizeof(Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertRotationToUnreal_Statics::AGX_ROS2Utilities_eventConvertRotationToUnreal_Parms), RF_Public|RF_Transient|RF_MarkAsNative, (EFunctionFlags)0x04822401, 0, 0, METADATA_PARAMS(UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertRotationToUnreal_Statics::Function_MetaDataParams), Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertRotationToUnreal_Statics::Function_MetaDataParams)},  };
static_assert(sizeof(Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertRotationToUnreal_Statics::AGX_ROS2Utilities_eventConvertRotationToUnreal_Parms) < MAX_uint16);
UFunction* Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertRotationToUnreal()
{
	static UFunction* ReturnFunction = nullptr;
	if (!ReturnFunction)
	{
		UECodeGen_Private::ConstructUFunction(&ReturnFunction, Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertRotationToUnreal_Statics::FuncParams);
	}
	return ReturnFunction;
}
DEFINE_FUNCTION(UAGX_ROS2Utilities::execConvertRotationToUnreal)
{
	P_GET_STRUCT(FQuat,Z_Param_RotROS);
	P_FINISH;
	P_NATIVE_BEGIN;
	*(FQuat*)Z_Param__Result=UAGX_ROS2Utilities::ConvertRotationToUnreal(Z_Param_RotROS);
	P_NATIVE_END;
}
// ********** End Class UAGX_ROS2Utilities Function ConvertRotationToUnreal ************************

// ********** Begin Class UAGX_ROS2Utilities Function ConvertTime **********************************
struct Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertTime_Statics
{
	struct AGX_ROS2Utilities_eventConvertTime_Parms
	{
		double TimeStamp;
		FAGX_BuiltinInterfacesTime ReturnValue;
	};
#if WITH_METADATA
	static constexpr UECodeGen_Private::FMetaDataPairParam Function_MetaDataParams[] = {
		{ "Category", "AGX ROS2" },
		{ "Comment", "/**\n\x09 * Takes a TimeStamp in seconds and converts it into a ROS2 builtin_interfaces::Time message.\n\x09 */" },
		{ "ModuleRelativePath", "Public/Utilities/AGX_ROS2Utilities.h" },
		{ "ToolTip", "Takes a TimeStamp in seconds and converts it into a ROS2 builtin_interfaces::Time message." },
	};
#endif // WITH_METADATA
	static const UECodeGen_Private::FDoublePropertyParams NewProp_TimeStamp;
	static const UECodeGen_Private::FStructPropertyParams NewProp_ReturnValue;
	static const UECodeGen_Private::FPropertyParamsBase* const PropPointers[];
	static const UECodeGen_Private::FFunctionParams FuncParams;
};
const UECodeGen_Private::FDoublePropertyParams Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertTime_Statics::NewProp_TimeStamp = { "TimeStamp", nullptr, (EPropertyFlags)0x0010000000000080, UECodeGen_Private::EPropertyGenFlags::Double, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, STRUCT_OFFSET(AGX_ROS2Utilities_eventConvertTime_Parms, TimeStamp), METADATA_PARAMS(0, nullptr) };
const UECodeGen_Private::FStructPropertyParams Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertTime_Statics::NewProp_ReturnValue = { "ReturnValue", nullptr, (EPropertyFlags)0x0010000000000580, UECodeGen_Private::EPropertyGenFlags::Struct, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, STRUCT_OFFSET(AGX_ROS2Utilities_eventConvertTime_Parms, ReturnValue), Z_Construct_UScriptStruct_FAGX_BuiltinInterfacesTime, METADATA_PARAMS(0, nullptr) }; // 2009276951
const UECodeGen_Private::FPropertyParamsBase* const Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertTime_Statics::PropPointers[] = {
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertTime_Statics::NewProp_TimeStamp,
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertTime_Statics::NewProp_ReturnValue,
};
static_assert(UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertTime_Statics::PropPointers) < 2048);
const UECodeGen_Private::FFunctionParams Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertTime_Statics::FuncParams = { { (UObject*(*)())Z_Construct_UClass_UAGX_ROS2Utilities, nullptr, "ConvertTime", Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertTime_Statics::PropPointers, UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertTime_Statics::PropPointers), sizeof(Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertTime_Statics::AGX_ROS2Utilities_eventConvertTime_Parms), RF_Public|RF_Transient|RF_MarkAsNative, (EFunctionFlags)0x14022401, 0, 0, METADATA_PARAMS(UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertTime_Statics::Function_MetaDataParams), Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertTime_Statics::Function_MetaDataParams)},  };
static_assert(sizeof(Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertTime_Statics::AGX_ROS2Utilities_eventConvertTime_Parms) < MAX_uint16);
UFunction* Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertTime()
{
	static UFunction* ReturnFunction = nullptr;
	if (!ReturnFunction)
	{
		UECodeGen_Private::ConstructUFunction(&ReturnFunction, Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertTime_Statics::FuncParams);
	}
	return ReturnFunction;
}
DEFINE_FUNCTION(UAGX_ROS2Utilities::execConvertTime)
{
	P_GET_PROPERTY(FDoubleProperty,Z_Param_TimeStamp);
	P_FINISH;
	P_NATIVE_BEGIN;
	*(FAGX_BuiltinInterfacesTime*)Z_Param__Result=UAGX_ROS2Utilities::ConvertTime(Z_Param_TimeStamp);
	P_NATIVE_END;
}
// ********** End Class UAGX_ROS2Utilities Function ConvertTime ************************************

// ********** Begin Class UAGX_ROS2Utilities Function ConvertVelocityToROS *************************
struct Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertVelocityToROS_Statics
{
	struct AGX_ROS2Utilities_eventConvertVelocityToROS_Parms
	{
		FVector VelUnreal;
		FVector ReturnValue;
	};
#if WITH_METADATA
	static constexpr UECodeGen_Private::FMetaDataPairParam Function_MetaDataParams[] = {
		{ "Category", "AGX ROS2" },
		{ "Comment", "/**\n     * Converts a velocity from Unreal's unit system [cm/s] to ROS2's unit system [m/s].\n\x09\x09 * ROS2 uses right-handed coordinate systems, while Unreal uses left-handed coordinate systems.\n     *\n     * VelUnreal - The velocity in Unreal's unit system (left-handed) [cm/s].\n     * Returns the converted velocity in ROS2's unit system (right-handed) [m/s].\n     */" },
		{ "ModuleRelativePath", "Public/Utilities/AGX_ROS2Utilities.h" },
		{ "ToolTip", "Converts a velocity from Unreal's unit system [cm/s] to ROS2's unit system [m/s].\nROS2 uses right-handed coordinate systems, while Unreal uses left-handed coordinate systems.\n\nVelUnreal - The velocity in Unreal's unit system (left-handed) [cm/s].\nReturns the converted velocity in ROS2's unit system (right-handed) [m/s]." },
	};
#endif // WITH_METADATA
	static const UECodeGen_Private::FStructPropertyParams NewProp_VelUnreal;
	static const UECodeGen_Private::FStructPropertyParams NewProp_ReturnValue;
	static const UECodeGen_Private::FPropertyParamsBase* const PropPointers[];
	static const UECodeGen_Private::FFunctionParams FuncParams;
};
const UECodeGen_Private::FStructPropertyParams Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertVelocityToROS_Statics::NewProp_VelUnreal = { "VelUnreal", nullptr, (EPropertyFlags)0x0010000000000080, UECodeGen_Private::EPropertyGenFlags::Struct, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, STRUCT_OFFSET(AGX_ROS2Utilities_eventConvertVelocityToROS_Parms, VelUnreal), Z_Construct_UScriptStruct_FVector, METADATA_PARAMS(0, nullptr) };
const UECodeGen_Private::FStructPropertyParams Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertVelocityToROS_Statics::NewProp_ReturnValue = { "ReturnValue", nullptr, (EPropertyFlags)0x0010000000000580, UECodeGen_Private::EPropertyGenFlags::Struct, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, STRUCT_OFFSET(AGX_ROS2Utilities_eventConvertVelocityToROS_Parms, ReturnValue), Z_Construct_UScriptStruct_FVector, METADATA_PARAMS(0, nullptr) };
const UECodeGen_Private::FPropertyParamsBase* const Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertVelocityToROS_Statics::PropPointers[] = {
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertVelocityToROS_Statics::NewProp_VelUnreal,
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertVelocityToROS_Statics::NewProp_ReturnValue,
};
static_assert(UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertVelocityToROS_Statics::PropPointers) < 2048);
const UECodeGen_Private::FFunctionParams Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertVelocityToROS_Statics::FuncParams = { { (UObject*(*)())Z_Construct_UClass_UAGX_ROS2Utilities, nullptr, "ConvertVelocityToROS", Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertVelocityToROS_Statics::PropPointers, UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertVelocityToROS_Statics::PropPointers), sizeof(Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertVelocityToROS_Statics::AGX_ROS2Utilities_eventConvertVelocityToROS_Parms), RF_Public|RF_Transient|RF_MarkAsNative, (EFunctionFlags)0x04822401, 0, 0, METADATA_PARAMS(UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertVelocityToROS_Statics::Function_MetaDataParams), Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertVelocityToROS_Statics::Function_MetaDataParams)},  };
static_assert(sizeof(Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertVelocityToROS_Statics::AGX_ROS2Utilities_eventConvertVelocityToROS_Parms) < MAX_uint16);
UFunction* Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertVelocityToROS()
{
	static UFunction* ReturnFunction = nullptr;
	if (!ReturnFunction)
	{
		UECodeGen_Private::ConstructUFunction(&ReturnFunction, Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertVelocityToROS_Statics::FuncParams);
	}
	return ReturnFunction;
}
DEFINE_FUNCTION(UAGX_ROS2Utilities::execConvertVelocityToROS)
{
	P_GET_STRUCT(FVector,Z_Param_VelUnreal);
	P_FINISH;
	P_NATIVE_BEGIN;
	*(FVector*)Z_Param__Result=UAGX_ROS2Utilities::ConvertVelocityToROS(Z_Param_VelUnreal);
	P_NATIVE_END;
}
// ********** End Class UAGX_ROS2Utilities Function ConvertVelocityToROS ***************************

// ********** Begin Class UAGX_ROS2Utilities Function ConvertVelocityToUnreal **********************
struct Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertVelocityToUnreal_Statics
{
	struct AGX_ROS2Utilities_eventConvertVelocityToUnreal_Parms
	{
		FVector VelROS;
		FVector ReturnValue;
	};
#if WITH_METADATA
	static constexpr UECodeGen_Private::FMetaDataPairParam Function_MetaDataParams[] = {
		{ "Category", "AGX ROS2" },
		{ "Comment", "/**\n     * Converts a velocity from ROS2's unit system [m/s] to Unreal's unit system [cm/s].\n\x09\x09 * ROS2 uses right-handed coordinate systems, while Unreal uses left-handed coordinate systems.\n     *\n     * VelROS - The velocity in ROS2's unit system (right-handed) [m/s].\n     * Returns the converted velocity in Unreal's unit system (left-handed) [cm/s].\n     */" },
		{ "ModuleRelativePath", "Public/Utilities/AGX_ROS2Utilities.h" },
		{ "ToolTip", "Converts a velocity from ROS2's unit system [m/s] to Unreal's unit system [cm/s].\nROS2 uses right-handed coordinate systems, while Unreal uses left-handed coordinate systems.\n\nVelROS - The velocity in ROS2's unit system (right-handed) [m/s].\nReturns the converted velocity in Unreal's unit system (left-handed) [cm/s]." },
	};
#endif // WITH_METADATA
	static const UECodeGen_Private::FStructPropertyParams NewProp_VelROS;
	static const UECodeGen_Private::FStructPropertyParams NewProp_ReturnValue;
	static const UECodeGen_Private::FPropertyParamsBase* const PropPointers[];
	static const UECodeGen_Private::FFunctionParams FuncParams;
};
const UECodeGen_Private::FStructPropertyParams Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertVelocityToUnreal_Statics::NewProp_VelROS = { "VelROS", nullptr, (EPropertyFlags)0x0010000000000080, UECodeGen_Private::EPropertyGenFlags::Struct, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, STRUCT_OFFSET(AGX_ROS2Utilities_eventConvertVelocityToUnreal_Parms, VelROS), Z_Construct_UScriptStruct_FVector, METADATA_PARAMS(0, nullptr) };
const UECodeGen_Private::FStructPropertyParams Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertVelocityToUnreal_Statics::NewProp_ReturnValue = { "ReturnValue", nullptr, (EPropertyFlags)0x0010000000000580, UECodeGen_Private::EPropertyGenFlags::Struct, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, STRUCT_OFFSET(AGX_ROS2Utilities_eventConvertVelocityToUnreal_Parms, ReturnValue), Z_Construct_UScriptStruct_FVector, METADATA_PARAMS(0, nullptr) };
const UECodeGen_Private::FPropertyParamsBase* const Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertVelocityToUnreal_Statics::PropPointers[] = {
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertVelocityToUnreal_Statics::NewProp_VelROS,
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertVelocityToUnreal_Statics::NewProp_ReturnValue,
};
static_assert(UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertVelocityToUnreal_Statics::PropPointers) < 2048);
const UECodeGen_Private::FFunctionParams Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertVelocityToUnreal_Statics::FuncParams = { { (UObject*(*)())Z_Construct_UClass_UAGX_ROS2Utilities, nullptr, "ConvertVelocityToUnreal", Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertVelocityToUnreal_Statics::PropPointers, UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertVelocityToUnreal_Statics::PropPointers), sizeof(Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertVelocityToUnreal_Statics::AGX_ROS2Utilities_eventConvertVelocityToUnreal_Parms), RF_Public|RF_Transient|RF_MarkAsNative, (EFunctionFlags)0x04822401, 0, 0, METADATA_PARAMS(UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertVelocityToUnreal_Statics::Function_MetaDataParams), Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertVelocityToUnreal_Statics::Function_MetaDataParams)},  };
static_assert(sizeof(Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertVelocityToUnreal_Statics::AGX_ROS2Utilities_eventConvertVelocityToUnreal_Parms) < MAX_uint16);
UFunction* Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertVelocityToUnreal()
{
	static UFunction* ReturnFunction = nullptr;
	if (!ReturnFunction)
	{
		UECodeGen_Private::ConstructUFunction(&ReturnFunction, Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertVelocityToUnreal_Statics::FuncParams);
	}
	return ReturnFunction;
}
DEFINE_FUNCTION(UAGX_ROS2Utilities::execConvertVelocityToUnreal)
{
	P_GET_STRUCT(FVector,Z_Param_VelROS);
	P_FINISH;
	P_NATIVE_BEGIN;
	*(FVector*)Z_Param__Result=UAGX_ROS2Utilities::ConvertVelocityToUnreal(Z_Param_VelROS);
	P_NATIVE_END;
}
// ********** End Class UAGX_ROS2Utilities Function ConvertVelocityToUnreal ************************

// ********** Begin Class UAGX_ROS2Utilities Function ConvertXYZ ***********************************
struct Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertXYZ_Statics
{
	struct AGX_ROS2Utilities_eventConvertXYZ_Parms
	{
		TArray<FAGX_LidarScanPoint> Points;
		bool DoublePrecision;
		bool ROSCoordinates;
		FString FrameId;
		FAGX_SensorMsgsPointCloud2 ReturnValue;
	};
#if WITH_METADATA
	static constexpr UECodeGen_Private::FMetaDataPairParam Function_MetaDataParams[] = {
		{ "Category", "AGX ROS2" },
		{ "Comment", "/**\n\x09 * Takes an array of Lidar Scan Points and converts it into a ROS2 sensor_msgs::PointCloud2\n\x09 * message.\n\x09 * The Data member consists of position X, Y, Z and Intensity for each point written as either\n\x09 * floats or doubles in little endian layout, i.e. 16 or 32 bytes per point.\n\x09 *\n\x09 * DoublePrecision - use double precision type when writing the X, Y, Z and intensity data. If\n\x09 * set to false, single precision (float) is used.\n\x09 *\n\x09 * ROSCoordinates - convert points to use ROS2 coordinate system instead of Unreal's coordinate\n\x09 * system.\n\x09 *\n\x09 * FrameId - corresponds to the frame_id of the std_msgs::Header message.\n\x09 * If not set, it will be an empty string.\n\x09 *\n\x09 * Note that all invalid points, such as points representing scan misses, are ignored.\n\x09 * This means that the sensor_msgs::PointCloud2 message created by this function is always\n\x09 * dense.\n\x09 *\n\x09 * The timestamp written to the Header member of the sensor_msgs::PointCloud2 message is set to\n\x09 * the timestamp of the first valid Point in the given array, even if other points have been\n\x09 * generated at later timestamps.\n\x09 */" },
		{ "CPP_Default_DoublePrecision", "false" },
		{ "CPP_Default_FrameId", "" },
		{ "CPP_Default_ROSCoordinates", "true" },
		{ "ModuleRelativePath", "Public/Utilities/AGX_ROS2Utilities.h" },
		{ "ToolTip", "Takes an array of Lidar Scan Points and converts it into a ROS2 sensor_msgs::PointCloud2\nmessage.\nThe Data member consists of position X, Y, Z and Intensity for each point written as either\nfloats or doubles in little endian layout, i.e. 16 or 32 bytes per point.\n\nDoublePrecision - use double precision type when writing the X, Y, Z and intensity data. If\nset to false, single precision (float) is used.\n\nROSCoordinates - convert points to use ROS2 coordinate system instead of Unreal's coordinate\nsystem.\n\nFrameId - corresponds to the frame_id of the std_msgs::Header message.\nIf not set, it will be an empty string.\n\nNote that all invalid points, such as points representing scan misses, are ignored.\nThis means that the sensor_msgs::PointCloud2 message created by this function is always\ndense.\n\nThe timestamp written to the Header member of the sensor_msgs::PointCloud2 message is set to\nthe timestamp of the first valid Point in the given array, even if other points have been\ngenerated at later timestamps." },
	};
	static constexpr UECodeGen_Private::FMetaDataPairParam NewProp_Points_MetaData[] = {
		{ "NativeConst", "" },
	};
	static constexpr UECodeGen_Private::FMetaDataPairParam NewProp_FrameId_MetaData[] = {
		{ "NativeConst", "" },
	};
#endif // WITH_METADATA
	static const UECodeGen_Private::FStructPropertyParams NewProp_Points_Inner;
	static const UECodeGen_Private::FArrayPropertyParams NewProp_Points;
	static void NewProp_DoublePrecision_SetBit(void* Obj);
	static const UECodeGen_Private::FBoolPropertyParams NewProp_DoublePrecision;
	static void NewProp_ROSCoordinates_SetBit(void* Obj);
	static const UECodeGen_Private::FBoolPropertyParams NewProp_ROSCoordinates;
	static const UECodeGen_Private::FStrPropertyParams NewProp_FrameId;
	static const UECodeGen_Private::FStructPropertyParams NewProp_ReturnValue;
	static const UECodeGen_Private::FPropertyParamsBase* const PropPointers[];
	static const UECodeGen_Private::FFunctionParams FuncParams;
};
const UECodeGen_Private::FStructPropertyParams Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertXYZ_Statics::NewProp_Points_Inner = { "Points", nullptr, (EPropertyFlags)0x0000000000000000, UECodeGen_Private::EPropertyGenFlags::Struct, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, 0, Z_Construct_UScriptStruct_FAGX_LidarScanPoint, METADATA_PARAMS(0, nullptr) }; // 3032037237
const UECodeGen_Private::FArrayPropertyParams Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertXYZ_Statics::NewProp_Points = { "Points", nullptr, (EPropertyFlags)0x0010000008000182, UECodeGen_Private::EPropertyGenFlags::Array, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, STRUCT_OFFSET(AGX_ROS2Utilities_eventConvertXYZ_Parms, Points), EArrayPropertyFlags::None, METADATA_PARAMS(UE_ARRAY_COUNT(NewProp_Points_MetaData), NewProp_Points_MetaData) }; // 3032037237
void Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertXYZ_Statics::NewProp_DoublePrecision_SetBit(void* Obj)
{
	((AGX_ROS2Utilities_eventConvertXYZ_Parms*)Obj)->DoublePrecision = 1;
}
const UECodeGen_Private::FBoolPropertyParams Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertXYZ_Statics::NewProp_DoublePrecision = { "DoublePrecision", nullptr, (EPropertyFlags)0x0010000000000080, UECodeGen_Private::EPropertyGenFlags::Bool | UECodeGen_Private::EPropertyGenFlags::NativeBool, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, sizeof(bool), sizeof(AGX_ROS2Utilities_eventConvertXYZ_Parms), &Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertXYZ_Statics::NewProp_DoublePrecision_SetBit, METADATA_PARAMS(0, nullptr) };
void Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertXYZ_Statics::NewProp_ROSCoordinates_SetBit(void* Obj)
{
	((AGX_ROS2Utilities_eventConvertXYZ_Parms*)Obj)->ROSCoordinates = 1;
}
const UECodeGen_Private::FBoolPropertyParams Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertXYZ_Statics::NewProp_ROSCoordinates = { "ROSCoordinates", nullptr, (EPropertyFlags)0x0010000000000080, UECodeGen_Private::EPropertyGenFlags::Bool | UECodeGen_Private::EPropertyGenFlags::NativeBool, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, sizeof(bool), sizeof(AGX_ROS2Utilities_eventConvertXYZ_Parms), &Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertXYZ_Statics::NewProp_ROSCoordinates_SetBit, METADATA_PARAMS(0, nullptr) };
const UECodeGen_Private::FStrPropertyParams Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertXYZ_Statics::NewProp_FrameId = { "FrameId", nullptr, (EPropertyFlags)0x0010000000000080, UECodeGen_Private::EPropertyGenFlags::Str, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, STRUCT_OFFSET(AGX_ROS2Utilities_eventConvertXYZ_Parms, FrameId), METADATA_PARAMS(UE_ARRAY_COUNT(NewProp_FrameId_MetaData), NewProp_FrameId_MetaData) };
const UECodeGen_Private::FStructPropertyParams Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertXYZ_Statics::NewProp_ReturnValue = { "ReturnValue", nullptr, (EPropertyFlags)0x0010000000000580, UECodeGen_Private::EPropertyGenFlags::Struct, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, STRUCT_OFFSET(AGX_ROS2Utilities_eventConvertXYZ_Parms, ReturnValue), Z_Construct_UScriptStruct_FAGX_SensorMsgsPointCloud2, METADATA_PARAMS(0, nullptr) }; // 2387818651
const UECodeGen_Private::FPropertyParamsBase* const Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertXYZ_Statics::PropPointers[] = {
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertXYZ_Statics::NewProp_Points_Inner,
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertXYZ_Statics::NewProp_Points,
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertXYZ_Statics::NewProp_DoublePrecision,
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertXYZ_Statics::NewProp_ROSCoordinates,
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertXYZ_Statics::NewProp_FrameId,
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertXYZ_Statics::NewProp_ReturnValue,
};
static_assert(UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertXYZ_Statics::PropPointers) < 2048);
const UECodeGen_Private::FFunctionParams Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertXYZ_Statics::FuncParams = { { (UObject*(*)())Z_Construct_UClass_UAGX_ROS2Utilities, nullptr, "ConvertXYZ", Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertXYZ_Statics::PropPointers, UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertXYZ_Statics::PropPointers), sizeof(Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertXYZ_Statics::AGX_ROS2Utilities_eventConvertXYZ_Parms), RF_Public|RF_Transient|RF_MarkAsNative, (EFunctionFlags)0x14422401, 0, 0, METADATA_PARAMS(UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertXYZ_Statics::Function_MetaDataParams), Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertXYZ_Statics::Function_MetaDataParams)},  };
static_assert(sizeof(Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertXYZ_Statics::AGX_ROS2Utilities_eventConvertXYZ_Parms) < MAX_uint16);
UFunction* Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertXYZ()
{
	static UFunction* ReturnFunction = nullptr;
	if (!ReturnFunction)
	{
		UECodeGen_Private::ConstructUFunction(&ReturnFunction, Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertXYZ_Statics::FuncParams);
	}
	return ReturnFunction;
}
DEFINE_FUNCTION(UAGX_ROS2Utilities::execConvertXYZ)
{
	P_GET_TARRAY_REF(FAGX_LidarScanPoint,Z_Param_Out_Points);
	P_GET_UBOOL(Z_Param_DoublePrecision);
	P_GET_UBOOL(Z_Param_ROSCoordinates);
	P_GET_PROPERTY(FStrProperty,Z_Param_FrameId);
	P_FINISH;
	P_NATIVE_BEGIN;
	*(FAGX_SensorMsgsPointCloud2*)Z_Param__Result=UAGX_ROS2Utilities::ConvertXYZ(Z_Param_Out_Points,Z_Param_DoublePrecision,Z_Param_ROSCoordinates,Z_Param_FrameId);
	P_NATIVE_END;
}
// ********** End Class UAGX_ROS2Utilities Function ConvertXYZ *************************************

// ********** Begin Class UAGX_ROS2Utilities *******************************************************
void UAGX_ROS2Utilities::StaticRegisterNativesUAGX_ROS2Utilities()
{
	UClass* Class = UAGX_ROS2Utilities::StaticClass();
	static const FNameNativePtrPair Funcs[] = {
		{ "ConvertAnglesTOF", &UAGX_ROS2Utilities::execConvertAnglesTOF },
		{ "ConvertAngularVelocityToROS", &UAGX_ROS2Utilities::execConvertAngularVelocityToROS },
		{ "ConvertAngularVelocityToUnreal", &UAGX_ROS2Utilities::execConvertAngularVelocityToUnreal },
		{ "ConvertDistanceToROS", &UAGX_ROS2Utilities::execConvertDistanceToROS },
		{ "ConvertDistanceToUnreal", &UAGX_ROS2Utilities::execConvertDistanceToUnreal },
		{ "ConvertPositionData", &UAGX_ROS2Utilities::execConvertPositionData },
		{ "ConvertPositionIntensityData", &UAGX_ROS2Utilities::execConvertPositionIntensityData },
		{ "ConvertPositionToROS", &UAGX_ROS2Utilities::execConvertPositionToROS },
		{ "ConvertPositionToUnreal", &UAGX_ROS2Utilities::execConvertPositionToUnreal },
		{ "ConvertRotationToROS", &UAGX_ROS2Utilities::execConvertRotationToROS },
		{ "ConvertRotationToUnreal", &UAGX_ROS2Utilities::execConvertRotationToUnreal },
		{ "ConvertTime", &UAGX_ROS2Utilities::execConvertTime },
		{ "ConvertVelocityToROS", &UAGX_ROS2Utilities::execConvertVelocityToROS },
		{ "ConvertVelocityToUnreal", &UAGX_ROS2Utilities::execConvertVelocityToUnreal },
		{ "ConvertXYZ", &UAGX_ROS2Utilities::execConvertXYZ },
	};
	FNativeFunctionRegistrar::RegisterFunctions(Class, Funcs, UE_ARRAY_COUNT(Funcs));
}
FClassRegistrationInfo Z_Registration_Info_UClass_UAGX_ROS2Utilities;
UClass* UAGX_ROS2Utilities::GetPrivateStaticClass()
{
	using TClass = UAGX_ROS2Utilities;
	if (!Z_Registration_Info_UClass_UAGX_ROS2Utilities.InnerSingleton)
	{
		GetPrivateStaticClassBody(
			StaticPackage(),
			TEXT("AGX_ROS2Utilities"),
			Z_Registration_Info_UClass_UAGX_ROS2Utilities.InnerSingleton,
			StaticRegisterNativesUAGX_ROS2Utilities,
			sizeof(TClass),
			alignof(TClass),
			TClass::StaticClassFlags,
			TClass::StaticClassCastFlags(),
			TClass::StaticConfigName(),
			(UClass::ClassConstructorType)InternalConstructor<TClass>,
			(UClass::ClassVTableHelperCtorCallerType)InternalVTableHelperCtorCaller<TClass>,
			UOBJECT_CPPCLASS_STATICFUNCTIONS_FORCLASS(TClass),
			&TClass::Super::StaticClass,
			&TClass::WithinClass::StaticClass
		);
	}
	return Z_Registration_Info_UClass_UAGX_ROS2Utilities.InnerSingleton;
}
UClass* Z_Construct_UClass_UAGX_ROS2Utilities_NoRegister()
{
	return UAGX_ROS2Utilities::GetPrivateStaticClass();
}
struct Z_Construct_UClass_UAGX_ROS2Utilities_Statics
{
#if WITH_METADATA
	static constexpr UECodeGen_Private::FMetaDataPairParam Class_MetaDataParams[] = {
		{ "ClassGroupNames", "AGX ROS2 Utilities" },
		{ "IncludePath", "Utilities/AGX_ROS2Utilities.h" },
		{ "ModuleRelativePath", "Public/Utilities/AGX_ROS2Utilities.h" },
	};
#endif // WITH_METADATA
	static UObject* (*const DependentSingletons[])();
	static constexpr FClassFunctionLinkInfo FuncInfo[] = {
		{ &Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertAnglesTOF, "ConvertAnglesTOF" }, // 777914982
		{ &Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertAngularVelocityToROS, "ConvertAngularVelocityToROS" }, // 1967836133
		{ &Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertAngularVelocityToUnreal, "ConvertAngularVelocityToUnreal" }, // 1962249309
		{ &Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertDistanceToROS, "ConvertDistanceToROS" }, // 793818562
		{ &Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertDistanceToUnreal, "ConvertDistanceToUnreal" }, // 1936949228
		{ &Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertPositionData, "ConvertPositionData" }, // 2565035926
		{ &Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertPositionIntensityData, "ConvertPositionIntensityData" }, // 3885434147
		{ &Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertPositionToROS, "ConvertPositionToROS" }, // 1242281763
		{ &Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertPositionToUnreal, "ConvertPositionToUnreal" }, // 783532357
		{ &Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertRotationToROS, "ConvertRotationToROS" }, // 1619284592
		{ &Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertRotationToUnreal, "ConvertRotationToUnreal" }, // 1953231701
		{ &Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertTime, "ConvertTime" }, // 2656584551
		{ &Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertVelocityToROS, "ConvertVelocityToROS" }, // 4262090793
		{ &Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertVelocityToUnreal, "ConvertVelocityToUnreal" }, // 11848126
		{ &Z_Construct_UFunction_UAGX_ROS2Utilities_ConvertXYZ, "ConvertXYZ" }, // 3720381033
	};
	static_assert(UE_ARRAY_COUNT(FuncInfo) < 2048);
	static constexpr FCppClassTypeInfoStatic StaticCppClassTypeInfo = {
		TCppClassTypeTraits<UAGX_ROS2Utilities>::IsAbstract,
	};
	static const UECodeGen_Private::FClassParams ClassParams;
};
UObject* (*const Z_Construct_UClass_UAGX_ROS2Utilities_Statics::DependentSingletons[])() = {
	(UObject* (*)())Z_Construct_UClass_UBlueprintFunctionLibrary,
	(UObject* (*)())Z_Construct_UPackage__Script_AGXUnreal,
};
static_assert(UE_ARRAY_COUNT(Z_Construct_UClass_UAGX_ROS2Utilities_Statics::DependentSingletons) < 16);
const UECodeGen_Private::FClassParams Z_Construct_UClass_UAGX_ROS2Utilities_Statics::ClassParams = {
	&UAGX_ROS2Utilities::StaticClass,
	nullptr,
	&StaticCppClassTypeInfo,
	DependentSingletons,
	FuncInfo,
	nullptr,
	nullptr,
	UE_ARRAY_COUNT(DependentSingletons),
	UE_ARRAY_COUNT(FuncInfo),
	0,
	0,
	0x001000A0u,
	METADATA_PARAMS(UE_ARRAY_COUNT(Z_Construct_UClass_UAGX_ROS2Utilities_Statics::Class_MetaDataParams), Z_Construct_UClass_UAGX_ROS2Utilities_Statics::Class_MetaDataParams)
};
UClass* Z_Construct_UClass_UAGX_ROS2Utilities()
{
	if (!Z_Registration_Info_UClass_UAGX_ROS2Utilities.OuterSingleton)
	{
		UECodeGen_Private::ConstructUClass(Z_Registration_Info_UClass_UAGX_ROS2Utilities.OuterSingleton, Z_Construct_UClass_UAGX_ROS2Utilities_Statics::ClassParams);
	}
	return Z_Registration_Info_UClass_UAGX_ROS2Utilities.OuterSingleton;
}
UAGX_ROS2Utilities::UAGX_ROS2Utilities(const FObjectInitializer& ObjectInitializer) : Super(ObjectInitializer) {}
DEFINE_VTABLE_PTR_HELPER_CTOR(UAGX_ROS2Utilities);
UAGX_ROS2Utilities::~UAGX_ROS2Utilities() {}
// ********** End Class UAGX_ROS2Utilities *********************************************************

// ********** Begin Registration *******************************************************************
struct Z_CompiledInDeferFile_FID_GitLab_Runner_builds_9YzzThLq_0_algoryx_unreal_agxunreal_s_selfhosted_build_AGXUnreal_HostProject_Plugins_AGXUnreal_Source_AGXUnreal_Public_Utilities_AGX_ROS2Utilities_h__Script_AGXUnreal_Statics
{
	static constexpr FClassRegisterCompiledInInfo ClassInfo[] = {
		{ Z_Construct_UClass_UAGX_ROS2Utilities, UAGX_ROS2Utilities::StaticClass, TEXT("UAGX_ROS2Utilities"), &Z_Registration_Info_UClass_UAGX_ROS2Utilities, CONSTRUCT_RELOAD_VERSION_INFO(FClassReloadVersionInfo, sizeof(UAGX_ROS2Utilities), 1395088681U) },
	};
};
static FRegisterCompiledInInfo Z_CompiledInDeferFile_FID_GitLab_Runner_builds_9YzzThLq_0_algoryx_unreal_agxunreal_s_selfhosted_build_AGXUnreal_HostProject_Plugins_AGXUnreal_Source_AGXUnreal_Public_Utilities_AGX_ROS2Utilities_h__Script_AGXUnreal_722561815(TEXT("/Script/AGXUnreal"),
	Z_CompiledInDeferFile_FID_GitLab_Runner_builds_9YzzThLq_0_algoryx_unreal_agxunreal_s_selfhosted_build_AGXUnreal_HostProject_Plugins_AGXUnreal_Source_AGXUnreal_Public_Utilities_AGX_ROS2Utilities_h__Script_AGXUnreal_Statics::ClassInfo, UE_ARRAY_COUNT(Z_CompiledInDeferFile_FID_GitLab_Runner_builds_9YzzThLq_0_algoryx_unreal_agxunreal_s_selfhosted_build_AGXUnreal_HostProject_Plugins_AGXUnreal_Source_AGXUnreal_Public_Utilities_AGX_ROS2Utilities_h__Script_AGXUnreal_Statics::ClassInfo),
	nullptr, 0,
	nullptr, 0);
// ********** End Registration *********************************************************************

PRAGMA_ENABLE_DEPRECATION_WARNINGS
