%module(package="openplx") Simulation
%feature("autodoc", "3");
%include <exception.i>
%include <std_string.i>
%include <python/openplx/openplx_shared_ptr.i>
%include <std_vector.i>
%import(module="Core") <python/openplx/Core.i>
%import(module="Math") <python/Math/MathModule.i>
%import(module="Physics") <python/Physics/PhysicsModule.i>
%import(module="Physics3D") <python/Physics3D/Physics3DModule.i>
%{
#include <openplx/Token.h>
using namespace openplx;
#include <openplx/NodeType.h>
#include <openplx/Node.h>
#include <openplx/Any.h>
#include <openplx/Object.h>
#include <openplx/EvaluatorContext.h>
#include <openplx/Math/Math_all.h>
#include <openplx/Physics/Physics_all.h>
#include <openplx/Physics3D/Physics3D_all.h>
#include <openplx/Simulation/Simulation_all.h>
%}
%include <exception.i>
%include <std_string.i>
%include <std_vector.i>
%apply unsigned long long int { uint64_t }
%apply long long int { int64_t }

%include <python/Simulation/Simulation.i>
OPENPLX_SWIG_BUNDLE_RENAMES_Simulation(Simulation_);
OPENPLX_SWIG_BUNDLE_SHARED_POINTERS_Simulation();
OPENPLX_SWIG_BUNDLE_SHARED_POINTER_DOWNCASTS_Simulation();
OPENPLX_SWIG_BUNDLE_VECTORS_Simulation();
%include "openplx/Simulation/CollisionGroup.h"
%include "openplx/Simulation/GravitationalField.h"
%include "openplx/Simulation/DisableCollisionPair.h"
%include "openplx/Simulation/Environment.h"
%include "openplx/Simulation/UniformGravitationalField.h"
%include "openplx/Simulation/PointGravitationalField.h"
