#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Vehicles/VehiclesBundleExport.h>
#include <openplx/Vehicles/VehiclesForward.h>
#include <openplx/DriveTrain/DriveTrainForward.h>
#include <openplx/MachineModeling/MachineModelingForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics1D/Physics1DForward.h>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/Simulation/SimulationForward.h>
#include <openplx/Visuals/VisualsForward.h>
#include <openplx/Physics3D/System.h>
#include <openplx/Physics3D/Bodies/RigidBody.h>
#include <openplx/Physics3D/Interactions/RedirectedMateConnector.h>
#include <openplx/Physics3D/Interactions/MateConnector.h>
#include <openplx/Physics3D/Interactions/Lock.h>

#ifdef _MSC_VER
#  pragma warning(push)
#  pragma warning(disable: 4251)
#endif

/* Generated code for model Base */
namespace openplx::Vehicles::Wheels {
    class OPENPLX_Vehicles_BUNDLE_EXPORT Base : public openplx::Physics3D::System {
        protected:
            std::shared_ptr<openplx::Physics3D::Bodies::RigidBody> m_rim;
            std::shared_ptr<openplx::Physics3D::Interactions::RedirectedMateConnector> m_connector;
            std::shared_ptr<openplx::Physics3D::Interactions::MateConnector> m_rim_alignment_connector;
            std::shared_ptr<openplx::Physics3D::Interactions::Lock> m_rim_alignment_mate;

        public:
            Base();
            virtual ~Base();
            std::shared_ptr<openplx::Physics3D::Bodies::RigidBody> rim() const;
            std::shared_ptr<openplx::Physics3D::Interactions::RedirectedMateConnector> connector() const;
            std::shared_ptr<openplx::Physics3D::Interactions::MateConnector> rim_alignment_connector() const;
            std::shared_ptr<openplx::Physics3D::Interactions::Lock> rim_alignment_mate() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}

#ifdef _MSC_VER
#  pragma warning(pop)
#endif
