#pragma once
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Vehicles/VehiclesBundleExport.h>
#include <openplx/Vehicles/VehiclesForward.h>
#include <openplx/DriveTrain/DriveTrainForward.h>
#include <openplx/MachineModeling/MachineModelingForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics1D/Physics1DForward.h>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/Simulation/SimulationForward.h>
#include <openplx/Visuals/VisualsForward.h>
#include <openplx/Vehicles/Steering/Interfaces/Base.h>
/* Generated code for model RackAndPinion */
namespace openplx::Vehicles::Steering::Interfaces {
    /**
     * Rack-pinion steering mechanism.
     **/
    class OPENPLX_Vehicles_BUNDLE_EXPORT RackAndPinion : public openplx::Vehicles::Steering::Interfaces::Base {
        public:
            RackAndPinion();
            virtual ~RackAndPinion();
            virtual double knuckle_angle() const = 0;
            virtual double knuckle_length() const = 0;
            virtual double initial_angle_right_tie_rod() const = 0;
            virtual double steering_column_distance() const = 0;
            virtual double rack_length() const = 0;
            virtual double gear() const = 0;
    };
}
