#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Vehicles/VehiclesBundleExport.h>
#include <openplx/Vehicles/VehiclesForward.h>
#include <openplx/DriveTrain/DriveTrainForward.h>
#include <openplx/MachineModeling/MachineModelingForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics1D/Physics1DForward.h>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/Simulation/SimulationForward.h>
#include <openplx/Visuals/VisualsForward.h>
#include <openplx/Vehicles/Steering/Articulated/Base.h>
#include <openplx/Physics3D/Interactions/MateConnector.h>
#include <openplx/MachineModeling/Actuators/Linear/Base.h>
#include <openplx/MachineModeling/Actuators/Linear/Connections/Base.h>

#ifdef _MSC_VER
#  pragma warning(push)
#  pragma warning(disable: 4251)
#endif

/* Generated code for model DualActuator */
namespace openplx::Vehicles::Steering::Articulated {
    class OPENPLX_Vehicles_BUNDLE_EXPORT DualActuator : public openplx::Vehicles::Steering::Articulated::Base {
        protected:
            std::shared_ptr<openplx::Physics3D::Interactions::MateConnector> m_left_front_connector;
            std::shared_ptr<openplx::Physics3D::Interactions::MateConnector> m_right_front_connector;
            std::shared_ptr<openplx::Physics3D::Interactions::MateConnector> m_left_rear_connector;
            std::shared_ptr<openplx::Physics3D::Interactions::MateConnector> m_right_rear_connector;
            std::shared_ptr<openplx::MachineModeling::Actuators::Linear::Base> m_left_actuator;
            std::shared_ptr<openplx::MachineModeling::Actuators::Linear::Base> m_right_actuator;
            std::shared_ptr<openplx::MachineModeling::Actuators::Linear::Connections::Base> m_left_actuator_connection;
            std::shared_ptr<openplx::MachineModeling::Actuators::Linear::Connections::Base> m_right_actuator_connection;

        public:
            DualActuator();
            virtual ~DualActuator();
            std::shared_ptr<openplx::Physics3D::Interactions::MateConnector> left_front_connector() const;
            std::shared_ptr<openplx::Physics3D::Interactions::MateConnector> right_front_connector() const;
            std::shared_ptr<openplx::Physics3D::Interactions::MateConnector> left_rear_connector() const;
            std::shared_ptr<openplx::Physics3D::Interactions::MateConnector> right_rear_connector() const;
            std::shared_ptr<openplx::MachineModeling::Actuators::Linear::Base> left_actuator() const;
            std::shared_ptr<openplx::MachineModeling::Actuators::Linear::Base> right_actuator() const;
            std::shared_ptr<openplx::MachineModeling::Actuators::Linear::Connections::Base> left_actuator_connection() const;
            std::shared_ptr<openplx::MachineModeling::Actuators::Linear::Connections::Base> right_actuator_connection() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}

#ifdef _MSC_VER
#  pragma warning(pop)
#endif
