#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Sensors/SensorsBundleExport.h>
#include <openplx/Sensors/SensorsForward.h>
#include <openplx/DriveTrain/DriveTrainForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics1D/Physics1DForward.h>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/Sensors/Optics/BeamDivergence.h>

#ifdef _MSC_VER
#  pragma warning(push)
#  pragma warning(disable: 4251)
#endif

/* Generated code for model ConicalBeamDivergence */
namespace openplx::Sensors::Optics {
    /**
     *     Beam divergence specification based on the conical approximation of the Gaussian beam
     *     radius:
     *
     *         w(x) = x tan(t_D) + w_0
     *
     *     which gives a conically expanding radius at a divergence (half-) angle of t_D from an
     *     initial of w_0 as the beam traverses the optical length x.
     *     */
    class OPENPLX_Sensors_BUNDLE_EXPORT ConicalBeamDivergence : public openplx::Sensors::Optics::BeamDivergence {
        protected:
            double m_divergence_angle;
            double m_waist_radius;

        public:
            ConicalBeamDivergence();
            virtual ~ConicalBeamDivergence();
            double divergence_angle() const;
            double waist_radius() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}

#ifdef _MSC_VER
#  pragma warning(pop)
#endif
