#pragma once

#include <memory>
#include "UuidGenerator.h"
#include <openplx/ErrorReporter.h>

namespace openplx
{
    class Logger;

    class RuntimeContext
    {
        public:
            RuntimeContext(std::shared_ptr<ErrorReporter> error_reporter);

            std::shared_ptr<ErrorReporter> getErrorReporter() const;
            void setLogger(std::shared_ptr<openplx::Logger> logger);
            std::shared_ptr<openplx::Logger> getLogger() const;
            void useUuidv5(std::string namespace_id);

            const UuidSettings& getUuidSettings() const;
        private:
            UuidSettings m_uuid_settings;
            std::shared_ptr<ErrorReporter> m_error_reporter;
            std::shared_ptr<openplx::Logger> m_logger;
    };
}
