#pragma once
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Physics3D/Physics3DBundleExport.h>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics/Interactions/SurfaceContact/Traits/SurfaceViscosity.h>
/* Generated code for model OrientedSurfaceViscosity */
namespace openplx::Physics3D::Interactions::SurfaceContact::Traits {
    /**
     * Extends the SurfaceViscosity trait and introduces
     * a secondary viscosity in the secondary direction,
     * defined by an OrientedFricion trait
     *
     * works with Physics.Interactions.Dissipation.DefaultDryFriction with OrientedFriction
     *
     **/
    class OPENPLX_Physics3D_BUNDLE_EXPORT OrientedSurfaceViscosity : public openplx::Physics::Interactions::SurfaceContact::Traits::SurfaceViscosity {
        public:
            OrientedSurfaceViscosity();
            virtual ~OrientedSurfaceViscosity();
            virtual double viscosity() const = 0;
            virtual double secondary_viscosity() const = 0;
    };
}
