#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Physics3D/Physics3DBundleExport.h>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics3D/Interactions/Mate.h>
#include <openplx/Physics/Signals/AngleOutputTrait.h>
#include <openplx/Physics/Signals/AngularVelocity1DOutputTrait.h>
#include <openplx/Physics3D/Signals/Force3DOutputTrait.h>
#include <openplx/Physics3D/Signals/Torque3DOutputTrait.h>
#include <openplx/Physics3D/Interactions/Dissipation/DefaultHingeDissipation.h>
#include <openplx/Physics3D/Interactions/Flexibility/DefaultHingeFlexibility.h>
#include <openplx/Physics3D/Interactions/Toughness/DefaultHingeToughness.h>
#include <openplx/Physics/Interactions/Dissipation/DefaultFriction.h>
#include <openplx/Physics/Signals/AngleOutput.h>
#include <openplx/Physics/Signals/AngularVelocity1DOutput.h>
#include <openplx/Physics3D/Signals/Torque3DOutput.h>
#include <openplx/Physics3D/Signals/Force3DOutput.h>

#ifdef _MSC_VER
#  pragma warning(push)
#  pragma warning(disable: 4251)
#endif

/* Generated code for model Hinge */
namespace openplx::Physics3D::Interactions {
    /**
     *     A hinge which constrain five degrees of freedom between two bodies.
     *     The rotation around the main axis of the two connectors is free.
     *     The friction around the hinge axis may be specified.
     *     */
    class OPENPLX_Physics3D_BUNDLE_EXPORT Hinge : public openplx::Physics3D::Interactions::Mate, public openplx::Physics::Signals::AngleOutputTrait, public openplx::Physics::Signals::AngularVelocity1DOutputTrait, public openplx::Physics3D::Signals::Force3DOutputTrait, public openplx::Physics3D::Signals::Torque3DOutputTrait {
        protected:
            double m_initial_angle;
            std::shared_ptr<openplx::Physics::Interactions::Dissipation::DefaultFriction> m_friction;
            std::shared_ptr<openplx::Physics::Signals::AngleOutput> m_angle_output;
            std::shared_ptr<openplx::Physics::Signals::AngularVelocity1DOutput> m_angular_velocity_output;
            std::shared_ptr<openplx::Physics3D::Signals::Torque3DOutput> m_torque_output;
            std::shared_ptr<openplx::Physics3D::Signals::Force3DOutput> m_force_output;

        public:
            Hinge();
            virtual ~Hinge();
            double initial_angle() const;
            std::shared_ptr<openplx::Physics3D::Interactions::Dissipation::DefaultHingeDissipation> dissipation() const;
            std::shared_ptr<openplx::Physics3D::Interactions::Flexibility::DefaultHingeFlexibility> flexibility() const;
            std::shared_ptr<openplx::Physics3D::Interactions::Toughness::DefaultHingeToughness> toughness() const;
            std::shared_ptr<openplx::Physics::Interactions::Dissipation::DefaultFriction> friction() const;
            std::shared_ptr<openplx::Physics::Signals::AngleOutput> angle_output() const;
            std::shared_ptr<openplx::Physics::Signals::AngularVelocity1DOutput> angular_velocity_output() const;
            std::shared_ptr<openplx::Physics3D::Signals::Torque3DOutput> torque_output() const;
            std::shared_ptr<openplx::Physics3D::Signals::Force3DOutput> force_output() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}

#ifdef _MSC_VER
#  pragma warning(pop)
#endif
