#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Physics/PhysicsBundleExport.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/Signals/Input.h>
#include <openplx/Physics/Signals/BoolInputTrait.h>

#ifdef _MSC_VER
#  pragma warning(push)
#  pragma warning(disable: 4251)
#endif

/* Generated code for model BoolInput */
namespace openplx::Physics::Signals {
    /**
     * An Input that is a boolean.
     **/
    class OPENPLX_Physics_BUNDLE_EXPORT BoolInput : public openplx::Physics::Signals::Input {
        protected:
            std::weak_ptr<openplx::Physics::Signals::BoolInputTrait> m_source;

        public:
            BoolInput();
            virtual ~BoolInput();
            std::shared_ptr<openplx::Physics::Signals::BoolInputTrait> source() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}

#ifdef _MSC_VER
#  pragma warning(pop)
#endif
