#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Physics/PhysicsBundleExport.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/Geometries/Material.h>
#include <openplx/Physics/Interactions/Dissipation/DefaultFriction.h>
#include <openplx/Physics/Interactions/Adhesion/DefaultAdhesion.h>
#include <openplx/Physics/Interactions/Flexibility/DefaultFlexibility.h>
#include <openplx/Physics/Interactions/Dissipation/DefaultDissipation.h>
#include <openplx/Physics/Interactions/Clearance/DefaultClearance.h>

#ifdef _MSC_VER
#  pragma warning(push)
#  pragma warning(disable: 4251)
#endif

/* Generated code for model Model */
namespace openplx::Physics::Interactions::SurfaceContact {
    /**
     *     The SurfaceContact.Model defines the interaction properties
     *     between two contacting surfaces.
     *     This definition is mapped through the materials, material_1 and material_2,
     *     of the contacting objects.
     *     This definition must be uniquely defined for a specific pair of materials.
     *     */
    class OPENPLX_Physics_BUNDLE_EXPORT Model : public openplx::Core::Object {
        protected:
            std::shared_ptr<openplx::Physics::Geometries::Material> m_material_1;
            std::shared_ptr<openplx::Physics::Geometries::Material> m_material_2;
            bool m_enabled;
            std::shared_ptr<openplx::Physics::Interactions::Dissipation::DefaultFriction> m_friction;
            std::shared_ptr<openplx::Physics::Interactions::Adhesion::DefaultAdhesion> m_adhesion;
            std::shared_ptr<openplx::Physics::Interactions::Flexibility::DefaultFlexibility> m_normal_flexibility;
            std::shared_ptr<openplx::Physics::Interactions::Dissipation::DefaultDissipation> m_dissipation;
            std::shared_ptr<openplx::Physics::Interactions::Clearance::DefaultClearance> m_clearance;
            double m_tangential_restitution;
            double m_normal_restitution;

        public:
            Model();
            virtual ~Model();
            std::shared_ptr<openplx::Physics::Geometries::Material> material_1() const;
            std::shared_ptr<openplx::Physics::Geometries::Material> material_2() const;
            bool enabled() const;
            std::shared_ptr<openplx::Physics::Interactions::Dissipation::DefaultFriction> friction() const;
            std::shared_ptr<openplx::Physics::Interactions::Adhesion::DefaultAdhesion> adhesion() const;
            std::shared_ptr<openplx::Physics::Interactions::Flexibility::DefaultFlexibility> normal_flexibility() const;
            std::shared_ptr<openplx::Physics::Interactions::Dissipation::DefaultDissipation> dissipation() const;
            std::shared_ptr<openplx::Physics::Interactions::Clearance::DefaultClearance> clearance() const;
            double tangential_restitution() const;
            double normal_restitution() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}

#ifdef _MSC_VER
#  pragma warning(pop)
#endif
