#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Physics/PhysicsBundleExport.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/Signals/BoolInputTrait.h>
#include <openplx/Physics/Signals/BoolOutputTrait.h>
#include <openplx/Physics/Interactions/Connector.h>
#include <openplx/Physics/Signals/EnableInteractionInput.h>
#include <openplx/Physics/Signals/InteractionEnabledOutput.h>

#ifdef _MSC_VER
#  pragma warning(push)
#  pragma warning(disable: 4251)
#endif

/* Generated code for model Interaction */
namespace openplx::Physics::Interactions {
    /**
     * Base type for Interaction
     * Examples of interactions are force fields, hinges or static electricity
     **/
    class OPENPLX_Physics_BUNDLE_EXPORT Interaction : public openplx::Core::Object, public openplx::Physics::Signals::BoolInputTrait, public openplx::Physics::Signals::BoolOutputTrait {
        protected:
            std::vector<std::shared_ptr<openplx::Physics::Interactions::Connector>> m_connectors;
            bool m_enabled;
            std::shared_ptr<openplx::Physics::Signals::EnableInteractionInput> m_enable_interaction_input;
            std::shared_ptr<openplx::Physics::Signals::InteractionEnabledOutput> m_interaction_enabled_output;

        public:
            Interaction();
            virtual ~Interaction();
            std::vector<std::shared_ptr<openplx::Physics::Interactions::Connector>> connectors() const;
            bool enabled() const;
            std::shared_ptr<openplx::Physics::Signals::EnableInteractionInput> enable_interaction_input() const;
            std::shared_ptr<openplx::Physics::Signals::InteractionEnabledOutput> interaction_enabled_output() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}

#ifdef _MSC_VER
#  pragma warning(pop)
#endif
