#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Math/MathBundleExport.h>
#include <openplx/Math/MathForward.h>

#ifdef _MSC_VER
#  pragma warning(push)
#  pragma warning(disable: 4251)
#endif

/* Generated code for model Vec2 */
namespace openplx::Math {
    class OPENPLX_Math_BUNDLE_EXPORT Vec2 : public openplx::Core::Object {
        protected:
            double m_x;
            double m_y;

        public:
            Vec2();
            virtual ~Vec2();
            double x() const;
            double y() const;
            static std::shared_ptr<openplx::Math::Vec2> X_AXIS();
            static std::shared_ptr<openplx::Math::Vec2> Y_AXIS();
            static std::shared_ptr<openplx::Math::Vec2> from_xy(double x, double y);
            double length() const;
            std::shared_ptr<openplx::Math::Vec2> normal() const;
            double dot(std::shared_ptr<openplx::Math::Vec2> rhs) const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}

#ifdef _MSC_VER
#  pragma warning(pop)
#endif
