#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Math/MathBundleExport.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Math/Vec3.h>

#ifdef _MSC_VER
#  pragma warning(push)
#  pragma warning(disable: 4251)
#endif

/* Generated code for model Line */
namespace openplx::Math {
    class OPENPLX_Math_BUNDLE_EXPORT Line : public openplx::Core::Object {
        protected:
            std::shared_ptr<openplx::Math::Vec3> m_start;
            std::shared_ptr<openplx::Math::Vec3> m_end;

        public:
            Line();
            virtual ~Line();
            std::shared_ptr<openplx::Math::Vec3> start() const;
            std::shared_ptr<openplx::Math::Vec3> end() const;
            static std::shared_ptr<openplx::Math::Line> from_points(std::shared_ptr<openplx::Math::Vec3> start, std::shared_ptr<openplx::Math::Vec3> end);
            double length() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}

#ifdef _MSC_VER
#  pragma warning(pop)
#endif
