#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/MachineModeling/MachineModelingBundleExport.h>
#include <openplx/MachineModeling/MachineModelingForward.h>
#include <openplx/DriveTrain/DriveTrainForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics1D/Physics1DForward.h>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/Simulation/SimulationForward.h>
#include <openplx/Visuals/VisualsForward.h>
#include <openplx/MachineModeling/Actuators/Linear/Base.h>
#include <openplx/MachineModeling/Actuators/Linear/CylinderPart.h>
#include <openplx/Physics3D/Interactions/Cylindrical.h>
#include <openplx/Physics3D/Interactions/LinearRange.h>

#ifdef _MSC_VER
#  pragma warning(push)
#  pragma warning(disable: 4251)
#endif

/* Generated code for model Cylinder */
namespace openplx::MachineModeling::Actuators::Linear {
    /**
     *     An actuator that consist of two rigid parts, connected with a cylindrical joint.
     *     The rigid parts move in AlongCylinder direction
     *     */
    class OPENPLX_MachineModeling_BUNDLE_EXPORT Cylinder : public openplx::MachineModeling::Actuators::Linear::Base {
        protected:
            std::shared_ptr<openplx::MachineModeling::Actuators::Linear::CylinderPart> m_barrel;
            std::shared_ptr<openplx::MachineModeling::Actuators::Linear::CylinderPart> m_rod;
            std::shared_ptr<openplx::Physics3D::Interactions::Cylindrical> m_cylindrical;
            std::shared_ptr<openplx::Physics3D::Interactions::LinearRange> m_range;

        public:
            Cylinder();
            virtual ~Cylinder();
            std::shared_ptr<openplx::MachineModeling::Actuators::Linear::CylinderPart> barrel() const;
            std::shared_ptr<openplx::MachineModeling::Actuators::Linear::CylinderPart> rod() const;
            std::shared_ptr<openplx::Physics3D::Interactions::Cylindrical> cylindrical() const;
            std::shared_ptr<openplx::Physics3D::Interactions::LinearRange> range() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}

#ifdef _MSC_VER
#  pragma warning(pop)
#endif
