
#pragma once

#include <filesystem>
#include <string>
#include <openplx/BundleConfig.h>
#include <openplx/ErrorReporter.h>
#include <openplx/Document.h>
#include <openplx/Import.h>

namespace openplx {
    class DocumentContext {
        public:
            DocumentContext(std::string s, std::filesystem::path p, Bundle::BundleConfig b);
            DocumentContext(std::string s, std::filesystem::path p, Bundle::BundleConfig b, ImportPtr import);
            const Bundle::BundleConfig& getBundleConfig() const;
            std::filesystem::path getPath() const;
            const std::string& getSource() const;
            void setSource(std::string source);
            const std::vector<DocPtr>& getDocuments() const;
            void appendToDocuments(DocPtr document);
            void clearDocuments();
            ImportPtr getImport() const;
            bool isCacheValid() const;
            void setCacheValid(bool cache_valid);
            bool isFlaggedForRemoval() const;
            void setFlagForRemoval(bool found_flag);

        private:
            Bundle::BundleConfig m_bundle;
            std::filesystem::path m_path;
            std::string m_source;
            std::vector<DocPtr> m_documents;
            ImportPtr m_import;
            bool m_cache_valid;
            bool m_flag_for_removal;
    };
}
