#pragma once

#include <string>
#include <memory>
#include <openplx/control_export.h>

namespace openplx {

    namespace Physics::Signals {
        class Output;
        class Input;
    }

    class ControlDispatchImpl;
    class Marshalling;
    class OutputHandler;
    class InputHandler;

    class OPENPLX_CONTROL_EXPORT ControlDispatch {
        public:
            ControlDispatch();
            ~ControlDispatch();

            bool handle_input(
                const std::shared_ptr<Physics::Signals::Input>& input,
                const std::shared_ptr<Marshalling>& marshalling
            );

            bool handle_output(
                const std::shared_ptr<Physics::Signals::Output>& output,
                const std::shared_ptr<Marshalling>& marshalling
            );

            /**
             * Empty source type means that the handler is used
             * for all source types.
             */
            void register_input_handler(
                std::shared_ptr<InputHandler> input_handler,
                const std::string& input_type,
                const std::string& source_type = ""
            );

            /**
             * Empty source type means that the handler is used
             * for all source types.
             */
            void register_output_handler(
                std::shared_ptr<OutputHandler> output_handler,
                const std::string& output_type,
                const std::string& source_type = ""
            );

        private:
            ControlDispatchImpl* m_impl;
    };
}
