
#pragma once

#include <memory>
#include <string>
#include <vector>
#include <openplx/Token.h>
#include <openplx/Node.h>
#include <openplx/Expression.h>

namespace openplx
{
    class Call : public Expression, public std::enable_shared_from_this<Call>
    {
        public:
            /* Factories */
            static CallPtr create(ExprPtr receiver, const std::vector<ExprPtr>& arguments);

            /* Overrides */
            CallPtr asCall() override;
            void accept(NodeVisitor& visitor) override;
            void unbind() override;
            ExprPtr clone() override;

            /* Receiver */
            ExprPtr getReceiver() const;
            void setReceiver(ExprPtr receiver);

            /* Method */
            MethodDeclPtr getMethod() const;
            void setMethod(MethodDeclPtr method);

            /* Arguments */
            const std::vector<ExprPtr>& getArguments() const;
            void appendToArguments(ExprPtr argument);

            /* Layout */
            void offsetLine(int64_t delta_line) override;

            col_t layoutOnSingleLine(line_t line, col_t column) override;

        private:
            Call();
            ExprPtr m_receiver;
            MethodDeclPtr m_method;
            std::vector<ExprPtr> m_arguments;
    };
}
