
#pragma once

#include <sstream>
#include <string>
#include <openplx/Token.h>
#include <openplx/NodeVisitor.h>
#include <openplx/IndentedStream.h>

namespace openplx
{
    class BoundNodeToStringVisitor : public NodeVisitor
    {
        public:

            BoundNodeToStringVisitor() : iss(oss) {}

            std::string result() { return this->oss.str(); }

            void visitDocument(const DocPtr &document) override;

            void visitModelDeclaration(const ModelDeclPtr &model_declaration) override;

            void visitVarAssignment(const VarAssignPtr &var_assignment) override;

            void visitMethodDeclaration(const MethodDeclPtr &method_declaration) override;

            void visitConstant(const ConstantPtr &constant) override;

            void visitCall(const CallPtr &call) override;

            void visitMemberAccess(const MemberAccessPtr &member_access) override;

            void visitArray(const ArrayPtr &array) override;

            void visitUnary(const UnaryPtr &unary) override;

            void visitBinaryOp(const BinaryOpPtr &binary_op) override;

            void visitPrimitiveType(const PrimitiveTypePtr &primitive_type) override;

            void visitParameter(const ParamPtr &parameter) override;

            void visitIndexing(const IndexingPtr& indexing) override;

            void visitAnnotation(const AnnotationPtr& annotation) override;

        private:
            std::ostringstream oss;
            is::IndentedStream iss;
            ModelDeclPtr m_model;
    };
}
