
#pragma once

#include <memory>
#include <string>
#include <vector>
#include <openplx/Token.h>
#include <openplx/Node.h>
#include <openplx/Type.h>
#include <openplx/SortedAssignment.h>

namespace openplx
{
    class ArrayType : public Type, public std::enable_shared_from_this<ArrayType>
    {
        public:
            /* Factories */
            static ArrayTypePtr create(NodePtr type);
            static ArrayTypePtr empty();

            /* Overrides */
            ArrayTypePtr asArrayType() override;
            TypePtr asType() override;
            void accept(NodeVisitor& visitor) override;
            bool isAssignableTo(const TypePtr &other) override;
            std::string toString() override;
            std::string toKey() override;
            TypePtr resolve() override;
            void unbind() override;
            bool isReferenceType() override;

            /** Is this an anonymous array, or is it bound to a variable */
            bool isAnonymousArray();

            /** Type of the elements in the Array */
            TypePtr getTypeOfArray() const;

            /* Empty */
            bool isEmpty() const;

        private:
            ArrayType(NodePtr type, bool empty);
            NodePtr m_type;
            bool m_empty;
    };
}
