/*
Copyright 2007-2025. Algoryx Simulation AB.

All AGX source code, intellectual property, documentation, sample code,
tutorials, scene files and technical white papers, are copyrighted, proprietary
and confidential material of Algoryx Simulation AB. You may not download, read,
store, distribute, publish, copy or otherwise disseminate, use or expose this
material unless having a written signed agreement with Algoryx Simulation AB, or having been
advised so by Algoryx Simulation AB for a time limited evaluation, or having purchased a
valid commercial license from Algoryx Simulation AB.

Algoryx Simulation AB disclaims all responsibilities for loss or damage caused
from using this software, unless otherwise stated in written agreements with
Algoryx Simulation AB.
*/
#pragma once
#include <agx/ElementaryConstraint.h>
#include <agxDriveTrain/Gear.h>
#include <agxPowerLine/PowerLine.h>
#include <agxSDK/EventManager.h>
#include <agxSDK/StepEventListener.h>
#include <agxOpenPLX/AgxMetadata.h>
#include <agxOpenPLX/SignalQueue.h>
#include <agxOpenPLX/export.h>

#include <openplx/DriveTrain/DriveTrain_all.h>
#include <openplx/Physics/Physics_all.h>
#include <openplx/Simulation/Simulation_all.h>

#include <vector>

namespace agxopenplx
{
  class AgxObjectMap;
  class OutputHandler;

  /**
   * @brief Propagates output OpenPLX signals from AGX
   */
  class AGXOPENPLX_EXPORT OutputSignalListener : public agxSDK::StepEventListener
  {
    public:
      OutputSignalListener(
        const std::shared_ptr<openplx::Core::Object>& openplx_scene, std::shared_ptr<OutputSignalQueue> output_queue,
        std::shared_ptr<AgxObjectMap> source_mapper, std::shared_ptr<AgxMetadata> metadata);
      void syncOutputSignals();
      void post(const agx::TimeStamp& time) override;
      /**
       * @brief Prefer this prio when adding OutputSignalListener to an AGX Simulation
       *
       * Set to run with highest priority so that any other post StepEventListeners can rely on signals being present
       *
       */
      static constexpr int RECOMMENDED_PRIO = agxSDK::EventManager::ExecutePriority::HIGHEST_PRIORITY;

      std::shared_ptr<OutputSignalQueue> getQueue() const;

    private:
      std::shared_ptr<OutputSignalQueue> m_output_queue;
      std::shared_ptr<OutputHandler> m_output_handler;
      std::vector<std::shared_ptr<openplx::Physics::Signals::Output>> m_outputs;
  };
}
