#pragma once

#include <string>
#include <vector>
#include <optional>
#include <agxOpenPLX/export.h>


#ifdef _MSC_VER
# pragma warning(push)
# pragma warning(disable: 4251) // warning C4251: class X needs to have dll-interface to be used by clients of class Y
#endif

namespace agxopenplx {
  /**
   * modelName - if set a specific model from the source/file will be loaded instead of the default
   * uuidv5NamespaceId - if set objects will be assigned version 5 UUIDs based on the namespace id
   *     and the object name instead of the default version 4 UUID.
   * mapVisuals - if set, visuals are included in the mapping.
   * debugRenderFrames - If set mate connectors are visualized in 3D
   * bundlePath(s) - Extra bundle paths to use when loading the .openplx file
   * skipDefaultBundles - If set the default standard bundles are not included when loading the .openplx file
   */
  class AGXOPENPLX_EXPORT OptParams
  {
    public:
      OptParams withModelName(std::string modelName);
      OptParams withUuidv5(std::string uuidv5NamespaceId);
      OptParams withMapVisuals(bool mapVisuals = true);
      OptParams withDebugRenderFrames(bool debugRenderFrames = true);
      OptParams withBundlePath(std::string bundlePath);
      OptParams withBundlePaths(const std::vector<std::string>& bundlePaths);
      OptParams withSkipDefaultBundles(bool skipDefaultBundles = true);
      OptParams withDebugLogs(bool debugLogsEnabled = true);

      const std::optional<std::string>& modelName() const;
      const std::optional<std::string>& uuidv5NamespaceId() const;
      const std::vector<std::string>& bundlePaths() const;
      bool mapVisuals() const;
      bool debugRenderFrames() const;
      bool skipDefaultBundles() const;
      bool debugLogsEnabled() const;

    private:
      std::optional<std::string> m_modelName = std::nullopt;
      std::optional<std::string> m_uuidv5NamespaceId = std::nullopt;
      std::vector<std::string> m_bundlePaths;
      bool m_mapVisuals { false };
      bool m_debugRenderFrames { false };
      bool m_skipDefaultBundles { false };
      bool m_debugLogsEnabled { false };
  };
}

#ifdef _MSC_VER
# pragma warning(pop)
#endif
