/*
Copyright 2007-2025. Algoryx Simulation AB.

All AGX source code, intellectual property, documentation, sample code,
tutorials, scene files and technical white papers, are copyrighted, proprietary
and confidential material of Algoryx Simulation AB. You may not download, read,
store, distribute, publish, copy or otherwise disseminate, use or expose this
material unless having a written signed agreement with Algoryx Simulation AB, or
having been advised so by Algoryx Simulation AB for a time limited evaluation,
or having purchased a valid commercial license from Algoryx Simulation AB.

Algoryx Simulation AB disclaims all responsibilities for loss or damage caused
from using this software, unless otherwise stated in written agreements with
Algoryx Simulation AB.
*/


/////////////////////////////////////////////////////////////////////
// AUTOMATICALLY GENERATED, DO NOT EDIT! (except inline functions) //
/////////////////////////////////////////////////////////////////////

#ifndef AGXFN_PHYSICS_RIGIDBODY_SOLVER_ALLOCATECONSTRAINTDATA_H
#define AGXFN_PHYSICS_RIGIDBODY_SOLVER_ALLOCATECONSTRAINTDATA_H

#include <agxData/Array.h>
#include <agxData/EntityPtr.h>
#include <agx/Integer.h>
#include <agx/Real.h>
#include <agx/Math.h>
#include <agx/Job.h>
#include <agx/Physics/GeometryContactEntity.h>
#include <agx/Physics/GraphNodeEntity.h>
#include <agx/Physics/ContactMaterialEntity.h>
#include <agx/Physics/GeometryEntity.h>
#include <agx/Physics/RigidBodyEntity.h>
#include <agx/Physics/ContactPointEntity.h>
#include <agx/Physics/BroadPhasePairEntity.h>
#include <agx/SpinMutex.h>
#include <agx/Physics/MaterialEntity.h>
#include <agx/Vec2.h>
#include <agx/Vec3.h>
#include <agx/Physics/ContactConstraintEntity.h>
#include <agx/IndexRange.h>
#include <agx/RigidBodyState.h>
#include <agx/Name.h>
#include <agx/SPDMatrix3x3.h>
#include <agx/Matrix3x3.h>
#include <agx/AffineMatrix4x4.h>
#include <agx/Range6.h>
#include <agx/Physics/BinaryConstraintEntity.h>
#include <agx/Physics/ManyBodyConstraintEntity.h>
#include <agx/Jacobian.h>


namespace agx { namespace Physics { namespace RigidBody { namespace Solver { } } } }

namespace agxFn
{
  namespace Physics
  {
    namespace RigidBody
    {
      namespace Solver
      {
        /**
        Function: Physics.RigidBody.Solver.AllocateConstraintData
        Implementation: Contact

        \param activeGeometryContacts 
        \param geometryContact 
        \param contactMaterial 
        \param contactConstraint 
        \param contactConstraintRowStorage 
        \param contactConstraintJacobianStorage 
        \param contactConstraintGMInvStorage 
        \param rigidBody 
        \param numGeometryContactsUsingPPGS 
        */
        void AllocateConstraintData__Contact
        (
          /* Parameter list automatically generated, do not edit */
          const agxData::Array< agx::UInt32 >& activeGeometryContacts,
          agx::Physics::GeometryContactData& geometryContact,
          agx::Physics::ContactMaterialData& contactMaterial,
          agx::Physics::ContactConstraintData& contactConstraint,
          agxData::EntityStorage* contactConstraintRowStorage,
          agxData::Buffer* contactConstraintJacobianStorage,
          agxData::Buffer* contactConstraintGMInvStorage,
          agx::Physics::RigidBodyData& rigidBody,
          const agx::UInt& numGeometryContactsUsingPPGS
        );


        /**
        Function: Physics.RigidBody.Solver.AllocateConstraintData
        Implementation: BinaryConstraint

        \param binaryConstraint 
        \param binaryConstraintRowStorage 
        \param binaryConstraintJacobianStorage 
        \param binaryConstraintGMInvStorage 
        */
        void AllocateConstraintData__BinaryConstraint
        (
          /* Parameter list automatically generated, do not edit */
          agx::Physics::BinaryConstraintData& binaryConstraint,
          agxData::EntityStorage* binaryConstraintRowStorage,
          agxData::Buffer* binaryConstraintJacobianStorage,
          agxData::Buffer* binaryConstraintGMInvStorage
        );


        /**
        Function: Physics.RigidBody.Solver.AllocateConstraintData
        Implementation: ManyBodyConstraint

        \param manyBodyConstraint 
        \param manyBodyConstraintRowStorage 
        \param manyBodyConstraintJacobianStorage 
        \param manyBodyConstraintGMInvStorage 
        \param manyBodyConstraintJacobian 
        */
        void AllocateConstraintData__ManyBodyConstraint
        (
          /* Parameter list automatically generated, do not edit */
          agx::Physics::ManyBodyConstraintData& manyBodyConstraint,
          agxData::EntityStorage* manyBodyConstraintRowStorage,
          agxData::Buffer* manyBodyConstraintJacobianStorage,
          agxData::Buffer* manyBodyConstraintGMInvStorage,
          agxData::Array< agx::Jacobian6DOFElement >& manyBodyConstraintJacobian
        );


      }
    }
  }
}

#endif
