%define OPENPLX_SWIG_NS_IMPORT_PARENT_DEPENDENCIES_Terrain()
%enddef

%define OPENPLX_SWIG_NS_MODULE_H_DEPENDENCIES_Terrain()
%{
#include <openplx/Math/Math_all.h>
#include <openplx/Physics/Physics_all.h>
#include <openplx/Physics3D/Physics3D_all.h>
#include <openplx/Terrain/Terrain_all.h>
%}
%enddef

%define OPENPLX_SWIG_NS_RENAMES_Terrain(prefix)
%rename(prefix ## Shovel) openplx::Terrain::Shovel;
%rename(prefix ## Terrain) openplx::Terrain::Terrain;
%rename(prefix ## TerrainMaterial) openplx::Terrain::TerrainMaterial;
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTERS_Terrain()
%shared_ptr(openplx::Terrain::Shovel);
%shared_ptr(openplx::Terrain::Terrain);
%shared_ptr(openplx::Terrain::TerrainMaterial);
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Terrain()
%typemap(out) std::shared_ptr<openplx::Terrain::Shovel> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Terrain::Terrain> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Terrain::TerrainMaterial> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%enddef

%define OPENPLX_SWIG_NS_VECTORS_Terrain()
%template(Terrain_Shovel_Vector) std::vector<std::shared_ptr<openplx::Terrain::Shovel>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Terrain::Shovel>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Terrain::Shovel>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Terrain::Shovel>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Terrain::Shovel>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Terrain::Shovel>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Terrain::Shovel>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Terrain_Terrain_Vector) std::vector<std::shared_ptr<openplx::Terrain::Terrain>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Terrain::Terrain>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Terrain::Terrain>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Terrain::Terrain>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Terrain::Terrain>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Terrain::Terrain>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Terrain::Terrain>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Terrain_TerrainMaterial_Vector) std::vector<std::shared_ptr<openplx::Terrain::TerrainMaterial>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Terrain::TerrainMaterial>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Terrain::TerrainMaterial>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Terrain::TerrainMaterial>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Terrain::TerrainMaterial>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Terrain::TerrainMaterial>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Terrain::TerrainMaterial>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%enddef

%define OPENPLX_SWIG_NS_INCLUDES_Terrain()
%include "openplx/Terrain/Shovel.h"
%include "openplx/Terrain/Terrain.h"
%include "openplx/Terrain/TerrainMaterial.h"
%enddef

%define OPENPLX_SWIG_NS_PY_IMPORTS_Terrain()
%pythoncode %{
from . import MaterialLibrary
%}
%enddef

%define OPENPLX_SWIG_NS_IMPORT_PARENT_DEPENDENCIES_Terrain_MaterialLibrary()
%import "Terrain.i"
%enddef

%define OPENPLX_SWIG_NS_MODULE_H_DEPENDENCIES_Terrain_MaterialLibrary()
%{
#include <openplx/Math/Math_all.h>
#include <openplx/Physics/Physics_all.h>
#include <openplx/Physics3D/Physics3D_all.h>
#include <openplx/Terrain/Terrain_all.h>
%}
%enddef

%define OPENPLX_SWIG_NS_RENAMES_Terrain_MaterialLibrary(prefix)
%rename(prefix ## defaultTerrainMaterial) openplx::Terrain::MaterialLibrary::defaultTerrainMaterial;
%rename(prefix ## dirt_1) openplx::Terrain::MaterialLibrary::dirt_1;
%rename(prefix ## gravel_1) openplx::Terrain::MaterialLibrary::gravel_1;
%rename(prefix ## iron_pellets) openplx::Terrain::MaterialLibrary::iron_pellets;
%rename(prefix ## sand_1) openplx::Terrain::MaterialLibrary::sand_1;
%rename(prefix ## wet_sand) openplx::Terrain::MaterialLibrary::wet_sand;
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTERS_Terrain_MaterialLibrary()
%shared_ptr(openplx::Terrain::MaterialLibrary::defaultTerrainMaterial);
%shared_ptr(openplx::Terrain::MaterialLibrary::dirt_1);
%shared_ptr(openplx::Terrain::MaterialLibrary::gravel_1);
%shared_ptr(openplx::Terrain::MaterialLibrary::iron_pellets);
%shared_ptr(openplx::Terrain::MaterialLibrary::sand_1);
%shared_ptr(openplx::Terrain::MaterialLibrary::wet_sand);
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Terrain_MaterialLibrary()
%typemap(out) std::shared_ptr<openplx::Terrain::MaterialLibrary::defaultTerrainMaterial> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Terrain::MaterialLibrary::dirt_1> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Terrain::MaterialLibrary::gravel_1> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Terrain::MaterialLibrary::iron_pellets> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Terrain::MaterialLibrary::sand_1> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Terrain::MaterialLibrary::wet_sand> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%enddef

%define OPENPLX_SWIG_NS_VECTORS_Terrain_MaterialLibrary()
%template(Terrain_MaterialLibrary_defaultTerrainMaterial_Vector) std::vector<std::shared_ptr<openplx::Terrain::MaterialLibrary::defaultTerrainMaterial>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Terrain::MaterialLibrary::defaultTerrainMaterial>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Terrain::MaterialLibrary::defaultTerrainMaterial>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Terrain::MaterialLibrary::defaultTerrainMaterial>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Terrain::MaterialLibrary::defaultTerrainMaterial>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Terrain::MaterialLibrary::defaultTerrainMaterial>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Terrain::MaterialLibrary::defaultTerrainMaterial>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Terrain_MaterialLibrary_dirt_1_Vector) std::vector<std::shared_ptr<openplx::Terrain::MaterialLibrary::dirt_1>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Terrain::MaterialLibrary::dirt_1>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Terrain::MaterialLibrary::dirt_1>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Terrain::MaterialLibrary::dirt_1>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Terrain::MaterialLibrary::dirt_1>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Terrain::MaterialLibrary::dirt_1>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Terrain::MaterialLibrary::dirt_1>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Terrain_MaterialLibrary_gravel_1_Vector) std::vector<std::shared_ptr<openplx::Terrain::MaterialLibrary::gravel_1>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Terrain::MaterialLibrary::gravel_1>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Terrain::MaterialLibrary::gravel_1>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Terrain::MaterialLibrary::gravel_1>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Terrain::MaterialLibrary::gravel_1>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Terrain::MaterialLibrary::gravel_1>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Terrain::MaterialLibrary::gravel_1>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Terrain_MaterialLibrary_iron_pellets_Vector) std::vector<std::shared_ptr<openplx::Terrain::MaterialLibrary::iron_pellets>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Terrain::MaterialLibrary::iron_pellets>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Terrain::MaterialLibrary::iron_pellets>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Terrain::MaterialLibrary::iron_pellets>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Terrain::MaterialLibrary::iron_pellets>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Terrain::MaterialLibrary::iron_pellets>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Terrain::MaterialLibrary::iron_pellets>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Terrain_MaterialLibrary_sand_1_Vector) std::vector<std::shared_ptr<openplx::Terrain::MaterialLibrary::sand_1>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Terrain::MaterialLibrary::sand_1>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Terrain::MaterialLibrary::sand_1>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Terrain::MaterialLibrary::sand_1>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Terrain::MaterialLibrary::sand_1>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Terrain::MaterialLibrary::sand_1>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Terrain::MaterialLibrary::sand_1>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Terrain_MaterialLibrary_wet_sand_Vector) std::vector<std::shared_ptr<openplx::Terrain::MaterialLibrary::wet_sand>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Terrain::MaterialLibrary::wet_sand>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Terrain::MaterialLibrary::wet_sand>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Terrain::MaterialLibrary::wet_sand>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Terrain::MaterialLibrary::wet_sand>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Terrain::MaterialLibrary::wet_sand>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Terrain::MaterialLibrary::wet_sand>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%enddef

%define OPENPLX_SWIG_NS_INCLUDES_Terrain_MaterialLibrary()
%include "openplx/Terrain/MaterialLibrary/defaultTerrainMaterial.h"
%include "openplx/Terrain/MaterialLibrary/dirt_1.h"
%include "openplx/Terrain/MaterialLibrary/gravel_1.h"
%include "openplx/Terrain/MaterialLibrary/iron_pellets.h"
%include "openplx/Terrain/MaterialLibrary/sand_1.h"
%include "openplx/Terrain/MaterialLibrary/wet_sand.h"
%enddef

%define OPENPLX_SWIG_NS_PY_IMPORTS_Terrain_MaterialLibrary()
%pythoncode %{
%}
%enddef

%define OPENPLX_SWIG_BUNDLE_INCLUDE_H_DEPENDENCIES_Terrain()
%{
#include <openplx/Math/Math_all.h>
#include <openplx/Physics/Physics_all.h>
#include <openplx/Physics3D/Physics3D_all.h>
#include <openplx/Terrain/Terrain_all.h>
%}
%enddef

%define OPENPLX_SWIG_BUNDLE_IMPORT_Terrain()
%import "Terrain.i"
%import "Terrain_MaterialLibrary.i"
%enddef

%define OPENPLX_SWIG_BUNDLE_IMPORT_DEPENDENCIES_Terrain()
%include <python/Math/Math.i>
OPENPLX_SWIG_BUNDLE_IMPORT_Math();
%include <python/Physics/Physics.i>
OPENPLX_SWIG_BUNDLE_IMPORT_Physics();
%include <python/Physics3D/Physics3D.i>
OPENPLX_SWIG_BUNDLE_IMPORT_Physics3D();
%enddef

%define OPENPLX_SWIG_BUNDLE_IMPORT_FLAT_DEPENDENCIES_Terrain()
%import "Math.i"
%import "Physics.i"
%import "Physics3D.i"
%enddef

%define OPENPLX_SWIG_BUNDLE_RENAMES_Terrain(prefix)
OPENPLX_SWIG_NS_RENAMES_Terrain(prefix);
OPENPLX_SWIG_NS_RENAMES_Terrain_MaterialLibrary(prefix ## MaterialLibrary_);
%enddef

%define OPENPLX_SWIG_BUNDLE_SHARED_POINTERS_Terrain()
OPENPLX_SWIG_NS_SHARED_POINTERS_Terrain();
OPENPLX_SWIG_NS_SHARED_POINTERS_Terrain_MaterialLibrary();
%enddef

%define OPENPLX_SWIG_BUNDLE_SHARED_POINTER_DOWNCASTS_Terrain()
OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Terrain();
OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Terrain_MaterialLibrary();
%enddef

%define OPENPLX_SWIG_BUNDLE_VECTORS_Terrain()
OPENPLX_SWIG_NS_VECTORS_Terrain();
OPENPLX_SWIG_NS_VECTORS_Terrain_MaterialLibrary();
%enddef

%define OPENPLX_SWIG_BUNDLE_INCLUDES_Terrain()
OPENPLX_SWIG_NS_INCLUDES_Terrain();
OPENPLX_SWIG_NS_INCLUDES_Terrain_MaterialLibrary();
%enddef

