%define OPENPLX_SWIG_NS_IMPORT_PARENT_DEPENDENCIES_Sensors()
%enddef

%define OPENPLX_SWIG_NS_MODULE_H_DEPENDENCIES_Sensors()
%{
#include <openplx/DriveTrain/DriveTrain_all.h>
#include <openplx/Math/Math_all.h>
#include <openplx/Physics/Physics_all.h>
#include <openplx/Physics1D/Physics1D_all.h>
#include <openplx/Physics3D/Physics3D_all.h>
#include <openplx/Sensors/Sensors_all.h>
%}
%enddef

%define OPENPLX_SWIG_NS_RENAMES_Sensors(prefix)
%rename(prefix ## AccelerometerLogic) openplx::Sensors::AccelerometerLogic;
%rename(prefix ## AccelerometerSensingDistortion) openplx::Sensors::AccelerometerSensingDistortion;
%rename(prefix ## AccelerometerSignalGaussianNoise) openplx::Sensors::AccelerometerSignalGaussianNoise;
%rename(prefix ## AccelerometerSignalSpectralGaussianNoise) openplx::Sensors::AccelerometerSignalSpectralGaussianNoise;
%rename(prefix ## Distortion) openplx::Sensors::Distortion;
%rename(prefix ## GyroscopeLogic) openplx::Sensors::GyroscopeLogic;
%rename(prefix ## GyroscopeSensingDistortion) openplx::Sensors::GyroscopeSensingDistortion;
%rename(prefix ## GyroscopeSignalGaussianNoise) openplx::Sensors::GyroscopeSignalGaussianNoise;
%rename(prefix ## GyroscopeSignalLinearAccelectionEffect) openplx::Sensors::GyroscopeSignalLinearAccelectionEffect;
%rename(prefix ## GyroscopeSignalSpectralGaussianNoise) openplx::Sensors::GyroscopeSignalSpectralGaussianNoise;
%rename(prefix ## LidarDetectionDistanceGaussianNoise) openplx::Sensors::LidarDetectionDistanceGaussianNoise;
%rename(prefix ## LidarLogic) openplx::Sensors::LidarLogic;
%rename(prefix ## LidarSensingDistortion) openplx::Sensors::LidarSensingDistortion;
%rename(prefix ## MagnetometerLogic) openplx::Sensors::MagnetometerLogic;
%rename(prefix ## MagnetometerSensingDistortion) openplx::Sensors::MagnetometerSensingDistortion;
%rename(prefix ## MagnetometerSignalGaussianNoise) openplx::Sensors::MagnetometerSignalGaussianNoise;
%rename(prefix ## MagnetometerSignalSpectralGaussianNoise) openplx::Sensors::MagnetometerSignalSpectralGaussianNoise;
%rename(prefix ## PulsedLidarLogic) openplx::Sensors::PulsedLidarLogic;
%rename(prefix ## SensorLogic) openplx::Sensors::SensorLogic;
%rename(prefix ## TriaxialRange) openplx::Sensors::TriaxialRange;
%rename(prefix ## TriaxialSensorLogic) openplx::Sensors::TriaxialSensorLogic;
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTERS_Sensors()
%shared_ptr(openplx::Sensors::AccelerometerLogic);
%shared_ptr(openplx::Sensors::AccelerometerSensingDistortion);
%shared_ptr(openplx::Sensors::AccelerometerSignalGaussianNoise);
%shared_ptr(openplx::Sensors::AccelerometerSignalSpectralGaussianNoise);
%shared_ptr(openplx::Sensors::Distortion);
%shared_ptr(openplx::Sensors::GyroscopeLogic);
%shared_ptr(openplx::Sensors::GyroscopeSensingDistortion);
%shared_ptr(openplx::Sensors::GyroscopeSignalGaussianNoise);
%shared_ptr(openplx::Sensors::GyroscopeSignalLinearAccelectionEffect);
%shared_ptr(openplx::Sensors::GyroscopeSignalSpectralGaussianNoise);
%shared_ptr(openplx::Sensors::LidarDetectionDistanceGaussianNoise);
%shared_ptr(openplx::Sensors::LidarLogic);
%shared_ptr(openplx::Sensors::LidarSensingDistortion);
%shared_ptr(openplx::Sensors::MagnetometerLogic);
%shared_ptr(openplx::Sensors::MagnetometerSensingDistortion);
%shared_ptr(openplx::Sensors::MagnetometerSignalGaussianNoise);
%shared_ptr(openplx::Sensors::MagnetometerSignalSpectralGaussianNoise);
%shared_ptr(openplx::Sensors::PulsedLidarLogic);
%shared_ptr(openplx::Sensors::SensorLogic);
%shared_ptr(openplx::Sensors::TriaxialRange);
%shared_ptr(openplx::Sensors::TriaxialSensorLogic);
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Sensors()
%typemap(out) std::shared_ptr<openplx::Sensors::AccelerometerLogic> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Sensors::AccelerometerSensingDistortion> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Sensors::AccelerometerSignalGaussianNoise> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Sensors::AccelerometerSignalSpectralGaussianNoise> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Sensors::Distortion> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Sensors::GyroscopeLogic> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Sensors::GyroscopeSensingDistortion> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Sensors::GyroscopeSignalGaussianNoise> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Sensors::GyroscopeSignalLinearAccelectionEffect> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Sensors::GyroscopeSignalSpectralGaussianNoise> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Sensors::LidarDetectionDistanceGaussianNoise> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Sensors::LidarLogic> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Sensors::LidarSensingDistortion> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Sensors::MagnetometerLogic> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Sensors::MagnetometerSensingDistortion> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Sensors::MagnetometerSignalGaussianNoise> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Sensors::MagnetometerSignalSpectralGaussianNoise> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Sensors::PulsedLidarLogic> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Sensors::SensorLogic> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Sensors::TriaxialRange> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Sensors::TriaxialSensorLogic> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%enddef

%define OPENPLX_SWIG_NS_VECTORS_Sensors()
%template(Sensors_AccelerometerLogic_Vector) std::vector<std::shared_ptr<openplx::Sensors::AccelerometerLogic>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Sensors::AccelerometerLogic>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Sensors::AccelerometerLogic>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Sensors::AccelerometerLogic>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Sensors::AccelerometerLogic>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Sensors::AccelerometerLogic>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Sensors::AccelerometerLogic>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Sensors_AccelerometerSensingDistortion_Vector) std::vector<std::shared_ptr<openplx::Sensors::AccelerometerSensingDistortion>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Sensors::AccelerometerSensingDistortion>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Sensors::AccelerometerSensingDistortion>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Sensors::AccelerometerSensingDistortion>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Sensors::AccelerometerSensingDistortion>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Sensors::AccelerometerSensingDistortion>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Sensors::AccelerometerSensingDistortion>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Sensors_AccelerometerSignalGaussianNoise_Vector) std::vector<std::shared_ptr<openplx::Sensors::AccelerometerSignalGaussianNoise>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Sensors::AccelerometerSignalGaussianNoise>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Sensors::AccelerometerSignalGaussianNoise>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Sensors::AccelerometerSignalGaussianNoise>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Sensors::AccelerometerSignalGaussianNoise>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Sensors::AccelerometerSignalGaussianNoise>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Sensors::AccelerometerSignalGaussianNoise>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Sensors_AccelerometerSignalSpectralGaussianNoise_Vector) std::vector<std::shared_ptr<openplx::Sensors::AccelerometerSignalSpectralGaussianNoise>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Sensors::AccelerometerSignalSpectralGaussianNoise>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Sensors::AccelerometerSignalSpectralGaussianNoise>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Sensors::AccelerometerSignalSpectralGaussianNoise>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Sensors::AccelerometerSignalSpectralGaussianNoise>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Sensors::AccelerometerSignalSpectralGaussianNoise>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Sensors::AccelerometerSignalSpectralGaussianNoise>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Sensors_Distortion_Vector) std::vector<std::shared_ptr<openplx::Sensors::Distortion>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Sensors::Distortion>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Sensors::Distortion>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Sensors::Distortion>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Sensors::Distortion>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Sensors::Distortion>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Sensors::Distortion>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Sensors_GyroscopeLogic_Vector) std::vector<std::shared_ptr<openplx::Sensors::GyroscopeLogic>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Sensors::GyroscopeLogic>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Sensors::GyroscopeLogic>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Sensors::GyroscopeLogic>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Sensors::GyroscopeLogic>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Sensors::GyroscopeLogic>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Sensors::GyroscopeLogic>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Sensors_GyroscopeSensingDistortion_Vector) std::vector<std::shared_ptr<openplx::Sensors::GyroscopeSensingDistortion>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Sensors::GyroscopeSensingDistortion>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Sensors::GyroscopeSensingDistortion>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Sensors::GyroscopeSensingDistortion>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Sensors::GyroscopeSensingDistortion>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Sensors::GyroscopeSensingDistortion>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Sensors::GyroscopeSensingDistortion>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Sensors_GyroscopeSignalGaussianNoise_Vector) std::vector<std::shared_ptr<openplx::Sensors::GyroscopeSignalGaussianNoise>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Sensors::GyroscopeSignalGaussianNoise>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Sensors::GyroscopeSignalGaussianNoise>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Sensors::GyroscopeSignalGaussianNoise>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Sensors::GyroscopeSignalGaussianNoise>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Sensors::GyroscopeSignalGaussianNoise>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Sensors::GyroscopeSignalGaussianNoise>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Sensors_GyroscopeSignalLinearAccelectionEffect_Vector) std::vector<std::shared_ptr<openplx::Sensors::GyroscopeSignalLinearAccelectionEffect>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Sensors::GyroscopeSignalLinearAccelectionEffect>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Sensors::GyroscopeSignalLinearAccelectionEffect>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Sensors::GyroscopeSignalLinearAccelectionEffect>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Sensors::GyroscopeSignalLinearAccelectionEffect>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Sensors::GyroscopeSignalLinearAccelectionEffect>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Sensors::GyroscopeSignalLinearAccelectionEffect>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Sensors_GyroscopeSignalSpectralGaussianNoise_Vector) std::vector<std::shared_ptr<openplx::Sensors::GyroscopeSignalSpectralGaussianNoise>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Sensors::GyroscopeSignalSpectralGaussianNoise>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Sensors::GyroscopeSignalSpectralGaussianNoise>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Sensors::GyroscopeSignalSpectralGaussianNoise>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Sensors::GyroscopeSignalSpectralGaussianNoise>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Sensors::GyroscopeSignalSpectralGaussianNoise>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Sensors::GyroscopeSignalSpectralGaussianNoise>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Sensors_LidarDetectionDistanceGaussianNoise_Vector) std::vector<std::shared_ptr<openplx::Sensors::LidarDetectionDistanceGaussianNoise>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Sensors::LidarDetectionDistanceGaussianNoise>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Sensors::LidarDetectionDistanceGaussianNoise>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Sensors::LidarDetectionDistanceGaussianNoise>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Sensors::LidarDetectionDistanceGaussianNoise>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Sensors::LidarDetectionDistanceGaussianNoise>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Sensors::LidarDetectionDistanceGaussianNoise>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Sensors_LidarLogic_Vector) std::vector<std::shared_ptr<openplx::Sensors::LidarLogic>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Sensors::LidarLogic>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Sensors::LidarLogic>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Sensors::LidarLogic>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Sensors::LidarLogic>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Sensors::LidarLogic>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Sensors::LidarLogic>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Sensors_LidarSensingDistortion_Vector) std::vector<std::shared_ptr<openplx::Sensors::LidarSensingDistortion>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Sensors::LidarSensingDistortion>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Sensors::LidarSensingDistortion>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Sensors::LidarSensingDistortion>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Sensors::LidarSensingDistortion>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Sensors::LidarSensingDistortion>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Sensors::LidarSensingDistortion>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Sensors_MagnetometerLogic_Vector) std::vector<std::shared_ptr<openplx::Sensors::MagnetometerLogic>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Sensors::MagnetometerLogic>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Sensors::MagnetometerLogic>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Sensors::MagnetometerLogic>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Sensors::MagnetometerLogic>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Sensors::MagnetometerLogic>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Sensors::MagnetometerLogic>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Sensors_MagnetometerSensingDistortion_Vector) std::vector<std::shared_ptr<openplx::Sensors::MagnetometerSensingDistortion>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Sensors::MagnetometerSensingDistortion>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Sensors::MagnetometerSensingDistortion>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Sensors::MagnetometerSensingDistortion>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Sensors::MagnetometerSensingDistortion>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Sensors::MagnetometerSensingDistortion>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Sensors::MagnetometerSensingDistortion>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Sensors_MagnetometerSignalGaussianNoise_Vector) std::vector<std::shared_ptr<openplx::Sensors::MagnetometerSignalGaussianNoise>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Sensors::MagnetometerSignalGaussianNoise>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Sensors::MagnetometerSignalGaussianNoise>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Sensors::MagnetometerSignalGaussianNoise>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Sensors::MagnetometerSignalGaussianNoise>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Sensors::MagnetometerSignalGaussianNoise>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Sensors::MagnetometerSignalGaussianNoise>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Sensors_MagnetometerSignalSpectralGaussianNoise_Vector) std::vector<std::shared_ptr<openplx::Sensors::MagnetometerSignalSpectralGaussianNoise>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Sensors::MagnetometerSignalSpectralGaussianNoise>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Sensors::MagnetometerSignalSpectralGaussianNoise>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Sensors::MagnetometerSignalSpectralGaussianNoise>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Sensors::MagnetometerSignalSpectralGaussianNoise>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Sensors::MagnetometerSignalSpectralGaussianNoise>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Sensors::MagnetometerSignalSpectralGaussianNoise>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Sensors_PulsedLidarLogic_Vector) std::vector<std::shared_ptr<openplx::Sensors::PulsedLidarLogic>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Sensors::PulsedLidarLogic>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Sensors::PulsedLidarLogic>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Sensors::PulsedLidarLogic>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Sensors::PulsedLidarLogic>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Sensors::PulsedLidarLogic>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Sensors::PulsedLidarLogic>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Sensors_SensorLogic_Vector) std::vector<std::shared_ptr<openplx::Sensors::SensorLogic>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Sensors::SensorLogic>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Sensors::SensorLogic>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Sensors::SensorLogic>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Sensors::SensorLogic>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Sensors::SensorLogic>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Sensors::SensorLogic>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Sensors_TriaxialRange_Vector) std::vector<std::shared_ptr<openplx::Sensors::TriaxialRange>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Sensors::TriaxialRange>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Sensors::TriaxialRange>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Sensors::TriaxialRange>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Sensors::TriaxialRange>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Sensors::TriaxialRange>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Sensors::TriaxialRange>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Sensors_TriaxialSensorLogic_Vector) std::vector<std::shared_ptr<openplx::Sensors::TriaxialSensorLogic>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Sensors::TriaxialSensorLogic>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Sensors::TriaxialSensorLogic>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Sensors::TriaxialSensorLogic>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Sensors::TriaxialSensorLogic>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Sensors::TriaxialSensorLogic>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Sensors::TriaxialSensorLogic>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%enddef

%define OPENPLX_SWIG_NS_INCLUDES_Sensors()
%include "openplx/Sensors/SensorLogic.h"
%include "openplx/Sensors/TriaxialSensorLogic.h"
%include "openplx/Sensors/AccelerometerLogic.h"
%include "openplx/Sensors/Distortion.h"
%include "openplx/Sensors/AccelerometerSensingDistortion.h"
%include "openplx/Sensors/AccelerometerSignalGaussianNoise.h"
%include "openplx/Sensors/AccelerometerSignalSpectralGaussianNoise.h"
%include "openplx/Sensors/GyroscopeLogic.h"
%include "openplx/Sensors/GyroscopeSensingDistortion.h"
%include "openplx/Sensors/GyroscopeSignalGaussianNoise.h"
%include "openplx/Sensors/GyroscopeSignalLinearAccelectionEffect.h"
%include "openplx/Sensors/GyroscopeSignalSpectralGaussianNoise.h"
%include "openplx/Sensors/LidarSensingDistortion.h"
%include "openplx/Sensors/LidarDetectionDistanceGaussianNoise.h"
%include "openplx/Sensors/LidarLogic.h"
%include "openplx/Sensors/MagnetometerLogic.h"
%include "openplx/Sensors/MagnetometerSensingDistortion.h"
%include "openplx/Sensors/MagnetometerSignalGaussianNoise.h"
%include "openplx/Sensors/MagnetometerSignalSpectralGaussianNoise.h"
%include "openplx/Sensors/PulsedLidarLogic.h"
%include "openplx/Sensors/TriaxialRange.h"
%enddef

%define OPENPLX_SWIG_NS_PY_IMPORTS_Sensors()
%pythoncode %{
from . import Library
from . import Optics
from . import Signals
%}
%enddef

%define OPENPLX_SWIG_NS_IMPORT_PARENT_DEPENDENCIES_Sensors_Library_LIDARs_Ouster()
%enddef

%define OPENPLX_SWIG_NS_MODULE_H_DEPENDENCIES_Sensors_Library_LIDARs_Ouster()
%{
#include <openplx/DriveTrain/DriveTrain_all.h>
#include <openplx/Math/Math_all.h>
#include <openplx/Physics/Physics_all.h>
#include <openplx/Physics1D/Physics1D_all.h>
#include <openplx/Physics3D/Physics3D_all.h>
#include <openplx/Sensors/Sensors_all.h>
%}
%enddef

%define OPENPLX_SWIG_NS_RENAMES_Sensors_Library_LIDARs_Ouster(prefix)
%rename(prefix ## OS0) openplx::Sensors::Library::LIDARs::Ouster::OS0;
%rename(prefix ## OS1) openplx::Sensors::Library::LIDARs::Ouster::OS1;
%rename(prefix ## OS2) openplx::Sensors::Library::LIDARs::Ouster::OS2;
%rename(prefix ## OSDome) openplx::Sensors::Library::LIDARs::Ouster::OSDome;
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTERS_Sensors_Library_LIDARs_Ouster()
%shared_ptr(openplx::Sensors::Library::LIDARs::Ouster::OS0);
%shared_ptr(openplx::Sensors::Library::LIDARs::Ouster::OS1);
%shared_ptr(openplx::Sensors::Library::LIDARs::Ouster::OS2);
%shared_ptr(openplx::Sensors::Library::LIDARs::Ouster::OSDome);
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Sensors_Library_LIDARs_Ouster()
%typemap(out) std::shared_ptr<openplx::Sensors::Library::LIDARs::Ouster::OS0> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Sensors::Library::LIDARs::Ouster::OS1> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Sensors::Library::LIDARs::Ouster::OS2> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Sensors::Library::LIDARs::Ouster::OSDome> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%enddef

%define OPENPLX_SWIG_NS_VECTORS_Sensors_Library_LIDARs_Ouster()
%template(Sensors_Library_LIDARs_Ouster_OS0_Vector) std::vector<std::shared_ptr<openplx::Sensors::Library::LIDARs::Ouster::OS0>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Sensors::Library::LIDARs::Ouster::OS0>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Sensors::Library::LIDARs::Ouster::OS0>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Sensors::Library::LIDARs::Ouster::OS0>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Sensors::Library::LIDARs::Ouster::OS0>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Sensors::Library::LIDARs::Ouster::OS0>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Sensors::Library::LIDARs::Ouster::OS0>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Sensors_Library_LIDARs_Ouster_OS1_Vector) std::vector<std::shared_ptr<openplx::Sensors::Library::LIDARs::Ouster::OS1>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Sensors::Library::LIDARs::Ouster::OS1>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Sensors::Library::LIDARs::Ouster::OS1>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Sensors::Library::LIDARs::Ouster::OS1>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Sensors::Library::LIDARs::Ouster::OS1>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Sensors::Library::LIDARs::Ouster::OS1>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Sensors::Library::LIDARs::Ouster::OS1>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Sensors_Library_LIDARs_Ouster_OS2_Vector) std::vector<std::shared_ptr<openplx::Sensors::Library::LIDARs::Ouster::OS2>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Sensors::Library::LIDARs::Ouster::OS2>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Sensors::Library::LIDARs::Ouster::OS2>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Sensors::Library::LIDARs::Ouster::OS2>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Sensors::Library::LIDARs::Ouster::OS2>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Sensors::Library::LIDARs::Ouster::OS2>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Sensors::Library::LIDARs::Ouster::OS2>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Sensors_Library_LIDARs_Ouster_OSDome_Vector) std::vector<std::shared_ptr<openplx::Sensors::Library::LIDARs::Ouster::OSDome>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Sensors::Library::LIDARs::Ouster::OSDome>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Sensors::Library::LIDARs::Ouster::OSDome>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Sensors::Library::LIDARs::Ouster::OSDome>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Sensors::Library::LIDARs::Ouster::OSDome>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Sensors::Library::LIDARs::Ouster::OSDome>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Sensors::Library::LIDARs::Ouster::OSDome>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%enddef

%define OPENPLX_SWIG_NS_INCLUDES_Sensors_Library_LIDARs_Ouster()
%include "openplx/Sensors/Library/LIDARs/Ouster/OS0.h"
%include "openplx/Sensors/Library/LIDARs/Ouster/OS1.h"
%include "openplx/Sensors/Library/LIDARs/Ouster/OS2.h"
%include "openplx/Sensors/Library/LIDARs/Ouster/OSDome.h"
%enddef

%define OPENPLX_SWIG_NS_PY_IMPORTS_Sensors_Library_LIDARs_Ouster()
%pythoncode %{
%}
%enddef

%define OPENPLX_SWIG_NS_IMPORT_PARENT_DEPENDENCIES_Sensors_Library_LIDARs_SICK()
%enddef

%define OPENPLX_SWIG_NS_MODULE_H_DEPENDENCIES_Sensors_Library_LIDARs_SICK()
%{
#include <openplx/DriveTrain/DriveTrain_all.h>
#include <openplx/Math/Math_all.h>
#include <openplx/Physics/Physics_all.h>
#include <openplx/Physics1D/Physics1D_all.h>
#include <openplx/Physics3D/Physics3D_all.h>
#include <openplx/Sensors/Sensors_all.h>
%}
%enddef

%define OPENPLX_SWIG_NS_RENAMES_Sensors_Library_LIDARs_SICK(prefix)
%rename(prefix ## TIM150) openplx::Sensors::Library::LIDARs::SICK::TIM150;
%rename(prefix ## TIM310) openplx::Sensors::Library::LIDARs::SICK::TIM310;
%rename(prefix ## TIM781) openplx::Sensors::Library::LIDARs::SICK::TIM781;
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTERS_Sensors_Library_LIDARs_SICK()
%shared_ptr(openplx::Sensors::Library::LIDARs::SICK::TIM150);
%shared_ptr(openplx::Sensors::Library::LIDARs::SICK::TIM310);
%shared_ptr(openplx::Sensors::Library::LIDARs::SICK::TIM781);
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Sensors_Library_LIDARs_SICK()
%typemap(out) std::shared_ptr<openplx::Sensors::Library::LIDARs::SICK::TIM150> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Sensors::Library::LIDARs::SICK::TIM310> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Sensors::Library::LIDARs::SICK::TIM781> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%enddef

%define OPENPLX_SWIG_NS_VECTORS_Sensors_Library_LIDARs_SICK()
%template(Sensors_Library_LIDARs_SICK_TIM150_Vector) std::vector<std::shared_ptr<openplx::Sensors::Library::LIDARs::SICK::TIM150>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Sensors::Library::LIDARs::SICK::TIM150>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Sensors::Library::LIDARs::SICK::TIM150>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Sensors::Library::LIDARs::SICK::TIM150>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Sensors::Library::LIDARs::SICK::TIM150>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Sensors::Library::LIDARs::SICK::TIM150>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Sensors::Library::LIDARs::SICK::TIM150>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Sensors_Library_LIDARs_SICK_TIM310_Vector) std::vector<std::shared_ptr<openplx::Sensors::Library::LIDARs::SICK::TIM310>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Sensors::Library::LIDARs::SICK::TIM310>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Sensors::Library::LIDARs::SICK::TIM310>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Sensors::Library::LIDARs::SICK::TIM310>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Sensors::Library::LIDARs::SICK::TIM310>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Sensors::Library::LIDARs::SICK::TIM310>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Sensors::Library::LIDARs::SICK::TIM310>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Sensors_Library_LIDARs_SICK_TIM781_Vector) std::vector<std::shared_ptr<openplx::Sensors::Library::LIDARs::SICK::TIM781>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Sensors::Library::LIDARs::SICK::TIM781>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Sensors::Library::LIDARs::SICK::TIM781>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Sensors::Library::LIDARs::SICK::TIM781>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Sensors::Library::LIDARs::SICK::TIM781>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Sensors::Library::LIDARs::SICK::TIM781>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Sensors::Library::LIDARs::SICK::TIM781>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%enddef

%define OPENPLX_SWIG_NS_INCLUDES_Sensors_Library_LIDARs_SICK()
%include "openplx/Sensors/Library/LIDARs/SICK/TIM150.h"
%include "openplx/Sensors/Library/LIDARs/SICK/TIM310.h"
%include "openplx/Sensors/Library/LIDARs/SICK/TIM781.h"
%enddef

%define OPENPLX_SWIG_NS_PY_IMPORTS_Sensors_Library_LIDARs_SICK()
%pythoncode %{
%}
%enddef

%define OPENPLX_SWIG_NS_IMPORT_PARENT_DEPENDENCIES_Sensors_Library_LIDARs_Velodyne()
%enddef

%define OPENPLX_SWIG_NS_MODULE_H_DEPENDENCIES_Sensors_Library_LIDARs_Velodyne()
%{
#include <openplx/DriveTrain/DriveTrain_all.h>
#include <openplx/Math/Math_all.h>
#include <openplx/Physics/Physics_all.h>
#include <openplx/Physics1D/Physics1D_all.h>
#include <openplx/Physics3D/Physics3D_all.h>
#include <openplx/Sensors/Sensors_all.h>
%}
%enddef

%define OPENPLX_SWIG_NS_RENAMES_Sensors_Library_LIDARs_Velodyne(prefix)
%rename(prefix ## VLP16) openplx::Sensors::Library::LIDARs::Velodyne::VLP16;
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTERS_Sensors_Library_LIDARs_Velodyne()
%shared_ptr(openplx::Sensors::Library::LIDARs::Velodyne::VLP16);
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Sensors_Library_LIDARs_Velodyne()
%typemap(out) std::shared_ptr<openplx::Sensors::Library::LIDARs::Velodyne::VLP16> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%enddef

%define OPENPLX_SWIG_NS_VECTORS_Sensors_Library_LIDARs_Velodyne()
%template(Sensors_Library_LIDARs_Velodyne_VLP16_Vector) std::vector<std::shared_ptr<openplx::Sensors::Library::LIDARs::Velodyne::VLP16>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Sensors::Library::LIDARs::Velodyne::VLP16>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Sensors::Library::LIDARs::Velodyne::VLP16>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Sensors::Library::LIDARs::Velodyne::VLP16>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Sensors::Library::LIDARs::Velodyne::VLP16>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Sensors::Library::LIDARs::Velodyne::VLP16>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Sensors::Library::LIDARs::Velodyne::VLP16>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%enddef

%define OPENPLX_SWIG_NS_INCLUDES_Sensors_Library_LIDARs_Velodyne()
%include "openplx/Sensors/Library/LIDARs/Velodyne/VLP16.h"
%enddef

%define OPENPLX_SWIG_NS_PY_IMPORTS_Sensors_Library_LIDARs_Velodyne()
%pythoncode %{
%}
%enddef

%define OPENPLX_SWIG_NS_IMPORT_PARENT_DEPENDENCIES_Sensors_Optics()
%import "Sensors.i"
%enddef

%define OPENPLX_SWIG_NS_MODULE_H_DEPENDENCIES_Sensors_Optics()
%{
#include <openplx/DriveTrain/DriveTrain_all.h>
#include <openplx/Math/Math_all.h>
#include <openplx/Physics/Physics_all.h>
#include <openplx/Physics1D/Physics1D_all.h>
#include <openplx/Physics3D/Physics3D_all.h>
#include <openplx/Sensors/Sensors_all.h>
%}
%enddef

%define OPENPLX_SWIG_NS_RENAMES_Sensors_Optics(prefix)
%rename(prefix ## BeamDivergence) openplx::Sensors::Optics::BeamDivergence;
%rename(prefix ## ConicalBeamDivergence) openplx::Sensors::Optics::ConicalBeamDivergence;
%rename(prefix ## HorizontalSweepRaySource) openplx::Sensors::Optics::HorizontalSweepRaySource;
%rename(prefix ## RayEmissionAngleGaussianNoise) openplx::Sensors::Optics::RayEmissionAngleGaussianNoise;
%rename(prefix ## RayEmissionDistortion) openplx::Sensors::Optics::RayEmissionDistortion;
%rename(prefix ## RaySource) openplx::Sensors::Optics::RaySource;
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTERS_Sensors_Optics()
%shared_ptr(openplx::Sensors::Optics::BeamDivergence);
%shared_ptr(openplx::Sensors::Optics::ConicalBeamDivergence);
%shared_ptr(openplx::Sensors::Optics::HorizontalSweepRaySource);
%shared_ptr(openplx::Sensors::Optics::RayEmissionAngleGaussianNoise);
%shared_ptr(openplx::Sensors::Optics::RayEmissionDistortion);
%shared_ptr(openplx::Sensors::Optics::RaySource);
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Sensors_Optics()
%typemap(out) std::shared_ptr<openplx::Sensors::Optics::BeamDivergence> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Sensors::Optics::ConicalBeamDivergence> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Sensors::Optics::HorizontalSweepRaySource> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Sensors::Optics::RayEmissionAngleGaussianNoise> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Sensors::Optics::RayEmissionDistortion> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Sensors::Optics::RaySource> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%enddef

%define OPENPLX_SWIG_NS_VECTORS_Sensors_Optics()
%template(Sensors_Optics_BeamDivergence_Vector) std::vector<std::shared_ptr<openplx::Sensors::Optics::BeamDivergence>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Sensors::Optics::BeamDivergence>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Sensors::Optics::BeamDivergence>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Sensors::Optics::BeamDivergence>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Sensors::Optics::BeamDivergence>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Sensors::Optics::BeamDivergence>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Sensors::Optics::BeamDivergence>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Sensors_Optics_ConicalBeamDivergence_Vector) std::vector<std::shared_ptr<openplx::Sensors::Optics::ConicalBeamDivergence>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Sensors::Optics::ConicalBeamDivergence>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Sensors::Optics::ConicalBeamDivergence>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Sensors::Optics::ConicalBeamDivergence>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Sensors::Optics::ConicalBeamDivergence>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Sensors::Optics::ConicalBeamDivergence>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Sensors::Optics::ConicalBeamDivergence>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Sensors_Optics_HorizontalSweepRaySource_Vector) std::vector<std::shared_ptr<openplx::Sensors::Optics::HorizontalSweepRaySource>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Sensors::Optics::HorizontalSweepRaySource>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Sensors::Optics::HorizontalSweepRaySource>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Sensors::Optics::HorizontalSweepRaySource>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Sensors::Optics::HorizontalSweepRaySource>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Sensors::Optics::HorizontalSweepRaySource>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Sensors::Optics::HorizontalSweepRaySource>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Sensors_Optics_RayEmissionAngleGaussianNoise_Vector) std::vector<std::shared_ptr<openplx::Sensors::Optics::RayEmissionAngleGaussianNoise>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Sensors::Optics::RayEmissionAngleGaussianNoise>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Sensors::Optics::RayEmissionAngleGaussianNoise>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Sensors::Optics::RayEmissionAngleGaussianNoise>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Sensors::Optics::RayEmissionAngleGaussianNoise>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Sensors::Optics::RayEmissionAngleGaussianNoise>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Sensors::Optics::RayEmissionAngleGaussianNoise>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Sensors_Optics_RayEmissionDistortion_Vector) std::vector<std::shared_ptr<openplx::Sensors::Optics::RayEmissionDistortion>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Sensors::Optics::RayEmissionDistortion>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Sensors::Optics::RayEmissionDistortion>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Sensors::Optics::RayEmissionDistortion>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Sensors::Optics::RayEmissionDistortion>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Sensors::Optics::RayEmissionDistortion>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Sensors::Optics::RayEmissionDistortion>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Sensors_Optics_RaySource_Vector) std::vector<std::shared_ptr<openplx::Sensors::Optics::RaySource>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Sensors::Optics::RaySource>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Sensors::Optics::RaySource>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Sensors::Optics::RaySource>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Sensors::Optics::RaySource>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Sensors::Optics::RaySource>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Sensors::Optics::RaySource>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%enddef

%define OPENPLX_SWIG_NS_INCLUDES_Sensors_Optics()
%include "openplx/Sensors/Optics/BeamDivergence.h"
%include "openplx/Sensors/Optics/ConicalBeamDivergence.h"
%include "openplx/Sensors/Optics/RaySource.h"
%include "openplx/Sensors/Optics/HorizontalSweepRaySource.h"
%include "openplx/Sensors/Optics/RayEmissionDistortion.h"
%include "openplx/Sensors/Optics/RayEmissionAngleGaussianNoise.h"
%enddef

%define OPENPLX_SWIG_NS_PY_IMPORTS_Sensors_Optics()
%pythoncode %{
%}
%enddef

%define OPENPLX_SWIG_NS_IMPORT_PARENT_DEPENDENCIES_Sensors_Optics_Traits()
%enddef

%define OPENPLX_SWIG_NS_MODULE_H_DEPENDENCIES_Sensors_Optics_Traits()
%{
#include <openplx/DriveTrain/DriveTrain_all.h>
#include <openplx/Math/Math_all.h>
#include <openplx/Physics/Physics_all.h>
#include <openplx/Physics1D/Physics1D_all.h>
#include <openplx/Physics3D/Physics3D_all.h>
#include <openplx/Sensors/Sensors_all.h>
%}
%enddef

%define OPENPLX_SWIG_NS_RENAMES_Sensors_Optics_Traits(prefix)
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTERS_Sensors_Optics_Traits()
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Sensors_Optics_Traits()
%enddef

%define OPENPLX_SWIG_NS_VECTORS_Sensors_Optics_Traits()
%enddef

%define OPENPLX_SWIG_NS_INCLUDES_Sensors_Optics_Traits()
%enddef

%define OPENPLX_SWIG_NS_PY_IMPORTS_Sensors_Optics_Traits()
%pythoncode %{
%}
%enddef

%define OPENPLX_SWIG_NS_IMPORT_PARENT_DEPENDENCIES_Sensors_Signals()
%enddef

%define OPENPLX_SWIG_NS_MODULE_H_DEPENDENCIES_Sensors_Signals()
%{
#include <openplx/DriveTrain/DriveTrain_all.h>
#include <openplx/Math/Math_all.h>
#include <openplx/Physics/Physics_all.h>
#include <openplx/Physics1D/Physics1D_all.h>
#include <openplx/Physics3D/Physics3D_all.h>
#include <openplx/Sensors/Sensors_all.h>
%}
%enddef

%define OPENPLX_SWIG_NS_RENAMES_Sensors_Signals(prefix)
%rename(prefix ## AccelerometerOutput) openplx::Sensors::Signals::AccelerometerOutput;
%rename(prefix ## GyroscopeOutput) openplx::Sensors::Signals::GyroscopeOutput;
%rename(prefix ## LidarOutput) openplx::Sensors::Signals::LidarOutput;
%rename(prefix ## LidarOutputField) openplx::Sensors::Signals::LidarOutputField;
%rename(prefix ## MagnetometerOutput) openplx::Sensors::Signals::MagnetometerOutput;
%rename(prefix ## SensorOutputSignal) openplx::Sensors::Signals::SensorOutputSignal;
%rename(prefix ## TriaxialOutputField) openplx::Sensors::Signals::TriaxialOutputField;
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTERS_Sensors_Signals()
%shared_ptr(openplx::Sensors::Signals::AccelerometerOutput);
%shared_ptr(openplx::Sensors::Signals::GyroscopeOutput);
%shared_ptr(openplx::Sensors::Signals::LidarOutput);
%shared_ptr(openplx::Sensors::Signals::LidarOutputField);
%shared_ptr(openplx::Sensors::Signals::MagnetometerOutput);
%shared_ptr(openplx::Sensors::Signals::SensorOutputSignal);
%shared_ptr(openplx::Sensors::Signals::TriaxialOutputField);
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Sensors_Signals()
%typemap(out) std::shared_ptr<openplx::Sensors::Signals::AccelerometerOutput> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Sensors::Signals::GyroscopeOutput> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Sensors::Signals::LidarOutput> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Sensors::Signals::LidarOutputField> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Sensors::Signals::MagnetometerOutput> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Sensors::Signals::SensorOutputSignal> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Sensors::Signals::TriaxialOutputField> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%enddef

%define OPENPLX_SWIG_NS_VECTORS_Sensors_Signals()
%template(Sensors_Signals_AccelerometerOutput_Vector) std::vector<std::shared_ptr<openplx::Sensors::Signals::AccelerometerOutput>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Sensors::Signals::AccelerometerOutput>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Sensors::Signals::AccelerometerOutput>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Sensors::Signals::AccelerometerOutput>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Sensors::Signals::AccelerometerOutput>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Sensors::Signals::AccelerometerOutput>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Sensors::Signals::AccelerometerOutput>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Sensors_Signals_GyroscopeOutput_Vector) std::vector<std::shared_ptr<openplx::Sensors::Signals::GyroscopeOutput>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Sensors::Signals::GyroscopeOutput>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Sensors::Signals::GyroscopeOutput>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Sensors::Signals::GyroscopeOutput>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Sensors::Signals::GyroscopeOutput>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Sensors::Signals::GyroscopeOutput>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Sensors::Signals::GyroscopeOutput>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Sensors_Signals_LidarOutput_Vector) std::vector<std::shared_ptr<openplx::Sensors::Signals::LidarOutput>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Sensors::Signals::LidarOutput>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Sensors::Signals::LidarOutput>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Sensors::Signals::LidarOutput>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Sensors::Signals::LidarOutput>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Sensors::Signals::LidarOutput>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Sensors::Signals::LidarOutput>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Sensors_Signals_LidarOutputField_Vector) std::vector<std::shared_ptr<openplx::Sensors::Signals::LidarOutputField>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Sensors::Signals::LidarOutputField>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Sensors::Signals::LidarOutputField>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Sensors::Signals::LidarOutputField>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Sensors::Signals::LidarOutputField>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Sensors::Signals::LidarOutputField>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Sensors::Signals::LidarOutputField>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Sensors_Signals_MagnetometerOutput_Vector) std::vector<std::shared_ptr<openplx::Sensors::Signals::MagnetometerOutput>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Sensors::Signals::MagnetometerOutput>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Sensors::Signals::MagnetometerOutput>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Sensors::Signals::MagnetometerOutput>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Sensors::Signals::MagnetometerOutput>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Sensors::Signals::MagnetometerOutput>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Sensors::Signals::MagnetometerOutput>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Sensors_Signals_SensorOutputSignal_Vector) std::vector<std::shared_ptr<openplx::Sensors::Signals::SensorOutputSignal>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Sensors::Signals::SensorOutputSignal>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Sensors::Signals::SensorOutputSignal>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Sensors::Signals::SensorOutputSignal>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Sensors::Signals::SensorOutputSignal>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Sensors::Signals::SensorOutputSignal>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Sensors::Signals::SensorOutputSignal>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Sensors_Signals_TriaxialOutputField_Vector) std::vector<std::shared_ptr<openplx::Sensors::Signals::TriaxialOutputField>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Sensors::Signals::TriaxialOutputField>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Sensors::Signals::TriaxialOutputField>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Sensors::Signals::TriaxialOutputField>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Sensors::Signals::TriaxialOutputField>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Sensors::Signals::TriaxialOutputField>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Sensors::Signals::TriaxialOutputField>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%enddef

%define OPENPLX_SWIG_NS_INCLUDES_Sensors_Signals()
%include "openplx/Sensors/Signals/AccelerometerOutput.h"
%include "openplx/Sensors/Signals/GyroscopeOutput.h"
%include "openplx/Sensors/Signals/LidarOutput.h"
%include "openplx/Sensors/Signals/LidarOutputField.h"
%include "openplx/Sensors/Signals/MagnetometerOutput.h"
%include "openplx/Sensors/Signals/SensorOutputSignal.h"
%include "openplx/Sensors/Signals/TriaxialOutputField.h"
%enddef

%define OPENPLX_SWIG_NS_PY_IMPORTS_Sensors_Signals()
%pythoncode %{
%}
%enddef

%define OPENPLX_SWIG_NS_IMPORT_PARENT_DEPENDENCIES_Sensors_Traits()
%enddef

%define OPENPLX_SWIG_NS_MODULE_H_DEPENDENCIES_Sensors_Traits()
%{
#include <openplx/DriveTrain/DriveTrain_all.h>
#include <openplx/Math/Math_all.h>
#include <openplx/Physics/Physics_all.h>
#include <openplx/Physics1D/Physics1D_all.h>
#include <openplx/Physics3D/Physics3D_all.h>
#include <openplx/Sensors/Sensors_all.h>
%}
%enddef

%define OPENPLX_SWIG_NS_RENAMES_Sensors_Traits(prefix)
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTERS_Sensors_Traits()
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Sensors_Traits()
%enddef

%define OPENPLX_SWIG_NS_VECTORS_Sensors_Traits()
%enddef

%define OPENPLX_SWIG_NS_INCLUDES_Sensors_Traits()
%enddef

%define OPENPLX_SWIG_NS_PY_IMPORTS_Sensors_Traits()
%pythoncode %{
%}
%enddef

%define OPENPLX_SWIG_BUNDLE_INCLUDE_H_DEPENDENCIES_Sensors()
%{
#include <openplx/DriveTrain/DriveTrain_all.h>
#include <openplx/Math/Math_all.h>
#include <openplx/Physics/Physics_all.h>
#include <openplx/Physics1D/Physics1D_all.h>
#include <openplx/Physics3D/Physics3D_all.h>
#include <openplx/Sensors/Sensors_all.h>
%}
%enddef

%define OPENPLX_SWIG_BUNDLE_IMPORT_Sensors()
%import "Sensors.i"
%import "Sensors_Library_LIDARs_Ouster.i"
%import "Sensors_Library_LIDARs_SICK.i"
%import "Sensors_Library_LIDARs_Velodyne.i"
%import "Sensors_Optics.i"
%import "Sensors_Optics_Traits.i"
%import "Sensors_Signals.i"
%import "Sensors_Traits.i"
%enddef

%define OPENPLX_SWIG_BUNDLE_IMPORT_DEPENDENCIES_Sensors()
%include <python/DriveTrain/DriveTrain.i>
OPENPLX_SWIG_BUNDLE_IMPORT_DriveTrain();
%include <python/Math/Math.i>
OPENPLX_SWIG_BUNDLE_IMPORT_Math();
%include <python/Physics/Physics.i>
OPENPLX_SWIG_BUNDLE_IMPORT_Physics();
%include <python/Physics1D/Physics1D.i>
OPENPLX_SWIG_BUNDLE_IMPORT_Physics1D();
%include <python/Physics3D/Physics3D.i>
OPENPLX_SWIG_BUNDLE_IMPORT_Physics3D();
%enddef

%define OPENPLX_SWIG_BUNDLE_IMPORT_FLAT_DEPENDENCIES_Sensors()
%import "DriveTrain.i"
%import "Math.i"
%import "Physics.i"
%import "Physics1D.i"
%import "Physics3D.i"
%enddef

%define OPENPLX_SWIG_BUNDLE_RENAMES_Sensors(prefix)
OPENPLX_SWIG_NS_RENAMES_Sensors(prefix);
OPENPLX_SWIG_NS_RENAMES_Sensors_Library_LIDARs_Ouster(prefix ## Library_LIDARs_Ouster_);
OPENPLX_SWIG_NS_RENAMES_Sensors_Library_LIDARs_SICK(prefix ## Library_LIDARs_SICK_);
OPENPLX_SWIG_NS_RENAMES_Sensors_Library_LIDARs_Velodyne(prefix ## Library_LIDARs_Velodyne_);
OPENPLX_SWIG_NS_RENAMES_Sensors_Optics(prefix ## Optics_);
OPENPLX_SWIG_NS_RENAMES_Sensors_Optics_Traits(prefix ## Optics_Traits_);
OPENPLX_SWIG_NS_RENAMES_Sensors_Signals(prefix ## Signals_);
OPENPLX_SWIG_NS_RENAMES_Sensors_Traits(prefix ## Traits_);
%enddef

%define OPENPLX_SWIG_BUNDLE_SHARED_POINTERS_Sensors()
OPENPLX_SWIG_NS_SHARED_POINTERS_Sensors();
OPENPLX_SWIG_NS_SHARED_POINTERS_Sensors_Library_LIDARs_Ouster();
OPENPLX_SWIG_NS_SHARED_POINTERS_Sensors_Library_LIDARs_SICK();
OPENPLX_SWIG_NS_SHARED_POINTERS_Sensors_Library_LIDARs_Velodyne();
OPENPLX_SWIG_NS_SHARED_POINTERS_Sensors_Optics();
OPENPLX_SWIG_NS_SHARED_POINTERS_Sensors_Optics_Traits();
OPENPLX_SWIG_NS_SHARED_POINTERS_Sensors_Signals();
OPENPLX_SWIG_NS_SHARED_POINTERS_Sensors_Traits();
%enddef

%define OPENPLX_SWIG_BUNDLE_SHARED_POINTER_DOWNCASTS_Sensors()
OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Sensors();
OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Sensors_Library_LIDARs_Ouster();
OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Sensors_Library_LIDARs_SICK();
OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Sensors_Library_LIDARs_Velodyne();
OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Sensors_Optics();
OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Sensors_Optics_Traits();
OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Sensors_Signals();
OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Sensors_Traits();
%enddef

%define OPENPLX_SWIG_BUNDLE_VECTORS_Sensors()
OPENPLX_SWIG_NS_VECTORS_Sensors();
OPENPLX_SWIG_NS_VECTORS_Sensors_Library_LIDARs_Ouster();
OPENPLX_SWIG_NS_VECTORS_Sensors_Library_LIDARs_SICK();
OPENPLX_SWIG_NS_VECTORS_Sensors_Library_LIDARs_Velodyne();
OPENPLX_SWIG_NS_VECTORS_Sensors_Optics();
OPENPLX_SWIG_NS_VECTORS_Sensors_Optics_Traits();
OPENPLX_SWIG_NS_VECTORS_Sensors_Signals();
OPENPLX_SWIG_NS_VECTORS_Sensors_Traits();
%enddef

%define OPENPLX_SWIG_BUNDLE_INCLUDES_Sensors()
OPENPLX_SWIG_NS_INCLUDES_Sensors();
OPENPLX_SWIG_NS_INCLUDES_Sensors_Library_LIDARs_Ouster();
OPENPLX_SWIG_NS_INCLUDES_Sensors_Library_LIDARs_SICK();
OPENPLX_SWIG_NS_INCLUDES_Sensors_Library_LIDARs_Velodyne();
OPENPLX_SWIG_NS_INCLUDES_Sensors_Optics();
OPENPLX_SWIG_NS_INCLUDES_Sensors_Optics_Traits();
OPENPLX_SWIG_NS_INCLUDES_Sensors_Signals();
OPENPLX_SWIG_NS_INCLUDES_Sensors_Traits();
%enddef

