#pragma once

#include <string>
#include <vector>
#include <memory>
#include <unordered_map>
#include <map>
#include <openplx/Plugin.h>
#include <openplx/Document.h>
#include <openplx/Import.h>
#include <openplx/ErrorReporter.h>

namespace openplx::Plugins::Urdf {
    class UrdfPluginImpl;
    class UrdfPlugin : public openplx::Plugin {
        public:
            UrdfPlugin();
            ~UrdfPlugin();
            DocPtr parse(const std::string& source, ImportPtr import, ErrorReporter& error_reporter) override;
            std::vector<std::string> extensions() override;
            void setPrecision(int precision) override;
            bool keyShouldBeSource() override;

            constexpr static const char* negligible_mass = "0.00000000000001";
            constexpr static const char* negligible_inertia_tensor = "0.000000000001";

        private:
            std::unique_ptr<UrdfPluginImpl> m_impl;
    };
}
